/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.api.servicemanagement.v1;

import com.google.api.Service;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.servicemanagement.v1.ConfigSource;
import com.google.api.servicemanagement.v1.CreateServiceConfigRequest;
import com.google.api.servicemanagement.v1.CreateServiceRequest;
import com.google.api.servicemanagement.v1.CreateServiceRolloutRequest;
import com.google.api.servicemanagement.v1.DeleteServiceRequest;
import com.google.api.servicemanagement.v1.GenerateConfigReportRequest;
import com.google.api.servicemanagement.v1.GenerateConfigReportResponse;
import com.google.api.servicemanagement.v1.GetServiceConfigRequest;
import com.google.api.servicemanagement.v1.GetServiceRequest;
import com.google.api.servicemanagement.v1.GetServiceRolloutRequest;
import com.google.api.servicemanagement.v1.ListServiceConfigsRequest;
import com.google.api.servicemanagement.v1.ListServiceConfigsResponse;
import com.google.api.servicemanagement.v1.ListServiceRolloutsRequest;
import com.google.api.servicemanagement.v1.ListServiceRolloutsResponse;
import com.google.api.servicemanagement.v1.ListServicesRequest;
import com.google.api.servicemanagement.v1.ListServicesResponse;
import com.google.api.servicemanagement.v1.ManagedService;
import com.google.api.servicemanagement.v1.OperationMetadata;
import com.google.api.servicemanagement.v1.Rollout;
import com.google.api.servicemanagement.v1.SubmitConfigSourceRequest;
import com.google.api.servicemanagement.v1.SubmitConfigSourceResponse;
import com.google.api.servicemanagement.v1.UndeleteServiceRequest;
import com.google.api.servicemanagement.v1.UndeleteServiceResponse;
import com.google.cloud.api.servicemanagement.v1.ServiceManagerSettings;
import com.google.cloud.api.servicemanagement.v1.stub.ServiceManagerStub;
import com.google.cloud.api.servicemanagement.v1.stub.ServiceManagerStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ServiceManagerClient
implements BackgroundResource {
    private final ServiceManagerSettings settings;
    private final ServiceManagerStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ServiceManagerClient create() throws IOException {
        return ServiceManagerClient.create(ServiceManagerSettings.newBuilder().build());
    }

    public static final ServiceManagerClient create(ServiceManagerSettings settings) throws IOException {
        return new ServiceManagerClient(settings);
    }

    public static final ServiceManagerClient create(ServiceManagerStub stub) {
        return new ServiceManagerClient(stub);
    }

    protected ServiceManagerClient(ServiceManagerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ServiceManagerStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ServiceManagerClient(ServiceManagerStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ServiceManagerSettings getSettings() {
        return this.settings;
    }

    public ServiceManagerStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListServicesPagedResponse listServices(String producerProjectId, String consumerId) {
        ListServicesRequest request = ListServicesRequest.newBuilder().setProducerProjectId(producerProjectId).setConsumerId(consumerId).build();
        return this.listServices(request);
    }

    public final ListServicesPagedResponse listServices(ListServicesRequest request) {
        return (ListServicesPagedResponse)((Object)this.listServicesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServicesRequest, ListServicesPagedResponse> listServicesPagedCallable() {
        return this.stub.listServicesPagedCallable();
    }

    public final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.stub.listServicesCallable();
    }

    public final ManagedService getService(String serviceName) {
        GetServiceRequest request = GetServiceRequest.newBuilder().setServiceName(serviceName).build();
        return this.getService(request);
    }

    public final ManagedService getService(GetServiceRequest request) {
        return (ManagedService)this.getServiceCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceRequest, ManagedService> getServiceCallable() {
        return this.stub.getServiceCallable();
    }

    public final OperationFuture<ManagedService, OperationMetadata> createServiceAsync(ManagedService service) {
        CreateServiceRequest request = CreateServiceRequest.newBuilder().setService(service).build();
        return this.createServiceAsync(request);
    }

    public final OperationFuture<ManagedService, OperationMetadata> createServiceAsync(CreateServiceRequest request) {
        return this.createServiceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateServiceRequest, ManagedService, OperationMetadata> createServiceOperationCallable() {
        return this.stub.createServiceOperationCallable();
    }

    public final UnaryCallable<CreateServiceRequest, Operation> createServiceCallable() {
        return this.stub.createServiceCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceAsync(String serviceName) {
        DeleteServiceRequest request = DeleteServiceRequest.newBuilder().setServiceName(serviceName).build();
        return this.deleteServiceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceAsync(DeleteServiceRequest request) {
        return this.deleteServiceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationCallable() {
        return this.stub.deleteServiceOperationCallable();
    }

    public final UnaryCallable<DeleteServiceRequest, Operation> deleteServiceCallable() {
        return this.stub.deleteServiceCallable();
    }

    public final OperationFuture<UndeleteServiceResponse, OperationMetadata> undeleteServiceAsync(String serviceName) {
        UndeleteServiceRequest request = UndeleteServiceRequest.newBuilder().setServiceName(serviceName).build();
        return this.undeleteServiceAsync(request);
    }

    public final OperationFuture<UndeleteServiceResponse, OperationMetadata> undeleteServiceAsync(UndeleteServiceRequest request) {
        return this.undeleteServiceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeleteServiceRequest, UndeleteServiceResponse, OperationMetadata> undeleteServiceOperationCallable() {
        return this.stub.undeleteServiceOperationCallable();
    }

    public final UnaryCallable<UndeleteServiceRequest, Operation> undeleteServiceCallable() {
        return this.stub.undeleteServiceCallable();
    }

    public final ListServiceConfigsPagedResponse listServiceConfigs(String serviceName) {
        ListServiceConfigsRequest request = ListServiceConfigsRequest.newBuilder().setServiceName(serviceName).build();
        return this.listServiceConfigs(request);
    }

    public final ListServiceConfigsPagedResponse listServiceConfigs(ListServiceConfigsRequest request) {
        return (ListServiceConfigsPagedResponse)((Object)this.listServiceConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServiceConfigsRequest, ListServiceConfigsPagedResponse> listServiceConfigsPagedCallable() {
        return this.stub.listServiceConfigsPagedCallable();
    }

    public final UnaryCallable<ListServiceConfigsRequest, ListServiceConfigsResponse> listServiceConfigsCallable() {
        return this.stub.listServiceConfigsCallable();
    }

    public final Service getServiceConfig(String serviceName, String configId, GetServiceConfigRequest.ConfigView view) {
        GetServiceConfigRequest request = GetServiceConfigRequest.newBuilder().setServiceName(serviceName).setConfigId(configId).setView(view).build();
        return this.getServiceConfig(request);
    }

    public final Service getServiceConfig(GetServiceConfigRequest request) {
        return (Service)this.getServiceConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceConfigRequest, Service> getServiceConfigCallable() {
        return this.stub.getServiceConfigCallable();
    }

    public final Service createServiceConfig(String serviceName, Service serviceConfig) {
        CreateServiceConfigRequest request = CreateServiceConfigRequest.newBuilder().setServiceName(serviceName).setServiceConfig(serviceConfig).build();
        return this.createServiceConfig(request);
    }

    public final Service createServiceConfig(CreateServiceConfigRequest request) {
        return (Service)this.createServiceConfigCallable().call((Object)request);
    }

    public final UnaryCallable<CreateServiceConfigRequest, Service> createServiceConfigCallable() {
        return this.stub.createServiceConfigCallable();
    }

    public final OperationFuture<SubmitConfigSourceResponse, OperationMetadata> submitConfigSourceAsync(String serviceName, ConfigSource configSource, boolean validateOnly) {
        SubmitConfigSourceRequest request = SubmitConfigSourceRequest.newBuilder().setServiceName(serviceName).setConfigSource(configSource).setValidateOnly(validateOnly).build();
        return this.submitConfigSourceAsync(request);
    }

    public final OperationFuture<SubmitConfigSourceResponse, OperationMetadata> submitConfigSourceAsync(SubmitConfigSourceRequest request) {
        return this.submitConfigSourceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SubmitConfigSourceRequest, SubmitConfigSourceResponse, OperationMetadata> submitConfigSourceOperationCallable() {
        return this.stub.submitConfigSourceOperationCallable();
    }

    public final UnaryCallable<SubmitConfigSourceRequest, Operation> submitConfigSourceCallable() {
        return this.stub.submitConfigSourceCallable();
    }

    public final ListServiceRolloutsPagedResponse listServiceRollouts(String serviceName, String filter) {
        ListServiceRolloutsRequest request = ListServiceRolloutsRequest.newBuilder().setServiceName(serviceName).setFilter(filter).build();
        return this.listServiceRollouts(request);
    }

    public final ListServiceRolloutsPagedResponse listServiceRollouts(ListServiceRolloutsRequest request) {
        return (ListServiceRolloutsPagedResponse)((Object)this.listServiceRolloutsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServiceRolloutsRequest, ListServiceRolloutsPagedResponse> listServiceRolloutsPagedCallable() {
        return this.stub.listServiceRolloutsPagedCallable();
    }

    public final UnaryCallable<ListServiceRolloutsRequest, ListServiceRolloutsResponse> listServiceRolloutsCallable() {
        return this.stub.listServiceRolloutsCallable();
    }

    public final Rollout getServiceRollout(String serviceName, String rolloutId) {
        GetServiceRolloutRequest request = GetServiceRolloutRequest.newBuilder().setServiceName(serviceName).setRolloutId(rolloutId).build();
        return this.getServiceRollout(request);
    }

    public final Rollout getServiceRollout(GetServiceRolloutRequest request) {
        return (Rollout)this.getServiceRolloutCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceRolloutRequest, Rollout> getServiceRolloutCallable() {
        return this.stub.getServiceRolloutCallable();
    }

    public final OperationFuture<Rollout, OperationMetadata> createServiceRolloutAsync(String serviceName, Rollout rollout) {
        CreateServiceRolloutRequest request = CreateServiceRolloutRequest.newBuilder().setServiceName(serviceName).setRollout(rollout).build();
        return this.createServiceRolloutAsync(request);
    }

    public final OperationFuture<Rollout, OperationMetadata> createServiceRolloutAsync(CreateServiceRolloutRequest request) {
        return this.createServiceRolloutOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateServiceRolloutRequest, Rollout, OperationMetadata> createServiceRolloutOperationCallable() {
        return this.stub.createServiceRolloutOperationCallable();
    }

    public final UnaryCallable<CreateServiceRolloutRequest, Operation> createServiceRolloutCallable() {
        return this.stub.createServiceRolloutCallable();
    }

    public final GenerateConfigReportResponse generateConfigReport(Any newConfig, Any oldConfig) {
        GenerateConfigReportRequest request = GenerateConfigReportRequest.newBuilder().setNewConfig(newConfig).setOldConfig(oldConfig).build();
        return this.generateConfigReport(request);
    }

    public final GenerateConfigReportResponse generateConfigReport(GenerateConfigReportRequest request) {
        return (GenerateConfigReportResponse)this.generateConfigReportCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateConfigReportRequest, GenerateConfigReportResponse> generateConfigReportCallable() {
        return this.stub.generateConfigReportCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListServiceRolloutsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServiceRolloutsRequest, ListServiceRolloutsResponse, Rollout, ListServiceRolloutsPage, ListServiceRolloutsFixedSizeCollection> {
        private ListServiceRolloutsFixedSizeCollection(List<ListServiceRolloutsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServiceRolloutsFixedSizeCollection createEmptyCollection() {
            return new ListServiceRolloutsFixedSizeCollection(null, 0);
        }

        protected ListServiceRolloutsFixedSizeCollection createCollection(List<ListServiceRolloutsPage> pages, int collectionSize) {
            return new ListServiceRolloutsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServiceRolloutsPage
    extends AbstractPage<ListServiceRolloutsRequest, ListServiceRolloutsResponse, Rollout, ListServiceRolloutsPage> {
        private ListServiceRolloutsPage(PageContext<ListServiceRolloutsRequest, ListServiceRolloutsResponse, Rollout> context, ListServiceRolloutsResponse response) {
            super(context, (Object)response);
        }

        private static ListServiceRolloutsPage createEmptyPage() {
            return new ListServiceRolloutsPage(null, null);
        }

        protected ListServiceRolloutsPage createPage(PageContext<ListServiceRolloutsRequest, ListServiceRolloutsResponse, Rollout> context, ListServiceRolloutsResponse response) {
            return new ListServiceRolloutsPage(context, response);
        }

        public ApiFuture<ListServiceRolloutsPage> createPageAsync(PageContext<ListServiceRolloutsRequest, ListServiceRolloutsResponse, Rollout> context, ApiFuture<ListServiceRolloutsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServiceRolloutsPagedResponse
    extends AbstractPagedListResponse<ListServiceRolloutsRequest, ListServiceRolloutsResponse, Rollout, ListServiceRolloutsPage, ListServiceRolloutsFixedSizeCollection> {
        public static ApiFuture<ListServiceRolloutsPagedResponse> createAsync(PageContext<ListServiceRolloutsRequest, ListServiceRolloutsResponse, Rollout> context, ApiFuture<ListServiceRolloutsResponse> futureResponse) {
            ApiFuture<ListServiceRolloutsPage> futurePage = ListServiceRolloutsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServiceRolloutsPagedResponse((ListServiceRolloutsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServiceRolloutsPagedResponse(ListServiceRolloutsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServiceRolloutsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListServiceConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServiceConfigsRequest, ListServiceConfigsResponse, Service, ListServiceConfigsPage, ListServiceConfigsFixedSizeCollection> {
        private ListServiceConfigsFixedSizeCollection(List<ListServiceConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServiceConfigsFixedSizeCollection createEmptyCollection() {
            return new ListServiceConfigsFixedSizeCollection(null, 0);
        }

        protected ListServiceConfigsFixedSizeCollection createCollection(List<ListServiceConfigsPage> pages, int collectionSize) {
            return new ListServiceConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServiceConfigsPage
    extends AbstractPage<ListServiceConfigsRequest, ListServiceConfigsResponse, Service, ListServiceConfigsPage> {
        private ListServiceConfigsPage(PageContext<ListServiceConfigsRequest, ListServiceConfigsResponse, Service> context, ListServiceConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListServiceConfigsPage createEmptyPage() {
            return new ListServiceConfigsPage(null, null);
        }

        protected ListServiceConfigsPage createPage(PageContext<ListServiceConfigsRequest, ListServiceConfigsResponse, Service> context, ListServiceConfigsResponse response) {
            return new ListServiceConfigsPage(context, response);
        }

        public ApiFuture<ListServiceConfigsPage> createPageAsync(PageContext<ListServiceConfigsRequest, ListServiceConfigsResponse, Service> context, ApiFuture<ListServiceConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServiceConfigsPagedResponse
    extends AbstractPagedListResponse<ListServiceConfigsRequest, ListServiceConfigsResponse, Service, ListServiceConfigsPage, ListServiceConfigsFixedSizeCollection> {
        public static ApiFuture<ListServiceConfigsPagedResponse> createAsync(PageContext<ListServiceConfigsRequest, ListServiceConfigsResponse, Service> context, ApiFuture<ListServiceConfigsResponse> futureResponse) {
            ApiFuture<ListServiceConfigsPage> futurePage = ListServiceConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServiceConfigsPagedResponse((ListServiceConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServiceConfigsPagedResponse(ListServiceConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServiceConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListServicesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServicesRequest, ListServicesResponse, ManagedService, ListServicesPage, ListServicesFixedSizeCollection> {
        private ListServicesFixedSizeCollection(List<ListServicesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServicesFixedSizeCollection createEmptyCollection() {
            return new ListServicesFixedSizeCollection(null, 0);
        }

        protected ListServicesFixedSizeCollection createCollection(List<ListServicesPage> pages, int collectionSize) {
            return new ListServicesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServicesPage
    extends AbstractPage<ListServicesRequest, ListServicesResponse, ManagedService, ListServicesPage> {
        private ListServicesPage(PageContext<ListServicesRequest, ListServicesResponse, ManagedService> context, ListServicesResponse response) {
            super(context, (Object)response);
        }

        private static ListServicesPage createEmptyPage() {
            return new ListServicesPage(null, null);
        }

        protected ListServicesPage createPage(PageContext<ListServicesRequest, ListServicesResponse, ManagedService> context, ListServicesResponse response) {
            return new ListServicesPage(context, response);
        }

        public ApiFuture<ListServicesPage> createPageAsync(PageContext<ListServicesRequest, ListServicesResponse, ManagedService> context, ApiFuture<ListServicesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServicesPagedResponse
    extends AbstractPagedListResponse<ListServicesRequest, ListServicesResponse, ManagedService, ListServicesPage, ListServicesFixedSizeCollection> {
        public static ApiFuture<ListServicesPagedResponse> createAsync(PageContext<ListServicesRequest, ListServicesResponse, ManagedService> context, ApiFuture<ListServicesResponse> futureResponse) {
            ApiFuture<ListServicesPage> futurePage = ListServicesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServicesPagedResponse((ListServicesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServicesPagedResponse(ListServicesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServicesFixedSizeCollection.createEmptyCollection());
        }
    }
}

