/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.api.servicemanagement.v1.stub;

import com.google.api.HttpRule;
import com.google.api.Service;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.servicemanagement.v1.CreateServiceConfigRequest;
import com.google.api.servicemanagement.v1.CreateServiceRequest;
import com.google.api.servicemanagement.v1.CreateServiceRolloutRequest;
import com.google.api.servicemanagement.v1.DeleteServiceRequest;
import com.google.api.servicemanagement.v1.GenerateConfigReportRequest;
import com.google.api.servicemanagement.v1.GenerateConfigReportResponse;
import com.google.api.servicemanagement.v1.GetServiceConfigRequest;
import com.google.api.servicemanagement.v1.GetServiceRequest;
import com.google.api.servicemanagement.v1.GetServiceRolloutRequest;
import com.google.api.servicemanagement.v1.ListServiceConfigsRequest;
import com.google.api.servicemanagement.v1.ListServiceConfigsResponse;
import com.google.api.servicemanagement.v1.ListServiceRolloutsRequest;
import com.google.api.servicemanagement.v1.ListServiceRolloutsResponse;
import com.google.api.servicemanagement.v1.ListServicesRequest;
import com.google.api.servicemanagement.v1.ListServicesResponse;
import com.google.api.servicemanagement.v1.ManagedService;
import com.google.api.servicemanagement.v1.OperationMetadata;
import com.google.api.servicemanagement.v1.Rollout;
import com.google.api.servicemanagement.v1.SubmitConfigSourceRequest;
import com.google.api.servicemanagement.v1.SubmitConfigSourceResponse;
import com.google.api.servicemanagement.v1.UndeleteServiceRequest;
import com.google.api.servicemanagement.v1.UndeleteServiceResponse;
import com.google.cloud.api.servicemanagement.v1.ServiceManagerClient;
import com.google.cloud.api.servicemanagement.v1.stub.HttpJsonServiceManagerCallableFactory;
import com.google.cloud.api.servicemanagement.v1.stub.ServiceManagerStub;
import com.google.cloud.api.servicemanagement.v1.stub.ServiceManagerStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonServiceManagerStub
extends ServiceManagerStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(Rollout.getDescriptor()).add(OperationMetadata.getDescriptor()).add(UndeleteServiceResponse.getDescriptor()).add(SubmitConfigSourceResponse.getDescriptor()).add(ManagedService.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListServicesRequest, ListServicesResponse> listServicesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.servicemanagement.v1.ServiceManager/ListServices").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/services", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "consumerId", (Object)request.getConsumerId());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "producerProjectId", (Object)request.getProducerProjectId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListServicesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetServiceRequest, ManagedService> getServiceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.servicemanagement.v1.ServiceManager/GetService").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/services/{serviceName}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "serviceName", (Object)request.getServiceName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ManagedService.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateServiceRequest, Operation> createServiceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.servicemanagement.v1.ServiceManager/CreateService").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/services", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("service", (Message)request.getService(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteServiceRequest, Operation> deleteServiceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.servicemanagement.v1.ServiceManager/DeleteService").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/services/{serviceName}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "serviceName", (Object)request.getServiceName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UndeleteServiceRequest, Operation> undeleteServiceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.servicemanagement.v1.ServiceManager/UndeleteService").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/services/{serviceName}:undelete", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "serviceName", (Object)request.getServiceName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListServiceConfigsRequest, ListServiceConfigsResponse> listServiceConfigsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.servicemanagement.v1.ServiceManager/ListServiceConfigs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/services/{serviceName}/configs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "serviceName", (Object)request.getServiceName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListServiceConfigsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetServiceConfigRequest, Service> getServiceConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.servicemanagement.v1.ServiceManager/GetServiceConfig").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/services/{serviceName}/configs/{configId}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "configId", (Object)request.getConfigId());
        serializer.putPathParam(fields, "serviceName", (Object)request.getServiceName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/services/{serviceName}/config"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Service.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateServiceConfigRequest, Service> createServiceConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.servicemanagement.v1.ServiceManager/CreateServiceConfig").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/services/{serviceName}/configs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "serviceName", (Object)request.getServiceName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("serviceConfig", (Message)request.getServiceConfig(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Service.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SubmitConfigSourceRequest, Operation> submitConfigSourceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.servicemanagement.v1.ServiceManager/SubmitConfigSource").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/services/{serviceName}/configs:submit", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "serviceName", (Object)request.getServiceName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearServiceName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListServiceRolloutsRequest, ListServiceRolloutsResponse> listServiceRolloutsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.servicemanagement.v1.ServiceManager/ListServiceRollouts").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/services/{serviceName}/rollouts", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "serviceName", (Object)request.getServiceName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListServiceRolloutsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetServiceRolloutRequest, Rollout> getServiceRolloutMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.servicemanagement.v1.ServiceManager/GetServiceRollout").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/services/{serviceName}/rollouts/{rolloutId}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "rolloutId", (Object)request.getRolloutId());
        serializer.putPathParam(fields, "serviceName", (Object)request.getServiceName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Rollout.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateServiceRolloutRequest, Operation> createServiceRolloutMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.servicemanagement.v1.ServiceManager/CreateServiceRollout").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/services/{serviceName}/rollouts", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "serviceName", (Object)request.getServiceName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("rollout", (Message)request.getRollout(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GenerateConfigReportRequest, GenerateConfigReportResponse> generateConfigReportMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.api.servicemanagement.v1.ServiceManager/GenerateConfigReport").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/services:generateConfigReport", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)GenerateConfigReportResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=services/*}:setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=services/*/consumers/*}:setIamPolicy"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=services/*}:getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=services/*/consumers/*}:getIamPolicy"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=services/*}:testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=services/*/consumers/*}:testIamPermissions"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable;
    private final UnaryCallable<ListServicesRequest, ServiceManagerClient.ListServicesPagedResponse> listServicesPagedCallable;
    private final UnaryCallable<GetServiceRequest, ManagedService> getServiceCallable;
    private final UnaryCallable<CreateServiceRequest, Operation> createServiceCallable;
    private final OperationCallable<CreateServiceRequest, ManagedService, OperationMetadata> createServiceOperationCallable;
    private final UnaryCallable<DeleteServiceRequest, Operation> deleteServiceCallable;
    private final OperationCallable<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationCallable;
    private final UnaryCallable<UndeleteServiceRequest, Operation> undeleteServiceCallable;
    private final OperationCallable<UndeleteServiceRequest, UndeleteServiceResponse, OperationMetadata> undeleteServiceOperationCallable;
    private final UnaryCallable<ListServiceConfigsRequest, ListServiceConfigsResponse> listServiceConfigsCallable;
    private final UnaryCallable<ListServiceConfigsRequest, ServiceManagerClient.ListServiceConfigsPagedResponse> listServiceConfigsPagedCallable;
    private final UnaryCallable<GetServiceConfigRequest, Service> getServiceConfigCallable;
    private final UnaryCallable<CreateServiceConfigRequest, Service> createServiceConfigCallable;
    private final UnaryCallable<SubmitConfigSourceRequest, Operation> submitConfigSourceCallable;
    private final OperationCallable<SubmitConfigSourceRequest, SubmitConfigSourceResponse, OperationMetadata> submitConfigSourceOperationCallable;
    private final UnaryCallable<ListServiceRolloutsRequest, ListServiceRolloutsResponse> listServiceRolloutsCallable;
    private final UnaryCallable<ListServiceRolloutsRequest, ServiceManagerClient.ListServiceRolloutsPagedResponse> listServiceRolloutsPagedCallable;
    private final UnaryCallable<GetServiceRolloutRequest, Rollout> getServiceRolloutCallable;
    private final UnaryCallable<CreateServiceRolloutRequest, Operation> createServiceRolloutCallable;
    private final OperationCallable<CreateServiceRolloutRequest, Rollout, OperationMetadata> createServiceRolloutOperationCallable;
    private final UnaryCallable<GenerateConfigReportRequest, GenerateConfigReportResponse> generateConfigReportCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonServiceManagerStub create(ServiceManagerStubSettings settings) throws IOException {
        return new HttpJsonServiceManagerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonServiceManagerStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonServiceManagerStub(ServiceManagerStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonServiceManagerStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonServiceManagerStub(ServiceManagerStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonServiceManagerStub(ServiceManagerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonServiceManagerCallableFactory());
    }

    protected HttpJsonServiceManagerStub(ServiceManagerStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/operations").build()).build());
        HttpJsonCallSettings listServicesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listServicesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getServiceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getServiceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("service_name", String.valueOf(request.getServiceName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createServiceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createServiceMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteServiceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteServiceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("service_name", String.valueOf(request.getServiceName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings undeleteServiceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(undeleteServiceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("service_name", String.valueOf(request.getServiceName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listServiceConfigsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listServiceConfigsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("service_name", String.valueOf(request.getServiceName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getServiceConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getServiceConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("config_id", String.valueOf(request.getConfigId()));
            builder.add("service_name", String.valueOf(request.getServiceName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createServiceConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createServiceConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("service_name", String.valueOf(request.getServiceName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings submitConfigSourceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(submitConfigSourceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("service_name", String.valueOf(request.getServiceName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listServiceRolloutsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listServiceRolloutsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("service_name", String.valueOf(request.getServiceName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getServiceRolloutTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getServiceRolloutMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("rollout_id", String.valueOf(request.getRolloutId()));
            builder.add("service_name", String.valueOf(request.getServiceName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createServiceRolloutTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createServiceRolloutMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("service_name", String.valueOf(request.getServiceName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings generateConfigReportTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(generateConfigReportMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.listServicesCallable = callableFactory.createUnaryCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.listServicesPagedCallable = callableFactory.createPagedCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.getServiceCallable = callableFactory.createUnaryCallable(getServiceTransportSettings, settings.getServiceSettings(), clientContext);
        this.createServiceCallable = callableFactory.createUnaryCallable(createServiceTransportSettings, settings.createServiceSettings(), clientContext);
        this.createServiceOperationCallable = callableFactory.createOperationCallable(createServiceTransportSettings, settings.createServiceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteServiceCallable = callableFactory.createUnaryCallable(deleteServiceTransportSettings, settings.deleteServiceSettings(), clientContext);
        this.deleteServiceOperationCallable = callableFactory.createOperationCallable(deleteServiceTransportSettings, settings.deleteServiceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.undeleteServiceCallable = callableFactory.createUnaryCallable(undeleteServiceTransportSettings, settings.undeleteServiceSettings(), clientContext);
        this.undeleteServiceOperationCallable = callableFactory.createOperationCallable(undeleteServiceTransportSettings, settings.undeleteServiceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listServiceConfigsCallable = callableFactory.createUnaryCallable(listServiceConfigsTransportSettings, settings.listServiceConfigsSettings(), clientContext);
        this.listServiceConfigsPagedCallable = callableFactory.createPagedCallable(listServiceConfigsTransportSettings, settings.listServiceConfigsSettings(), clientContext);
        this.getServiceConfigCallable = callableFactory.createUnaryCallable(getServiceConfigTransportSettings, settings.getServiceConfigSettings(), clientContext);
        this.createServiceConfigCallable = callableFactory.createUnaryCallable(createServiceConfigTransportSettings, settings.createServiceConfigSettings(), clientContext);
        this.submitConfigSourceCallable = callableFactory.createUnaryCallable(submitConfigSourceTransportSettings, settings.submitConfigSourceSettings(), clientContext);
        this.submitConfigSourceOperationCallable = callableFactory.createOperationCallable(submitConfigSourceTransportSettings, settings.submitConfigSourceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listServiceRolloutsCallable = callableFactory.createUnaryCallable(listServiceRolloutsTransportSettings, settings.listServiceRolloutsSettings(), clientContext);
        this.listServiceRolloutsPagedCallable = callableFactory.createPagedCallable(listServiceRolloutsTransportSettings, settings.listServiceRolloutsSettings(), clientContext);
        this.getServiceRolloutCallable = callableFactory.createUnaryCallable(getServiceRolloutTransportSettings, settings.getServiceRolloutSettings(), clientContext);
        this.createServiceRolloutCallable = callableFactory.createUnaryCallable(createServiceRolloutTransportSettings, settings.createServiceRolloutSettings(), clientContext);
        this.createServiceRolloutOperationCallable = callableFactory.createOperationCallable(createServiceRolloutTransportSettings, settings.createServiceRolloutOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.generateConfigReportCallable = callableFactory.createUnaryCallable(generateConfigReportTransportSettings, settings.generateConfigReportSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listServicesMethodDescriptor);
        methodDescriptors.add(getServiceMethodDescriptor);
        methodDescriptors.add(createServiceMethodDescriptor);
        methodDescriptors.add(deleteServiceMethodDescriptor);
        methodDescriptors.add(undeleteServiceMethodDescriptor);
        methodDescriptors.add(listServiceConfigsMethodDescriptor);
        methodDescriptors.add(getServiceConfigMethodDescriptor);
        methodDescriptors.add(createServiceConfigMethodDescriptor);
        methodDescriptors.add(submitConfigSourceMethodDescriptor);
        methodDescriptors.add(listServiceRolloutsMethodDescriptor);
        methodDescriptors.add(getServiceRolloutMethodDescriptor);
        methodDescriptors.add(createServiceRolloutMethodDescriptor);
        methodDescriptors.add(generateConfigReportMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.listServicesCallable;
    }

    @Override
    public UnaryCallable<ListServicesRequest, ServiceManagerClient.ListServicesPagedResponse> listServicesPagedCallable() {
        return this.listServicesPagedCallable;
    }

    @Override
    public UnaryCallable<GetServiceRequest, ManagedService> getServiceCallable() {
        return this.getServiceCallable;
    }

    @Override
    public UnaryCallable<CreateServiceRequest, Operation> createServiceCallable() {
        return this.createServiceCallable;
    }

    @Override
    public OperationCallable<CreateServiceRequest, ManagedService, OperationMetadata> createServiceOperationCallable() {
        return this.createServiceOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteServiceRequest, Operation> deleteServiceCallable() {
        return this.deleteServiceCallable;
    }

    @Override
    public OperationCallable<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationCallable() {
        return this.deleteServiceOperationCallable;
    }

    @Override
    public UnaryCallable<UndeleteServiceRequest, Operation> undeleteServiceCallable() {
        return this.undeleteServiceCallable;
    }

    @Override
    public OperationCallable<UndeleteServiceRequest, UndeleteServiceResponse, OperationMetadata> undeleteServiceOperationCallable() {
        return this.undeleteServiceOperationCallable;
    }

    @Override
    public UnaryCallable<ListServiceConfigsRequest, ListServiceConfigsResponse> listServiceConfigsCallable() {
        return this.listServiceConfigsCallable;
    }

    @Override
    public UnaryCallable<ListServiceConfigsRequest, ServiceManagerClient.ListServiceConfigsPagedResponse> listServiceConfigsPagedCallable() {
        return this.listServiceConfigsPagedCallable;
    }

    @Override
    public UnaryCallable<GetServiceConfigRequest, Service> getServiceConfigCallable() {
        return this.getServiceConfigCallable;
    }

    @Override
    public UnaryCallable<CreateServiceConfigRequest, Service> createServiceConfigCallable() {
        return this.createServiceConfigCallable;
    }

    @Override
    public UnaryCallable<SubmitConfigSourceRequest, Operation> submitConfigSourceCallable() {
        return this.submitConfigSourceCallable;
    }

    @Override
    public OperationCallable<SubmitConfigSourceRequest, SubmitConfigSourceResponse, OperationMetadata> submitConfigSourceOperationCallable() {
        return this.submitConfigSourceOperationCallable;
    }

    @Override
    public UnaryCallable<ListServiceRolloutsRequest, ListServiceRolloutsResponse> listServiceRolloutsCallable() {
        return this.listServiceRolloutsCallable;
    }

    @Override
    public UnaryCallable<ListServiceRolloutsRequest, ServiceManagerClient.ListServiceRolloutsPagedResponse> listServiceRolloutsPagedCallable() {
        return this.listServiceRolloutsPagedCallable;
    }

    @Override
    public UnaryCallable<GetServiceRolloutRequest, Rollout> getServiceRolloutCallable() {
        return this.getServiceRolloutCallable;
    }

    @Override
    public UnaryCallable<CreateServiceRolloutRequest, Operation> createServiceRolloutCallable() {
        return this.createServiceRolloutCallable;
    }

    @Override
    public OperationCallable<CreateServiceRolloutRequest, Rollout, OperationMetadata> createServiceRolloutOperationCallable() {
        return this.createServiceRolloutOperationCallable;
    }

    @Override
    public UnaryCallable<GenerateConfigReportRequest, GenerateConfigReportResponse> generateConfigReportCallable() {
        return this.generateConfigReportCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

