/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.securitycenter.v2.AttackPath;
import com.google.cloud.securitycenter.v2.BatchCreateResourceValueConfigsRequest;
import com.google.cloud.securitycenter.v2.BatchCreateResourceValueConfigsResponse;
import com.google.cloud.securitycenter.v2.BigQueryExport;
import com.google.cloud.securitycenter.v2.BigQueryExportName;
import com.google.cloud.securitycenter.v2.BulkMuteFindingsRequest;
import com.google.cloud.securitycenter.v2.BulkMuteFindingsResponse;
import com.google.cloud.securitycenter.v2.CreateBigQueryExportRequest;
import com.google.cloud.securitycenter.v2.CreateFindingRequest;
import com.google.cloud.securitycenter.v2.CreateMuteConfigRequest;
import com.google.cloud.securitycenter.v2.CreateNotificationConfigRequest;
import com.google.cloud.securitycenter.v2.CreateResourceValueConfigRequest;
import com.google.cloud.securitycenter.v2.CreateSourceRequest;
import com.google.cloud.securitycenter.v2.DeleteBigQueryExportRequest;
import com.google.cloud.securitycenter.v2.DeleteMuteConfigRequest;
import com.google.cloud.securitycenter.v2.DeleteNotificationConfigRequest;
import com.google.cloud.securitycenter.v2.DeleteResourceValueConfigRequest;
import com.google.cloud.securitycenter.v2.ExternalSystem;
import com.google.cloud.securitycenter.v2.Finding;
import com.google.cloud.securitycenter.v2.FindingName;
import com.google.cloud.securitycenter.v2.FolderLocationName;
import com.google.cloud.securitycenter.v2.FolderName;
import com.google.cloud.securitycenter.v2.GetBigQueryExportRequest;
import com.google.cloud.securitycenter.v2.GetMuteConfigRequest;
import com.google.cloud.securitycenter.v2.GetNotificationConfigRequest;
import com.google.cloud.securitycenter.v2.GetResourceValueConfigRequest;
import com.google.cloud.securitycenter.v2.GetSimulationRequest;
import com.google.cloud.securitycenter.v2.GetSourceRequest;
import com.google.cloud.securitycenter.v2.GetValuedResourceRequest;
import com.google.cloud.securitycenter.v2.GroupFindingsRequest;
import com.google.cloud.securitycenter.v2.GroupFindingsResponse;
import com.google.cloud.securitycenter.v2.GroupResult;
import com.google.cloud.securitycenter.v2.ListAttackPathsRequest;
import com.google.cloud.securitycenter.v2.ListAttackPathsResponse;
import com.google.cloud.securitycenter.v2.ListBigQueryExportsRequest;
import com.google.cloud.securitycenter.v2.ListBigQueryExportsResponse;
import com.google.cloud.securitycenter.v2.ListFindingsRequest;
import com.google.cloud.securitycenter.v2.ListFindingsResponse;
import com.google.cloud.securitycenter.v2.ListMuteConfigsRequest;
import com.google.cloud.securitycenter.v2.ListMuteConfigsResponse;
import com.google.cloud.securitycenter.v2.ListNotificationConfigsRequest;
import com.google.cloud.securitycenter.v2.ListNotificationConfigsResponse;
import com.google.cloud.securitycenter.v2.ListResourceValueConfigsRequest;
import com.google.cloud.securitycenter.v2.ListResourceValueConfigsResponse;
import com.google.cloud.securitycenter.v2.ListSourcesRequest;
import com.google.cloud.securitycenter.v2.ListSourcesResponse;
import com.google.cloud.securitycenter.v2.ListValuedResourcesRequest;
import com.google.cloud.securitycenter.v2.ListValuedResourcesResponse;
import com.google.cloud.securitycenter.v2.LocationName;
import com.google.cloud.securitycenter.v2.MuteConfig;
import com.google.cloud.securitycenter.v2.MuteConfigName;
import com.google.cloud.securitycenter.v2.NotificationConfig;
import com.google.cloud.securitycenter.v2.NotificationConfigName;
import com.google.cloud.securitycenter.v2.OrganizationLocationName;
import com.google.cloud.securitycenter.v2.OrganizationName;
import com.google.cloud.securitycenter.v2.ProjectName;
import com.google.cloud.securitycenter.v2.ResourceValueConfig;
import com.google.cloud.securitycenter.v2.ResourceValueConfigName;
import com.google.cloud.securitycenter.v2.SecurityCenterSettings;
import com.google.cloud.securitycenter.v2.SecurityMarks;
import com.google.cloud.securitycenter.v2.SetFindingStateRequest;
import com.google.cloud.securitycenter.v2.SetMuteRequest;
import com.google.cloud.securitycenter.v2.Simulation;
import com.google.cloud.securitycenter.v2.SimulationName;
import com.google.cloud.securitycenter.v2.Source;
import com.google.cloud.securitycenter.v2.SourceName;
import com.google.cloud.securitycenter.v2.UpdateBigQueryExportRequest;
import com.google.cloud.securitycenter.v2.UpdateExternalSystemRequest;
import com.google.cloud.securitycenter.v2.UpdateFindingRequest;
import com.google.cloud.securitycenter.v2.UpdateMuteConfigRequest;
import com.google.cloud.securitycenter.v2.UpdateNotificationConfigRequest;
import com.google.cloud.securitycenter.v2.UpdateResourceValueConfigRequest;
import com.google.cloud.securitycenter.v2.UpdateSecurityMarksRequest;
import com.google.cloud.securitycenter.v2.UpdateSourceRequest;
import com.google.cloud.securitycenter.v2.ValuedResource;
import com.google.cloud.securitycenter.v2.ValuedResourceName;
import com.google.cloud.securitycenter.v2.stub.SecurityCenterStub;
import com.google.cloud.securitycenter.v2.stub.SecurityCenterStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SecurityCenterClient
implements BackgroundResource {
    private final SecurityCenterSettings settings;
    private final SecurityCenterStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final SecurityCenterClient create() throws IOException {
        return SecurityCenterClient.create(SecurityCenterSettings.newBuilder().build());
    }

    public static final SecurityCenterClient create(SecurityCenterSettings settings) throws IOException {
        return new SecurityCenterClient(settings);
    }

    public static final SecurityCenterClient create(SecurityCenterStub stub) {
        return new SecurityCenterClient(stub);
    }

    protected SecurityCenterClient(SecurityCenterSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SecurityCenterStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected SecurityCenterClient(SecurityCenterStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final SecurityCenterSettings getSettings() {
        return this.settings;
    }

    public SecurityCenterStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final BatchCreateResourceValueConfigsResponse batchCreateResourceValueConfigs(OrganizationName parent, List<CreateResourceValueConfigRequest> requests) {
        BatchCreateResourceValueConfigsRequest request = BatchCreateResourceValueConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchCreateResourceValueConfigs(request);
    }

    public final BatchCreateResourceValueConfigsResponse batchCreateResourceValueConfigs(String parent, List<CreateResourceValueConfigRequest> requests) {
        BatchCreateResourceValueConfigsRequest request = BatchCreateResourceValueConfigsRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchCreateResourceValueConfigs(request);
    }

    public final BatchCreateResourceValueConfigsResponse batchCreateResourceValueConfigs(BatchCreateResourceValueConfigsRequest request) {
        return (BatchCreateResourceValueConfigsResponse)this.batchCreateResourceValueConfigsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchCreateResourceValueConfigsRequest, BatchCreateResourceValueConfigsResponse> batchCreateResourceValueConfigsCallable() {
        return this.stub.batchCreateResourceValueConfigsCallable();
    }

    public final OperationFuture<BulkMuteFindingsResponse, Empty> bulkMuteFindingsAsync(ResourceName parent) {
        BulkMuteFindingsRequest request = BulkMuteFindingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.bulkMuteFindingsAsync(request);
    }

    public final OperationFuture<BulkMuteFindingsResponse, Empty> bulkMuteFindingsAsync(String parent) {
        BulkMuteFindingsRequest request = BulkMuteFindingsRequest.newBuilder().setParent(parent).build();
        return this.bulkMuteFindingsAsync(request);
    }

    public final OperationFuture<BulkMuteFindingsResponse, Empty> bulkMuteFindingsAsync(BulkMuteFindingsRequest request) {
        return this.bulkMuteFindingsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BulkMuteFindingsRequest, BulkMuteFindingsResponse, Empty> bulkMuteFindingsOperationCallable() {
        return this.stub.bulkMuteFindingsOperationCallable();
    }

    public final UnaryCallable<BulkMuteFindingsRequest, Operation> bulkMuteFindingsCallable() {
        return this.stub.bulkMuteFindingsCallable();
    }

    public final BigQueryExport createBigQueryExport(FolderLocationName parent, BigQueryExport bigQueryExport, String bigQueryExportId) {
        CreateBigQueryExportRequest request = CreateBigQueryExportRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBigQueryExport(bigQueryExport).setBigQueryExportId(bigQueryExportId).build();
        return this.createBigQueryExport(request);
    }

    public final BigQueryExport createBigQueryExport(LocationName parent, BigQueryExport bigQueryExport, String bigQueryExportId) {
        CreateBigQueryExportRequest request = CreateBigQueryExportRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBigQueryExport(bigQueryExport).setBigQueryExportId(bigQueryExportId).build();
        return this.createBigQueryExport(request);
    }

    public final BigQueryExport createBigQueryExport(OrganizationLocationName parent, BigQueryExport bigQueryExport, String bigQueryExportId) {
        CreateBigQueryExportRequest request = CreateBigQueryExportRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBigQueryExport(bigQueryExport).setBigQueryExportId(bigQueryExportId).build();
        return this.createBigQueryExport(request);
    }

    public final BigQueryExport createBigQueryExport(String parent, BigQueryExport bigQueryExport, String bigQueryExportId) {
        CreateBigQueryExportRequest request = CreateBigQueryExportRequest.newBuilder().setParent(parent).setBigQueryExport(bigQueryExport).setBigQueryExportId(bigQueryExportId).build();
        return this.createBigQueryExport(request);
    }

    public final BigQueryExport createBigQueryExport(CreateBigQueryExportRequest request) {
        return (BigQueryExport)this.createBigQueryExportCallable().call((Object)request);
    }

    public final UnaryCallable<CreateBigQueryExportRequest, BigQueryExport> createBigQueryExportCallable() {
        return this.stub.createBigQueryExportCallable();
    }

    public final Finding createFinding(SourceName parent, Finding finding, String findingId) {
        CreateFindingRequest request = CreateFindingRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFinding(finding).setFindingId(findingId).build();
        return this.createFinding(request);
    }

    public final Finding createFinding(String parent, Finding finding, String findingId) {
        CreateFindingRequest request = CreateFindingRequest.newBuilder().setParent(parent).setFinding(finding).setFindingId(findingId).build();
        return this.createFinding(request);
    }

    public final Finding createFinding(CreateFindingRequest request) {
        return (Finding)this.createFindingCallable().call((Object)request);
    }

    public final UnaryCallable<CreateFindingRequest, Finding> createFindingCallable() {
        return this.stub.createFindingCallable();
    }

    public final MuteConfig createMuteConfig(FolderLocationName parent, MuteConfig muteConfig, String muteConfigId) {
        CreateMuteConfigRequest request = CreateMuteConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMuteConfig(muteConfig).setMuteConfigId(muteConfigId).build();
        return this.createMuteConfig(request);
    }

    public final MuteConfig createMuteConfig(FolderName parent, MuteConfig muteConfig, String muteConfigId) {
        CreateMuteConfigRequest request = CreateMuteConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMuteConfig(muteConfig).setMuteConfigId(muteConfigId).build();
        return this.createMuteConfig(request);
    }

    public final MuteConfig createMuteConfig(LocationName parent, MuteConfig muteConfig, String muteConfigId) {
        CreateMuteConfigRequest request = CreateMuteConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMuteConfig(muteConfig).setMuteConfigId(muteConfigId).build();
        return this.createMuteConfig(request);
    }

    public final MuteConfig createMuteConfig(OrganizationLocationName parent, MuteConfig muteConfig, String muteConfigId) {
        CreateMuteConfigRequest request = CreateMuteConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMuteConfig(muteConfig).setMuteConfigId(muteConfigId).build();
        return this.createMuteConfig(request);
    }

    public final MuteConfig createMuteConfig(OrganizationName parent, MuteConfig muteConfig, String muteConfigId) {
        CreateMuteConfigRequest request = CreateMuteConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMuteConfig(muteConfig).setMuteConfigId(muteConfigId).build();
        return this.createMuteConfig(request);
    }

    public final MuteConfig createMuteConfig(ProjectName parent, MuteConfig muteConfig, String muteConfigId) {
        CreateMuteConfigRequest request = CreateMuteConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMuteConfig(muteConfig).setMuteConfigId(muteConfigId).build();
        return this.createMuteConfig(request);
    }

    public final MuteConfig createMuteConfig(String parent, MuteConfig muteConfig, String muteConfigId) {
        CreateMuteConfigRequest request = CreateMuteConfigRequest.newBuilder().setParent(parent).setMuteConfig(muteConfig).setMuteConfigId(muteConfigId).build();
        return this.createMuteConfig(request);
    }

    public final MuteConfig createMuteConfig(CreateMuteConfigRequest request) {
        return (MuteConfig)this.createMuteConfigCallable().call((Object)request);
    }

    public final UnaryCallable<CreateMuteConfigRequest, MuteConfig> createMuteConfigCallable() {
        return this.stub.createMuteConfigCallable();
    }

    public final NotificationConfig createNotificationConfig(FolderLocationName parent, NotificationConfig notificationConfig, String configId) {
        CreateNotificationConfigRequest request = CreateNotificationConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNotificationConfig(notificationConfig).setConfigId(configId).build();
        return this.createNotificationConfig(request);
    }

    public final NotificationConfig createNotificationConfig(LocationName parent, NotificationConfig notificationConfig, String configId) {
        CreateNotificationConfigRequest request = CreateNotificationConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNotificationConfig(notificationConfig).setConfigId(configId).build();
        return this.createNotificationConfig(request);
    }

    public final NotificationConfig createNotificationConfig(OrganizationLocationName parent, NotificationConfig notificationConfig, String configId) {
        CreateNotificationConfigRequest request = CreateNotificationConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNotificationConfig(notificationConfig).setConfigId(configId).build();
        return this.createNotificationConfig(request);
    }

    public final NotificationConfig createNotificationConfig(String parent, NotificationConfig notificationConfig, String configId) {
        CreateNotificationConfigRequest request = CreateNotificationConfigRequest.newBuilder().setParent(parent).setNotificationConfig(notificationConfig).setConfigId(configId).build();
        return this.createNotificationConfig(request);
    }

    public final NotificationConfig createNotificationConfig(CreateNotificationConfigRequest request) {
        return (NotificationConfig)this.createNotificationConfigCallable().call((Object)request);
    }

    public final UnaryCallable<CreateNotificationConfigRequest, NotificationConfig> createNotificationConfigCallable() {
        return this.stub.createNotificationConfigCallable();
    }

    public final Source createSource(OrganizationName parent, Source source) {
        CreateSourceRequest request = CreateSourceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSource(source).build();
        return this.createSource(request);
    }

    public final Source createSource(String parent, Source source) {
        CreateSourceRequest request = CreateSourceRequest.newBuilder().setParent(parent).setSource(source).build();
        return this.createSource(request);
    }

    public final Source createSource(CreateSourceRequest request) {
        return (Source)this.createSourceCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSourceRequest, Source> createSourceCallable() {
        return this.stub.createSourceCallable();
    }

    public final void deleteBigQueryExport(BigQueryExportName name) {
        DeleteBigQueryExportRequest request = DeleteBigQueryExportRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteBigQueryExport(request);
    }

    public final void deleteBigQueryExport(String name) {
        DeleteBigQueryExportRequest request = DeleteBigQueryExportRequest.newBuilder().setName(name).build();
        this.deleteBigQueryExport(request);
    }

    public final void deleteBigQueryExport(DeleteBigQueryExportRequest request) {
        this.deleteBigQueryExportCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteBigQueryExportRequest, Empty> deleteBigQueryExportCallable() {
        return this.stub.deleteBigQueryExportCallable();
    }

    public final void deleteMuteConfig(MuteConfigName name) {
        DeleteMuteConfigRequest request = DeleteMuteConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteMuteConfig(request);
    }

    public final void deleteMuteConfig(String name) {
        DeleteMuteConfigRequest request = DeleteMuteConfigRequest.newBuilder().setName(name).build();
        this.deleteMuteConfig(request);
    }

    public final void deleteMuteConfig(DeleteMuteConfigRequest request) {
        this.deleteMuteConfigCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteMuteConfigRequest, Empty> deleteMuteConfigCallable() {
        return this.stub.deleteMuteConfigCallable();
    }

    public final void deleteNotificationConfig(NotificationConfigName name) {
        DeleteNotificationConfigRequest request = DeleteNotificationConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteNotificationConfig(request);
    }

    public final void deleteNotificationConfig(String name) {
        DeleteNotificationConfigRequest request = DeleteNotificationConfigRequest.newBuilder().setName(name).build();
        this.deleteNotificationConfig(request);
    }

    public final void deleteNotificationConfig(DeleteNotificationConfigRequest request) {
        this.deleteNotificationConfigCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteNotificationConfigRequest, Empty> deleteNotificationConfigCallable() {
        return this.stub.deleteNotificationConfigCallable();
    }

    public final void deleteResourceValueConfig(ResourceValueConfigName name) {
        DeleteResourceValueConfigRequest request = DeleteResourceValueConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteResourceValueConfig(request);
    }

    public final void deleteResourceValueConfig(String name) {
        DeleteResourceValueConfigRequest request = DeleteResourceValueConfigRequest.newBuilder().setName(name).build();
        this.deleteResourceValueConfig(request);
    }

    public final void deleteResourceValueConfig(DeleteResourceValueConfigRequest request) {
        this.deleteResourceValueConfigCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteResourceValueConfigRequest, Empty> deleteResourceValueConfigCallable() {
        return this.stub.deleteResourceValueConfigCallable();
    }

    public final BigQueryExport getBigQueryExport(BigQueryExportName name) {
        GetBigQueryExportRequest request = GetBigQueryExportRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBigQueryExport(request);
    }

    public final BigQueryExport getBigQueryExport(String name) {
        GetBigQueryExportRequest request = GetBigQueryExportRequest.newBuilder().setName(name).build();
        return this.getBigQueryExport(request);
    }

    public final BigQueryExport getBigQueryExport(GetBigQueryExportRequest request) {
        return (BigQueryExport)this.getBigQueryExportCallable().call((Object)request);
    }

    public final UnaryCallable<GetBigQueryExportRequest, BigQueryExport> getBigQueryExportCallable() {
        return this.stub.getBigQueryExportCallable();
    }

    public final Simulation getSimulation(SimulationName name) {
        GetSimulationRequest request = GetSimulationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSimulation(request);
    }

    public final Simulation getSimulation(String name) {
        GetSimulationRequest request = GetSimulationRequest.newBuilder().setName(name).build();
        return this.getSimulation(request);
    }

    public final Simulation getSimulation(GetSimulationRequest request) {
        return (Simulation)this.getSimulationCallable().call((Object)request);
    }

    public final UnaryCallable<GetSimulationRequest, Simulation> getSimulationCallable() {
        return this.stub.getSimulationCallable();
    }

    public final ValuedResource getValuedResource(ValuedResourceName name) {
        GetValuedResourceRequest request = GetValuedResourceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getValuedResource(request);
    }

    public final ValuedResource getValuedResource(String name) {
        GetValuedResourceRequest request = GetValuedResourceRequest.newBuilder().setName(name).build();
        return this.getValuedResource(request);
    }

    public final ValuedResource getValuedResource(GetValuedResourceRequest request) {
        return (ValuedResource)this.getValuedResourceCallable().call((Object)request);
    }

    public final UnaryCallable<GetValuedResourceRequest, ValuedResource> getValuedResourceCallable() {
        return this.stub.getValuedResourceCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final MuteConfig getMuteConfig(MuteConfigName name) {
        GetMuteConfigRequest request = GetMuteConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMuteConfig(request);
    }

    public final MuteConfig getMuteConfig(String name) {
        GetMuteConfigRequest request = GetMuteConfigRequest.newBuilder().setName(name).build();
        return this.getMuteConfig(request);
    }

    public final MuteConfig getMuteConfig(GetMuteConfigRequest request) {
        return (MuteConfig)this.getMuteConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetMuteConfigRequest, MuteConfig> getMuteConfigCallable() {
        return this.stub.getMuteConfigCallable();
    }

    public final NotificationConfig getNotificationConfig(NotificationConfigName name) {
        GetNotificationConfigRequest request = GetNotificationConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNotificationConfig(request);
    }

    public final NotificationConfig getNotificationConfig(String name) {
        GetNotificationConfigRequest request = GetNotificationConfigRequest.newBuilder().setName(name).build();
        return this.getNotificationConfig(request);
    }

    public final NotificationConfig getNotificationConfig(GetNotificationConfigRequest request) {
        return (NotificationConfig)this.getNotificationConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetNotificationConfigRequest, NotificationConfig> getNotificationConfigCallable() {
        return this.stub.getNotificationConfigCallable();
    }

    public final ResourceValueConfig getResourceValueConfig(ResourceValueConfigName name) {
        GetResourceValueConfigRequest request = GetResourceValueConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getResourceValueConfig(request);
    }

    public final ResourceValueConfig getResourceValueConfig(String name) {
        GetResourceValueConfigRequest request = GetResourceValueConfigRequest.newBuilder().setName(name).build();
        return this.getResourceValueConfig(request);
    }

    public final ResourceValueConfig getResourceValueConfig(GetResourceValueConfigRequest request) {
        return (ResourceValueConfig)this.getResourceValueConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetResourceValueConfigRequest, ResourceValueConfig> getResourceValueConfigCallable() {
        return this.stub.getResourceValueConfigCallable();
    }

    public final Source getSource(SourceName name) {
        GetSourceRequest request = GetSourceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSource(request);
    }

    public final Source getSource(String name) {
        GetSourceRequest request = GetSourceRequest.newBuilder().setName(name).build();
        return this.getSource(request);
    }

    public final Source getSource(GetSourceRequest request) {
        return (Source)this.getSourceCallable().call((Object)request);
    }

    public final UnaryCallable<GetSourceRequest, Source> getSourceCallable() {
        return this.stub.getSourceCallable();
    }

    public final GroupFindingsPagedResponse groupFindings(SourceName parent, String groupBy) {
        GroupFindingsRequest request = GroupFindingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGroupBy(groupBy).build();
        return this.groupFindings(request);
    }

    public final GroupFindingsPagedResponse groupFindings(String parent, String groupBy) {
        GroupFindingsRequest request = GroupFindingsRequest.newBuilder().setParent(parent).setGroupBy(groupBy).build();
        return this.groupFindings(request);
    }

    public final GroupFindingsPagedResponse groupFindings(GroupFindingsRequest request) {
        return (GroupFindingsPagedResponse)((Object)this.groupFindingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<GroupFindingsRequest, GroupFindingsPagedResponse> groupFindingsPagedCallable() {
        return this.stub.groupFindingsPagedCallable();
    }

    public final UnaryCallable<GroupFindingsRequest, GroupFindingsResponse> groupFindingsCallable() {
        return this.stub.groupFindingsCallable();
    }

    public final ListAttackPathsPagedResponse listAttackPaths(ValuedResourceName parent) {
        ListAttackPathsRequest request = ListAttackPathsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAttackPaths(request);
    }

    public final ListAttackPathsPagedResponse listAttackPaths(String parent) {
        ListAttackPathsRequest request = ListAttackPathsRequest.newBuilder().setParent(parent).build();
        return this.listAttackPaths(request);
    }

    public final ListAttackPathsPagedResponse listAttackPaths(ListAttackPathsRequest request) {
        return (ListAttackPathsPagedResponse)((Object)this.listAttackPathsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAttackPathsRequest, ListAttackPathsPagedResponse> listAttackPathsPagedCallable() {
        return this.stub.listAttackPathsPagedCallable();
    }

    public final UnaryCallable<ListAttackPathsRequest, ListAttackPathsResponse> listAttackPathsCallable() {
        return this.stub.listAttackPathsCallable();
    }

    public final ListBigQueryExportsPagedResponse listBigQueryExports(FolderLocationName parent) {
        ListBigQueryExportsRequest request = ListBigQueryExportsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBigQueryExports(request);
    }

    public final ListBigQueryExportsPagedResponse listBigQueryExports(LocationName parent) {
        ListBigQueryExportsRequest request = ListBigQueryExportsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBigQueryExports(request);
    }

    public final ListBigQueryExportsPagedResponse listBigQueryExports(OrganizationLocationName parent) {
        ListBigQueryExportsRequest request = ListBigQueryExportsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBigQueryExports(request);
    }

    public final ListBigQueryExportsPagedResponse listBigQueryExports(String parent) {
        ListBigQueryExportsRequest request = ListBigQueryExportsRequest.newBuilder().setParent(parent).build();
        return this.listBigQueryExports(request);
    }

    public final ListBigQueryExportsPagedResponse listBigQueryExports(ListBigQueryExportsRequest request) {
        return (ListBigQueryExportsPagedResponse)((Object)this.listBigQueryExportsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBigQueryExportsRequest, ListBigQueryExportsPagedResponse> listBigQueryExportsPagedCallable() {
        return this.stub.listBigQueryExportsPagedCallable();
    }

    public final UnaryCallable<ListBigQueryExportsRequest, ListBigQueryExportsResponse> listBigQueryExportsCallable() {
        return this.stub.listBigQueryExportsCallable();
    }

    public final ListFindingsPagedResponse listFindings(SourceName parent) {
        ListFindingsRequest request = ListFindingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFindings(request);
    }

    public final ListFindingsPagedResponse listFindings(String parent) {
        ListFindingsRequest request = ListFindingsRequest.newBuilder().setParent(parent).build();
        return this.listFindings(request);
    }

    public final ListFindingsPagedResponse listFindings(ListFindingsRequest request) {
        return (ListFindingsPagedResponse)((Object)this.listFindingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFindingsRequest, ListFindingsPagedResponse> listFindingsPagedCallable() {
        return this.stub.listFindingsPagedCallable();
    }

    public final UnaryCallable<ListFindingsRequest, ListFindingsResponse> listFindingsCallable() {
        return this.stub.listFindingsCallable();
    }

    public final ListMuteConfigsPagedResponse listMuteConfigs(FolderLocationName parent) {
        ListMuteConfigsRequest request = ListMuteConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMuteConfigs(request);
    }

    public final ListMuteConfigsPagedResponse listMuteConfigs(FolderName parent) {
        ListMuteConfigsRequest request = ListMuteConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMuteConfigs(request);
    }

    public final ListMuteConfigsPagedResponse listMuteConfigs(LocationName parent) {
        ListMuteConfigsRequest request = ListMuteConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMuteConfigs(request);
    }

    public final ListMuteConfigsPagedResponse listMuteConfigs(OrganizationLocationName parent) {
        ListMuteConfigsRequest request = ListMuteConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMuteConfigs(request);
    }

    public final ListMuteConfigsPagedResponse listMuteConfigs(OrganizationName parent) {
        ListMuteConfigsRequest request = ListMuteConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMuteConfigs(request);
    }

    public final ListMuteConfigsPagedResponse listMuteConfigs(ProjectName parent) {
        ListMuteConfigsRequest request = ListMuteConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMuteConfigs(request);
    }

    public final ListMuteConfigsPagedResponse listMuteConfigs(String parent) {
        ListMuteConfigsRequest request = ListMuteConfigsRequest.newBuilder().setParent(parent).build();
        return this.listMuteConfigs(request);
    }

    public final ListMuteConfigsPagedResponse listMuteConfigs(ListMuteConfigsRequest request) {
        return (ListMuteConfigsPagedResponse)((Object)this.listMuteConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMuteConfigsRequest, ListMuteConfigsPagedResponse> listMuteConfigsPagedCallable() {
        return this.stub.listMuteConfigsPagedCallable();
    }

    public final UnaryCallable<ListMuteConfigsRequest, ListMuteConfigsResponse> listMuteConfigsCallable() {
        return this.stub.listMuteConfigsCallable();
    }

    public final ListNotificationConfigsPagedResponse listNotificationConfigs(FolderLocationName parent) {
        ListNotificationConfigsRequest request = ListNotificationConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNotificationConfigs(request);
    }

    public final ListNotificationConfigsPagedResponse listNotificationConfigs(LocationName parent) {
        ListNotificationConfigsRequest request = ListNotificationConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNotificationConfigs(request);
    }

    public final ListNotificationConfigsPagedResponse listNotificationConfigs(OrganizationLocationName parent) {
        ListNotificationConfigsRequest request = ListNotificationConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNotificationConfigs(request);
    }

    public final ListNotificationConfigsPagedResponse listNotificationConfigs(String parent) {
        ListNotificationConfigsRequest request = ListNotificationConfigsRequest.newBuilder().setParent(parent).build();
        return this.listNotificationConfigs(request);
    }

    public final ListNotificationConfigsPagedResponse listNotificationConfigs(ListNotificationConfigsRequest request) {
        return (ListNotificationConfigsPagedResponse)((Object)this.listNotificationConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNotificationConfigsRequest, ListNotificationConfigsPagedResponse> listNotificationConfigsPagedCallable() {
        return this.stub.listNotificationConfigsPagedCallable();
    }

    public final UnaryCallable<ListNotificationConfigsRequest, ListNotificationConfigsResponse> listNotificationConfigsCallable() {
        return this.stub.listNotificationConfigsCallable();
    }

    public final ListResourceValueConfigsPagedResponse listResourceValueConfigs(OrganizationName parent) {
        ListResourceValueConfigsRequest request = ListResourceValueConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listResourceValueConfigs(request);
    }

    public final ListResourceValueConfigsPagedResponse listResourceValueConfigs(String parent) {
        ListResourceValueConfigsRequest request = ListResourceValueConfigsRequest.newBuilder().setParent(parent).build();
        return this.listResourceValueConfigs(request);
    }

    public final ListResourceValueConfigsPagedResponse listResourceValueConfigs(ListResourceValueConfigsRequest request) {
        return (ListResourceValueConfigsPagedResponse)((Object)this.listResourceValueConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListResourceValueConfigsRequest, ListResourceValueConfigsPagedResponse> listResourceValueConfigsPagedCallable() {
        return this.stub.listResourceValueConfigsPagedCallable();
    }

    public final UnaryCallable<ListResourceValueConfigsRequest, ListResourceValueConfigsResponse> listResourceValueConfigsCallable() {
        return this.stub.listResourceValueConfigsCallable();
    }

    public final ListSourcesPagedResponse listSources(FolderName parent) {
        ListSourcesRequest request = ListSourcesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSources(request);
    }

    public final ListSourcesPagedResponse listSources(OrganizationName parent) {
        ListSourcesRequest request = ListSourcesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSources(request);
    }

    public final ListSourcesPagedResponse listSources(ProjectName parent) {
        ListSourcesRequest request = ListSourcesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSources(request);
    }

    public final ListSourcesPagedResponse listSources(String parent) {
        ListSourcesRequest request = ListSourcesRequest.newBuilder().setParent(parent).build();
        return this.listSources(request);
    }

    public final ListSourcesPagedResponse listSources(ListSourcesRequest request) {
        return (ListSourcesPagedResponse)((Object)this.listSourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSourcesRequest, ListSourcesPagedResponse> listSourcesPagedCallable() {
        return this.stub.listSourcesPagedCallable();
    }

    public final UnaryCallable<ListSourcesRequest, ListSourcesResponse> listSourcesCallable() {
        return this.stub.listSourcesCallable();
    }

    public final ListValuedResourcesPagedResponse listValuedResources(SimulationName parent) {
        ListValuedResourcesRequest request = ListValuedResourcesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listValuedResources(request);
    }

    public final ListValuedResourcesPagedResponse listValuedResources(String parent) {
        ListValuedResourcesRequest request = ListValuedResourcesRequest.newBuilder().setParent(parent).build();
        return this.listValuedResources(request);
    }

    public final ListValuedResourcesPagedResponse listValuedResources(ListValuedResourcesRequest request) {
        return (ListValuedResourcesPagedResponse)((Object)this.listValuedResourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListValuedResourcesRequest, ListValuedResourcesPagedResponse> listValuedResourcesPagedCallable() {
        return this.stub.listValuedResourcesPagedCallable();
    }

    public final UnaryCallable<ListValuedResourcesRequest, ListValuedResourcesResponse> listValuedResourcesCallable() {
        return this.stub.listValuedResourcesCallable();
    }

    public final Finding setFindingState(FindingName name, Finding.State state) {
        SetFindingStateRequest request = SetFindingStateRequest.newBuilder().setName(name == null ? null : name.toString()).setState(state).build();
        return this.setFindingState(request);
    }

    public final Finding setFindingState(String name, Finding.State state) {
        SetFindingStateRequest request = SetFindingStateRequest.newBuilder().setName(name).setState(state).build();
        return this.setFindingState(request);
    }

    public final Finding setFindingState(SetFindingStateRequest request) {
        return (Finding)this.setFindingStateCallable().call((Object)request);
    }

    public final UnaryCallable<SetFindingStateRequest, Finding> setFindingStateCallable() {
        return this.stub.setFindingStateCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Finding setMute(FindingName name, Finding.Mute mute) {
        SetMuteRequest request = SetMuteRequest.newBuilder().setName(name == null ? null : name.toString()).setMute(mute).build();
        return this.setMute(request);
    }

    public final Finding setMute(String name, Finding.Mute mute) {
        SetMuteRequest request = SetMuteRequest.newBuilder().setName(name).setMute(mute).build();
        return this.setMute(request);
    }

    public final Finding setMute(SetMuteRequest request) {
        return (Finding)this.setMuteCallable().call((Object)request);
    }

    public final UnaryCallable<SetMuteRequest, Finding> setMuteCallable() {
        return this.stub.setMuteCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final BigQueryExport updateBigQueryExport(BigQueryExport bigQueryExport, FieldMask updateMask) {
        UpdateBigQueryExportRequest request = UpdateBigQueryExportRequest.newBuilder().setBigQueryExport(bigQueryExport).setUpdateMask(updateMask).build();
        return this.updateBigQueryExport(request);
    }

    public final BigQueryExport updateBigQueryExport(UpdateBigQueryExportRequest request) {
        return (BigQueryExport)this.updateBigQueryExportCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateBigQueryExportRequest, BigQueryExport> updateBigQueryExportCallable() {
        return this.stub.updateBigQueryExportCallable();
    }

    public final ExternalSystem updateExternalSystem(ExternalSystem externalSystem, FieldMask updateMask) {
        UpdateExternalSystemRequest request = UpdateExternalSystemRequest.newBuilder().setExternalSystem(externalSystem).setUpdateMask(updateMask).build();
        return this.updateExternalSystem(request);
    }

    public final ExternalSystem updateExternalSystem(UpdateExternalSystemRequest request) {
        return (ExternalSystem)this.updateExternalSystemCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateExternalSystemRequest, ExternalSystem> updateExternalSystemCallable() {
        return this.stub.updateExternalSystemCallable();
    }

    public final Finding updateFinding(Finding finding, FieldMask updateMask) {
        UpdateFindingRequest request = UpdateFindingRequest.newBuilder().setFinding(finding).setUpdateMask(updateMask).build();
        return this.updateFinding(request);
    }

    public final Finding updateFinding(UpdateFindingRequest request) {
        return (Finding)this.updateFindingCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateFindingRequest, Finding> updateFindingCallable() {
        return this.stub.updateFindingCallable();
    }

    public final MuteConfig updateMuteConfig(MuteConfig muteConfig, FieldMask updateMask) {
        UpdateMuteConfigRequest request = UpdateMuteConfigRequest.newBuilder().setMuteConfig(muteConfig).setUpdateMask(updateMask).build();
        return this.updateMuteConfig(request);
    }

    public final MuteConfig updateMuteConfig(UpdateMuteConfigRequest request) {
        return (MuteConfig)this.updateMuteConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateMuteConfigRequest, MuteConfig> updateMuteConfigCallable() {
        return this.stub.updateMuteConfigCallable();
    }

    public final NotificationConfig updateNotificationConfig(NotificationConfig notificationConfig, FieldMask updateMask) {
        UpdateNotificationConfigRequest request = UpdateNotificationConfigRequest.newBuilder().setNotificationConfig(notificationConfig).setUpdateMask(updateMask).build();
        return this.updateNotificationConfig(request);
    }

    public final NotificationConfig updateNotificationConfig(UpdateNotificationConfigRequest request) {
        return (NotificationConfig)this.updateNotificationConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateNotificationConfigRequest, NotificationConfig> updateNotificationConfigCallable() {
        return this.stub.updateNotificationConfigCallable();
    }

    public final ResourceValueConfig updateResourceValueConfig(ResourceValueConfig resourceValueConfig, FieldMask updateMask) {
        UpdateResourceValueConfigRequest request = UpdateResourceValueConfigRequest.newBuilder().setResourceValueConfig(resourceValueConfig).setUpdateMask(updateMask).build();
        return this.updateResourceValueConfig(request);
    }

    public final ResourceValueConfig updateResourceValueConfig(UpdateResourceValueConfigRequest request) {
        return (ResourceValueConfig)this.updateResourceValueConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateResourceValueConfigRequest, ResourceValueConfig> updateResourceValueConfigCallable() {
        return this.stub.updateResourceValueConfigCallable();
    }

    public final SecurityMarks updateSecurityMarks(SecurityMarks securityMarks, FieldMask updateMask) {
        UpdateSecurityMarksRequest request = UpdateSecurityMarksRequest.newBuilder().setSecurityMarks(securityMarks).setUpdateMask(updateMask).build();
        return this.updateSecurityMarks(request);
    }

    public final SecurityMarks updateSecurityMarks(UpdateSecurityMarksRequest request) {
        return (SecurityMarks)this.updateSecurityMarksCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSecurityMarksRequest, SecurityMarks> updateSecurityMarksCallable() {
        return this.stub.updateSecurityMarksCallable();
    }

    public final Source updateSource(Source source, FieldMask updateMask) {
        UpdateSourceRequest request = UpdateSourceRequest.newBuilder().setSource(source).setUpdateMask(updateMask).build();
        return this.updateSource(request);
    }

    public final Source updateSource(UpdateSourceRequest request) {
        return (Source)this.updateSourceCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSourceRequest, Source> updateSourceCallable() {
        return this.stub.updateSourceCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListValuedResourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListValuedResourcesRequest, ListValuedResourcesResponse, ValuedResource, ListValuedResourcesPage, ListValuedResourcesFixedSizeCollection> {
        private ListValuedResourcesFixedSizeCollection(List<ListValuedResourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListValuedResourcesFixedSizeCollection createEmptyCollection() {
            return new ListValuedResourcesFixedSizeCollection(null, 0);
        }

        protected ListValuedResourcesFixedSizeCollection createCollection(List<ListValuedResourcesPage> pages, int collectionSize) {
            return new ListValuedResourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListValuedResourcesPage
    extends AbstractPage<ListValuedResourcesRequest, ListValuedResourcesResponse, ValuedResource, ListValuedResourcesPage> {
        private ListValuedResourcesPage(PageContext<ListValuedResourcesRequest, ListValuedResourcesResponse, ValuedResource> context, ListValuedResourcesResponse response) {
            super(context, (Object)response);
        }

        private static ListValuedResourcesPage createEmptyPage() {
            return new ListValuedResourcesPage(null, null);
        }

        protected ListValuedResourcesPage createPage(PageContext<ListValuedResourcesRequest, ListValuedResourcesResponse, ValuedResource> context, ListValuedResourcesResponse response) {
            return new ListValuedResourcesPage(context, response);
        }

        public ApiFuture<ListValuedResourcesPage> createPageAsync(PageContext<ListValuedResourcesRequest, ListValuedResourcesResponse, ValuedResource> context, ApiFuture<ListValuedResourcesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListValuedResourcesPagedResponse
    extends AbstractPagedListResponse<ListValuedResourcesRequest, ListValuedResourcesResponse, ValuedResource, ListValuedResourcesPage, ListValuedResourcesFixedSizeCollection> {
        public static ApiFuture<ListValuedResourcesPagedResponse> createAsync(PageContext<ListValuedResourcesRequest, ListValuedResourcesResponse, ValuedResource> context, ApiFuture<ListValuedResourcesResponse> futureResponse) {
            ApiFuture<ListValuedResourcesPage> futurePage = ListValuedResourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListValuedResourcesPagedResponse((ListValuedResourcesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListValuedResourcesPagedResponse(ListValuedResourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListValuedResourcesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSourcesRequest, ListSourcesResponse, Source, ListSourcesPage, ListSourcesFixedSizeCollection> {
        private ListSourcesFixedSizeCollection(List<ListSourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSourcesFixedSizeCollection createEmptyCollection() {
            return new ListSourcesFixedSizeCollection(null, 0);
        }

        protected ListSourcesFixedSizeCollection createCollection(List<ListSourcesPage> pages, int collectionSize) {
            return new ListSourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSourcesPage
    extends AbstractPage<ListSourcesRequest, ListSourcesResponse, Source, ListSourcesPage> {
        private ListSourcesPage(PageContext<ListSourcesRequest, ListSourcesResponse, Source> context, ListSourcesResponse response) {
            super(context, (Object)response);
        }

        private static ListSourcesPage createEmptyPage() {
            return new ListSourcesPage(null, null);
        }

        protected ListSourcesPage createPage(PageContext<ListSourcesRequest, ListSourcesResponse, Source> context, ListSourcesResponse response) {
            return new ListSourcesPage(context, response);
        }

        public ApiFuture<ListSourcesPage> createPageAsync(PageContext<ListSourcesRequest, ListSourcesResponse, Source> context, ApiFuture<ListSourcesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSourcesPagedResponse
    extends AbstractPagedListResponse<ListSourcesRequest, ListSourcesResponse, Source, ListSourcesPage, ListSourcesFixedSizeCollection> {
        public static ApiFuture<ListSourcesPagedResponse> createAsync(PageContext<ListSourcesRequest, ListSourcesResponse, Source> context, ApiFuture<ListSourcesResponse> futureResponse) {
            ApiFuture<ListSourcesPage> futurePage = ListSourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSourcesPagedResponse((ListSourcesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSourcesPagedResponse(ListSourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSourcesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListResourceValueConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListResourceValueConfigsRequest, ListResourceValueConfigsResponse, ResourceValueConfig, ListResourceValueConfigsPage, ListResourceValueConfigsFixedSizeCollection> {
        private ListResourceValueConfigsFixedSizeCollection(List<ListResourceValueConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListResourceValueConfigsFixedSizeCollection createEmptyCollection() {
            return new ListResourceValueConfigsFixedSizeCollection(null, 0);
        }

        protected ListResourceValueConfigsFixedSizeCollection createCollection(List<ListResourceValueConfigsPage> pages, int collectionSize) {
            return new ListResourceValueConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListResourceValueConfigsPage
    extends AbstractPage<ListResourceValueConfigsRequest, ListResourceValueConfigsResponse, ResourceValueConfig, ListResourceValueConfigsPage> {
        private ListResourceValueConfigsPage(PageContext<ListResourceValueConfigsRequest, ListResourceValueConfigsResponse, ResourceValueConfig> context, ListResourceValueConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListResourceValueConfigsPage createEmptyPage() {
            return new ListResourceValueConfigsPage(null, null);
        }

        protected ListResourceValueConfigsPage createPage(PageContext<ListResourceValueConfigsRequest, ListResourceValueConfigsResponse, ResourceValueConfig> context, ListResourceValueConfigsResponse response) {
            return new ListResourceValueConfigsPage(context, response);
        }

        public ApiFuture<ListResourceValueConfigsPage> createPageAsync(PageContext<ListResourceValueConfigsRequest, ListResourceValueConfigsResponse, ResourceValueConfig> context, ApiFuture<ListResourceValueConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListResourceValueConfigsPagedResponse
    extends AbstractPagedListResponse<ListResourceValueConfigsRequest, ListResourceValueConfigsResponse, ResourceValueConfig, ListResourceValueConfigsPage, ListResourceValueConfigsFixedSizeCollection> {
        public static ApiFuture<ListResourceValueConfigsPagedResponse> createAsync(PageContext<ListResourceValueConfigsRequest, ListResourceValueConfigsResponse, ResourceValueConfig> context, ApiFuture<ListResourceValueConfigsResponse> futureResponse) {
            ApiFuture<ListResourceValueConfigsPage> futurePage = ListResourceValueConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListResourceValueConfigsPagedResponse((ListResourceValueConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListResourceValueConfigsPagedResponse(ListResourceValueConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListResourceValueConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNotificationConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig, ListNotificationConfigsPage, ListNotificationConfigsFixedSizeCollection> {
        private ListNotificationConfigsFixedSizeCollection(List<ListNotificationConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNotificationConfigsFixedSizeCollection createEmptyCollection() {
            return new ListNotificationConfigsFixedSizeCollection(null, 0);
        }

        protected ListNotificationConfigsFixedSizeCollection createCollection(List<ListNotificationConfigsPage> pages, int collectionSize) {
            return new ListNotificationConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNotificationConfigsPage
    extends AbstractPage<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig, ListNotificationConfigsPage> {
        private ListNotificationConfigsPage(PageContext<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig> context, ListNotificationConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListNotificationConfigsPage createEmptyPage() {
            return new ListNotificationConfigsPage(null, null);
        }

        protected ListNotificationConfigsPage createPage(PageContext<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig> context, ListNotificationConfigsResponse response) {
            return new ListNotificationConfigsPage(context, response);
        }

        public ApiFuture<ListNotificationConfigsPage> createPageAsync(PageContext<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig> context, ApiFuture<ListNotificationConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNotificationConfigsPagedResponse
    extends AbstractPagedListResponse<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig, ListNotificationConfigsPage, ListNotificationConfigsFixedSizeCollection> {
        public static ApiFuture<ListNotificationConfigsPagedResponse> createAsync(PageContext<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig> context, ApiFuture<ListNotificationConfigsResponse> futureResponse) {
            ApiFuture<ListNotificationConfigsPage> futurePage = ListNotificationConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNotificationConfigsPagedResponse((ListNotificationConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNotificationConfigsPagedResponse(ListNotificationConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNotificationConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMuteConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMuteConfigsRequest, ListMuteConfigsResponse, MuteConfig, ListMuteConfigsPage, ListMuteConfigsFixedSizeCollection> {
        private ListMuteConfigsFixedSizeCollection(List<ListMuteConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMuteConfigsFixedSizeCollection createEmptyCollection() {
            return new ListMuteConfigsFixedSizeCollection(null, 0);
        }

        protected ListMuteConfigsFixedSizeCollection createCollection(List<ListMuteConfigsPage> pages, int collectionSize) {
            return new ListMuteConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMuteConfigsPage
    extends AbstractPage<ListMuteConfigsRequest, ListMuteConfigsResponse, MuteConfig, ListMuteConfigsPage> {
        private ListMuteConfigsPage(PageContext<ListMuteConfigsRequest, ListMuteConfigsResponse, MuteConfig> context, ListMuteConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListMuteConfigsPage createEmptyPage() {
            return new ListMuteConfigsPage(null, null);
        }

        protected ListMuteConfigsPage createPage(PageContext<ListMuteConfigsRequest, ListMuteConfigsResponse, MuteConfig> context, ListMuteConfigsResponse response) {
            return new ListMuteConfigsPage(context, response);
        }

        public ApiFuture<ListMuteConfigsPage> createPageAsync(PageContext<ListMuteConfigsRequest, ListMuteConfigsResponse, MuteConfig> context, ApiFuture<ListMuteConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMuteConfigsPagedResponse
    extends AbstractPagedListResponse<ListMuteConfigsRequest, ListMuteConfigsResponse, MuteConfig, ListMuteConfigsPage, ListMuteConfigsFixedSizeCollection> {
        public static ApiFuture<ListMuteConfigsPagedResponse> createAsync(PageContext<ListMuteConfigsRequest, ListMuteConfigsResponse, MuteConfig> context, ApiFuture<ListMuteConfigsResponse> futureResponse) {
            ApiFuture<ListMuteConfigsPage> futurePage = ListMuteConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMuteConfigsPagedResponse((ListMuteConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMuteConfigsPagedResponse(ListMuteConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMuteConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFindingsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFindingsRequest, ListFindingsResponse, ListFindingsResponse.ListFindingsResult, ListFindingsPage, ListFindingsFixedSizeCollection> {
        private ListFindingsFixedSizeCollection(List<ListFindingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFindingsFixedSizeCollection createEmptyCollection() {
            return new ListFindingsFixedSizeCollection(null, 0);
        }

        protected ListFindingsFixedSizeCollection createCollection(List<ListFindingsPage> pages, int collectionSize) {
            return new ListFindingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFindingsPage
    extends AbstractPage<ListFindingsRequest, ListFindingsResponse, ListFindingsResponse.ListFindingsResult, ListFindingsPage> {
        private ListFindingsPage(PageContext<ListFindingsRequest, ListFindingsResponse, ListFindingsResponse.ListFindingsResult> context, ListFindingsResponse response) {
            super(context, (Object)response);
        }

        private static ListFindingsPage createEmptyPage() {
            return new ListFindingsPage(null, null);
        }

        protected ListFindingsPage createPage(PageContext<ListFindingsRequest, ListFindingsResponse, ListFindingsResponse.ListFindingsResult> context, ListFindingsResponse response) {
            return new ListFindingsPage(context, response);
        }

        public ApiFuture<ListFindingsPage> createPageAsync(PageContext<ListFindingsRequest, ListFindingsResponse, ListFindingsResponse.ListFindingsResult> context, ApiFuture<ListFindingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFindingsPagedResponse
    extends AbstractPagedListResponse<ListFindingsRequest, ListFindingsResponse, ListFindingsResponse.ListFindingsResult, ListFindingsPage, ListFindingsFixedSizeCollection> {
        public static ApiFuture<ListFindingsPagedResponse> createAsync(PageContext<ListFindingsRequest, ListFindingsResponse, ListFindingsResponse.ListFindingsResult> context, ApiFuture<ListFindingsResponse> futureResponse) {
            ApiFuture<ListFindingsPage> futurePage = ListFindingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFindingsPagedResponse((ListFindingsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListFindingsPagedResponse(ListFindingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFindingsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBigQueryExportsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBigQueryExportsRequest, ListBigQueryExportsResponse, BigQueryExport, ListBigQueryExportsPage, ListBigQueryExportsFixedSizeCollection> {
        private ListBigQueryExportsFixedSizeCollection(List<ListBigQueryExportsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBigQueryExportsFixedSizeCollection createEmptyCollection() {
            return new ListBigQueryExportsFixedSizeCollection(null, 0);
        }

        protected ListBigQueryExportsFixedSizeCollection createCollection(List<ListBigQueryExportsPage> pages, int collectionSize) {
            return new ListBigQueryExportsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBigQueryExportsPage
    extends AbstractPage<ListBigQueryExportsRequest, ListBigQueryExportsResponse, BigQueryExport, ListBigQueryExportsPage> {
        private ListBigQueryExportsPage(PageContext<ListBigQueryExportsRequest, ListBigQueryExportsResponse, BigQueryExport> context, ListBigQueryExportsResponse response) {
            super(context, (Object)response);
        }

        private static ListBigQueryExportsPage createEmptyPage() {
            return new ListBigQueryExportsPage(null, null);
        }

        protected ListBigQueryExportsPage createPage(PageContext<ListBigQueryExportsRequest, ListBigQueryExportsResponse, BigQueryExport> context, ListBigQueryExportsResponse response) {
            return new ListBigQueryExportsPage(context, response);
        }

        public ApiFuture<ListBigQueryExportsPage> createPageAsync(PageContext<ListBigQueryExportsRequest, ListBigQueryExportsResponse, BigQueryExport> context, ApiFuture<ListBigQueryExportsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBigQueryExportsPagedResponse
    extends AbstractPagedListResponse<ListBigQueryExportsRequest, ListBigQueryExportsResponse, BigQueryExport, ListBigQueryExportsPage, ListBigQueryExportsFixedSizeCollection> {
        public static ApiFuture<ListBigQueryExportsPagedResponse> createAsync(PageContext<ListBigQueryExportsRequest, ListBigQueryExportsResponse, BigQueryExport> context, ApiFuture<ListBigQueryExportsResponse> futureResponse) {
            ApiFuture<ListBigQueryExportsPage> futurePage = ListBigQueryExportsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBigQueryExportsPagedResponse((ListBigQueryExportsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBigQueryExportsPagedResponse(ListBigQueryExportsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBigQueryExportsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAttackPathsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAttackPathsRequest, ListAttackPathsResponse, AttackPath, ListAttackPathsPage, ListAttackPathsFixedSizeCollection> {
        private ListAttackPathsFixedSizeCollection(List<ListAttackPathsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAttackPathsFixedSizeCollection createEmptyCollection() {
            return new ListAttackPathsFixedSizeCollection(null, 0);
        }

        protected ListAttackPathsFixedSizeCollection createCollection(List<ListAttackPathsPage> pages, int collectionSize) {
            return new ListAttackPathsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAttackPathsPage
    extends AbstractPage<ListAttackPathsRequest, ListAttackPathsResponse, AttackPath, ListAttackPathsPage> {
        private ListAttackPathsPage(PageContext<ListAttackPathsRequest, ListAttackPathsResponse, AttackPath> context, ListAttackPathsResponse response) {
            super(context, (Object)response);
        }

        private static ListAttackPathsPage createEmptyPage() {
            return new ListAttackPathsPage(null, null);
        }

        protected ListAttackPathsPage createPage(PageContext<ListAttackPathsRequest, ListAttackPathsResponse, AttackPath> context, ListAttackPathsResponse response) {
            return new ListAttackPathsPage(context, response);
        }

        public ApiFuture<ListAttackPathsPage> createPageAsync(PageContext<ListAttackPathsRequest, ListAttackPathsResponse, AttackPath> context, ApiFuture<ListAttackPathsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAttackPathsPagedResponse
    extends AbstractPagedListResponse<ListAttackPathsRequest, ListAttackPathsResponse, AttackPath, ListAttackPathsPage, ListAttackPathsFixedSizeCollection> {
        public static ApiFuture<ListAttackPathsPagedResponse> createAsync(PageContext<ListAttackPathsRequest, ListAttackPathsResponse, AttackPath> context, ApiFuture<ListAttackPathsResponse> futureResponse) {
            ApiFuture<ListAttackPathsPage> futurePage = ListAttackPathsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAttackPathsPagedResponse((ListAttackPathsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAttackPathsPagedResponse(ListAttackPathsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAttackPathsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class GroupFindingsFixedSizeCollection
    extends AbstractFixedSizeCollection<GroupFindingsRequest, GroupFindingsResponse, GroupResult, GroupFindingsPage, GroupFindingsFixedSizeCollection> {
        private GroupFindingsFixedSizeCollection(List<GroupFindingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static GroupFindingsFixedSizeCollection createEmptyCollection() {
            return new GroupFindingsFixedSizeCollection(null, 0);
        }

        protected GroupFindingsFixedSizeCollection createCollection(List<GroupFindingsPage> pages, int collectionSize) {
            return new GroupFindingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class GroupFindingsPage
    extends AbstractPage<GroupFindingsRequest, GroupFindingsResponse, GroupResult, GroupFindingsPage> {
        private GroupFindingsPage(PageContext<GroupFindingsRequest, GroupFindingsResponse, GroupResult> context, GroupFindingsResponse response) {
            super(context, (Object)response);
        }

        private static GroupFindingsPage createEmptyPage() {
            return new GroupFindingsPage(null, null);
        }

        protected GroupFindingsPage createPage(PageContext<GroupFindingsRequest, GroupFindingsResponse, GroupResult> context, GroupFindingsResponse response) {
            return new GroupFindingsPage(context, response);
        }

        public ApiFuture<GroupFindingsPage> createPageAsync(PageContext<GroupFindingsRequest, GroupFindingsResponse, GroupResult> context, ApiFuture<GroupFindingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class GroupFindingsPagedResponse
    extends AbstractPagedListResponse<GroupFindingsRequest, GroupFindingsResponse, GroupResult, GroupFindingsPage, GroupFindingsFixedSizeCollection> {
        public static ApiFuture<GroupFindingsPagedResponse> createAsync(PageContext<GroupFindingsRequest, GroupFindingsResponse, GroupResult> context, ApiFuture<GroupFindingsResponse> futureResponse) {
            ApiFuture<GroupFindingsPage> futurePage = GroupFindingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new GroupFindingsPagedResponse((GroupFindingsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private GroupFindingsPagedResponse(GroupFindingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)GroupFindingsFixedSizeCollection.createEmptyCollection());
        }
    }
}

