/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.securitycenter.v1beta1.CreateFindingRequest;
import com.google.cloud.securitycenter.v1beta1.CreateSourceRequest;
import com.google.cloud.securitycenter.v1beta1.Finding;
import com.google.cloud.securitycenter.v1beta1.GetOrganizationSettingsRequest;
import com.google.cloud.securitycenter.v1beta1.GetSourceRequest;
import com.google.cloud.securitycenter.v1beta1.GroupAssetsRequest;
import com.google.cloud.securitycenter.v1beta1.GroupAssetsResponse;
import com.google.cloud.securitycenter.v1beta1.GroupFindingsRequest;
import com.google.cloud.securitycenter.v1beta1.GroupFindingsResponse;
import com.google.cloud.securitycenter.v1beta1.GroupResult;
import com.google.cloud.securitycenter.v1beta1.ListAssetsRequest;
import com.google.cloud.securitycenter.v1beta1.ListAssetsResponse;
import com.google.cloud.securitycenter.v1beta1.ListFindingsRequest;
import com.google.cloud.securitycenter.v1beta1.ListFindingsResponse;
import com.google.cloud.securitycenter.v1beta1.ListSourcesRequest;
import com.google.cloud.securitycenter.v1beta1.ListSourcesResponse;
import com.google.cloud.securitycenter.v1beta1.OrganizationSettings;
import com.google.cloud.securitycenter.v1beta1.RunAssetDiscoveryRequest;
import com.google.cloud.securitycenter.v1beta1.SecurityCenterClient;
import com.google.cloud.securitycenter.v1beta1.SecurityMarks;
import com.google.cloud.securitycenter.v1beta1.SetFindingStateRequest;
import com.google.cloud.securitycenter.v1beta1.Source;
import com.google.cloud.securitycenter.v1beta1.UpdateFindingRequest;
import com.google.cloud.securitycenter.v1beta1.UpdateOrganizationSettingsRequest;
import com.google.cloud.securitycenter.v1beta1.UpdateSecurityMarksRequest;
import com.google.cloud.securitycenter.v1beta1.UpdateSourceRequest;
import com.google.cloud.securitycenter.v1beta1.stub.GrpcSecurityCenterStub;
import com.google.cloud.securitycenter.v1beta1.stub.SecurityCenterStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class SecurityCenterStubSettings
extends StubSettings<SecurityCenterStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateSourceRequest, Source> createSourceSettings;
    private final UnaryCallSettings<CreateFindingRequest, Finding> createFindingSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<GetOrganizationSettingsRequest, OrganizationSettings> getOrganizationSettingsSettings;
    private final UnaryCallSettings<GetSourceRequest, Source> getSourceSettings;
    private final PagedCallSettings<GroupAssetsRequest, GroupAssetsResponse, SecurityCenterClient.GroupAssetsPagedResponse> groupAssetsSettings;
    private final PagedCallSettings<GroupFindingsRequest, GroupFindingsResponse, SecurityCenterClient.GroupFindingsPagedResponse> groupFindingsSettings;
    private final PagedCallSettings<ListAssetsRequest, ListAssetsResponse, SecurityCenterClient.ListAssetsPagedResponse> listAssetsSettings;
    private final PagedCallSettings<ListFindingsRequest, ListFindingsResponse, SecurityCenterClient.ListFindingsPagedResponse> listFindingsSettings;
    private final PagedCallSettings<ListSourcesRequest, ListSourcesResponse, SecurityCenterClient.ListSourcesPagedResponse> listSourcesSettings;
    private final UnaryCallSettings<RunAssetDiscoveryRequest, Operation> runAssetDiscoverySettings;
    private final OperationCallSettings<RunAssetDiscoveryRequest, Empty, Empty> runAssetDiscoveryOperationSettings;
    private final UnaryCallSettings<SetFindingStateRequest, Finding> setFindingStateSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private final UnaryCallSettings<UpdateFindingRequest, Finding> updateFindingSettings;
    private final UnaryCallSettings<UpdateOrganizationSettingsRequest, OrganizationSettings> updateOrganizationSettingsSettings;
    private final UnaryCallSettings<UpdateSourceRequest, Source> updateSourceSettings;
    private final UnaryCallSettings<UpdateSecurityMarksRequest, SecurityMarks> updateSecurityMarksSettings;
    private static final PagedListDescriptor<GroupAssetsRequest, GroupAssetsResponse, GroupResult> GROUP_ASSETS_PAGE_STR_DESC = new PagedListDescriptor<GroupAssetsRequest, GroupAssetsResponse, GroupResult>(){

        public String emptyToken() {
            return "";
        }

        public GroupAssetsRequest injectToken(GroupAssetsRequest payload, String token) {
            return GroupAssetsRequest.newBuilder((GroupAssetsRequest)payload).setPageToken(token).build();
        }

        public GroupAssetsRequest injectPageSize(GroupAssetsRequest payload, int pageSize) {
            return GroupAssetsRequest.newBuilder((GroupAssetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(GroupAssetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(GroupAssetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GroupResult> extractResources(GroupAssetsResponse payload) {
            return payload.getGroupByResultsList() != null ? payload.getGroupByResultsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<GroupFindingsRequest, GroupFindingsResponse, GroupResult> GROUP_FINDINGS_PAGE_STR_DESC = new PagedListDescriptor<GroupFindingsRequest, GroupFindingsResponse, GroupResult>(){

        public String emptyToken() {
            return "";
        }

        public GroupFindingsRequest injectToken(GroupFindingsRequest payload, String token) {
            return GroupFindingsRequest.newBuilder((GroupFindingsRequest)payload).setPageToken(token).build();
        }

        public GroupFindingsRequest injectPageSize(GroupFindingsRequest payload, int pageSize) {
            return GroupFindingsRequest.newBuilder((GroupFindingsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(GroupFindingsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(GroupFindingsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GroupResult> extractResources(GroupFindingsResponse payload) {
            return payload.getGroupByResultsList() != null ? payload.getGroupByResultsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListAssetsRequest, ListAssetsResponse, ListAssetsResponse.ListAssetsResult> LIST_ASSETS_PAGE_STR_DESC = new PagedListDescriptor<ListAssetsRequest, ListAssetsResponse, ListAssetsResponse.ListAssetsResult>(){

        public String emptyToken() {
            return "";
        }

        public ListAssetsRequest injectToken(ListAssetsRequest payload, String token) {
            return ListAssetsRequest.newBuilder((ListAssetsRequest)payload).setPageToken(token).build();
        }

        public ListAssetsRequest injectPageSize(ListAssetsRequest payload, int pageSize) {
            return ListAssetsRequest.newBuilder((ListAssetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAssetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAssetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ListAssetsResponse.ListAssetsResult> extractResources(ListAssetsResponse payload) {
            return payload.getListAssetsResultsList() != null ? payload.getListAssetsResultsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListFindingsRequest, ListFindingsResponse, Finding> LIST_FINDINGS_PAGE_STR_DESC = new PagedListDescriptor<ListFindingsRequest, ListFindingsResponse, Finding>(){

        public String emptyToken() {
            return "";
        }

        public ListFindingsRequest injectToken(ListFindingsRequest payload, String token) {
            return ListFindingsRequest.newBuilder((ListFindingsRequest)payload).setPageToken(token).build();
        }

        public ListFindingsRequest injectPageSize(ListFindingsRequest payload, int pageSize) {
            return ListFindingsRequest.newBuilder((ListFindingsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFindingsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFindingsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Finding> extractResources(ListFindingsResponse payload) {
            return payload.getFindingsList() != null ? payload.getFindingsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListSourcesRequest, ListSourcesResponse, Source> LIST_SOURCES_PAGE_STR_DESC = new PagedListDescriptor<ListSourcesRequest, ListSourcesResponse, Source>(){

        public String emptyToken() {
            return "";
        }

        public ListSourcesRequest injectToken(ListSourcesRequest payload, String token) {
            return ListSourcesRequest.newBuilder((ListSourcesRequest)payload).setPageToken(token).build();
        }

        public ListSourcesRequest injectPageSize(ListSourcesRequest payload, int pageSize) {
            return ListSourcesRequest.newBuilder((ListSourcesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSourcesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSourcesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Source> extractResources(ListSourcesResponse payload) {
            return payload.getSourcesList() != null ? payload.getSourcesList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<GroupAssetsRequest, GroupAssetsResponse, SecurityCenterClient.GroupAssetsPagedResponse> GROUP_ASSETS_PAGE_STR_FACT = new PagedListResponseFactory<GroupAssetsRequest, GroupAssetsResponse, SecurityCenterClient.GroupAssetsPagedResponse>(){

        public ApiFuture<SecurityCenterClient.GroupAssetsPagedResponse> getFuturePagedResponse(UnaryCallable<GroupAssetsRequest, GroupAssetsResponse> callable, GroupAssetsRequest request, ApiCallContext context, ApiFuture<GroupAssetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)GROUP_ASSETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SecurityCenterClient.GroupAssetsPagedResponse.createAsync((PageContext<GroupAssetsRequest, GroupAssetsResponse, GroupResult>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<GroupFindingsRequest, GroupFindingsResponse, SecurityCenterClient.GroupFindingsPagedResponse> GROUP_FINDINGS_PAGE_STR_FACT = new PagedListResponseFactory<GroupFindingsRequest, GroupFindingsResponse, SecurityCenterClient.GroupFindingsPagedResponse>(){

        public ApiFuture<SecurityCenterClient.GroupFindingsPagedResponse> getFuturePagedResponse(UnaryCallable<GroupFindingsRequest, GroupFindingsResponse> callable, GroupFindingsRequest request, ApiCallContext context, ApiFuture<GroupFindingsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)GROUP_FINDINGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SecurityCenterClient.GroupFindingsPagedResponse.createAsync((PageContext<GroupFindingsRequest, GroupFindingsResponse, GroupResult>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAssetsRequest, ListAssetsResponse, SecurityCenterClient.ListAssetsPagedResponse> LIST_ASSETS_PAGE_STR_FACT = new PagedListResponseFactory<ListAssetsRequest, ListAssetsResponse, SecurityCenterClient.ListAssetsPagedResponse>(){

        public ApiFuture<SecurityCenterClient.ListAssetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAssetsRequest, ListAssetsResponse> callable, ListAssetsRequest request, ApiCallContext context, ApiFuture<ListAssetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ASSETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SecurityCenterClient.ListAssetsPagedResponse.createAsync((PageContext<ListAssetsRequest, ListAssetsResponse, ListAssetsResponse.ListAssetsResult>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListFindingsRequest, ListFindingsResponse, SecurityCenterClient.ListFindingsPagedResponse> LIST_FINDINGS_PAGE_STR_FACT = new PagedListResponseFactory<ListFindingsRequest, ListFindingsResponse, SecurityCenterClient.ListFindingsPagedResponse>(){

        public ApiFuture<SecurityCenterClient.ListFindingsPagedResponse> getFuturePagedResponse(UnaryCallable<ListFindingsRequest, ListFindingsResponse> callable, ListFindingsRequest request, ApiCallContext context, ApiFuture<ListFindingsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FINDINGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SecurityCenterClient.ListFindingsPagedResponse.createAsync((PageContext<ListFindingsRequest, ListFindingsResponse, Finding>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSourcesRequest, ListSourcesResponse, SecurityCenterClient.ListSourcesPagedResponse> LIST_SOURCES_PAGE_STR_FACT = new PagedListResponseFactory<ListSourcesRequest, ListSourcesResponse, SecurityCenterClient.ListSourcesPagedResponse>(){

        public ApiFuture<SecurityCenterClient.ListSourcesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSourcesRequest, ListSourcesResponse> callable, ListSourcesRequest request, ApiCallContext context, ApiFuture<ListSourcesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SOURCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SecurityCenterClient.ListSourcesPagedResponse.createAsync((PageContext<ListSourcesRequest, ListSourcesResponse, Source>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateSourceRequest, Source> createSourceSettings() {
        return this.createSourceSettings;
    }

    public UnaryCallSettings<CreateFindingRequest, Finding> createFindingSettings() {
        return this.createFindingSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<GetOrganizationSettingsRequest, OrganizationSettings> getOrganizationSettingsSettings() {
        return this.getOrganizationSettingsSettings;
    }

    public UnaryCallSettings<GetSourceRequest, Source> getSourceSettings() {
        return this.getSourceSettings;
    }

    public PagedCallSettings<GroupAssetsRequest, GroupAssetsResponse, SecurityCenterClient.GroupAssetsPagedResponse> groupAssetsSettings() {
        return this.groupAssetsSettings;
    }

    public PagedCallSettings<GroupFindingsRequest, GroupFindingsResponse, SecurityCenterClient.GroupFindingsPagedResponse> groupFindingsSettings() {
        return this.groupFindingsSettings;
    }

    public PagedCallSettings<ListAssetsRequest, ListAssetsResponse, SecurityCenterClient.ListAssetsPagedResponse> listAssetsSettings() {
        return this.listAssetsSettings;
    }

    public PagedCallSettings<ListFindingsRequest, ListFindingsResponse, SecurityCenterClient.ListFindingsPagedResponse> listFindingsSettings() {
        return this.listFindingsSettings;
    }

    public PagedCallSettings<ListSourcesRequest, ListSourcesResponse, SecurityCenterClient.ListSourcesPagedResponse> listSourcesSettings() {
        return this.listSourcesSettings;
    }

    public UnaryCallSettings<RunAssetDiscoveryRequest, Operation> runAssetDiscoverySettings() {
        return this.runAssetDiscoverySettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<RunAssetDiscoveryRequest, Empty, Empty> runAssetDiscoveryOperationSettings() {
        return this.runAssetDiscoveryOperationSettings;
    }

    public UnaryCallSettings<SetFindingStateRequest, Finding> setFindingStateSettings() {
        return this.setFindingStateSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public UnaryCallSettings<UpdateFindingRequest, Finding> updateFindingSettings() {
        return this.updateFindingSettings;
    }

    public UnaryCallSettings<UpdateOrganizationSettingsRequest, OrganizationSettings> updateOrganizationSettingsSettings() {
        return this.updateOrganizationSettingsSettings;
    }

    public UnaryCallSettings<UpdateSourceRequest, Source> updateSourceSettings() {
        return this.updateSourceSettings;
    }

    public UnaryCallSettings<UpdateSecurityMarksRequest, SecurityMarks> updateSecurityMarksSettings() {
        return this.updateSecurityMarksSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SecurityCenterStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSecurityCenterStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "securitycenter.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SecurityCenterStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SecurityCenterStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SecurityCenterStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createSourceSettings = settingsBuilder.createSourceSettings().build();
        this.createFindingSettings = settingsBuilder.createFindingSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.getOrganizationSettingsSettings = settingsBuilder.getOrganizationSettingsSettings().build();
        this.getSourceSettings = settingsBuilder.getSourceSettings().build();
        this.groupAssetsSettings = settingsBuilder.groupAssetsSettings().build();
        this.groupFindingsSettings = settingsBuilder.groupFindingsSettings().build();
        this.listAssetsSettings = settingsBuilder.listAssetsSettings().build();
        this.listFindingsSettings = settingsBuilder.listFindingsSettings().build();
        this.listSourcesSettings = settingsBuilder.listSourcesSettings().build();
        this.runAssetDiscoverySettings = settingsBuilder.runAssetDiscoverySettings().build();
        this.runAssetDiscoveryOperationSettings = settingsBuilder.runAssetDiscoveryOperationSettings().build();
        this.setFindingStateSettings = settingsBuilder.setFindingStateSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
        this.updateFindingSettings = settingsBuilder.updateFindingSettings().build();
        this.updateOrganizationSettingsSettings = settingsBuilder.updateOrganizationSettingsSettings().build();
        this.updateSourceSettings = settingsBuilder.updateSourceSettings().build();
        this.updateSecurityMarksSettings = settingsBuilder.updateSecurityMarksSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SecurityCenterStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateSourceRequest, Source> createSourceSettings;
        private final UnaryCallSettings.Builder<CreateFindingRequest, Finding> createFindingSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<GetOrganizationSettingsRequest, OrganizationSettings> getOrganizationSettingsSettings;
        private final UnaryCallSettings.Builder<GetSourceRequest, Source> getSourceSettings;
        private final PagedCallSettings.Builder<GroupAssetsRequest, GroupAssetsResponse, SecurityCenterClient.GroupAssetsPagedResponse> groupAssetsSettings;
        private final PagedCallSettings.Builder<GroupFindingsRequest, GroupFindingsResponse, SecurityCenterClient.GroupFindingsPagedResponse> groupFindingsSettings;
        private final PagedCallSettings.Builder<ListAssetsRequest, ListAssetsResponse, SecurityCenterClient.ListAssetsPagedResponse> listAssetsSettings;
        private final PagedCallSettings.Builder<ListFindingsRequest, ListFindingsResponse, SecurityCenterClient.ListFindingsPagedResponse> listFindingsSettings;
        private final PagedCallSettings.Builder<ListSourcesRequest, ListSourcesResponse, SecurityCenterClient.ListSourcesPagedResponse> listSourcesSettings;
        private final UnaryCallSettings.Builder<RunAssetDiscoveryRequest, Operation> runAssetDiscoverySettings;
        private final OperationCallSettings.Builder<RunAssetDiscoveryRequest, Empty, Empty> runAssetDiscoveryOperationSettings;
        private final UnaryCallSettings.Builder<SetFindingStateRequest, Finding> setFindingStateSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private final UnaryCallSettings.Builder<UpdateFindingRequest, Finding> updateFindingSettings;
        private final UnaryCallSettings.Builder<UpdateOrganizationSettingsRequest, OrganizationSettings> updateOrganizationSettingsSettings;
        private final UnaryCallSettings.Builder<UpdateSourceRequest, Source> updateSourceSettings;
        private final UnaryCallSettings.Builder<UpdateSecurityMarksRequest, SecurityMarks> updateSecurityMarksSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFindingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getOrganizationSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.groupAssetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)GROUP_ASSETS_PAGE_STR_FACT);
            this.groupFindingsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)GROUP_FINDINGS_PAGE_STR_FACT);
            this.listAssetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ASSETS_PAGE_STR_FACT);
            this.listFindingsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FINDINGS_PAGE_STR_FACT);
            this.listSourcesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SOURCES_PAGE_STR_FACT);
            this.runAssetDiscoverySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runAssetDiscoveryOperationSettings = OperationCallSettings.newBuilder();
            this.setFindingStateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFindingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateOrganizationSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSecurityMarksSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSourceSettings, this.createFindingSettings, this.getIamPolicySettings, this.getOrganizationSettingsSettings, this.getSourceSettings, this.groupAssetsSettings, this.groupFindingsSettings, this.listAssetsSettings, this.listFindingsSettings, this.listSourcesSettings, this.runAssetDiscoverySettings, this.setFindingStateSettings, (Object[])new UnaryCallSettings.Builder[]{this.setIamPolicySettings, this.testIamPermissionsSettings, this.updateFindingSettings, this.updateOrganizationSettingsSettings, this.updateSourceSettings, this.updateSecurityMarksSettings});
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SecurityCenterStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SecurityCenterStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SecurityCenterStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(SecurityCenterStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createFindingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getOrganizationSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getSourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.groupAssetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.groupFindingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.listAssetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.listFindingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.listSourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.runAssetDiscoverySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setFindingStateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateFindingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateOrganizationSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateSourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateSecurityMarksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.runAssetDiscoveryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Empty.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        protected Builder(SecurityCenterStubSettings settings) {
            super((StubSettings)settings);
            this.createSourceSettings = settings.createSourceSettings.toBuilder();
            this.createFindingSettings = settings.createFindingSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.getOrganizationSettingsSettings = settings.getOrganizationSettingsSettings.toBuilder();
            this.getSourceSettings = settings.getSourceSettings.toBuilder();
            this.groupAssetsSettings = settings.groupAssetsSettings.toBuilder();
            this.groupFindingsSettings = settings.groupFindingsSettings.toBuilder();
            this.listAssetsSettings = settings.listAssetsSettings.toBuilder();
            this.listFindingsSettings = settings.listFindingsSettings.toBuilder();
            this.listSourcesSettings = settings.listSourcesSettings.toBuilder();
            this.runAssetDiscoverySettings = settings.runAssetDiscoverySettings.toBuilder();
            this.runAssetDiscoveryOperationSettings = settings.runAssetDiscoveryOperationSettings.toBuilder();
            this.setFindingStateSettings = settings.setFindingStateSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.updateFindingSettings = settings.updateFindingSettings.toBuilder();
            this.updateOrganizationSettingsSettings = settings.updateOrganizationSettingsSettings.toBuilder();
            this.updateSourceSettings = settings.updateSourceSettings.toBuilder();
            this.updateSecurityMarksSettings = settings.updateSecurityMarksSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSourceSettings, this.createFindingSettings, this.getIamPolicySettings, this.getOrganizationSettingsSettings, this.getSourceSettings, this.groupAssetsSettings, this.groupFindingsSettings, this.listAssetsSettings, this.listFindingsSettings, this.listSourcesSettings, this.runAssetDiscoverySettings, this.setFindingStateSettings, (Object[])new UnaryCallSettings.Builder[]{this.setIamPolicySettings, this.testIamPermissionsSettings, this.updateFindingSettings, this.updateOrganizationSettingsSettings, this.updateSourceSettings, this.updateSecurityMarksSettings});
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateSourceRequest, Source> createSourceSettings() {
            return this.createSourceSettings;
        }

        public UnaryCallSettings.Builder<CreateFindingRequest, Finding> createFindingSettings() {
            return this.createFindingSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetOrganizationSettingsRequest, OrganizationSettings> getOrganizationSettingsSettings() {
            return this.getOrganizationSettingsSettings;
        }

        public UnaryCallSettings.Builder<GetSourceRequest, Source> getSourceSettings() {
            return this.getSourceSettings;
        }

        public PagedCallSettings.Builder<GroupAssetsRequest, GroupAssetsResponse, SecurityCenterClient.GroupAssetsPagedResponse> groupAssetsSettings() {
            return this.groupAssetsSettings;
        }

        public PagedCallSettings.Builder<GroupFindingsRequest, GroupFindingsResponse, SecurityCenterClient.GroupFindingsPagedResponse> groupFindingsSettings() {
            return this.groupFindingsSettings;
        }

        public PagedCallSettings.Builder<ListAssetsRequest, ListAssetsResponse, SecurityCenterClient.ListAssetsPagedResponse> listAssetsSettings() {
            return this.listAssetsSettings;
        }

        public PagedCallSettings.Builder<ListFindingsRequest, ListFindingsResponse, SecurityCenterClient.ListFindingsPagedResponse> listFindingsSettings() {
            return this.listFindingsSettings;
        }

        public PagedCallSettings.Builder<ListSourcesRequest, ListSourcesResponse, SecurityCenterClient.ListSourcesPagedResponse> listSourcesSettings() {
            return this.listSourcesSettings;
        }

        public UnaryCallSettings.Builder<RunAssetDiscoveryRequest, Operation> runAssetDiscoverySettings() {
            return this.runAssetDiscoverySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RunAssetDiscoveryRequest, Empty, Empty> runAssetDiscoveryOperationSettings() {
            return this.runAssetDiscoveryOperationSettings;
        }

        public UnaryCallSettings.Builder<SetFindingStateRequest, Finding> setFindingStateSettings() {
            return this.setFindingStateSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public UnaryCallSettings.Builder<UpdateFindingRequest, Finding> updateFindingSettings() {
            return this.updateFindingSettings;
        }

        public UnaryCallSettings.Builder<UpdateOrganizationSettingsRequest, OrganizationSettings> updateOrganizationSettingsSettings() {
            return this.updateOrganizationSettingsSettings;
        }

        public UnaryCallSettings.Builder<UpdateSourceRequest, Source> updateSourceSettings() {
            return this.updateSourceSettings;
        }

        public UnaryCallSettings.Builder<UpdateSecurityMarksRequest, SecurityMarks> updateSecurityMarksSettings() {
            return this.updateSecurityMarksSettings;
        }

        public SecurityCenterStubSettings build() throws IOException {
            return new SecurityCenterStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)480000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)480000L)).setTotalTimeout(Duration.ofMillis((long)480000L)).build();
            definitions.put((Object)"retry_policy_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)480000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)480000L)).setTotalTimeout(Duration.ofMillis((long)480000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

