/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.security.privateca.v1beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.security.privateca.v1beta1.ActivateCertificateAuthorityRequest;
import com.google.cloud.security.privateca.v1beta1.Certificate;
import com.google.cloud.security.privateca.v1beta1.CertificateAuthority;
import com.google.cloud.security.privateca.v1beta1.CertificateAuthorityName;
import com.google.cloud.security.privateca.v1beta1.CertificateAuthorityServiceSettings;
import com.google.cloud.security.privateca.v1beta1.CertificateName;
import com.google.cloud.security.privateca.v1beta1.CertificateRevocationList;
import com.google.cloud.security.privateca.v1beta1.CertificateRevocationListName;
import com.google.cloud.security.privateca.v1beta1.CreateCertificateAuthorityRequest;
import com.google.cloud.security.privateca.v1beta1.CreateCertificateRequest;
import com.google.cloud.security.privateca.v1beta1.CreateCertificateRevocationListRequest;
import com.google.cloud.security.privateca.v1beta1.CreateReusableConfigRequest;
import com.google.cloud.security.privateca.v1beta1.DeleteReusableConfigRequest;
import com.google.cloud.security.privateca.v1beta1.DisableCertificateAuthorityRequest;
import com.google.cloud.security.privateca.v1beta1.EnableCertificateAuthorityRequest;
import com.google.cloud.security.privateca.v1beta1.FetchCertificateAuthorityCsrRequest;
import com.google.cloud.security.privateca.v1beta1.FetchCertificateAuthorityCsrResponse;
import com.google.cloud.security.privateca.v1beta1.GetCertificateAuthorityRequest;
import com.google.cloud.security.privateca.v1beta1.GetCertificateRequest;
import com.google.cloud.security.privateca.v1beta1.GetCertificateRevocationListRequest;
import com.google.cloud.security.privateca.v1beta1.GetReusableConfigRequest;
import com.google.cloud.security.privateca.v1beta1.ListCertificateAuthoritiesRequest;
import com.google.cloud.security.privateca.v1beta1.ListCertificateAuthoritiesResponse;
import com.google.cloud.security.privateca.v1beta1.ListCertificateRevocationListsRequest;
import com.google.cloud.security.privateca.v1beta1.ListCertificateRevocationListsResponse;
import com.google.cloud.security.privateca.v1beta1.ListCertificatesRequest;
import com.google.cloud.security.privateca.v1beta1.ListCertificatesResponse;
import com.google.cloud.security.privateca.v1beta1.ListReusableConfigsRequest;
import com.google.cloud.security.privateca.v1beta1.ListReusableConfigsResponse;
import com.google.cloud.security.privateca.v1beta1.LocationName;
import com.google.cloud.security.privateca.v1beta1.OperationMetadata;
import com.google.cloud.security.privateca.v1beta1.RestoreCertificateAuthorityRequest;
import com.google.cloud.security.privateca.v1beta1.ReusableConfig;
import com.google.cloud.security.privateca.v1beta1.ReusableConfigName;
import com.google.cloud.security.privateca.v1beta1.RevokeCertificateRequest;
import com.google.cloud.security.privateca.v1beta1.ScheduleDeleteCertificateAuthorityRequest;
import com.google.cloud.security.privateca.v1beta1.UpdateCertificateAuthorityRequest;
import com.google.cloud.security.privateca.v1beta1.UpdateCertificateRequest;
import com.google.cloud.security.privateca.v1beta1.UpdateCertificateRevocationListRequest;
import com.google.cloud.security.privateca.v1beta1.UpdateReusableConfigRequest;
import com.google.cloud.security.privateca.v1beta1.stub.CertificateAuthorityServiceStub;
import com.google.cloud.security.privateca.v1beta1.stub.CertificateAuthorityServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class CertificateAuthorityServiceClient
implements BackgroundResource {
    private final CertificateAuthorityServiceSettings settings;
    private final CertificateAuthorityServiceStub stub;
    private final OperationsClient operationsClient;

    public static final CertificateAuthorityServiceClient create() throws IOException {
        return CertificateAuthorityServiceClient.create(CertificateAuthorityServiceSettings.newBuilder().build());
    }

    public static final CertificateAuthorityServiceClient create(CertificateAuthorityServiceSettings settings) throws IOException {
        return new CertificateAuthorityServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CertificateAuthorityServiceClient create(CertificateAuthorityServiceStub stub) {
        return new CertificateAuthorityServiceClient(stub);
    }

    protected CertificateAuthorityServiceClient(CertificateAuthorityServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CertificateAuthorityServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CertificateAuthorityServiceClient(CertificateAuthorityServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final CertificateAuthorityServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CertificateAuthorityServiceStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Certificate createCertificate(CertificateAuthorityName parent, Certificate certificate, String certificateId) {
        CreateCertificateRequest request = CreateCertificateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCertificate(certificate).setCertificateId(certificateId).build();
        return this.createCertificate(request);
    }

    public final Certificate createCertificate(String parent, Certificate certificate, String certificateId) {
        CreateCertificateRequest request = CreateCertificateRequest.newBuilder().setParent(parent).setCertificate(certificate).setCertificateId(certificateId).build();
        return this.createCertificate(request);
    }

    public final Certificate createCertificate(CreateCertificateRequest request) {
        return (Certificate)this.createCertificateCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCertificateRequest, Certificate> createCertificateCallable() {
        return this.stub.createCertificateCallable();
    }

    public final Certificate getCertificate(CertificateName name) {
        GetCertificateRequest request = GetCertificateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCertificate(request);
    }

    public final Certificate getCertificate(String name) {
        GetCertificateRequest request = GetCertificateRequest.newBuilder().setName(name).build();
        return this.getCertificate(request);
    }

    public final Certificate getCertificate(GetCertificateRequest request) {
        return (Certificate)this.getCertificateCallable().call((Object)request);
    }

    public final UnaryCallable<GetCertificateRequest, Certificate> getCertificateCallable() {
        return this.stub.getCertificateCallable();
    }

    public final ListCertificatesPagedResponse listCertificates(CertificateAuthorityName parent) {
        ListCertificatesRequest request = ListCertificatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCertificates(request);
    }

    public final ListCertificatesPagedResponse listCertificates(String parent) {
        ListCertificatesRequest request = ListCertificatesRequest.newBuilder().setParent(parent).build();
        return this.listCertificates(request);
    }

    public final ListCertificatesPagedResponse listCertificates(ListCertificatesRequest request) {
        return (ListCertificatesPagedResponse)((Object)this.listCertificatesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCertificatesRequest, ListCertificatesPagedResponse> listCertificatesPagedCallable() {
        return this.stub.listCertificatesPagedCallable();
    }

    public final UnaryCallable<ListCertificatesRequest, ListCertificatesResponse> listCertificatesCallable() {
        return this.stub.listCertificatesCallable();
    }

    public final Certificate revokeCertificate(CertificateName name) {
        RevokeCertificateRequest request = RevokeCertificateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.revokeCertificate(request);
    }

    public final Certificate revokeCertificate(String name) {
        RevokeCertificateRequest request = RevokeCertificateRequest.newBuilder().setName(name).build();
        return this.revokeCertificate(request);
    }

    public final Certificate revokeCertificate(RevokeCertificateRequest request) {
        return (Certificate)this.revokeCertificateCallable().call((Object)request);
    }

    public final UnaryCallable<RevokeCertificateRequest, Certificate> revokeCertificateCallable() {
        return this.stub.revokeCertificateCallable();
    }

    public final Certificate updateCertificate(Certificate certificate, FieldMask updateMask) {
        UpdateCertificateRequest request = UpdateCertificateRequest.newBuilder().setCertificate(certificate).setUpdateMask(updateMask).build();
        return this.updateCertificate(request);
    }

    public final Certificate updateCertificate(UpdateCertificateRequest request) {
        return (Certificate)this.updateCertificateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCertificateRequest, Certificate> updateCertificateCallable() {
        return this.stub.updateCertificateCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> activateCertificateAuthorityAsync(CertificateAuthorityName name) {
        ActivateCertificateAuthorityRequest request = ActivateCertificateAuthorityRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.activateCertificateAuthorityAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> activateCertificateAuthorityAsync(String name) {
        ActivateCertificateAuthorityRequest request = ActivateCertificateAuthorityRequest.newBuilder().setName(name).build();
        return this.activateCertificateAuthorityAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> activateCertificateAuthorityAsync(ActivateCertificateAuthorityRequest request) {
        return this.activateCertificateAuthorityOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<ActivateCertificateAuthorityRequest, CertificateAuthority, OperationMetadata> activateCertificateAuthorityOperationCallable() {
        return this.stub.activateCertificateAuthorityOperationCallable();
    }

    public final UnaryCallable<ActivateCertificateAuthorityRequest, Operation> activateCertificateAuthorityCallable() {
        return this.stub.activateCertificateAuthorityCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> createCertificateAuthorityAsync(LocationName parent, CertificateAuthority certificateAuthority, String certificateAuthorityId) {
        CreateCertificateAuthorityRequest request = CreateCertificateAuthorityRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCertificateAuthority(certificateAuthority).setCertificateAuthorityId(certificateAuthorityId).build();
        return this.createCertificateAuthorityAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> createCertificateAuthorityAsync(String parent, CertificateAuthority certificateAuthority, String certificateAuthorityId) {
        CreateCertificateAuthorityRequest request = CreateCertificateAuthorityRequest.newBuilder().setParent(parent).setCertificateAuthority(certificateAuthority).setCertificateAuthorityId(certificateAuthorityId).build();
        return this.createCertificateAuthorityAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> createCertificateAuthorityAsync(CreateCertificateAuthorityRequest request) {
        return this.createCertificateAuthorityOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<CreateCertificateAuthorityRequest, CertificateAuthority, OperationMetadata> createCertificateAuthorityOperationCallable() {
        return this.stub.createCertificateAuthorityOperationCallable();
    }

    public final UnaryCallable<CreateCertificateAuthorityRequest, Operation> createCertificateAuthorityCallable() {
        return this.stub.createCertificateAuthorityCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> disableCertificateAuthorityAsync(CertificateAuthorityName name) {
        DisableCertificateAuthorityRequest request = DisableCertificateAuthorityRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.disableCertificateAuthorityAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> disableCertificateAuthorityAsync(String name) {
        DisableCertificateAuthorityRequest request = DisableCertificateAuthorityRequest.newBuilder().setName(name).build();
        return this.disableCertificateAuthorityAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> disableCertificateAuthorityAsync(DisableCertificateAuthorityRequest request) {
        return this.disableCertificateAuthorityOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<DisableCertificateAuthorityRequest, CertificateAuthority, OperationMetadata> disableCertificateAuthorityOperationCallable() {
        return this.stub.disableCertificateAuthorityOperationCallable();
    }

    public final UnaryCallable<DisableCertificateAuthorityRequest, Operation> disableCertificateAuthorityCallable() {
        return this.stub.disableCertificateAuthorityCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> enableCertificateAuthorityAsync(CertificateAuthorityName name) {
        EnableCertificateAuthorityRequest request = EnableCertificateAuthorityRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.enableCertificateAuthorityAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> enableCertificateAuthorityAsync(String name) {
        EnableCertificateAuthorityRequest request = EnableCertificateAuthorityRequest.newBuilder().setName(name).build();
        return this.enableCertificateAuthorityAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> enableCertificateAuthorityAsync(EnableCertificateAuthorityRequest request) {
        return this.enableCertificateAuthorityOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<EnableCertificateAuthorityRequest, CertificateAuthority, OperationMetadata> enableCertificateAuthorityOperationCallable() {
        return this.stub.enableCertificateAuthorityOperationCallable();
    }

    public final UnaryCallable<EnableCertificateAuthorityRequest, Operation> enableCertificateAuthorityCallable() {
        return this.stub.enableCertificateAuthorityCallable();
    }

    public final FetchCertificateAuthorityCsrResponse fetchCertificateAuthorityCsr(CertificateAuthorityName name) {
        FetchCertificateAuthorityCsrRequest request = FetchCertificateAuthorityCsrRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.fetchCertificateAuthorityCsr(request);
    }

    public final FetchCertificateAuthorityCsrResponse fetchCertificateAuthorityCsr(String name) {
        FetchCertificateAuthorityCsrRequest request = FetchCertificateAuthorityCsrRequest.newBuilder().setName(name).build();
        return this.fetchCertificateAuthorityCsr(request);
    }

    public final FetchCertificateAuthorityCsrResponse fetchCertificateAuthorityCsr(FetchCertificateAuthorityCsrRequest request) {
        return (FetchCertificateAuthorityCsrResponse)this.fetchCertificateAuthorityCsrCallable().call((Object)request);
    }

    public final UnaryCallable<FetchCertificateAuthorityCsrRequest, FetchCertificateAuthorityCsrResponse> fetchCertificateAuthorityCsrCallable() {
        return this.stub.fetchCertificateAuthorityCsrCallable();
    }

    public final CertificateAuthority getCertificateAuthority(CertificateAuthorityName name) {
        GetCertificateAuthorityRequest request = GetCertificateAuthorityRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCertificateAuthority(request);
    }

    public final CertificateAuthority getCertificateAuthority(String name) {
        GetCertificateAuthorityRequest request = GetCertificateAuthorityRequest.newBuilder().setName(name).build();
        return this.getCertificateAuthority(request);
    }

    public final CertificateAuthority getCertificateAuthority(GetCertificateAuthorityRequest request) {
        return (CertificateAuthority)this.getCertificateAuthorityCallable().call((Object)request);
    }

    public final UnaryCallable<GetCertificateAuthorityRequest, CertificateAuthority> getCertificateAuthorityCallable() {
        return this.stub.getCertificateAuthorityCallable();
    }

    public final ListCertificateAuthoritiesPagedResponse listCertificateAuthorities(LocationName parent) {
        ListCertificateAuthoritiesRequest request = ListCertificateAuthoritiesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCertificateAuthorities(request);
    }

    public final ListCertificateAuthoritiesPagedResponse listCertificateAuthorities(String parent) {
        ListCertificateAuthoritiesRequest request = ListCertificateAuthoritiesRequest.newBuilder().setParent(parent).build();
        return this.listCertificateAuthorities(request);
    }

    public final ListCertificateAuthoritiesPagedResponse listCertificateAuthorities(ListCertificateAuthoritiesRequest request) {
        return (ListCertificateAuthoritiesPagedResponse)((Object)this.listCertificateAuthoritiesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesPagedResponse> listCertificateAuthoritiesPagedCallable() {
        return this.stub.listCertificateAuthoritiesPagedCallable();
    }

    public final UnaryCallable<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse> listCertificateAuthoritiesCallable() {
        return this.stub.listCertificateAuthoritiesCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> restoreCertificateAuthorityAsync(CertificateAuthorityName name) {
        RestoreCertificateAuthorityRequest request = RestoreCertificateAuthorityRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.restoreCertificateAuthorityAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> restoreCertificateAuthorityAsync(String name) {
        RestoreCertificateAuthorityRequest request = RestoreCertificateAuthorityRequest.newBuilder().setName(name).build();
        return this.restoreCertificateAuthorityAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> restoreCertificateAuthorityAsync(RestoreCertificateAuthorityRequest request) {
        return this.restoreCertificateAuthorityOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<RestoreCertificateAuthorityRequest, CertificateAuthority, OperationMetadata> restoreCertificateAuthorityOperationCallable() {
        return this.stub.restoreCertificateAuthorityOperationCallable();
    }

    public final UnaryCallable<RestoreCertificateAuthorityRequest, Operation> restoreCertificateAuthorityCallable() {
        return this.stub.restoreCertificateAuthorityCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> scheduleDeleteCertificateAuthorityAsync(CertificateAuthorityName name) {
        ScheduleDeleteCertificateAuthorityRequest request = ScheduleDeleteCertificateAuthorityRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.scheduleDeleteCertificateAuthorityAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> scheduleDeleteCertificateAuthorityAsync(String name) {
        ScheduleDeleteCertificateAuthorityRequest request = ScheduleDeleteCertificateAuthorityRequest.newBuilder().setName(name).build();
        return this.scheduleDeleteCertificateAuthorityAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> scheduleDeleteCertificateAuthorityAsync(ScheduleDeleteCertificateAuthorityRequest request) {
        return this.scheduleDeleteCertificateAuthorityOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<ScheduleDeleteCertificateAuthorityRequest, CertificateAuthority, OperationMetadata> scheduleDeleteCertificateAuthorityOperationCallable() {
        return this.stub.scheduleDeleteCertificateAuthorityOperationCallable();
    }

    public final UnaryCallable<ScheduleDeleteCertificateAuthorityRequest, Operation> scheduleDeleteCertificateAuthorityCallable() {
        return this.stub.scheduleDeleteCertificateAuthorityCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> updateCertificateAuthorityAsync(CertificateAuthority certificateAuthority, FieldMask updateMask) {
        UpdateCertificateAuthorityRequest request = UpdateCertificateAuthorityRequest.newBuilder().setCertificateAuthority(certificateAuthority).setUpdateMask(updateMask).build();
        return this.updateCertificateAuthorityAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateAuthority, OperationMetadata> updateCertificateAuthorityAsync(UpdateCertificateAuthorityRequest request) {
        return this.updateCertificateAuthorityOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<UpdateCertificateAuthorityRequest, CertificateAuthority, OperationMetadata> updateCertificateAuthorityOperationCallable() {
        return this.stub.updateCertificateAuthorityOperationCallable();
    }

    public final UnaryCallable<UpdateCertificateAuthorityRequest, Operation> updateCertificateAuthorityCallable() {
        return this.stub.updateCertificateAuthorityCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateRevocationList, OperationMetadata> createCertificateRevocationListAsync(CertificateAuthorityName parent, CertificateRevocationList certificateRevocationList, String certificateRevocationListId) {
        CreateCertificateRevocationListRequest request = CreateCertificateRevocationListRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCertificateRevocationList(certificateRevocationList).setCertificateRevocationListId(certificateRevocationListId).build();
        return this.createCertificateRevocationListAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateRevocationList, OperationMetadata> createCertificateRevocationListAsync(String parent, CertificateRevocationList certificateRevocationList, String certificateRevocationListId) {
        CreateCertificateRevocationListRequest request = CreateCertificateRevocationListRequest.newBuilder().setParent(parent).setCertificateRevocationList(certificateRevocationList).setCertificateRevocationListId(certificateRevocationListId).build();
        return this.createCertificateRevocationListAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateRevocationList, OperationMetadata> createCertificateRevocationListAsync(CreateCertificateRevocationListRequest request) {
        return this.createCertificateRevocationListOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<CreateCertificateRevocationListRequest, CertificateRevocationList, OperationMetadata> createCertificateRevocationListOperationCallable() {
        return this.stub.createCertificateRevocationListOperationCallable();
    }

    public final UnaryCallable<CreateCertificateRevocationListRequest, Operation> createCertificateRevocationListCallable() {
        return this.stub.createCertificateRevocationListCallable();
    }

    public final CertificateRevocationList getCertificateRevocationList(CertificateRevocationListName name) {
        GetCertificateRevocationListRequest request = GetCertificateRevocationListRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCertificateRevocationList(request);
    }

    public final CertificateRevocationList getCertificateRevocationList(String name) {
        GetCertificateRevocationListRequest request = GetCertificateRevocationListRequest.newBuilder().setName(name).build();
        return this.getCertificateRevocationList(request);
    }

    public final CertificateRevocationList getCertificateRevocationList(GetCertificateRevocationListRequest request) {
        return (CertificateRevocationList)this.getCertificateRevocationListCallable().call((Object)request);
    }

    public final UnaryCallable<GetCertificateRevocationListRequest, CertificateRevocationList> getCertificateRevocationListCallable() {
        return this.stub.getCertificateRevocationListCallable();
    }

    public final ListCertificateRevocationListsPagedResponse listCertificateRevocationLists(CertificateAuthorityName parent) {
        ListCertificateRevocationListsRequest request = ListCertificateRevocationListsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCertificateRevocationLists(request);
    }

    public final ListCertificateRevocationListsPagedResponse listCertificateRevocationLists(String parent) {
        ListCertificateRevocationListsRequest request = ListCertificateRevocationListsRequest.newBuilder().setParent(parent).build();
        return this.listCertificateRevocationLists(request);
    }

    public final ListCertificateRevocationListsPagedResponse listCertificateRevocationLists(ListCertificateRevocationListsRequest request) {
        return (ListCertificateRevocationListsPagedResponse)((Object)this.listCertificateRevocationListsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCertificateRevocationListsRequest, ListCertificateRevocationListsPagedResponse> listCertificateRevocationListsPagedCallable() {
        return this.stub.listCertificateRevocationListsPagedCallable();
    }

    public final UnaryCallable<ListCertificateRevocationListsRequest, ListCertificateRevocationListsResponse> listCertificateRevocationListsCallable() {
        return this.stub.listCertificateRevocationListsCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateRevocationList, OperationMetadata> updateCertificateRevocationListAsync(CertificateRevocationList certificateRevocationList, FieldMask updateMask) {
        UpdateCertificateRevocationListRequest request = UpdateCertificateRevocationListRequest.newBuilder().setCertificateRevocationList(certificateRevocationList).setUpdateMask(updateMask).build();
        return this.updateCertificateRevocationListAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CertificateRevocationList, OperationMetadata> updateCertificateRevocationListAsync(UpdateCertificateRevocationListRequest request) {
        return this.updateCertificateRevocationListOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<UpdateCertificateRevocationListRequest, CertificateRevocationList, OperationMetadata> updateCertificateRevocationListOperationCallable() {
        return this.stub.updateCertificateRevocationListOperationCallable();
    }

    public final UnaryCallable<UpdateCertificateRevocationListRequest, Operation> updateCertificateRevocationListCallable() {
        return this.stub.updateCertificateRevocationListCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ReusableConfig, OperationMetadata> createReusableConfigAsync(LocationName parent, ReusableConfig reusableConfig, String reusableConfigId) {
        CreateReusableConfigRequest request = CreateReusableConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setReusableConfig(reusableConfig).setReusableConfigId(reusableConfigId).build();
        return this.createReusableConfigAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ReusableConfig, OperationMetadata> createReusableConfigAsync(String parent, ReusableConfig reusableConfig, String reusableConfigId) {
        CreateReusableConfigRequest request = CreateReusableConfigRequest.newBuilder().setParent(parent).setReusableConfig(reusableConfig).setReusableConfigId(reusableConfigId).build();
        return this.createReusableConfigAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ReusableConfig, OperationMetadata> createReusableConfigAsync(CreateReusableConfigRequest request) {
        return this.createReusableConfigOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<CreateReusableConfigRequest, ReusableConfig, OperationMetadata> createReusableConfigOperationCallable() {
        return this.stub.createReusableConfigOperationCallable();
    }

    public final UnaryCallable<CreateReusableConfigRequest, Operation> createReusableConfigCallable() {
        return this.stub.createReusableConfigCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deleteReusableConfigAsync(ReusableConfigName name) {
        DeleteReusableConfigRequest request = DeleteReusableConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteReusableConfigAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deleteReusableConfigAsync(String name) {
        DeleteReusableConfigRequest request = DeleteReusableConfigRequest.newBuilder().setName(name).build();
        return this.deleteReusableConfigAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deleteReusableConfigAsync(DeleteReusableConfigRequest request) {
        return this.deleteReusableConfigOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<DeleteReusableConfigRequest, Empty, OperationMetadata> deleteReusableConfigOperationCallable() {
        return this.stub.deleteReusableConfigOperationCallable();
    }

    public final UnaryCallable<DeleteReusableConfigRequest, Operation> deleteReusableConfigCallable() {
        return this.stub.deleteReusableConfigCallable();
    }

    public final ReusableConfig getReusableConfig(ReusableConfigName name) {
        GetReusableConfigRequest request = GetReusableConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getReusableConfig(request);
    }

    public final ReusableConfig getReusableConfig(String name) {
        GetReusableConfigRequest request = GetReusableConfigRequest.newBuilder().setName(name).build();
        return this.getReusableConfig(request);
    }

    public final ReusableConfig getReusableConfig(GetReusableConfigRequest request) {
        return (ReusableConfig)this.getReusableConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetReusableConfigRequest, ReusableConfig> getReusableConfigCallable() {
        return this.stub.getReusableConfigCallable();
    }

    public final ListReusableConfigsPagedResponse listReusableConfigs(LocationName parent) {
        ListReusableConfigsRequest request = ListReusableConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listReusableConfigs(request);
    }

    public final ListReusableConfigsPagedResponse listReusableConfigs(String parent) {
        ListReusableConfigsRequest request = ListReusableConfigsRequest.newBuilder().setParent(parent).build();
        return this.listReusableConfigs(request);
    }

    public final ListReusableConfigsPagedResponse listReusableConfigs(ListReusableConfigsRequest request) {
        return (ListReusableConfigsPagedResponse)((Object)this.listReusableConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReusableConfigsRequest, ListReusableConfigsPagedResponse> listReusableConfigsPagedCallable() {
        return this.stub.listReusableConfigsPagedCallable();
    }

    public final UnaryCallable<ListReusableConfigsRequest, ListReusableConfigsResponse> listReusableConfigsCallable() {
        return this.stub.listReusableConfigsCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ReusableConfig, OperationMetadata> updateReusableConfigAsync(ReusableConfig reusableConfig, FieldMask updateMask) {
        UpdateReusableConfigRequest request = UpdateReusableConfigRequest.newBuilder().setReusableConfig(reusableConfig).setUpdateMask(updateMask).build();
        return this.updateReusableConfigAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ReusableConfig, OperationMetadata> updateReusableConfigAsync(UpdateReusableConfigRequest request) {
        return this.updateReusableConfigOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<UpdateReusableConfigRequest, ReusableConfig, OperationMetadata> updateReusableConfigOperationCallable() {
        return this.stub.updateReusableConfigOperationCallable();
    }

    public final UnaryCallable<UpdateReusableConfigRequest, Operation> updateReusableConfigCallable() {
        return this.stub.updateReusableConfigCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListReusableConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReusableConfigsRequest, ListReusableConfigsResponse, ReusableConfig, ListReusableConfigsPage, ListReusableConfigsFixedSizeCollection> {
        private ListReusableConfigsFixedSizeCollection(List<ListReusableConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReusableConfigsFixedSizeCollection createEmptyCollection() {
            return new ListReusableConfigsFixedSizeCollection(null, 0);
        }

        protected ListReusableConfigsFixedSizeCollection createCollection(List<ListReusableConfigsPage> pages, int collectionSize) {
            return new ListReusableConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReusableConfigsPage
    extends AbstractPage<ListReusableConfigsRequest, ListReusableConfigsResponse, ReusableConfig, ListReusableConfigsPage> {
        private ListReusableConfigsPage(PageContext<ListReusableConfigsRequest, ListReusableConfigsResponse, ReusableConfig> context, ListReusableConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListReusableConfigsPage createEmptyPage() {
            return new ListReusableConfigsPage(null, null);
        }

        protected ListReusableConfigsPage createPage(PageContext<ListReusableConfigsRequest, ListReusableConfigsResponse, ReusableConfig> context, ListReusableConfigsResponse response) {
            return new ListReusableConfigsPage(context, response);
        }

        public ApiFuture<ListReusableConfigsPage> createPageAsync(PageContext<ListReusableConfigsRequest, ListReusableConfigsResponse, ReusableConfig> context, ApiFuture<ListReusableConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReusableConfigsPagedResponse
    extends AbstractPagedListResponse<ListReusableConfigsRequest, ListReusableConfigsResponse, ReusableConfig, ListReusableConfigsPage, ListReusableConfigsFixedSizeCollection> {
        public static ApiFuture<ListReusableConfigsPagedResponse> createAsync(PageContext<ListReusableConfigsRequest, ListReusableConfigsResponse, ReusableConfig> context, ApiFuture<ListReusableConfigsResponse> futureResponse) {
            ApiFuture<ListReusableConfigsPage> futurePage = ListReusableConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListReusableConfigsPage, ListReusableConfigsPagedResponse>(){

                public ListReusableConfigsPagedResponse apply(ListReusableConfigsPage input) {
                    return new ListReusableConfigsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListReusableConfigsPagedResponse(ListReusableConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReusableConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCertificateRevocationListsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCertificateRevocationListsRequest, ListCertificateRevocationListsResponse, CertificateRevocationList, ListCertificateRevocationListsPage, ListCertificateRevocationListsFixedSizeCollection> {
        private ListCertificateRevocationListsFixedSizeCollection(List<ListCertificateRevocationListsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCertificateRevocationListsFixedSizeCollection createEmptyCollection() {
            return new ListCertificateRevocationListsFixedSizeCollection(null, 0);
        }

        protected ListCertificateRevocationListsFixedSizeCollection createCollection(List<ListCertificateRevocationListsPage> pages, int collectionSize) {
            return new ListCertificateRevocationListsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCertificateRevocationListsPage
    extends AbstractPage<ListCertificateRevocationListsRequest, ListCertificateRevocationListsResponse, CertificateRevocationList, ListCertificateRevocationListsPage> {
        private ListCertificateRevocationListsPage(PageContext<ListCertificateRevocationListsRequest, ListCertificateRevocationListsResponse, CertificateRevocationList> context, ListCertificateRevocationListsResponse response) {
            super(context, (Object)response);
        }

        private static ListCertificateRevocationListsPage createEmptyPage() {
            return new ListCertificateRevocationListsPage(null, null);
        }

        protected ListCertificateRevocationListsPage createPage(PageContext<ListCertificateRevocationListsRequest, ListCertificateRevocationListsResponse, CertificateRevocationList> context, ListCertificateRevocationListsResponse response) {
            return new ListCertificateRevocationListsPage(context, response);
        }

        public ApiFuture<ListCertificateRevocationListsPage> createPageAsync(PageContext<ListCertificateRevocationListsRequest, ListCertificateRevocationListsResponse, CertificateRevocationList> context, ApiFuture<ListCertificateRevocationListsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCertificateRevocationListsPagedResponse
    extends AbstractPagedListResponse<ListCertificateRevocationListsRequest, ListCertificateRevocationListsResponse, CertificateRevocationList, ListCertificateRevocationListsPage, ListCertificateRevocationListsFixedSizeCollection> {
        public static ApiFuture<ListCertificateRevocationListsPagedResponse> createAsync(PageContext<ListCertificateRevocationListsRequest, ListCertificateRevocationListsResponse, CertificateRevocationList> context, ApiFuture<ListCertificateRevocationListsResponse> futureResponse) {
            ApiFuture<ListCertificateRevocationListsPage> futurePage = ListCertificateRevocationListsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListCertificateRevocationListsPage, ListCertificateRevocationListsPagedResponse>(){

                public ListCertificateRevocationListsPagedResponse apply(ListCertificateRevocationListsPage input) {
                    return new ListCertificateRevocationListsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListCertificateRevocationListsPagedResponse(ListCertificateRevocationListsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCertificateRevocationListsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCertificateAuthoritiesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse, CertificateAuthority, ListCertificateAuthoritiesPage, ListCertificateAuthoritiesFixedSizeCollection> {
        private ListCertificateAuthoritiesFixedSizeCollection(List<ListCertificateAuthoritiesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCertificateAuthoritiesFixedSizeCollection createEmptyCollection() {
            return new ListCertificateAuthoritiesFixedSizeCollection(null, 0);
        }

        protected ListCertificateAuthoritiesFixedSizeCollection createCollection(List<ListCertificateAuthoritiesPage> pages, int collectionSize) {
            return new ListCertificateAuthoritiesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCertificateAuthoritiesPage
    extends AbstractPage<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse, CertificateAuthority, ListCertificateAuthoritiesPage> {
        private ListCertificateAuthoritiesPage(PageContext<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse, CertificateAuthority> context, ListCertificateAuthoritiesResponse response) {
            super(context, (Object)response);
        }

        private static ListCertificateAuthoritiesPage createEmptyPage() {
            return new ListCertificateAuthoritiesPage(null, null);
        }

        protected ListCertificateAuthoritiesPage createPage(PageContext<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse, CertificateAuthority> context, ListCertificateAuthoritiesResponse response) {
            return new ListCertificateAuthoritiesPage(context, response);
        }

        public ApiFuture<ListCertificateAuthoritiesPage> createPageAsync(PageContext<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse, CertificateAuthority> context, ApiFuture<ListCertificateAuthoritiesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCertificateAuthoritiesPagedResponse
    extends AbstractPagedListResponse<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse, CertificateAuthority, ListCertificateAuthoritiesPage, ListCertificateAuthoritiesFixedSizeCollection> {
        public static ApiFuture<ListCertificateAuthoritiesPagedResponse> createAsync(PageContext<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse, CertificateAuthority> context, ApiFuture<ListCertificateAuthoritiesResponse> futureResponse) {
            ApiFuture<ListCertificateAuthoritiesPage> futurePage = ListCertificateAuthoritiesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListCertificateAuthoritiesPage, ListCertificateAuthoritiesPagedResponse>(){

                public ListCertificateAuthoritiesPagedResponse apply(ListCertificateAuthoritiesPage input) {
                    return new ListCertificateAuthoritiesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListCertificateAuthoritiesPagedResponse(ListCertificateAuthoritiesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCertificateAuthoritiesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCertificatesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCertificatesRequest, ListCertificatesResponse, Certificate, ListCertificatesPage, ListCertificatesFixedSizeCollection> {
        private ListCertificatesFixedSizeCollection(List<ListCertificatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCertificatesFixedSizeCollection createEmptyCollection() {
            return new ListCertificatesFixedSizeCollection(null, 0);
        }

        protected ListCertificatesFixedSizeCollection createCollection(List<ListCertificatesPage> pages, int collectionSize) {
            return new ListCertificatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCertificatesPage
    extends AbstractPage<ListCertificatesRequest, ListCertificatesResponse, Certificate, ListCertificatesPage> {
        private ListCertificatesPage(PageContext<ListCertificatesRequest, ListCertificatesResponse, Certificate> context, ListCertificatesResponse response) {
            super(context, (Object)response);
        }

        private static ListCertificatesPage createEmptyPage() {
            return new ListCertificatesPage(null, null);
        }

        protected ListCertificatesPage createPage(PageContext<ListCertificatesRequest, ListCertificatesResponse, Certificate> context, ListCertificatesResponse response) {
            return new ListCertificatesPage(context, response);
        }

        public ApiFuture<ListCertificatesPage> createPageAsync(PageContext<ListCertificatesRequest, ListCertificatesResponse, Certificate> context, ApiFuture<ListCertificatesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCertificatesPagedResponse
    extends AbstractPagedListResponse<ListCertificatesRequest, ListCertificatesResponse, Certificate, ListCertificatesPage, ListCertificatesFixedSizeCollection> {
        public static ApiFuture<ListCertificatesPagedResponse> createAsync(PageContext<ListCertificatesRequest, ListCertificatesResponse, Certificate> context, ApiFuture<ListCertificatesResponse> futureResponse) {
            ApiFuture<ListCertificatesPage> futurePage = ListCertificatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListCertificatesPage, ListCertificatesPagedResponse>(){

                public ListCertificatesPagedResponse apply(ListCertificatesPage input) {
                    return new ListCertificatesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListCertificatesPagedResponse(ListCertificatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCertificatesFixedSizeCollection.createEmptyCollection());
        }
    }
}

