/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.secretmanager.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.secretmanager.v1.AccessSecretVersionRequest;
import com.google.cloud.secretmanager.v1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1.AddSecretVersionRequest;
import com.google.cloud.secretmanager.v1.CreateSecretRequest;
import com.google.cloud.secretmanager.v1.DeleteSecretRequest;
import com.google.cloud.secretmanager.v1.DestroySecretVersionRequest;
import com.google.cloud.secretmanager.v1.DisableSecretVersionRequest;
import com.google.cloud.secretmanager.v1.EnableSecretVersionRequest;
import com.google.cloud.secretmanager.v1.GetSecretRequest;
import com.google.cloud.secretmanager.v1.GetSecretVersionRequest;
import com.google.cloud.secretmanager.v1.ListSecretVersionsRequest;
import com.google.cloud.secretmanager.v1.ListSecretVersionsResponse;
import com.google.cloud.secretmanager.v1.ListSecretsRequest;
import com.google.cloud.secretmanager.v1.ListSecretsResponse;
import com.google.cloud.secretmanager.v1.Secret;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretVersion;
import com.google.cloud.secretmanager.v1.UpdateSecretRequest;
import com.google.cloud.secretmanager.v1.stub.GrpcSecretManagerServiceStub;
import com.google.cloud.secretmanager.v1.stub.HttpJsonSecretManagerServiceStub;
import com.google.cloud.secretmanager.v1.stub.SecretManagerServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class SecretManagerServiceStubSettings
extends StubSettings<SecretManagerServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListSecretsRequest, ListSecretsResponse, SecretManagerServiceClient.ListSecretsPagedResponse> listSecretsSettings;
    private final UnaryCallSettings<CreateSecretRequest, Secret> createSecretSettings;
    private final UnaryCallSettings<AddSecretVersionRequest, SecretVersion> addSecretVersionSettings;
    private final UnaryCallSettings<GetSecretRequest, Secret> getSecretSettings;
    private final UnaryCallSettings<UpdateSecretRequest, Secret> updateSecretSettings;
    private final UnaryCallSettings<DeleteSecretRequest, Empty> deleteSecretSettings;
    private final PagedCallSettings<ListSecretVersionsRequest, ListSecretVersionsResponse, SecretManagerServiceClient.ListSecretVersionsPagedResponse> listSecretVersionsSettings;
    private final UnaryCallSettings<GetSecretVersionRequest, SecretVersion> getSecretVersionSettings;
    private final UnaryCallSettings<AccessSecretVersionRequest, AccessSecretVersionResponse> accessSecretVersionSettings;
    private final UnaryCallSettings<DisableSecretVersionRequest, SecretVersion> disableSecretVersionSettings;
    private final UnaryCallSettings<EnableSecretVersionRequest, SecretVersion> enableSecretVersionSettings;
    private final UnaryCallSettings<DestroySecretVersionRequest, SecretVersion> destroySecretVersionSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListSecretsRequest, ListSecretsResponse, Secret> LIST_SECRETS_PAGE_STR_DESC = new PagedListDescriptor<ListSecretsRequest, ListSecretsResponse, Secret>(){

        public String emptyToken() {
            return "";
        }

        public ListSecretsRequest injectToken(ListSecretsRequest payload, String token) {
            return ListSecretsRequest.newBuilder((ListSecretsRequest)payload).setPageToken(token).build();
        }

        public ListSecretsRequest injectPageSize(ListSecretsRequest payload, int pageSize) {
            return ListSecretsRequest.newBuilder((ListSecretsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSecretsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSecretsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Secret> extractResources(ListSecretsResponse payload) {
            return payload.getSecretsList() == null ? ImmutableList.of() : payload.getSecretsList();
        }
    };
    private static final PagedListDescriptor<ListSecretVersionsRequest, ListSecretVersionsResponse, SecretVersion> LIST_SECRET_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListSecretVersionsRequest, ListSecretVersionsResponse, SecretVersion>(){

        public String emptyToken() {
            return "";
        }

        public ListSecretVersionsRequest injectToken(ListSecretVersionsRequest payload, String token) {
            return ListSecretVersionsRequest.newBuilder((ListSecretVersionsRequest)payload).setPageToken(token).build();
        }

        public ListSecretVersionsRequest injectPageSize(ListSecretVersionsRequest payload, int pageSize) {
            return ListSecretVersionsRequest.newBuilder((ListSecretVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSecretVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSecretVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SecretVersion> extractResources(ListSecretVersionsResponse payload) {
            return payload.getVersionsList() == null ? ImmutableList.of() : payload.getVersionsList();
        }
    };
    private static final PagedListResponseFactory<ListSecretsRequest, ListSecretsResponse, SecretManagerServiceClient.ListSecretsPagedResponse> LIST_SECRETS_PAGE_STR_FACT = new PagedListResponseFactory<ListSecretsRequest, ListSecretsResponse, SecretManagerServiceClient.ListSecretsPagedResponse>(){

        public ApiFuture<SecretManagerServiceClient.ListSecretsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSecretsRequest, ListSecretsResponse> callable, ListSecretsRequest request, ApiCallContext context, ApiFuture<ListSecretsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SECRETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SecretManagerServiceClient.ListSecretsPagedResponse.createAsync((PageContext<ListSecretsRequest, ListSecretsResponse, Secret>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSecretVersionsRequest, ListSecretVersionsResponse, SecretManagerServiceClient.ListSecretVersionsPagedResponse> LIST_SECRET_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListSecretVersionsRequest, ListSecretVersionsResponse, SecretManagerServiceClient.ListSecretVersionsPagedResponse>(){

        public ApiFuture<SecretManagerServiceClient.ListSecretVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSecretVersionsRequest, ListSecretVersionsResponse> callable, ListSecretVersionsRequest request, ApiCallContext context, ApiFuture<ListSecretVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SECRET_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SecretManagerServiceClient.ListSecretVersionsPagedResponse.createAsync((PageContext<ListSecretVersionsRequest, ListSecretVersionsResponse, SecretVersion>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListSecretsRequest, ListSecretsResponse, SecretManagerServiceClient.ListSecretsPagedResponse> listSecretsSettings() {
        return this.listSecretsSettings;
    }

    public UnaryCallSettings<CreateSecretRequest, Secret> createSecretSettings() {
        return this.createSecretSettings;
    }

    public UnaryCallSettings<AddSecretVersionRequest, SecretVersion> addSecretVersionSettings() {
        return this.addSecretVersionSettings;
    }

    public UnaryCallSettings<GetSecretRequest, Secret> getSecretSettings() {
        return this.getSecretSettings;
    }

    public UnaryCallSettings<UpdateSecretRequest, Secret> updateSecretSettings() {
        return this.updateSecretSettings;
    }

    public UnaryCallSettings<DeleteSecretRequest, Empty> deleteSecretSettings() {
        return this.deleteSecretSettings;
    }

    public PagedCallSettings<ListSecretVersionsRequest, ListSecretVersionsResponse, SecretManagerServiceClient.ListSecretVersionsPagedResponse> listSecretVersionsSettings() {
        return this.listSecretVersionsSettings;
    }

    public UnaryCallSettings<GetSecretVersionRequest, SecretVersion> getSecretVersionSettings() {
        return this.getSecretVersionSettings;
    }

    public UnaryCallSettings<AccessSecretVersionRequest, AccessSecretVersionResponse> accessSecretVersionSettings() {
        return this.accessSecretVersionSettings;
    }

    public UnaryCallSettings<DisableSecretVersionRequest, SecretVersion> disableSecretVersionSettings() {
        return this.disableSecretVersionSettings;
    }

    public UnaryCallSettings<EnableSecretVersionRequest, SecretVersion> enableSecretVersionSettings() {
        return this.enableSecretVersionSettings;
    }

    public UnaryCallSettings<DestroySecretVersionRequest, SecretVersion> destroySecretVersionSettings() {
        return this.destroySecretVersionSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public SecretManagerServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSecretManagerServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSecretManagerServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return SecretManagerServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "secretmanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "secretmanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "secretmanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SecretManagerServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SecretManagerServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SecretManagerServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return SecretManagerServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SecretManagerServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listSecretsSettings = settingsBuilder.listSecretsSettings().build();
        this.createSecretSettings = settingsBuilder.createSecretSettings().build();
        this.addSecretVersionSettings = settingsBuilder.addSecretVersionSettings().build();
        this.getSecretSettings = settingsBuilder.getSecretSettings().build();
        this.updateSecretSettings = settingsBuilder.updateSecretSettings().build();
        this.deleteSecretSettings = settingsBuilder.deleteSecretSettings().build();
        this.listSecretVersionsSettings = settingsBuilder.listSecretVersionsSettings().build();
        this.getSecretVersionSettings = settingsBuilder.getSecretVersionSettings().build();
        this.accessSecretVersionSettings = settingsBuilder.accessSecretVersionSettings().build();
        this.disableSecretVersionSettings = settingsBuilder.disableSecretVersionSettings().build();
        this.enableSecretVersionSettings = settingsBuilder.enableSecretVersionSettings().build();
        this.destroySecretVersionSettings = settingsBuilder.destroySecretVersionSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SecretManagerServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListSecretsRequest, ListSecretsResponse, SecretManagerServiceClient.ListSecretsPagedResponse> listSecretsSettings;
        private final UnaryCallSettings.Builder<CreateSecretRequest, Secret> createSecretSettings;
        private final UnaryCallSettings.Builder<AddSecretVersionRequest, SecretVersion> addSecretVersionSettings;
        private final UnaryCallSettings.Builder<GetSecretRequest, Secret> getSecretSettings;
        private final UnaryCallSettings.Builder<UpdateSecretRequest, Secret> updateSecretSettings;
        private final UnaryCallSettings.Builder<DeleteSecretRequest, Empty> deleteSecretSettings;
        private final PagedCallSettings.Builder<ListSecretVersionsRequest, ListSecretVersionsResponse, SecretManagerServiceClient.ListSecretVersionsPagedResponse> listSecretVersionsSettings;
        private final UnaryCallSettings.Builder<GetSecretVersionRequest, SecretVersion> getSecretVersionSettings;
        private final UnaryCallSettings.Builder<AccessSecretVersionRequest, AccessSecretVersionResponse> accessSecretVersionSettings;
        private final UnaryCallSettings.Builder<DisableSecretVersionRequest, SecretVersion> disableSecretVersionSettings;
        private final UnaryCallSettings.Builder<EnableSecretVersionRequest, SecretVersion> enableSecretVersionSettings;
        private final UnaryCallSettings.Builder<DestroySecretVersionRequest, SecretVersion> destroySecretVersionSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listSecretsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SECRETS_PAGE_STR_FACT);
            this.createSecretSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addSecretVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSecretSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSecretSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSecretSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSecretVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SECRET_VERSIONS_PAGE_STR_FACT);
            this.getSecretVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.accessSecretVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.disableSecretVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.enableSecretVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.destroySecretVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listSecretsSettings, this.createSecretSettings, this.addSecretVersionSettings, this.getSecretSettings, this.updateSecretSettings, this.deleteSecretSettings, this.listSecretVersionsSettings, this.getSecretVersionSettings, this.accessSecretVersionSettings, this.disableSecretVersionSettings, this.enableSecretVersionSettings, this.destroySecretVersionSettings, (Object[])new UnaryCallSettings.Builder[]{this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(SecretManagerServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listSecretsSettings = settings.listSecretsSettings.toBuilder();
            this.createSecretSettings = settings.createSecretSettings.toBuilder();
            this.addSecretVersionSettings = settings.addSecretVersionSettings.toBuilder();
            this.getSecretSettings = settings.getSecretSettings.toBuilder();
            this.updateSecretSettings = settings.updateSecretSettings.toBuilder();
            this.deleteSecretSettings = settings.deleteSecretSettings.toBuilder();
            this.listSecretVersionsSettings = settings.listSecretVersionsSettings.toBuilder();
            this.getSecretVersionSettings = settings.getSecretVersionSettings.toBuilder();
            this.accessSecretVersionSettings = settings.accessSecretVersionSettings.toBuilder();
            this.disableSecretVersionSettings = settings.disableSecretVersionSettings.toBuilder();
            this.enableSecretVersionSettings = settings.enableSecretVersionSettings.toBuilder();
            this.destroySecretVersionSettings = settings.destroySecretVersionSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listSecretsSettings, this.createSecretSettings, this.addSecretVersionSettings, this.getSecretSettings, this.updateSecretSettings, this.deleteSecretSettings, this.listSecretVersionsSettings, this.getSecretVersionSettings, this.accessSecretVersionSettings, this.disableSecretVersionSettings, this.enableSecretVersionSettings, this.destroySecretVersionSettings, (Object[])new UnaryCallSettings.Builder[]{this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SecretManagerServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SecretManagerServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SecretManagerServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SecretManagerServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)SecretManagerServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)SecretManagerServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SecretManagerServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SecretManagerServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listSecretsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createSecretSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.addSecretVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getSecretSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateSecretSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteSecretSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listSecretVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getSecretVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.accessSecretVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.disableSecretVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.enableSecretVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.destroySecretVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListSecretsRequest, ListSecretsResponse, SecretManagerServiceClient.ListSecretsPagedResponse> listSecretsSettings() {
            return this.listSecretsSettings;
        }

        public UnaryCallSettings.Builder<CreateSecretRequest, Secret> createSecretSettings() {
            return this.createSecretSettings;
        }

        public UnaryCallSettings.Builder<AddSecretVersionRequest, SecretVersion> addSecretVersionSettings() {
            return this.addSecretVersionSettings;
        }

        public UnaryCallSettings.Builder<GetSecretRequest, Secret> getSecretSettings() {
            return this.getSecretSettings;
        }

        public UnaryCallSettings.Builder<UpdateSecretRequest, Secret> updateSecretSettings() {
            return this.updateSecretSettings;
        }

        public UnaryCallSettings.Builder<DeleteSecretRequest, Empty> deleteSecretSettings() {
            return this.deleteSecretSettings;
        }

        public PagedCallSettings.Builder<ListSecretVersionsRequest, ListSecretVersionsResponse, SecretManagerServiceClient.ListSecretVersionsPagedResponse> listSecretVersionsSettings() {
            return this.listSecretVersionsSettings;
        }

        public UnaryCallSettings.Builder<GetSecretVersionRequest, SecretVersion> getSecretVersionSettings() {
            return this.getSecretVersionSettings;
        }

        public UnaryCallSettings.Builder<AccessSecretVersionRequest, AccessSecretVersionResponse> accessSecretVersionSettings() {
            return this.accessSecretVersionSettings;
        }

        public UnaryCallSettings.Builder<DisableSecretVersionRequest, SecretVersion> disableSecretVersionSettings() {
            return this.disableSecretVersionSettings;
        }

        public UnaryCallSettings.Builder<EnableSecretVersionRequest, SecretVersion> enableSecretVersionSettings() {
            return this.enableSecretVersionSettings;
        }

        public UnaryCallSettings.Builder<DestroySecretVersionRequest, SecretVersion> destroySecretVersionSettings() {
            return this.destroySecretVersionSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return SecretManagerServiceStubSettings.getDefaultEndpoint();
        }

        public SecretManagerServiceStubSettings build() throws IOException {
            return new SecretManagerServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.RESOURCE_EXHAUSTED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)2000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

