/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.run.v2.CreateWorkerPoolRequest;
import com.google.cloud.run.v2.DeleteWorkerPoolRequest;
import com.google.cloud.run.v2.GetWorkerPoolRequest;
import com.google.cloud.run.v2.ListWorkerPoolsRequest;
import com.google.cloud.run.v2.ListWorkerPoolsResponse;
import com.google.cloud.run.v2.UpdateWorkerPoolRequest;
import com.google.cloud.run.v2.WorkerPool;
import com.google.cloud.run.v2.WorkerPoolsClient;
import com.google.cloud.run.v2.stub.GrpcWorkerPoolsCallableFactory;
import com.google.cloud.run.v2.stub.WorkerPoolsStub;
import com.google.cloud.run.v2.stub.WorkerPoolsStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcWorkerPoolsStub
extends WorkerPoolsStub {
    private static final MethodDescriptor<CreateWorkerPoolRequest, Operation> createWorkerPoolMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.WorkerPools/CreateWorkerPool").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateWorkerPoolRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetWorkerPoolRequest, WorkerPool> getWorkerPoolMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.WorkerPools/GetWorkerPool").setRequestMarshaller(ProtoUtils.marshaller((Message)GetWorkerPoolRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)WorkerPool.getDefaultInstance())).build();
    private static final MethodDescriptor<ListWorkerPoolsRequest, ListWorkerPoolsResponse> listWorkerPoolsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.WorkerPools/ListWorkerPools").setRequestMarshaller(ProtoUtils.marshaller((Message)ListWorkerPoolsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListWorkerPoolsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateWorkerPoolRequest, Operation> updateWorkerPoolMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.WorkerPools/UpdateWorkerPool").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateWorkerPoolRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.WorkerPools/DeleteWorkerPool").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteWorkerPoolRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.WorkerPools/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.WorkerPools/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.WorkerPools/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateWorkerPoolRequest, Operation> createWorkerPoolCallable;
    private final OperationCallable<CreateWorkerPoolRequest, WorkerPool, WorkerPool> createWorkerPoolOperationCallable;
    private final UnaryCallable<GetWorkerPoolRequest, WorkerPool> getWorkerPoolCallable;
    private final UnaryCallable<ListWorkerPoolsRequest, ListWorkerPoolsResponse> listWorkerPoolsCallable;
    private final UnaryCallable<ListWorkerPoolsRequest, WorkerPoolsClient.ListWorkerPoolsPagedResponse> listWorkerPoolsPagedCallable;
    private final UnaryCallable<UpdateWorkerPoolRequest, Operation> updateWorkerPoolCallable;
    private final OperationCallable<UpdateWorkerPoolRequest, WorkerPool, WorkerPool> updateWorkerPoolOperationCallable;
    private final UnaryCallable<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolCallable;
    private final OperationCallable<DeleteWorkerPoolRequest, WorkerPool, WorkerPool> deleteWorkerPoolOperationCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;
    private static final PathTemplate CREATE_WORKER_POOL_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}");
    private static final PathTemplate GET_WORKER_POOL_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/**");
    private static final PathTemplate LIST_WORKER_POOLS_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}");
    private static final PathTemplate UPDATE_WORKER_POOL_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/**");
    private static final PathTemplate DELETE_WORKER_POOL_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/**");

    public static final GrpcWorkerPoolsStub create(WorkerPoolsStubSettings settings) throws IOException {
        return new GrpcWorkerPoolsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcWorkerPoolsStub create(ClientContext clientContext) throws IOException {
        return new GrpcWorkerPoolsStub(WorkerPoolsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcWorkerPoolsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcWorkerPoolsStub(WorkerPoolsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcWorkerPoolsStub(WorkerPoolsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcWorkerPoolsCallableFactory());
    }

    protected GrpcWorkerPoolsStub(WorkerPoolsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createWorkerPoolTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createWorkerPoolMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "location", CREATE_WORKER_POOL_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings getWorkerPoolTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getWorkerPoolMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", GET_WORKER_POOL_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings listWorkerPoolsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listWorkerPoolsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "location", LIST_WORKER_POOLS_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings updateWorkerPoolTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateWorkerPoolMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            if (request.getWorkerPool() != null) {
                builder.add(request.getWorkerPool().getName(), "location", UPDATE_WORKER_POOL_0_PATH_TEMPLATE);
            }
            return builder.build();
        }).build();
        GrpcCallSettings deleteWorkerPoolTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteWorkerPoolMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", DELETE_WORKER_POOL_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createWorkerPoolCallable = callableFactory.createUnaryCallable(createWorkerPoolTransportSettings, settings.createWorkerPoolSettings(), clientContext);
        this.createWorkerPoolOperationCallable = callableFactory.createOperationCallable(createWorkerPoolTransportSettings, settings.createWorkerPoolOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getWorkerPoolCallable = callableFactory.createUnaryCallable(getWorkerPoolTransportSettings, settings.getWorkerPoolSettings(), clientContext);
        this.listWorkerPoolsCallable = callableFactory.createUnaryCallable(listWorkerPoolsTransportSettings, settings.listWorkerPoolsSettings(), clientContext);
        this.listWorkerPoolsPagedCallable = callableFactory.createPagedCallable(listWorkerPoolsTransportSettings, settings.listWorkerPoolsSettings(), clientContext);
        this.updateWorkerPoolCallable = callableFactory.createUnaryCallable(updateWorkerPoolTransportSettings, settings.updateWorkerPoolSettings(), clientContext);
        this.updateWorkerPoolOperationCallable = callableFactory.createOperationCallable(updateWorkerPoolTransportSettings, settings.updateWorkerPoolOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteWorkerPoolCallable = callableFactory.createUnaryCallable(deleteWorkerPoolTransportSettings, settings.deleteWorkerPoolSettings(), clientContext);
        this.deleteWorkerPoolOperationCallable = callableFactory.createOperationCallable(deleteWorkerPoolTransportSettings, settings.deleteWorkerPoolOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateWorkerPoolRequest, Operation> createWorkerPoolCallable() {
        return this.createWorkerPoolCallable;
    }

    @Override
    public OperationCallable<CreateWorkerPoolRequest, WorkerPool, WorkerPool> createWorkerPoolOperationCallable() {
        return this.createWorkerPoolOperationCallable;
    }

    @Override
    public UnaryCallable<GetWorkerPoolRequest, WorkerPool> getWorkerPoolCallable() {
        return this.getWorkerPoolCallable;
    }

    @Override
    public UnaryCallable<ListWorkerPoolsRequest, ListWorkerPoolsResponse> listWorkerPoolsCallable() {
        return this.listWorkerPoolsCallable;
    }

    @Override
    public UnaryCallable<ListWorkerPoolsRequest, WorkerPoolsClient.ListWorkerPoolsPagedResponse> listWorkerPoolsPagedCallable() {
        return this.listWorkerPoolsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateWorkerPoolRequest, Operation> updateWorkerPoolCallable() {
        return this.updateWorkerPoolCallable;
    }

    @Override
    public OperationCallable<UpdateWorkerPoolRequest, WorkerPool, WorkerPool> updateWorkerPoolOperationCallable() {
        return this.updateWorkerPoolOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolCallable() {
        return this.deleteWorkerPoolCallable;
    }

    @Override
    public OperationCallable<DeleteWorkerPoolRequest, WorkerPool, WorkerPool> deleteWorkerPoolOperationCallable() {
        return this.deleteWorkerPoolOperationCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

