/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.run.v2.DeleteRevisionRequest;
import com.google.cloud.run.v2.GetRevisionRequest;
import com.google.cloud.run.v2.ListRevisionsRequest;
import com.google.cloud.run.v2.ListRevisionsResponse;
import com.google.cloud.run.v2.Revision;
import com.google.cloud.run.v2.RevisionsClient;
import com.google.cloud.run.v2.stub.GrpcRevisionsStub;
import com.google.cloud.run.v2.stub.HttpJsonRevisionsStub;
import com.google.cloud.run.v2.stub.RevisionsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class RevisionsStubSettings
extends StubSettings<RevisionsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetRevisionRequest, Revision> getRevisionSettings;
    private final PagedCallSettings<ListRevisionsRequest, ListRevisionsResponse, RevisionsClient.ListRevisionsPagedResponse> listRevisionsSettings;
    private final UnaryCallSettings<DeleteRevisionRequest, Operation> deleteRevisionSettings;
    private final OperationCallSettings<DeleteRevisionRequest, Revision, Revision> deleteRevisionOperationSettings;
    private static final PagedListDescriptor<ListRevisionsRequest, ListRevisionsResponse, Revision> LIST_REVISIONS_PAGE_STR_DESC = new PagedListDescriptor<ListRevisionsRequest, ListRevisionsResponse, Revision>(){

        public String emptyToken() {
            return "";
        }

        public ListRevisionsRequest injectToken(ListRevisionsRequest payload, String token) {
            return ListRevisionsRequest.newBuilder((ListRevisionsRequest)payload).setPageToken(token).build();
        }

        public ListRevisionsRequest injectPageSize(ListRevisionsRequest payload, int pageSize) {
            return ListRevisionsRequest.newBuilder((ListRevisionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRevisionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRevisionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Revision> extractResources(ListRevisionsResponse payload) {
            return payload.getRevisionsList() == null ? ImmutableList.of() : payload.getRevisionsList();
        }
    };
    private static final PagedListResponseFactory<ListRevisionsRequest, ListRevisionsResponse, RevisionsClient.ListRevisionsPagedResponse> LIST_REVISIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListRevisionsRequest, ListRevisionsResponse, RevisionsClient.ListRevisionsPagedResponse>(){

        public ApiFuture<RevisionsClient.ListRevisionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRevisionsRequest, ListRevisionsResponse> callable, ListRevisionsRequest request, ApiCallContext context, ApiFuture<ListRevisionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REVISIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RevisionsClient.ListRevisionsPagedResponse.createAsync((PageContext<ListRevisionsRequest, ListRevisionsResponse, Revision>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetRevisionRequest, Revision> getRevisionSettings() {
        return this.getRevisionSettings;
    }

    public PagedCallSettings<ListRevisionsRequest, ListRevisionsResponse, RevisionsClient.ListRevisionsPagedResponse> listRevisionsSettings() {
        return this.listRevisionsSettings;
    }

    public UnaryCallSettings<DeleteRevisionRequest, Operation> deleteRevisionSettings() {
        return this.deleteRevisionSettings;
    }

    public OperationCallSettings<DeleteRevisionRequest, Revision, Revision> deleteRevisionOperationSettings() {
        return this.deleteRevisionOperationSettings;
    }

    public RevisionsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcRevisionsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRevisionsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "run";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "run.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "run.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RevisionsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RevisionsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RevisionsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return RevisionsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RevisionsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getRevisionSettings = settingsBuilder.getRevisionSettings().build();
        this.listRevisionsSettings = settingsBuilder.listRevisionsSettings().build();
        this.deleteRevisionSettings = settingsBuilder.deleteRevisionSettings().build();
        this.deleteRevisionOperationSettings = settingsBuilder.deleteRevisionOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RevisionsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetRevisionRequest, Revision> getRevisionSettings;
        private final PagedCallSettings.Builder<ListRevisionsRequest, ListRevisionsResponse, RevisionsClient.ListRevisionsPagedResponse> listRevisionsSettings;
        private final UnaryCallSettings.Builder<DeleteRevisionRequest, Operation> deleteRevisionSettings;
        private final OperationCallSettings.Builder<DeleteRevisionRequest, Revision, Revision> deleteRevisionOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getRevisionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRevisionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REVISIONS_PAGE_STR_FACT);
            this.deleteRevisionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRevisionOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getRevisionSettings, this.listRevisionsSettings, this.deleteRevisionSettings);
            Builder.initDefaults(this);
        }

        protected Builder(RevisionsStubSettings settings) {
            super((StubSettings)settings);
            this.getRevisionSettings = settings.getRevisionSettings.toBuilder();
            this.listRevisionsSettings = settings.listRevisionsSettings.toBuilder();
            this.deleteRevisionSettings = settings.deleteRevisionSettings.toBuilder();
            this.deleteRevisionOperationSettings = settings.deleteRevisionOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getRevisionSettings, this.listRevisionsSettings, this.deleteRevisionSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RevisionsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RevisionsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RevisionsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RevisionsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(RevisionsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)RevisionsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)RevisionsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RevisionsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RevisionsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(RevisionsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getRevisionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listRevisionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteRevisionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteRevisionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Revision.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Revision.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetRevisionRequest, Revision> getRevisionSettings() {
            return this.getRevisionSettings;
        }

        public PagedCallSettings.Builder<ListRevisionsRequest, ListRevisionsResponse, RevisionsClient.ListRevisionsPagedResponse> listRevisionsSettings() {
            return this.listRevisionsSettings;
        }

        public UnaryCallSettings.Builder<DeleteRevisionRequest, Operation> deleteRevisionSettings() {
            return this.deleteRevisionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteRevisionRequest, Revision, Revision> deleteRevisionOperationSettings() {
            return this.deleteRevisionOperationSettings;
        }

        public RevisionsStubSettings build() throws IOException {
            return new RevisionsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

