/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.run.v2.DeleteRevisionRequest;
import com.google.cloud.run.v2.GetRevisionRequest;
import com.google.cloud.run.v2.ListRevisionsRequest;
import com.google.cloud.run.v2.ListRevisionsResponse;
import com.google.cloud.run.v2.Revision;
import com.google.cloud.run.v2.RevisionsClient;
import com.google.cloud.run.v2.stub.HttpJsonRevisionsCallableFactory;
import com.google.cloud.run.v2.stub.RevisionsStub;
import com.google.cloud.run.v2.stub.RevisionsStubSettings;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonRevisionsStub
extends RevisionsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Revision.getDescriptor()).build();
    private static final ApiMethodDescriptor<GetRevisionRequest, Revision> getRevisionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Revisions/GetRevision").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/services/*/revisions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Revision.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListRevisionsRequest, ListRevisionsResponse> listRevisionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Revisions/ListRevisions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*/services/*}/revisions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "showDeleted", (Object)request.getShowDeleted());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListRevisionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteRevisionRequest, Operation> deleteRevisionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Revisions/DeleteRevision").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/services/*/revisions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<GetRevisionRequest, Revision> getRevisionCallable;
    private final UnaryCallable<ListRevisionsRequest, ListRevisionsResponse> listRevisionsCallable;
    private final UnaryCallable<ListRevisionsRequest, RevisionsClient.ListRevisionsPagedResponse> listRevisionsPagedCallable;
    private final UnaryCallable<DeleteRevisionRequest, Operation> deleteRevisionCallable;
    private final OperationCallable<DeleteRevisionRequest, Revision, Revision> deleteRevisionOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonRevisionsStub create(RevisionsStubSettings settings) throws IOException {
        return new HttpJsonRevisionsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonRevisionsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonRevisionsStub(RevisionsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonRevisionsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonRevisionsStub(RevisionsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonRevisionsStub(RevisionsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonRevisionsCallableFactory());
    }

    protected HttpJsonRevisionsStub(RevisionsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings getRevisionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRevisionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listRevisionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRevisionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteRevisionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteRevisionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.getRevisionCallable = callableFactory.createUnaryCallable(getRevisionTransportSettings, settings.getRevisionSettings(), clientContext);
        this.listRevisionsCallable = callableFactory.createUnaryCallable(listRevisionsTransportSettings, settings.listRevisionsSettings(), clientContext);
        this.listRevisionsPagedCallable = callableFactory.createPagedCallable(listRevisionsTransportSettings, settings.listRevisionsSettings(), clientContext);
        this.deleteRevisionCallable = callableFactory.createUnaryCallable(deleteRevisionTransportSettings, settings.deleteRevisionSettings(), clientContext);
        this.deleteRevisionOperationCallable = callableFactory.createOperationCallable(deleteRevisionTransportSettings, settings.deleteRevisionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getRevisionMethodDescriptor);
        methodDescriptors.add(listRevisionsMethodDescriptor);
        methodDescriptors.add(deleteRevisionMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<GetRevisionRequest, Revision> getRevisionCallable() {
        return this.getRevisionCallable;
    }

    @Override
    public UnaryCallable<ListRevisionsRequest, ListRevisionsResponse> listRevisionsCallable() {
        return this.listRevisionsCallable;
    }

    @Override
    public UnaryCallable<ListRevisionsRequest, RevisionsClient.ListRevisionsPagedResponse> listRevisionsPagedCallable() {
        return this.listRevisionsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteRevisionRequest, Operation> deleteRevisionCallable() {
        return this.deleteRevisionCallable;
    }

    @Override
    public OperationCallable<DeleteRevisionRequest, Revision, Revision> deleteRevisionOperationCallable() {
        return this.deleteRevisionOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

