/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2beta;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2beta.AlertConfig;
import com.google.cloud.retail.v2beta.AlertConfigName;
import com.google.cloud.retail.v2beta.GetAlertConfigRequest;
import com.google.cloud.retail.v2beta.ProjectServiceSettings;
import com.google.cloud.retail.v2beta.UpdateAlertConfigRequest;
import com.google.cloud.retail.v2beta.stub.ProjectServiceStub;
import com.google.cloud.retail.v2beta.stub.ProjectServiceStubSettings;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ProjectServiceClient
implements BackgroundResource {
    private final ProjectServiceSettings settings;
    private final ProjectServiceStub stub;

    public static final ProjectServiceClient create() throws IOException {
        return ProjectServiceClient.create(ProjectServiceSettings.newBuilder().build());
    }

    public static final ProjectServiceClient create(ProjectServiceSettings settings) throws IOException {
        return new ProjectServiceClient(settings);
    }

    public static final ProjectServiceClient create(ProjectServiceStub stub) {
        return new ProjectServiceClient(stub);
    }

    protected ProjectServiceClient(ProjectServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProjectServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ProjectServiceClient(ProjectServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ProjectServiceSettings getSettings() {
        return this.settings;
    }

    public ProjectServiceStub getStub() {
        return this.stub;
    }

    public final AlertConfig getAlertConfig(AlertConfigName name) {
        GetAlertConfigRequest request = GetAlertConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAlertConfig(request);
    }

    public final AlertConfig getAlertConfig(String name) {
        GetAlertConfigRequest request = GetAlertConfigRequest.newBuilder().setName(name).build();
        return this.getAlertConfig(request);
    }

    public final AlertConfig getAlertConfig(GetAlertConfigRequest request) {
        return (AlertConfig)this.getAlertConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetAlertConfigRequest, AlertConfig> getAlertConfigCallable() {
        return this.stub.getAlertConfigCallable();
    }

    public final AlertConfig updateAlertConfig(AlertConfig alertConfig, FieldMask updateMask) {
        UpdateAlertConfigRequest request = UpdateAlertConfigRequest.newBuilder().setAlertConfig(alertConfig).setUpdateMask(updateMask).build();
        return this.updateAlertConfig(request);
    }

    public final AlertConfig updateAlertConfig(UpdateAlertConfigRequest request) {
        return (AlertConfig)this.updateAlertConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAlertConfigRequest, AlertConfig> updateAlertConfigCallable() {
        return this.stub.updateAlertConfigCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

