/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2beta.AddFulfillmentPlacesMetadata;
import com.google.cloud.retail.v2beta.AddFulfillmentPlacesRequest;
import com.google.cloud.retail.v2beta.AddFulfillmentPlacesResponse;
import com.google.cloud.retail.v2beta.AddLocalInventoriesMetadata;
import com.google.cloud.retail.v2beta.AddLocalInventoriesRequest;
import com.google.cloud.retail.v2beta.AddLocalInventoriesResponse;
import com.google.cloud.retail.v2beta.CreateProductRequest;
import com.google.cloud.retail.v2beta.DeleteProductRequest;
import com.google.cloud.retail.v2beta.GetProductRequest;
import com.google.cloud.retail.v2beta.ImportMetadata;
import com.google.cloud.retail.v2beta.ImportProductsRequest;
import com.google.cloud.retail.v2beta.ImportProductsResponse;
import com.google.cloud.retail.v2beta.ListProductsRequest;
import com.google.cloud.retail.v2beta.ListProductsResponse;
import com.google.cloud.retail.v2beta.Product;
import com.google.cloud.retail.v2beta.ProductServiceClient;
import com.google.cloud.retail.v2beta.PurgeProductsMetadata;
import com.google.cloud.retail.v2beta.PurgeProductsRequest;
import com.google.cloud.retail.v2beta.PurgeProductsResponse;
import com.google.cloud.retail.v2beta.RemoveFulfillmentPlacesMetadata;
import com.google.cloud.retail.v2beta.RemoveFulfillmentPlacesRequest;
import com.google.cloud.retail.v2beta.RemoveFulfillmentPlacesResponse;
import com.google.cloud.retail.v2beta.RemoveLocalInventoriesMetadata;
import com.google.cloud.retail.v2beta.RemoveLocalInventoriesRequest;
import com.google.cloud.retail.v2beta.RemoveLocalInventoriesResponse;
import com.google.cloud.retail.v2beta.SetInventoryMetadata;
import com.google.cloud.retail.v2beta.SetInventoryRequest;
import com.google.cloud.retail.v2beta.SetInventoryResponse;
import com.google.cloud.retail.v2beta.UpdateProductRequest;
import com.google.cloud.retail.v2beta.stub.GrpcProductServiceStub;
import com.google.cloud.retail.v2beta.stub.HttpJsonProductServiceStub;
import com.google.cloud.retail.v2beta.stub.ProductServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ProductServiceStubSettings
extends StubSettings<ProductServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateProductRequest, Product> createProductSettings;
    private final UnaryCallSettings<GetProductRequest, Product> getProductSettings;
    private final PagedCallSettings<ListProductsRequest, ListProductsResponse, ProductServiceClient.ListProductsPagedResponse> listProductsSettings;
    private final UnaryCallSettings<UpdateProductRequest, Product> updateProductSettings;
    private final UnaryCallSettings<DeleteProductRequest, Empty> deleteProductSettings;
    private final UnaryCallSettings<PurgeProductsRequest, Operation> purgeProductsSettings;
    private final OperationCallSettings<PurgeProductsRequest, PurgeProductsResponse, PurgeProductsMetadata> purgeProductsOperationSettings;
    private final UnaryCallSettings<ImportProductsRequest, Operation> importProductsSettings;
    private final OperationCallSettings<ImportProductsRequest, ImportProductsResponse, ImportMetadata> importProductsOperationSettings;
    private final UnaryCallSettings<SetInventoryRequest, Operation> setInventorySettings;
    private final OperationCallSettings<SetInventoryRequest, SetInventoryResponse, SetInventoryMetadata> setInventoryOperationSettings;
    private final UnaryCallSettings<AddFulfillmentPlacesRequest, Operation> addFulfillmentPlacesSettings;
    private final OperationCallSettings<AddFulfillmentPlacesRequest, AddFulfillmentPlacesResponse, AddFulfillmentPlacesMetadata> addFulfillmentPlacesOperationSettings;
    private final UnaryCallSettings<RemoveFulfillmentPlacesRequest, Operation> removeFulfillmentPlacesSettings;
    private final OperationCallSettings<RemoveFulfillmentPlacesRequest, RemoveFulfillmentPlacesResponse, RemoveFulfillmentPlacesMetadata> removeFulfillmentPlacesOperationSettings;
    private final UnaryCallSettings<AddLocalInventoriesRequest, Operation> addLocalInventoriesSettings;
    private final OperationCallSettings<AddLocalInventoriesRequest, AddLocalInventoriesResponse, AddLocalInventoriesMetadata> addLocalInventoriesOperationSettings;
    private final UnaryCallSettings<RemoveLocalInventoriesRequest, Operation> removeLocalInventoriesSettings;
    private final OperationCallSettings<RemoveLocalInventoriesRequest, RemoveLocalInventoriesResponse, RemoveLocalInventoriesMetadata> removeLocalInventoriesOperationSettings;
    private static final PagedListDescriptor<ListProductsRequest, ListProductsResponse, Product> LIST_PRODUCTS_PAGE_STR_DESC = new PagedListDescriptor<ListProductsRequest, ListProductsResponse, Product>(){

        public String emptyToken() {
            return "";
        }

        public ListProductsRequest injectToken(ListProductsRequest payload, String token) {
            return ListProductsRequest.newBuilder((ListProductsRequest)payload).setPageToken(token).build();
        }

        public ListProductsRequest injectPageSize(ListProductsRequest payload, int pageSize) {
            return ListProductsRequest.newBuilder((ListProductsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListProductsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListProductsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Product> extractResources(ListProductsResponse payload) {
            return payload.getProductsList() == null ? ImmutableList.of() : payload.getProductsList();
        }
    };
    private static final PagedListResponseFactory<ListProductsRequest, ListProductsResponse, ProductServiceClient.ListProductsPagedResponse> LIST_PRODUCTS_PAGE_STR_FACT = new PagedListResponseFactory<ListProductsRequest, ListProductsResponse, ProductServiceClient.ListProductsPagedResponse>(){

        public ApiFuture<ProductServiceClient.ListProductsPagedResponse> getFuturePagedResponse(UnaryCallable<ListProductsRequest, ListProductsResponse> callable, ListProductsRequest request, ApiCallContext context, ApiFuture<ListProductsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PRODUCTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ProductServiceClient.ListProductsPagedResponse.createAsync((PageContext<ListProductsRequest, ListProductsResponse, Product>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateProductRequest, Product> createProductSettings() {
        return this.createProductSettings;
    }

    public UnaryCallSettings<GetProductRequest, Product> getProductSettings() {
        return this.getProductSettings;
    }

    public PagedCallSettings<ListProductsRequest, ListProductsResponse, ProductServiceClient.ListProductsPagedResponse> listProductsSettings() {
        return this.listProductsSettings;
    }

    public UnaryCallSettings<UpdateProductRequest, Product> updateProductSettings() {
        return this.updateProductSettings;
    }

    public UnaryCallSettings<DeleteProductRequest, Empty> deleteProductSettings() {
        return this.deleteProductSettings;
    }

    public UnaryCallSettings<PurgeProductsRequest, Operation> purgeProductsSettings() {
        return this.purgeProductsSettings;
    }

    public OperationCallSettings<PurgeProductsRequest, PurgeProductsResponse, PurgeProductsMetadata> purgeProductsOperationSettings() {
        return this.purgeProductsOperationSettings;
    }

    public UnaryCallSettings<ImportProductsRequest, Operation> importProductsSettings() {
        return this.importProductsSettings;
    }

    public OperationCallSettings<ImportProductsRequest, ImportProductsResponse, ImportMetadata> importProductsOperationSettings() {
        return this.importProductsOperationSettings;
    }

    public UnaryCallSettings<SetInventoryRequest, Operation> setInventorySettings() {
        return this.setInventorySettings;
    }

    public OperationCallSettings<SetInventoryRequest, SetInventoryResponse, SetInventoryMetadata> setInventoryOperationSettings() {
        return this.setInventoryOperationSettings;
    }

    public UnaryCallSettings<AddFulfillmentPlacesRequest, Operation> addFulfillmentPlacesSettings() {
        return this.addFulfillmentPlacesSettings;
    }

    public OperationCallSettings<AddFulfillmentPlacesRequest, AddFulfillmentPlacesResponse, AddFulfillmentPlacesMetadata> addFulfillmentPlacesOperationSettings() {
        return this.addFulfillmentPlacesOperationSettings;
    }

    public UnaryCallSettings<RemoveFulfillmentPlacesRequest, Operation> removeFulfillmentPlacesSettings() {
        return this.removeFulfillmentPlacesSettings;
    }

    public OperationCallSettings<RemoveFulfillmentPlacesRequest, RemoveFulfillmentPlacesResponse, RemoveFulfillmentPlacesMetadata> removeFulfillmentPlacesOperationSettings() {
        return this.removeFulfillmentPlacesOperationSettings;
    }

    public UnaryCallSettings<AddLocalInventoriesRequest, Operation> addLocalInventoriesSettings() {
        return this.addLocalInventoriesSettings;
    }

    public OperationCallSettings<AddLocalInventoriesRequest, AddLocalInventoriesResponse, AddLocalInventoriesMetadata> addLocalInventoriesOperationSettings() {
        return this.addLocalInventoriesOperationSettings;
    }

    public UnaryCallSettings<RemoveLocalInventoriesRequest, Operation> removeLocalInventoriesSettings() {
        return this.removeLocalInventoriesSettings;
    }

    public OperationCallSettings<RemoveLocalInventoriesRequest, RemoveLocalInventoriesResponse, RemoveLocalInventoriesMetadata> removeLocalInventoriesOperationSettings() {
        return this.removeLocalInventoriesOperationSettings;
    }

    public ProductServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcProductServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonProductServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "retail";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "retail.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "retail.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ProductServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ProductServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ProductServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ProductServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ProductServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createProductSettings = settingsBuilder.createProductSettings().build();
        this.getProductSettings = settingsBuilder.getProductSettings().build();
        this.listProductsSettings = settingsBuilder.listProductsSettings().build();
        this.updateProductSettings = settingsBuilder.updateProductSettings().build();
        this.deleteProductSettings = settingsBuilder.deleteProductSettings().build();
        this.purgeProductsSettings = settingsBuilder.purgeProductsSettings().build();
        this.purgeProductsOperationSettings = settingsBuilder.purgeProductsOperationSettings().build();
        this.importProductsSettings = settingsBuilder.importProductsSettings().build();
        this.importProductsOperationSettings = settingsBuilder.importProductsOperationSettings().build();
        this.setInventorySettings = settingsBuilder.setInventorySettings().build();
        this.setInventoryOperationSettings = settingsBuilder.setInventoryOperationSettings().build();
        this.addFulfillmentPlacesSettings = settingsBuilder.addFulfillmentPlacesSettings().build();
        this.addFulfillmentPlacesOperationSettings = settingsBuilder.addFulfillmentPlacesOperationSettings().build();
        this.removeFulfillmentPlacesSettings = settingsBuilder.removeFulfillmentPlacesSettings().build();
        this.removeFulfillmentPlacesOperationSettings = settingsBuilder.removeFulfillmentPlacesOperationSettings().build();
        this.addLocalInventoriesSettings = settingsBuilder.addLocalInventoriesSettings().build();
        this.addLocalInventoriesOperationSettings = settingsBuilder.addLocalInventoriesOperationSettings().build();
        this.removeLocalInventoriesSettings = settingsBuilder.removeLocalInventoriesSettings().build();
        this.removeLocalInventoriesOperationSettings = settingsBuilder.removeLocalInventoriesOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ProductServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateProductRequest, Product> createProductSettings;
        private final UnaryCallSettings.Builder<GetProductRequest, Product> getProductSettings;
        private final PagedCallSettings.Builder<ListProductsRequest, ListProductsResponse, ProductServiceClient.ListProductsPagedResponse> listProductsSettings;
        private final UnaryCallSettings.Builder<UpdateProductRequest, Product> updateProductSettings;
        private final UnaryCallSettings.Builder<DeleteProductRequest, Empty> deleteProductSettings;
        private final UnaryCallSettings.Builder<PurgeProductsRequest, Operation> purgeProductsSettings;
        private final OperationCallSettings.Builder<PurgeProductsRequest, PurgeProductsResponse, PurgeProductsMetadata> purgeProductsOperationSettings;
        private final UnaryCallSettings.Builder<ImportProductsRequest, Operation> importProductsSettings;
        private final OperationCallSettings.Builder<ImportProductsRequest, ImportProductsResponse, ImportMetadata> importProductsOperationSettings;
        private final UnaryCallSettings.Builder<SetInventoryRequest, Operation> setInventorySettings;
        private final OperationCallSettings.Builder<SetInventoryRequest, SetInventoryResponse, SetInventoryMetadata> setInventoryOperationSettings;
        private final UnaryCallSettings.Builder<AddFulfillmentPlacesRequest, Operation> addFulfillmentPlacesSettings;
        private final OperationCallSettings.Builder<AddFulfillmentPlacesRequest, AddFulfillmentPlacesResponse, AddFulfillmentPlacesMetadata> addFulfillmentPlacesOperationSettings;
        private final UnaryCallSettings.Builder<RemoveFulfillmentPlacesRequest, Operation> removeFulfillmentPlacesSettings;
        private final OperationCallSettings.Builder<RemoveFulfillmentPlacesRequest, RemoveFulfillmentPlacesResponse, RemoveFulfillmentPlacesMetadata> removeFulfillmentPlacesOperationSettings;
        private final UnaryCallSettings.Builder<AddLocalInventoriesRequest, Operation> addLocalInventoriesSettings;
        private final OperationCallSettings.Builder<AddLocalInventoriesRequest, AddLocalInventoriesResponse, AddLocalInventoriesMetadata> addLocalInventoriesOperationSettings;
        private final UnaryCallSettings.Builder<RemoveLocalInventoriesRequest, Operation> removeLocalInventoriesSettings;
        private final OperationCallSettings.Builder<RemoveLocalInventoriesRequest, RemoveLocalInventoriesResponse, RemoveLocalInventoriesMetadata> removeLocalInventoriesOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createProductSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getProductSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listProductsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PRODUCTS_PAGE_STR_FACT);
            this.updateProductSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteProductSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.purgeProductsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.purgeProductsOperationSettings = OperationCallSettings.newBuilder();
            this.importProductsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importProductsOperationSettings = OperationCallSettings.newBuilder();
            this.setInventorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setInventoryOperationSettings = OperationCallSettings.newBuilder();
            this.addFulfillmentPlacesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addFulfillmentPlacesOperationSettings = OperationCallSettings.newBuilder();
            this.removeFulfillmentPlacesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeFulfillmentPlacesOperationSettings = OperationCallSettings.newBuilder();
            this.addLocalInventoriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addLocalInventoriesOperationSettings = OperationCallSettings.newBuilder();
            this.removeLocalInventoriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeLocalInventoriesOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createProductSettings, this.getProductSettings, this.listProductsSettings, this.updateProductSettings, this.deleteProductSettings, this.purgeProductsSettings, this.importProductsSettings, this.setInventorySettings, this.addFulfillmentPlacesSettings, this.removeFulfillmentPlacesSettings, this.addLocalInventoriesSettings, this.removeLocalInventoriesSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(ProductServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createProductSettings = settings.createProductSettings.toBuilder();
            this.getProductSettings = settings.getProductSettings.toBuilder();
            this.listProductsSettings = settings.listProductsSettings.toBuilder();
            this.updateProductSettings = settings.updateProductSettings.toBuilder();
            this.deleteProductSettings = settings.deleteProductSettings.toBuilder();
            this.purgeProductsSettings = settings.purgeProductsSettings.toBuilder();
            this.purgeProductsOperationSettings = settings.purgeProductsOperationSettings.toBuilder();
            this.importProductsSettings = settings.importProductsSettings.toBuilder();
            this.importProductsOperationSettings = settings.importProductsOperationSettings.toBuilder();
            this.setInventorySettings = settings.setInventorySettings.toBuilder();
            this.setInventoryOperationSettings = settings.setInventoryOperationSettings.toBuilder();
            this.addFulfillmentPlacesSettings = settings.addFulfillmentPlacesSettings.toBuilder();
            this.addFulfillmentPlacesOperationSettings = settings.addFulfillmentPlacesOperationSettings.toBuilder();
            this.removeFulfillmentPlacesSettings = settings.removeFulfillmentPlacesSettings.toBuilder();
            this.removeFulfillmentPlacesOperationSettings = settings.removeFulfillmentPlacesOperationSettings.toBuilder();
            this.addLocalInventoriesSettings = settings.addLocalInventoriesSettings.toBuilder();
            this.addLocalInventoriesOperationSettings = settings.addLocalInventoriesOperationSettings.toBuilder();
            this.removeLocalInventoriesSettings = settings.removeLocalInventoriesSettings.toBuilder();
            this.removeLocalInventoriesOperationSettings = settings.removeLocalInventoriesOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createProductSettings, this.getProductSettings, this.listProductsSettings, this.updateProductSettings, this.deleteProductSettings, this.purgeProductsSettings, this.importProductsSettings, this.setInventorySettings, this.addFulfillmentPlacesSettings, this.removeFulfillmentPlacesSettings, this.addLocalInventoriesSettings, this.removeLocalInventoriesSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ProductServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ProductServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ProductServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ProductServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ProductServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ProductServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ProductServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ProductServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createProductSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.getProductSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.listProductsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.updateProductSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.deleteProductSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.purgeProductsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.importProductsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_4_params"));
            builder.setInventorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.addFulfillmentPlacesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.removeFulfillmentPlacesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.addLocalInventoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.removeLocalInventoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.purgeProductsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(PurgeProductsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(PurgeProductsMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.importProductsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_4_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportProductsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.setInventoryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(SetInventoryResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(SetInventoryMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.addFulfillmentPlacesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AddFulfillmentPlacesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AddFulfillmentPlacesMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.removeFulfillmentPlacesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(RemoveFulfillmentPlacesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(RemoveFulfillmentPlacesMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.addLocalInventoriesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AddLocalInventoriesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AddLocalInventoriesMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.removeLocalInventoriesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(RemoveLocalInventoriesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(RemoveLocalInventoriesMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateProductRequest, Product> createProductSettings() {
            return this.createProductSettings;
        }

        public UnaryCallSettings.Builder<GetProductRequest, Product> getProductSettings() {
            return this.getProductSettings;
        }

        public PagedCallSettings.Builder<ListProductsRequest, ListProductsResponse, ProductServiceClient.ListProductsPagedResponse> listProductsSettings() {
            return this.listProductsSettings;
        }

        public UnaryCallSettings.Builder<UpdateProductRequest, Product> updateProductSettings() {
            return this.updateProductSettings;
        }

        public UnaryCallSettings.Builder<DeleteProductRequest, Empty> deleteProductSettings() {
            return this.deleteProductSettings;
        }

        public UnaryCallSettings.Builder<PurgeProductsRequest, Operation> purgeProductsSettings() {
            return this.purgeProductsSettings;
        }

        public OperationCallSettings.Builder<PurgeProductsRequest, PurgeProductsResponse, PurgeProductsMetadata> purgeProductsOperationSettings() {
            return this.purgeProductsOperationSettings;
        }

        public UnaryCallSettings.Builder<ImportProductsRequest, Operation> importProductsSettings() {
            return this.importProductsSettings;
        }

        public OperationCallSettings.Builder<ImportProductsRequest, ImportProductsResponse, ImportMetadata> importProductsOperationSettings() {
            return this.importProductsOperationSettings;
        }

        public UnaryCallSettings.Builder<SetInventoryRequest, Operation> setInventorySettings() {
            return this.setInventorySettings;
        }

        public OperationCallSettings.Builder<SetInventoryRequest, SetInventoryResponse, SetInventoryMetadata> setInventoryOperationSettings() {
            return this.setInventoryOperationSettings;
        }

        public UnaryCallSettings.Builder<AddFulfillmentPlacesRequest, Operation> addFulfillmentPlacesSettings() {
            return this.addFulfillmentPlacesSettings;
        }

        public OperationCallSettings.Builder<AddFulfillmentPlacesRequest, AddFulfillmentPlacesResponse, AddFulfillmentPlacesMetadata> addFulfillmentPlacesOperationSettings() {
            return this.addFulfillmentPlacesOperationSettings;
        }

        public UnaryCallSettings.Builder<RemoveFulfillmentPlacesRequest, Operation> removeFulfillmentPlacesSettings() {
            return this.removeFulfillmentPlacesSettings;
        }

        public OperationCallSettings.Builder<RemoveFulfillmentPlacesRequest, RemoveFulfillmentPlacesResponse, RemoveFulfillmentPlacesMetadata> removeFulfillmentPlacesOperationSettings() {
            return this.removeFulfillmentPlacesOperationSettings;
        }

        public UnaryCallSettings.Builder<AddLocalInventoriesRequest, Operation> addLocalInventoriesSettings() {
            return this.addLocalInventoriesSettings;
        }

        public OperationCallSettings.Builder<AddLocalInventoriesRequest, AddLocalInventoriesResponse, AddLocalInventoriesMetadata> addLocalInventoriesOperationSettings() {
            return this.addLocalInventoriesOperationSettings;
        }

        public UnaryCallSettings.Builder<RemoveLocalInventoriesRequest, Operation> removeLocalInventoriesSettings() {
            return this.removeLocalInventoriesSettings;
        }

        public OperationCallSettings.Builder<RemoveLocalInventoriesRequest, RemoveLocalInventoriesResponse, RemoveLocalInventoriesMetadata> removeLocalInventoriesOperationSettings() {
            return this.removeLocalInventoriesOperationSettings;
        }

        public ProductServiceStubSettings build() throws IOException {
            return new ProductServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            definitions.put((Object)"retry_policy_4_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)30000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)300000L)).setInitialRpcTimeout(Duration.ofMillis((long)300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)300000L)).setTotalTimeout(Duration.ofMillis((long)300000L)).build();
            definitions.put((Object)"retry_policy_4_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

