/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2alpha.AddCatalogAttributeRequest;
import com.google.cloud.retail.v2alpha.AttributesConfig;
import com.google.cloud.retail.v2alpha.BatchRemoveCatalogAttributesRequest;
import com.google.cloud.retail.v2alpha.BatchRemoveCatalogAttributesResponse;
import com.google.cloud.retail.v2alpha.Catalog;
import com.google.cloud.retail.v2alpha.CatalogServiceClient;
import com.google.cloud.retail.v2alpha.CompletionConfig;
import com.google.cloud.retail.v2alpha.GetAttributesConfigRequest;
import com.google.cloud.retail.v2alpha.GetCompletionConfigRequest;
import com.google.cloud.retail.v2alpha.GetDefaultBranchRequest;
import com.google.cloud.retail.v2alpha.GetDefaultBranchResponse;
import com.google.cloud.retail.v2alpha.ListCatalogsRequest;
import com.google.cloud.retail.v2alpha.ListCatalogsResponse;
import com.google.cloud.retail.v2alpha.RemoveCatalogAttributeRequest;
import com.google.cloud.retail.v2alpha.ReplaceCatalogAttributeRequest;
import com.google.cloud.retail.v2alpha.SetDefaultBranchRequest;
import com.google.cloud.retail.v2alpha.UpdateAttributesConfigRequest;
import com.google.cloud.retail.v2alpha.UpdateCatalogRequest;
import com.google.cloud.retail.v2alpha.UpdateCompletionConfigRequest;
import com.google.cloud.retail.v2alpha.stub.CatalogServiceStub;
import com.google.cloud.retail.v2alpha.stub.CatalogServiceStubSettings;
import com.google.cloud.retail.v2alpha.stub.HttpJsonCatalogServiceCallableFactory;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonCatalogServiceStub
extends CatalogServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListCatalogsRequest, ListCatalogsResponse> listCatalogsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.CatalogService/ListCatalogs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{parent=projects/*/locations/*}/catalogs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListCatalogsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateCatalogRequest, Catalog> updateCatalogMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.CatalogService/UpdateCatalog").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{catalog.name=projects/*/locations/*/catalogs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "catalog.name", (Object)request.getCatalog().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("catalog", (Message)request.getCatalog(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Catalog.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetDefaultBranchRequest, Empty> setDefaultBranchMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.CatalogService/SetDefaultBranch").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{catalog=projects/*/locations/*/catalogs/*}:setDefaultBranch", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "catalog", (Object)request.getCatalog());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearCatalog().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.CatalogService/GetDefaultBranch").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{catalog=projects/*/locations/*/catalogs/*}:getDefaultBranch", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "catalog", (Object)request.getCatalog());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)GetDefaultBranchResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetCompletionConfigRequest, CompletionConfig> getCompletionConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.CatalogService/GetCompletionConfig").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{name=projects/*/locations/*/catalogs/*/completionConfig}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CompletionConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateCompletionConfigRequest, CompletionConfig> updateCompletionConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.CatalogService/UpdateCompletionConfig").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{completionConfig.name=projects/*/locations/*/catalogs/*/completionConfig}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "completionConfig.name", (Object)request.getCompletionConfig().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("completionConfig", (Message)request.getCompletionConfig(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CompletionConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetAttributesConfigRequest, AttributesConfig> getAttributesConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.CatalogService/GetAttributesConfig").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{name=projects/*/locations/*/catalogs/*/attributesConfig}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AttributesConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateAttributesConfigRequest, AttributesConfig> updateAttributesConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.CatalogService/UpdateAttributesConfig").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{attributesConfig.name=projects/*/locations/*/catalogs/*/attributesConfig}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "attributesConfig.name", (Object)request.getAttributesConfig().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("attributesConfig", (Message)request.getAttributesConfig(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AttributesConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<AddCatalogAttributeRequest, AttributesConfig> addCatalogAttributeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.CatalogService/AddCatalogAttribute").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{attributesConfig=projects/*/locations/*/catalogs/*/attributesConfig}:addCatalogAttribute", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "attributesConfig", (Object)request.getAttributesConfig());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearAttributesConfig().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AttributesConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RemoveCatalogAttributeRequest, AttributesConfig> removeCatalogAttributeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.CatalogService/RemoveCatalogAttribute").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{attributesConfig=projects/*/locations/*/catalogs/*/attributesConfig}:removeCatalogAttribute", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "attributesConfig", (Object)request.getAttributesConfig());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearAttributesConfig().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AttributesConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchRemoveCatalogAttributesRequest, BatchRemoveCatalogAttributesResponse> batchRemoveCatalogAttributesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.CatalogService/BatchRemoveCatalogAttributes").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{attributesConfig=projects/*/locations/*/catalogs/*/attributesConfig}:batchRemoveCatalogAttributes", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "attributesConfig", (Object)request.getAttributesConfig());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearAttributesConfig().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BatchRemoveCatalogAttributesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ReplaceCatalogAttributeRequest, AttributesConfig> replaceCatalogAttributeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.CatalogService/ReplaceCatalogAttribute").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{attributesConfig=projects/*/locations/*/catalogs/*/attributesConfig}:replaceCatalogAttribute", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "attributesConfig", (Object)request.getAttributesConfig());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearAttributesConfig().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AttributesConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListCatalogsRequest, ListCatalogsResponse> listCatalogsCallable;
    private final UnaryCallable<ListCatalogsRequest, CatalogServiceClient.ListCatalogsPagedResponse> listCatalogsPagedCallable;
    private final UnaryCallable<UpdateCatalogRequest, Catalog> updateCatalogCallable;
    private final UnaryCallable<SetDefaultBranchRequest, Empty> setDefaultBranchCallable;
    private final UnaryCallable<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchCallable;
    private final UnaryCallable<GetCompletionConfigRequest, CompletionConfig> getCompletionConfigCallable;
    private final UnaryCallable<UpdateCompletionConfigRequest, CompletionConfig> updateCompletionConfigCallable;
    private final UnaryCallable<GetAttributesConfigRequest, AttributesConfig> getAttributesConfigCallable;
    private final UnaryCallable<UpdateAttributesConfigRequest, AttributesConfig> updateAttributesConfigCallable;
    private final UnaryCallable<AddCatalogAttributeRequest, AttributesConfig> addCatalogAttributeCallable;
    private final UnaryCallable<RemoveCatalogAttributeRequest, AttributesConfig> removeCatalogAttributeCallable;
    private final UnaryCallable<BatchRemoveCatalogAttributesRequest, BatchRemoveCatalogAttributesResponse> batchRemoveCatalogAttributesCallable;
    private final UnaryCallable<ReplaceCatalogAttributeRequest, AttributesConfig> replaceCatalogAttributeCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCatalogServiceStub create(CatalogServiceStubSettings settings) throws IOException {
        return new HttpJsonCatalogServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCatalogServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCatalogServiceStub(CatalogServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonCatalogServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCatalogServiceStub(CatalogServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCatalogServiceStub(CatalogServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCatalogServiceCallableFactory());
    }

    protected HttpJsonCatalogServiceStub(CatalogServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listCatalogsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listCatalogsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateCatalogTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateCatalogMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("catalog.name", String.valueOf(request.getCatalog().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings setDefaultBranchTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setDefaultBranchMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("catalog", String.valueOf(request.getCatalog()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getDefaultBranchTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDefaultBranchMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("catalog", String.valueOf(request.getCatalog()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getCompletionConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getCompletionConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateCompletionConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateCompletionConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("completion_config.name", String.valueOf(request.getCompletionConfig().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getAttributesConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getAttributesConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateAttributesConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateAttributesConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("attributes_config.name", String.valueOf(request.getAttributesConfig().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings addCatalogAttributeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(addCatalogAttributeMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("attributes_config", String.valueOf(request.getAttributesConfig()));
            return builder.build();
        }).build();
        HttpJsonCallSettings removeCatalogAttributeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(removeCatalogAttributeMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("attributes_config", String.valueOf(request.getAttributesConfig()));
            return builder.build();
        }).build();
        HttpJsonCallSettings batchRemoveCatalogAttributesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchRemoveCatalogAttributesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("attributes_config", String.valueOf(request.getAttributesConfig()));
            return builder.build();
        }).build();
        HttpJsonCallSettings replaceCatalogAttributeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(replaceCatalogAttributeMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("attributes_config", String.valueOf(request.getAttributesConfig()));
            return builder.build();
        }).build();
        this.listCatalogsCallable = callableFactory.createUnaryCallable(listCatalogsTransportSettings, settings.listCatalogsSettings(), clientContext);
        this.listCatalogsPagedCallable = callableFactory.createPagedCallable(listCatalogsTransportSettings, settings.listCatalogsSettings(), clientContext);
        this.updateCatalogCallable = callableFactory.createUnaryCallable(updateCatalogTransportSettings, settings.updateCatalogSettings(), clientContext);
        this.setDefaultBranchCallable = callableFactory.createUnaryCallable(setDefaultBranchTransportSettings, settings.setDefaultBranchSettings(), clientContext);
        this.getDefaultBranchCallable = callableFactory.createUnaryCallable(getDefaultBranchTransportSettings, settings.getDefaultBranchSettings(), clientContext);
        this.getCompletionConfigCallable = callableFactory.createUnaryCallable(getCompletionConfigTransportSettings, settings.getCompletionConfigSettings(), clientContext);
        this.updateCompletionConfigCallable = callableFactory.createUnaryCallable(updateCompletionConfigTransportSettings, settings.updateCompletionConfigSettings(), clientContext);
        this.getAttributesConfigCallable = callableFactory.createUnaryCallable(getAttributesConfigTransportSettings, settings.getAttributesConfigSettings(), clientContext);
        this.updateAttributesConfigCallable = callableFactory.createUnaryCallable(updateAttributesConfigTransportSettings, settings.updateAttributesConfigSettings(), clientContext);
        this.addCatalogAttributeCallable = callableFactory.createUnaryCallable(addCatalogAttributeTransportSettings, settings.addCatalogAttributeSettings(), clientContext);
        this.removeCatalogAttributeCallable = callableFactory.createUnaryCallable(removeCatalogAttributeTransportSettings, settings.removeCatalogAttributeSettings(), clientContext);
        this.batchRemoveCatalogAttributesCallable = callableFactory.createUnaryCallable(batchRemoveCatalogAttributesTransportSettings, settings.batchRemoveCatalogAttributesSettings(), clientContext);
        this.replaceCatalogAttributeCallable = callableFactory.createUnaryCallable(replaceCatalogAttributeTransportSettings, settings.replaceCatalogAttributeSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listCatalogsMethodDescriptor);
        methodDescriptors.add(updateCatalogMethodDescriptor);
        methodDescriptors.add(setDefaultBranchMethodDescriptor);
        methodDescriptors.add(getDefaultBranchMethodDescriptor);
        methodDescriptors.add(getCompletionConfigMethodDescriptor);
        methodDescriptors.add(updateCompletionConfigMethodDescriptor);
        methodDescriptors.add(getAttributesConfigMethodDescriptor);
        methodDescriptors.add(updateAttributesConfigMethodDescriptor);
        methodDescriptors.add(addCatalogAttributeMethodDescriptor);
        methodDescriptors.add(removeCatalogAttributeMethodDescriptor);
        methodDescriptors.add(batchRemoveCatalogAttributesMethodDescriptor);
        methodDescriptors.add(replaceCatalogAttributeMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListCatalogsRequest, ListCatalogsResponse> listCatalogsCallable() {
        return this.listCatalogsCallable;
    }

    @Override
    public UnaryCallable<ListCatalogsRequest, CatalogServiceClient.ListCatalogsPagedResponse> listCatalogsPagedCallable() {
        return this.listCatalogsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateCatalogRequest, Catalog> updateCatalogCallable() {
        return this.updateCatalogCallable;
    }

    @Override
    public UnaryCallable<SetDefaultBranchRequest, Empty> setDefaultBranchCallable() {
        return this.setDefaultBranchCallable;
    }

    @Override
    public UnaryCallable<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchCallable() {
        return this.getDefaultBranchCallable;
    }

    @Override
    public UnaryCallable<GetCompletionConfigRequest, CompletionConfig> getCompletionConfigCallable() {
        return this.getCompletionConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateCompletionConfigRequest, CompletionConfig> updateCompletionConfigCallable() {
        return this.updateCompletionConfigCallable;
    }

    @Override
    public UnaryCallable<GetAttributesConfigRequest, AttributesConfig> getAttributesConfigCallable() {
        return this.getAttributesConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateAttributesConfigRequest, AttributesConfig> updateAttributesConfigCallable() {
        return this.updateAttributesConfigCallable;
    }

    @Override
    public UnaryCallable<AddCatalogAttributeRequest, AttributesConfig> addCatalogAttributeCallable() {
        return this.addCatalogAttributeCallable;
    }

    @Override
    public UnaryCallable<RemoveCatalogAttributeRequest, AttributesConfig> removeCatalogAttributeCallable() {
        return this.removeCatalogAttributeCallable;
    }

    @Override
    public UnaryCallable<BatchRemoveCatalogAttributesRequest, BatchRemoveCatalogAttributesResponse> batchRemoveCatalogAttributesCallable() {
        return this.batchRemoveCatalogAttributesCallable;
    }

    @Override
    public UnaryCallable<ReplaceCatalogAttributeRequest, AttributesConfig> replaceCatalogAttributeCallable() {
        return this.replaceCatalogAttributeCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

