/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.OperationsClient;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2.CompleteQueryRequest;
import com.google.cloud.retail.v2.CompleteQueryResponse;
import com.google.cloud.retail.v2.CompletionServiceSettings;
import com.google.cloud.retail.v2.ImportCompletionDataRequest;
import com.google.cloud.retail.v2.ImportCompletionDataResponse;
import com.google.cloud.retail.v2.ImportMetadata;
import com.google.cloud.retail.v2.stub.CompletionServiceStub;
import com.google.cloud.retail.v2.stub.CompletionServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class CompletionServiceClient
implements BackgroundResource {
    private final CompletionServiceSettings settings;
    private final CompletionServiceStub stub;
    private final OperationsClient httpJsonOperationsClient;
    private final com.google.longrunning.OperationsClient operationsClient;

    public static final CompletionServiceClient create() throws IOException {
        return CompletionServiceClient.create(CompletionServiceSettings.newBuilder().build());
    }

    public static final CompletionServiceClient create(CompletionServiceSettings settings) throws IOException {
        return new CompletionServiceClient(settings);
    }

    public static final CompletionServiceClient create(CompletionServiceStub stub) {
        return new CompletionServiceClient(stub);
    }

    protected CompletionServiceClient(CompletionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CompletionServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = com.google.longrunning.OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = OperationsClient.create((com.google.api.gax.httpjson.longrunning.stub.OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected CompletionServiceClient(CompletionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = com.google.longrunning.OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = OperationsClient.create((com.google.api.gax.httpjson.longrunning.stub.OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final CompletionServiceSettings getSettings() {
        return this.settings;
    }

    public CompletionServiceStub getStub() {
        return this.stub;
    }

    public final com.google.longrunning.OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final CompleteQueryResponse completeQuery(CompleteQueryRequest request) {
        return (CompleteQueryResponse)this.completeQueryCallable().call((Object)request);
    }

    public final UnaryCallable<CompleteQueryRequest, CompleteQueryResponse> completeQueryCallable() {
        return this.stub.completeQueryCallable();
    }

    public final OperationFuture<ImportCompletionDataResponse, ImportMetadata> importCompletionDataAsync(ImportCompletionDataRequest request) {
        return this.importCompletionDataOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportCompletionDataRequest, ImportCompletionDataResponse, ImportMetadata> importCompletionDataOperationCallable() {
        return this.stub.importCompletionDataOperationCallable();
    }

    public final UnaryCallable<ImportCompletionDataRequest, Operation> importCompletionDataCallable() {
        return this.stub.importCompletionDataCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

