/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2beta.PredictRequest;
import com.google.cloud.retail.v2beta.PredictResponse;
import com.google.cloud.retail.v2beta.stub.HttpJsonPredictionServiceCallableFactory;
import com.google.cloud.retail.v2beta.stub.PredictionServiceStub;
import com.google.cloud.retail.v2beta.stub.PredictionServiceStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonPredictionServiceStub
extends PredictionServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<PredictRequest, PredictResponse> predictMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2beta.PredictionService/Predict").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{placement=projects/*/locations/*/catalogs/*/placements/*}:predict", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "placement", (Object)request.getPlacement());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearPlacement().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)PredictResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<PredictRequest, PredictResponse> predictCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonPredictionServiceStub create(PredictionServiceStubSettings settings) throws IOException {
        return new HttpJsonPredictionServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonPredictionServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonPredictionServiceStub(PredictionServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonPredictionServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonPredictionServiceStub(PredictionServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonPredictionServiceStub(PredictionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonPredictionServiceCallableFactory());
    }

    protected HttpJsonPredictionServiceStub(PredictionServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings predictTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(predictMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.predictCallable = callableFactory.createUnaryCallable(predictTransportSettings, settings.predictSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(predictMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<PredictRequest, PredictResponse> predictCallable() {
        return this.predictCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

