/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2beta.SearchRequest;
import com.google.cloud.retail.v2beta.SearchResponse;
import com.google.cloud.retail.v2beta.SearchServiceClient;
import com.google.cloud.retail.v2beta.stub.HttpJsonSearchServiceCallableFactory;
import com.google.cloud.retail.v2beta.stub.SearchServiceStub;
import com.google.cloud.retail.v2beta.stub.SearchServiceStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonSearchServiceStub
extends SearchServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<SearchRequest, SearchResponse> searchMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2beta.SearchService/Search").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{placement=projects/*/locations/*/catalogs/*/placements/*}:search", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "placement", (Object)request.getPlacement());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2beta/{placement=projects/*/locations/*/catalogs/*/servingConfigs/*}:search"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearPlacement().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<SearchRequest, SearchResponse> searchCallable;
    private final UnaryCallable<SearchRequest, SearchServiceClient.SearchPagedResponse> searchPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonSearchServiceStub create(SearchServiceStubSettings settings) throws IOException {
        return new HttpJsonSearchServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonSearchServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonSearchServiceStub(SearchServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonSearchServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonSearchServiceStub(SearchServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonSearchServiceStub(SearchServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonSearchServiceCallableFactory());
    }

    protected HttpJsonSearchServiceStub(SearchServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings searchTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.searchCallable = callableFactory.createUnaryCallable(searchTransportSettings, settings.searchSettings(), clientContext);
        this.searchPagedCallable = callableFactory.createPagedCallable(searchTransportSettings, settings.searchSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(searchMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<SearchRequest, SearchResponse> searchCallable() {
        return this.searchCallable;
    }

    @Override
    public UnaryCallable<SearchRequest, SearchServiceClient.SearchPagedResponse> searchPagedCallable() {
        return this.searchPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

