/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2beta.SearchRequest;
import com.google.cloud.retail.v2beta.SearchResponse;
import com.google.cloud.retail.v2beta.SearchServiceSettings;
import com.google.cloud.retail.v2beta.stub.SearchServiceStub;
import com.google.cloud.retail.v2beta.stub.SearchServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SearchServiceClient
implements BackgroundResource {
    private final SearchServiceSettings settings;
    private final SearchServiceStub stub;

    public static final SearchServiceClient create() throws IOException {
        return SearchServiceClient.create(SearchServiceSettings.newBuilder().build());
    }

    public static final SearchServiceClient create(SearchServiceSettings settings) throws IOException {
        return new SearchServiceClient(settings);
    }

    public static final SearchServiceClient create(SearchServiceStub stub) {
        return new SearchServiceClient(stub);
    }

    protected SearchServiceClient(SearchServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SearchServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected SearchServiceClient(SearchServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SearchServiceSettings getSettings() {
        return this.settings;
    }

    public SearchServiceStub getStub() {
        return this.stub;
    }

    public final SearchPagedResponse search(SearchRequest request) {
        return (SearchPagedResponse)((Object)this.searchPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchRequest, SearchPagedResponse> searchPagedCallable() {
        return this.stub.searchPagedCallable();
    }

    public final UnaryCallable<SearchRequest, SearchResponse> searchCallable() {
        return this.stub.searchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchRequest, SearchResponse, SearchResponse.SearchResult, SearchPage, SearchFixedSizeCollection> {
        private SearchFixedSizeCollection(List<SearchPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchFixedSizeCollection createEmptyCollection() {
            return new SearchFixedSizeCollection(null, 0);
        }

        protected SearchFixedSizeCollection createCollection(List<SearchPage> pages, int collectionSize) {
            return new SearchFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchPage
    extends AbstractPage<SearchRequest, SearchResponse, SearchResponse.SearchResult, SearchPage> {
        private SearchPage(PageContext<SearchRequest, SearchResponse, SearchResponse.SearchResult> context, SearchResponse response) {
            super(context, (Object)response);
        }

        private static SearchPage createEmptyPage() {
            return new SearchPage(null, null);
        }

        protected SearchPage createPage(PageContext<SearchRequest, SearchResponse, SearchResponse.SearchResult> context, SearchResponse response) {
            return new SearchPage(context, response);
        }

        public ApiFuture<SearchPage> createPageAsync(PageContext<SearchRequest, SearchResponse, SearchResponse.SearchResult> context, ApiFuture<SearchResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchPagedResponse
    extends AbstractPagedListResponse<SearchRequest, SearchResponse, SearchResponse.SearchResult, SearchPage, SearchFixedSizeCollection> {
        public static ApiFuture<SearchPagedResponse> createAsync(PageContext<SearchRequest, SearchResponse, SearchResponse.SearchResult> context, ApiFuture<SearchResponse> futureResponse) {
            ApiFuture<SearchPage> futurePage = SearchPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchPagedResponse((SearchPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchPagedResponse(SearchPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchFixedSizeCollection.createEmptyCollection());
        }
    }
}

