/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2beta.CreateModelMetadata;
import com.google.cloud.retail.v2beta.CreateModelRequest;
import com.google.cloud.retail.v2beta.DeleteModelRequest;
import com.google.cloud.retail.v2beta.ListModelsRequest;
import com.google.cloud.retail.v2beta.ListModelsResponse;
import com.google.cloud.retail.v2beta.Model;
import com.google.cloud.retail.v2beta.ModelServiceClient;
import com.google.cloud.retail.v2beta.PauseModelRequest;
import com.google.cloud.retail.v2beta.ResumeModelRequest;
import com.google.cloud.retail.v2beta.TuneModelMetadata;
import com.google.cloud.retail.v2beta.TuneModelRequest;
import com.google.cloud.retail.v2beta.TuneModelResponse;
import com.google.cloud.retail.v2beta.UpdateModelRequest;
import com.google.cloud.retail.v2beta.stub.HttpJsonModelServiceCallableFactory;
import com.google.cloud.retail.v2beta.stub.ModelServiceStub;
import com.google.cloud.retail.v2beta.stub.ModelServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonModelServiceStub
extends ModelServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(TuneModelMetadata.getDescriptor()).add(CreateModelMetadata.getDescriptor()).add(Model.getDescriptor()).add(TuneModelResponse.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateModelRequest, Operation> createModelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2beta.ModelService/CreateModel").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{parent=projects/*/locations/*/catalogs/*}/models", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "dryRun", (Object)request.getDryRun());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("model", (Message)request.getModel(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<PauseModelRequest, Model> pauseModelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2beta.ModelService/PauseModel").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{name=projects/*/locations/*/catalogs/*/models/*}:pause", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Model.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ResumeModelRequest, Model> resumeModelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2beta.ModelService/ResumeModel").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{name=projects/*/locations/*/catalogs/*/models/*}:resume", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Model.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteModelRequest, Empty> deleteModelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2beta.ModelService/DeleteModel").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{name=projects/*/locations/*/catalogs/*/models/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListModelsRequest, ListModelsResponse> listModelsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2beta.ModelService/ListModels").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{parent=projects/*/locations/*/catalogs/*}/models", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListModelsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateModelRequest, Model> updateModelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2beta.ModelService/UpdateModel").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{model.name=projects/*/locations/*/catalogs/*/models/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "model.name", (Object)request.getModel().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("model", (Message)request.getModel(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Model.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TuneModelRequest, Operation> tuneModelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2beta.ModelService/TuneModel").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{name=projects/*/locations/*/catalogs/*/models/*}:tune", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<CreateModelRequest, Operation> createModelCallable;
    private final OperationCallable<CreateModelRequest, Model, CreateModelMetadata> createModelOperationCallable;
    private final UnaryCallable<PauseModelRequest, Model> pauseModelCallable;
    private final UnaryCallable<ResumeModelRequest, Model> resumeModelCallable;
    private final UnaryCallable<DeleteModelRequest, Empty> deleteModelCallable;
    private final UnaryCallable<ListModelsRequest, ListModelsResponse> listModelsCallable;
    private final UnaryCallable<ListModelsRequest, ModelServiceClient.ListModelsPagedResponse> listModelsPagedCallable;
    private final UnaryCallable<UpdateModelRequest, Model> updateModelCallable;
    private final UnaryCallable<TuneModelRequest, Operation> tuneModelCallable;
    private final OperationCallable<TuneModelRequest, TuneModelResponse, TuneModelMetadata> tuneModelOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonModelServiceStub create(ModelServiceStubSettings settings) throws IOException {
        return new HttpJsonModelServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonModelServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonModelServiceStub(ModelServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonModelServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonModelServiceStub(ModelServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonModelServiceStub(ModelServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonModelServiceCallableFactory());
    }

    protected HttpJsonModelServiceStub(ModelServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings createModelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createModelMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings pauseModelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(pauseModelMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings resumeModelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(resumeModelMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteModelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteModelMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listModelsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listModelsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateModelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateModelMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings tuneModelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(tuneModelMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createModelCallable = callableFactory.createUnaryCallable(createModelTransportSettings, settings.createModelSettings(), clientContext);
        this.createModelOperationCallable = callableFactory.createOperationCallable(createModelTransportSettings, settings.createModelOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.pauseModelCallable = callableFactory.createUnaryCallable(pauseModelTransportSettings, settings.pauseModelSettings(), clientContext);
        this.resumeModelCallable = callableFactory.createUnaryCallable(resumeModelTransportSettings, settings.resumeModelSettings(), clientContext);
        this.deleteModelCallable = callableFactory.createUnaryCallable(deleteModelTransportSettings, settings.deleteModelSettings(), clientContext);
        this.listModelsCallable = callableFactory.createUnaryCallable(listModelsTransportSettings, settings.listModelsSettings(), clientContext);
        this.listModelsPagedCallable = callableFactory.createPagedCallable(listModelsTransportSettings, settings.listModelsSettings(), clientContext);
        this.updateModelCallable = callableFactory.createUnaryCallable(updateModelTransportSettings, settings.updateModelSettings(), clientContext);
        this.tuneModelCallable = callableFactory.createUnaryCallable(tuneModelTransportSettings, settings.tuneModelSettings(), clientContext);
        this.tuneModelOperationCallable = callableFactory.createOperationCallable(tuneModelTransportSettings, settings.tuneModelOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createModelMethodDescriptor);
        methodDescriptors.add(pauseModelMethodDescriptor);
        methodDescriptors.add(resumeModelMethodDescriptor);
        methodDescriptors.add(deleteModelMethodDescriptor);
        methodDescriptors.add(listModelsMethodDescriptor);
        methodDescriptors.add(updateModelMethodDescriptor);
        methodDescriptors.add(tuneModelMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateModelRequest, Operation> createModelCallable() {
        return this.createModelCallable;
    }

    @Override
    public OperationCallable<CreateModelRequest, Model, CreateModelMetadata> createModelOperationCallable() {
        return this.createModelOperationCallable;
    }

    @Override
    public UnaryCallable<PauseModelRequest, Model> pauseModelCallable() {
        return this.pauseModelCallable;
    }

    @Override
    public UnaryCallable<ResumeModelRequest, Model> resumeModelCallable() {
        return this.resumeModelCallable;
    }

    @Override
    public UnaryCallable<DeleteModelRequest, Empty> deleteModelCallable() {
        return this.deleteModelCallable;
    }

    @Override
    public UnaryCallable<ListModelsRequest, ListModelsResponse> listModelsCallable() {
        return this.listModelsCallable;
    }

    @Override
    public UnaryCallable<ListModelsRequest, ModelServiceClient.ListModelsPagedResponse> listModelsPagedCallable() {
        return this.listModelsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateModelRequest, Model> updateModelCallable() {
        return this.updateModelCallable;
    }

    @Override
    public UnaryCallable<TuneModelRequest, Operation> tuneModelCallable() {
        return this.tuneModelCallable;
    }

    @Override
    public OperationCallable<TuneModelRequest, TuneModelResponse, TuneModelMetadata> tuneModelOperationCallable() {
        return this.tuneModelOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

