/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2.BranchName;
import com.google.cloud.retail.v2.CreateProductRequest;
import com.google.cloud.retail.v2.DeleteProductRequest;
import com.google.cloud.retail.v2.GetProductRequest;
import com.google.cloud.retail.v2.ImportMetadata;
import com.google.cloud.retail.v2.ImportProductsRequest;
import com.google.cloud.retail.v2.ImportProductsResponse;
import com.google.cloud.retail.v2.Product;
import com.google.cloud.retail.v2.ProductName;
import com.google.cloud.retail.v2.ProductServiceSettings;
import com.google.cloud.retail.v2.UpdateProductRequest;
import com.google.cloud.retail.v2.stub.ProductServiceStub;
import com.google.cloud.retail.v2.stub.ProductServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class ProductServiceClient
implements BackgroundResource {
    private final ProductServiceSettings settings;
    private final ProductServiceStub stub;
    private final OperationsClient operationsClient;

    public static final ProductServiceClient create() throws IOException {
        return ProductServiceClient.create(ProductServiceSettings.newBuilder().build());
    }

    public static final ProductServiceClient create(ProductServiceSettings settings) throws IOException {
        return new ProductServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ProductServiceClient create(ProductServiceStub stub) {
        return new ProductServiceClient(stub);
    }

    protected ProductServiceClient(ProductServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProductServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ProductServiceClient(ProductServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ProductServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ProductServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Product createProduct(BranchName parent, Product product, String productId) {
        CreateProductRequest request = CreateProductRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setProduct(product).setProductId(productId).build();
        return this.createProduct(request);
    }

    public final Product createProduct(String parent, Product product, String productId) {
        CreateProductRequest request = CreateProductRequest.newBuilder().setParent(parent).setProduct(product).setProductId(productId).build();
        return this.createProduct(request);
    }

    public final Product createProduct(CreateProductRequest request) {
        return (Product)this.createProductCallable().call((Object)request);
    }

    public final UnaryCallable<CreateProductRequest, Product> createProductCallable() {
        return this.stub.createProductCallable();
    }

    public final Product getProduct(ProductName name) {
        GetProductRequest request = GetProductRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProduct(request);
    }

    public final Product getProduct(String name) {
        GetProductRequest request = GetProductRequest.newBuilder().setName(name).build();
        return this.getProduct(request);
    }

    public final Product getProduct(GetProductRequest request) {
        return (Product)this.getProductCallable().call((Object)request);
    }

    public final UnaryCallable<GetProductRequest, Product> getProductCallable() {
        return this.stub.getProductCallable();
    }

    public final Product updateProduct(Product product, FieldMask updateMask) {
        UpdateProductRequest request = UpdateProductRequest.newBuilder().setProduct(product).setUpdateMask(updateMask).build();
        return this.updateProduct(request);
    }

    public final Product updateProduct(UpdateProductRequest request) {
        return (Product)this.updateProductCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateProductRequest, Product> updateProductCallable() {
        return this.stub.updateProductCallable();
    }

    public final void deleteProduct(ProductName name) {
        DeleteProductRequest request = DeleteProductRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteProduct(request);
    }

    public final void deleteProduct(String name) {
        DeleteProductRequest request = DeleteProductRequest.newBuilder().setName(name).build();
        this.deleteProduct(request);
    }

    public final void deleteProduct(DeleteProductRequest request) {
        this.deleteProductCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteProductRequest, Empty> deleteProductCallable() {
        return this.stub.deleteProductCallable();
    }

    public final OperationFuture<ImportProductsResponse, ImportMetadata> importProductsAsync(ImportProductsRequest request) {
        return this.importProductsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportProductsRequest, ImportProductsResponse, ImportMetadata> importProductsOperationCallable() {
        return this.stub.importProductsOperationCallable();
    }

    public final UnaryCallable<ImportProductsRequest, Operation> importProductsCallable() {
        return this.stub.importProductsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

