/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcemanager.v3.CreateTagHoldMetadata;
import com.google.cloud.resourcemanager.v3.CreateTagHoldRequest;
import com.google.cloud.resourcemanager.v3.DeleteTagHoldMetadata;
import com.google.cloud.resourcemanager.v3.DeleteTagHoldRequest;
import com.google.cloud.resourcemanager.v3.ListTagHoldsRequest;
import com.google.cloud.resourcemanager.v3.ListTagHoldsResponse;
import com.google.cloud.resourcemanager.v3.TagHold;
import com.google.cloud.resourcemanager.v3.TagHoldName;
import com.google.cloud.resourcemanager.v3.TagHoldsSettings;
import com.google.cloud.resourcemanager.v3.TagValueName;
import com.google.cloud.resourcemanager.v3.stub.TagHoldsStub;
import com.google.cloud.resourcemanager.v3.stub.TagHoldsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TagHoldsClient
implements BackgroundResource {
    private final TagHoldsSettings settings;
    private final TagHoldsStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final TagHoldsClient create() throws IOException {
        return TagHoldsClient.create(TagHoldsSettings.newBuilder().build());
    }

    public static final TagHoldsClient create(TagHoldsSettings settings) throws IOException {
        return new TagHoldsClient(settings);
    }

    public static final TagHoldsClient create(TagHoldsStub stub) {
        return new TagHoldsClient(stub);
    }

    protected TagHoldsClient(TagHoldsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TagHoldsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected TagHoldsClient(TagHoldsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final TagHoldsSettings getSettings() {
        return this.settings;
    }

    public TagHoldsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<TagHold, CreateTagHoldMetadata> createTagHoldAsync(TagValueName parent, TagHold tagHold) {
        CreateTagHoldRequest request = CreateTagHoldRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTagHold(tagHold).build();
        return this.createTagHoldAsync(request);
    }

    public final OperationFuture<TagHold, CreateTagHoldMetadata> createTagHoldAsync(String parent, TagHold tagHold) {
        CreateTagHoldRequest request = CreateTagHoldRequest.newBuilder().setParent(parent).setTagHold(tagHold).build();
        return this.createTagHoldAsync(request);
    }

    public final OperationFuture<TagHold, CreateTagHoldMetadata> createTagHoldAsync(CreateTagHoldRequest request) {
        return this.createTagHoldOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateTagHoldRequest, TagHold, CreateTagHoldMetadata> createTagHoldOperationCallable() {
        return this.stub.createTagHoldOperationCallable();
    }

    public final UnaryCallable<CreateTagHoldRequest, Operation> createTagHoldCallable() {
        return this.stub.createTagHoldCallable();
    }

    public final OperationFuture<Empty, DeleteTagHoldMetadata> deleteTagHoldAsync(TagHoldName name) {
        DeleteTagHoldRequest request = DeleteTagHoldRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteTagHoldAsync(request);
    }

    public final OperationFuture<Empty, DeleteTagHoldMetadata> deleteTagHoldAsync(String name) {
        DeleteTagHoldRequest request = DeleteTagHoldRequest.newBuilder().setName(name).build();
        return this.deleteTagHoldAsync(request);
    }

    public final OperationFuture<Empty, DeleteTagHoldMetadata> deleteTagHoldAsync(DeleteTagHoldRequest request) {
        return this.deleteTagHoldOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTagHoldRequest, Empty, DeleteTagHoldMetadata> deleteTagHoldOperationCallable() {
        return this.stub.deleteTagHoldOperationCallable();
    }

    public final UnaryCallable<DeleteTagHoldRequest, Operation> deleteTagHoldCallable() {
        return this.stub.deleteTagHoldCallable();
    }

    public final ListTagHoldsPagedResponse listTagHolds(TagValueName parent) {
        ListTagHoldsRequest request = ListTagHoldsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTagHolds(request);
    }

    public final ListTagHoldsPagedResponse listTagHolds(String parent) {
        ListTagHoldsRequest request = ListTagHoldsRequest.newBuilder().setParent(parent).build();
        return this.listTagHolds(request);
    }

    public final ListTagHoldsPagedResponse listTagHolds(ListTagHoldsRequest request) {
        return (ListTagHoldsPagedResponse)((Object)this.listTagHoldsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTagHoldsRequest, ListTagHoldsPagedResponse> listTagHoldsPagedCallable() {
        return this.stub.listTagHoldsPagedCallable();
    }

    public final UnaryCallable<ListTagHoldsRequest, ListTagHoldsResponse> listTagHoldsCallable() {
        return this.stub.listTagHoldsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTagHoldsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTagHoldsRequest, ListTagHoldsResponse, TagHold, ListTagHoldsPage, ListTagHoldsFixedSizeCollection> {
        private ListTagHoldsFixedSizeCollection(List<ListTagHoldsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTagHoldsFixedSizeCollection createEmptyCollection() {
            return new ListTagHoldsFixedSizeCollection(null, 0);
        }

        protected ListTagHoldsFixedSizeCollection createCollection(List<ListTagHoldsPage> pages, int collectionSize) {
            return new ListTagHoldsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTagHoldsPage
    extends AbstractPage<ListTagHoldsRequest, ListTagHoldsResponse, TagHold, ListTagHoldsPage> {
        private ListTagHoldsPage(PageContext<ListTagHoldsRequest, ListTagHoldsResponse, TagHold> context, ListTagHoldsResponse response) {
            super(context, (Object)response);
        }

        private static ListTagHoldsPage createEmptyPage() {
            return new ListTagHoldsPage(null, null);
        }

        protected ListTagHoldsPage createPage(PageContext<ListTagHoldsRequest, ListTagHoldsResponse, TagHold> context, ListTagHoldsResponse response) {
            return new ListTagHoldsPage(context, response);
        }

        public ApiFuture<ListTagHoldsPage> createPageAsync(PageContext<ListTagHoldsRequest, ListTagHoldsResponse, TagHold> context, ApiFuture<ListTagHoldsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTagHoldsPagedResponse
    extends AbstractPagedListResponse<ListTagHoldsRequest, ListTagHoldsResponse, TagHold, ListTagHoldsPage, ListTagHoldsFixedSizeCollection> {
        public static ApiFuture<ListTagHoldsPagedResponse> createAsync(PageContext<ListTagHoldsRequest, ListTagHoldsResponse, TagHold> context, ApiFuture<ListTagHoldsResponse> futureResponse) {
            ApiFuture<ListTagHoldsPage> futurePage = ListTagHoldsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTagHoldsPagedResponse((ListTagHoldsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTagHoldsPagedResponse(ListTagHoldsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTagHoldsFixedSizeCollection.createEmptyCollection());
        }
    }
}

