/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcemanager.v3.CreateTagValueMetadata;
import com.google.cloud.resourcemanager.v3.CreateTagValueRequest;
import com.google.cloud.resourcemanager.v3.DeleteTagValueMetadata;
import com.google.cloud.resourcemanager.v3.DeleteTagValueRequest;
import com.google.cloud.resourcemanager.v3.GetTagValueRequest;
import com.google.cloud.resourcemanager.v3.ListTagValuesRequest;
import com.google.cloud.resourcemanager.v3.ListTagValuesResponse;
import com.google.cloud.resourcemanager.v3.TagValue;
import com.google.cloud.resourcemanager.v3.TagValuesClient;
import com.google.cloud.resourcemanager.v3.UpdateTagValueMetadata;
import com.google.cloud.resourcemanager.v3.UpdateTagValueRequest;
import com.google.cloud.resourcemanager.v3.stub.HttpJsonTagValuesCallableFactory;
import com.google.cloud.resourcemanager.v3.stub.TagValuesStub;
import com.google.cloud.resourcemanager.v3.stub.TagValuesStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonTagValuesStub
extends TagValuesStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(TagValue.getDescriptor()).add(CreateTagValueMetadata.getDescriptor()).add(UpdateTagValueMetadata.getDescriptor()).add(DeleteTagValueMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListTagValuesRequest, ListTagValuesResponse> listTagValuesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagValues/ListTagValues").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/tagValues", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListTagValuesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetTagValueRequest, TagValue> getTagValueMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagValues/GetTagValue").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=tagValues/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TagValue.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateTagValueRequest, Operation> createTagValueMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagValues/CreateTagValue").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/tagValues", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("tagValue", (Message)request.getTagValue(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateTagValueRequest, Operation> updateTagValueMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagValues/UpdateTagValue").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{tagValue.name=tagValues/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "tagValue.name", (Object)request.getTagValue().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("tagValue", (Message)request.getTagValue(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteTagValueRequest, Operation> deleteTagValueMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagValues/DeleteTagValue").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=tagValues/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagValues/GetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{resource=tagValues/*}:getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagValues/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{resource=tagValues/*}:setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcemanager.v3.TagValues/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{resource=tagValues/*}:testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListTagValuesRequest, ListTagValuesResponse> listTagValuesCallable;
    private final UnaryCallable<ListTagValuesRequest, TagValuesClient.ListTagValuesPagedResponse> listTagValuesPagedCallable;
    private final UnaryCallable<GetTagValueRequest, TagValue> getTagValueCallable;
    private final UnaryCallable<CreateTagValueRequest, Operation> createTagValueCallable;
    private final OperationCallable<CreateTagValueRequest, TagValue, CreateTagValueMetadata> createTagValueOperationCallable;
    private final UnaryCallable<UpdateTagValueRequest, Operation> updateTagValueCallable;
    private final OperationCallable<UpdateTagValueRequest, TagValue, UpdateTagValueMetadata> updateTagValueOperationCallable;
    private final UnaryCallable<DeleteTagValueRequest, Operation> deleteTagValueCallable;
    private final OperationCallable<DeleteTagValueRequest, TagValue, DeleteTagValueMetadata> deleteTagValueOperationCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonTagValuesStub create(TagValuesStubSettings settings) throws IOException {
        return new HttpJsonTagValuesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonTagValuesStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonTagValuesStub(TagValuesStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonTagValuesStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonTagValuesStub(TagValuesStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonTagValuesStub(TagValuesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonTagValuesCallableFactory());
    }

    protected HttpJsonTagValuesStub(TagValuesStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings listTagValuesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listTagValuesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getTagValueTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getTagValueMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createTagValueTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createTagValueMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateTagValueTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateTagValueMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteTagValueTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteTagValueMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listTagValuesCallable = callableFactory.createUnaryCallable(listTagValuesTransportSettings, settings.listTagValuesSettings(), clientContext);
        this.listTagValuesPagedCallable = callableFactory.createPagedCallable(listTagValuesTransportSettings, settings.listTagValuesSettings(), clientContext);
        this.getTagValueCallable = callableFactory.createUnaryCallable(getTagValueTransportSettings, settings.getTagValueSettings(), clientContext);
        this.createTagValueCallable = callableFactory.createUnaryCallable(createTagValueTransportSettings, settings.createTagValueSettings(), clientContext);
        this.createTagValueOperationCallable = callableFactory.createOperationCallable(createTagValueTransportSettings, settings.createTagValueOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateTagValueCallable = callableFactory.createUnaryCallable(updateTagValueTransportSettings, settings.updateTagValueSettings(), clientContext);
        this.updateTagValueOperationCallable = callableFactory.createOperationCallable(updateTagValueTransportSettings, settings.updateTagValueOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteTagValueCallable = callableFactory.createUnaryCallable(deleteTagValueTransportSettings, settings.deleteTagValueSettings(), clientContext);
        this.deleteTagValueOperationCallable = callableFactory.createOperationCallable(deleteTagValueTransportSettings, settings.deleteTagValueOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listTagValuesMethodDescriptor);
        methodDescriptors.add(getTagValueMethodDescriptor);
        methodDescriptors.add(createTagValueMethodDescriptor);
        methodDescriptors.add(updateTagValueMethodDescriptor);
        methodDescriptors.add(deleteTagValueMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListTagValuesRequest, ListTagValuesResponse> listTagValuesCallable() {
        return this.listTagValuesCallable;
    }

    @Override
    public UnaryCallable<ListTagValuesRequest, TagValuesClient.ListTagValuesPagedResponse> listTagValuesPagedCallable() {
        return this.listTagValuesPagedCallable;
    }

    @Override
    public UnaryCallable<GetTagValueRequest, TagValue> getTagValueCallable() {
        return this.getTagValueCallable;
    }

    @Override
    public UnaryCallable<CreateTagValueRequest, Operation> createTagValueCallable() {
        return this.createTagValueCallable;
    }

    @Override
    public OperationCallable<CreateTagValueRequest, TagValue, CreateTagValueMetadata> createTagValueOperationCallable() {
        return this.createTagValueOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateTagValueRequest, Operation> updateTagValueCallable() {
        return this.updateTagValueCallable;
    }

    @Override
    public OperationCallable<UpdateTagValueRequest, TagValue, UpdateTagValueMetadata> updateTagValueOperationCallable() {
        return this.updateTagValueOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteTagValueRequest, Operation> deleteTagValueCallable() {
        return this.deleteTagValueCallable;
    }

    @Override
    public OperationCallable<DeleteTagValueRequest, TagValue, DeleteTagValueMetadata> deleteTagValueOperationCallable() {
        return this.deleteTagValueOperationCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

