/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager;

import com.google.api.services.cloudresourcemanager.model.BooleanConstraint;
import com.google.api.services.cloudresourcemanager.model.Constraint;
import com.google.api.services.cloudresourcemanager.model.ListConstraint;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class ConstraintInfo {
    static final Function<Constraint, ConstraintInfo> FROM_PROTOBUF_FUNCTION = new Function<Constraint, ConstraintInfo>(){

        public ConstraintInfo apply(Constraint protobuf) {
            return ConstraintInfo.fromProtobuf(protobuf);
        }
    };
    static final Function<ConstraintInfo, Constraint> TO_PROTOBUF_FUNCTION = new Function<ConstraintInfo, Constraint>(){

        public Constraint apply(ConstraintInfo constraintInfo) {
            return constraintInfo.toProtobuf();
        }
    };
    private BooleanConstraint booleanConstraint;
    private String constraintDefault;
    private String description;
    private String displayName;
    private Constraints constraints;
    private String name;
    private Integer version;

    ConstraintInfo(Builder builder) {
        this.booleanConstraint = builder.booleanConstraint;
        this.constraintDefault = builder.constraintDefault;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.constraints = builder.constraints;
        this.name = builder.name;
        this.version = builder.version;
    }

    public BooleanConstraint getBooleanConstraint() {
        return this.booleanConstraint;
    }

    public String getConstraintDefault() {
        return this.constraintDefault;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Constraints getConstraints() {
        return this.constraints;
    }

    public String getName() {
        return this.name;
    }

    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstraintInfo that = (ConstraintInfo)o;
        return Objects.equals(this.booleanConstraint, that.booleanConstraint) && Objects.equals(this.constraintDefault, that.constraintDefault) && Objects.equals(this.description, that.description) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.constraints, that.constraints) && Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.booleanConstraint, this.constraintDefault, this.description, this.displayName, this.constraints, this.name, this.version);
    }

    public static Builder newBuilder(String name) {
        return new Builder(name);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    Constraint toProtobuf() {
        Constraint constraintProto = new Constraint();
        constraintProto.setBooleanConstraint(this.booleanConstraint);
        constraintProto.setConstraintDefault(this.constraintDefault);
        constraintProto.setDescription(this.description);
        constraintProto.setDisplayName(this.displayName);
        if (this.constraints != null) {
            constraintProto.setListConstraint(this.constraints.toProtobuf());
        }
        constraintProto.setName(this.name);
        constraintProto.setVersion(this.version);
        return constraintProto;
    }

    static ConstraintInfo fromProtobuf(Constraint constraintProtobuf) {
        Builder builder = ConstraintInfo.newBuilder(constraintProtobuf.getName());
        builder.setBooleanConstraint(constraintProtobuf.getBooleanConstraint());
        builder.setConstraintDefault(constraintProtobuf.getConstraintDefault());
        builder.setDescription(constraintProtobuf.getDescription());
        builder.setDisplayName(constraintProtobuf.getDisplayName());
        if (constraintProtobuf.getListConstraint() != null) {
            builder.setConstraints(Constraints.fromProtobuf(constraintProtobuf.getListConstraint()));
        }
        if (constraintProtobuf.getName() != null && !constraintProtobuf.getName().equals("Unnamed")) {
            builder.setName(constraintProtobuf.getName());
        }
        builder.setVersion(constraintProtobuf.getVersion());
        return builder.build();
    }

    static class Builder {
        private BooleanConstraint booleanConstraint;
        private String constraintDefault;
        private String description;
        private String displayName;
        private Constraints constraints;
        private String name;
        private Integer version;

        Builder(String name) {
            this.name = name;
        }

        Builder(ConstraintInfo info) {
            this.booleanConstraint = info.booleanConstraint;
            this.constraintDefault = info.constraintDefault;
            this.description = info.description;
            this.displayName = info.displayName;
            this.constraints = info.constraints;
            this.name = info.name;
            this.version = info.version;
        }

        Builder setBooleanConstraint(BooleanConstraint booleanConstraint) {
            this.booleanConstraint = booleanConstraint;
            return this;
        }

        Builder setConstraintDefault(String constraintDefault) {
            this.constraintDefault = constraintDefault;
            return this;
        }

        Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        Builder setConstraints(Constraints constraints) {
            this.constraints = constraints;
            return this;
        }

        Builder setName(String name) {
            this.name = name;
            return this;
        }

        Builder setVersion(Integer version) {
            this.version = version;
            return this;
        }

        ConstraintInfo build() {
            return new ConstraintInfo(this);
        }
    }

    static class Constraints {
        private final String suggestedValue;
        private final Boolean supportsUnder;

        Constraints(String suggestedValue, Boolean supportsUnder) {
            this.suggestedValue = suggestedValue;
            this.supportsUnder = supportsUnder;
        }

        String getSuggestedValue() {
            return this.suggestedValue;
        }

        Boolean getSupportsUnder() {
            return this.supportsUnder;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("suggestedValue", (Object)this.getSuggestedValue()).add("supportsUnder", (Object)this.getSupportsUnder()).toString();
        }

        public int hashCode() {
            return Objects.hash(this.suggestedValue, this.supportsUnder);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Constraints that = (Constraints)o;
            return Objects.equals(this.suggestedValue, that.suggestedValue) && Objects.equals(this.supportsUnder, that.supportsUnder);
        }

        ListConstraint toProtobuf() {
            return new ListConstraint().setSuggestedValue(this.suggestedValue).setSupportsUnder(this.supportsUnder);
        }

        static Constraints fromProtobuf(ListConstraint listConstraint) {
            return new Constraints(listConstraint.getSuggestedValue(), listConstraint.getSupportsUnder());
        }
    }
}

