/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.resourcemanager.v3.CreateTagValueMetadata;
import com.google.cloud.resourcemanager.v3.CreateTagValueRequest;
import com.google.cloud.resourcemanager.v3.DeleteTagValueMetadata;
import com.google.cloud.resourcemanager.v3.DeleteTagValueRequest;
import com.google.cloud.resourcemanager.v3.GetTagValueRequest;
import com.google.cloud.resourcemanager.v3.ListTagValuesRequest;
import com.google.cloud.resourcemanager.v3.ListTagValuesResponse;
import com.google.cloud.resourcemanager.v3.TagValue;
import com.google.cloud.resourcemanager.v3.TagValueName;
import com.google.cloud.resourcemanager.v3.TagValuesSettings;
import com.google.cloud.resourcemanager.v3.UpdateTagValueMetadata;
import com.google.cloud.resourcemanager.v3.UpdateTagValueRequest;
import com.google.cloud.resourcemanager.v3.stub.TagValuesStub;
import com.google.cloud.resourcemanager.v3.stub.TagValuesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TagValuesClient
implements BackgroundResource {
    private final TagValuesSettings settings;
    private final TagValuesStub stub;
    private final OperationsClient operationsClient;

    public static final TagValuesClient create() throws IOException {
        return TagValuesClient.create(TagValuesSettings.newBuilder().build());
    }

    public static final TagValuesClient create(TagValuesSettings settings) throws IOException {
        return new TagValuesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TagValuesClient create(TagValuesStub stub) {
        return new TagValuesClient(stub);
    }

    protected TagValuesClient(TagValuesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TagValuesStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TagValuesClient(TagValuesStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final TagValuesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TagValuesStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListTagValuesPagedResponse listTagValues(ResourceName parent) {
        ListTagValuesRequest request = ListTagValuesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTagValues(request);
    }

    public final ListTagValuesPagedResponse listTagValues(String parent) {
        ListTagValuesRequest request = ListTagValuesRequest.newBuilder().setParent(parent).build();
        return this.listTagValues(request);
    }

    public final ListTagValuesPagedResponse listTagValues(ListTagValuesRequest request) {
        return (ListTagValuesPagedResponse)((Object)this.listTagValuesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTagValuesRequest, ListTagValuesPagedResponse> listTagValuesPagedCallable() {
        return this.stub.listTagValuesPagedCallable();
    }

    public final UnaryCallable<ListTagValuesRequest, ListTagValuesResponse> listTagValuesCallable() {
        return this.stub.listTagValuesCallable();
    }

    public final TagValue getTagValue(TagValueName name) {
        GetTagValueRequest request = GetTagValueRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTagValue(request);
    }

    public final TagValue getTagValue(String name) {
        GetTagValueRequest request = GetTagValueRequest.newBuilder().setName(name).build();
        return this.getTagValue(request);
    }

    public final TagValue getTagValue(GetTagValueRequest request) {
        return (TagValue)this.getTagValueCallable().call((Object)request);
    }

    public final UnaryCallable<GetTagValueRequest, TagValue> getTagValueCallable() {
        return this.stub.getTagValueCallable();
    }

    public final OperationFuture<TagValue, CreateTagValueMetadata> createTagValueAsync(TagValue tagValue) {
        CreateTagValueRequest request = CreateTagValueRequest.newBuilder().setTagValue(tagValue).build();
        return this.createTagValueAsync(request);
    }

    public final OperationFuture<TagValue, CreateTagValueMetadata> createTagValueAsync(CreateTagValueRequest request) {
        return this.createTagValueOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateTagValueRequest, TagValue, CreateTagValueMetadata> createTagValueOperationCallable() {
        return this.stub.createTagValueOperationCallable();
    }

    public final UnaryCallable<CreateTagValueRequest, Operation> createTagValueCallable() {
        return this.stub.createTagValueCallable();
    }

    public final OperationFuture<TagValue, UpdateTagValueMetadata> updateTagValueAsync(TagValue tagValue, FieldMask updateMask) {
        UpdateTagValueRequest request = UpdateTagValueRequest.newBuilder().setTagValue(tagValue).setUpdateMask(updateMask).build();
        return this.updateTagValueAsync(request);
    }

    public final OperationFuture<TagValue, UpdateTagValueMetadata> updateTagValueAsync(UpdateTagValueRequest request) {
        return this.updateTagValueOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateTagValueRequest, TagValue, UpdateTagValueMetadata> updateTagValueOperationCallable() {
        return this.stub.updateTagValueOperationCallable();
    }

    public final UnaryCallable<UpdateTagValueRequest, Operation> updateTagValueCallable() {
        return this.stub.updateTagValueCallable();
    }

    public final OperationFuture<TagValue, DeleteTagValueMetadata> deleteTagValueAsync(TagValueName name) {
        DeleteTagValueRequest request = DeleteTagValueRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteTagValueAsync(request);
    }

    public final OperationFuture<TagValue, DeleteTagValueMetadata> deleteTagValueAsync(String name) {
        DeleteTagValueRequest request = DeleteTagValueRequest.newBuilder().setName(name).build();
        return this.deleteTagValueAsync(request);
    }

    public final OperationFuture<TagValue, DeleteTagValueMetadata> deleteTagValueAsync(DeleteTagValueRequest request) {
        return this.deleteTagValueOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTagValueRequest, TagValue, DeleteTagValueMetadata> deleteTagValueOperationCallable() {
        return this.stub.deleteTagValueOperationCallable();
    }

    public final UnaryCallable<DeleteTagValueRequest, Operation> deleteTagValueCallable() {
        return this.stub.deleteTagValueCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTagValuesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTagValuesRequest, ListTagValuesResponse, TagValue, ListTagValuesPage, ListTagValuesFixedSizeCollection> {
        private ListTagValuesFixedSizeCollection(List<ListTagValuesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTagValuesFixedSizeCollection createEmptyCollection() {
            return new ListTagValuesFixedSizeCollection(null, 0);
        }

        protected ListTagValuesFixedSizeCollection createCollection(List<ListTagValuesPage> pages, int collectionSize) {
            return new ListTagValuesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTagValuesPage
    extends AbstractPage<ListTagValuesRequest, ListTagValuesResponse, TagValue, ListTagValuesPage> {
        private ListTagValuesPage(PageContext<ListTagValuesRequest, ListTagValuesResponse, TagValue> context, ListTagValuesResponse response) {
            super(context, (Object)response);
        }

        private static ListTagValuesPage createEmptyPage() {
            return new ListTagValuesPage(null, null);
        }

        protected ListTagValuesPage createPage(PageContext<ListTagValuesRequest, ListTagValuesResponse, TagValue> context, ListTagValuesResponse response) {
            return new ListTagValuesPage(context, response);
        }

        public ApiFuture<ListTagValuesPage> createPageAsync(PageContext<ListTagValuesRequest, ListTagValuesResponse, TagValue> context, ApiFuture<ListTagValuesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTagValuesPagedResponse
    extends AbstractPagedListResponse<ListTagValuesRequest, ListTagValuesResponse, TagValue, ListTagValuesPage, ListTagValuesFixedSizeCollection> {
        public static ApiFuture<ListTagValuesPagedResponse> createAsync(PageContext<ListTagValuesRequest, ListTagValuesResponse, TagValue> context, ApiFuture<ListTagValuesResponse> futureResponse) {
            ApiFuture<ListTagValuesPage> futurePage = ListTagValuesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTagValuesPage, ListTagValuesPagedResponse>(){

                public ListTagValuesPagedResponse apply(ListTagValuesPage input) {
                    return new ListTagValuesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTagValuesPagedResponse(ListTagValuesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTagValuesFixedSizeCollection.createEmptyCollection());
        }
    }
}

