/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.redis.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.redis.v1beta1.CloudRedisClient;
import com.google.cloud.redis.v1beta1.CreateInstanceRequest;
import com.google.cloud.redis.v1beta1.DeleteInstanceRequest;
import com.google.cloud.redis.v1beta1.ExportInstanceRequest;
import com.google.cloud.redis.v1beta1.FailoverInstanceRequest;
import com.google.cloud.redis.v1beta1.GetInstanceAuthStringRequest;
import com.google.cloud.redis.v1beta1.GetInstanceRequest;
import com.google.cloud.redis.v1beta1.ImportInstanceRequest;
import com.google.cloud.redis.v1beta1.Instance;
import com.google.cloud.redis.v1beta1.InstanceAuthString;
import com.google.cloud.redis.v1beta1.ListInstancesRequest;
import com.google.cloud.redis.v1beta1.ListInstancesResponse;
import com.google.cloud.redis.v1beta1.RescheduleMaintenanceRequest;
import com.google.cloud.redis.v1beta1.UpdateInstanceRequest;
import com.google.cloud.redis.v1beta1.UpgradeInstanceRequest;
import com.google.cloud.redis.v1beta1.stub.CloudRedisStub;
import com.google.cloud.redis.v1beta1.stub.CloudRedisStubSettings;
import com.google.cloud.redis.v1beta1.stub.GrpcCloudRedisCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcCloudRedisStub
extends CloudRedisStub {
    private static final MethodDescriptor<ListInstancesRequest, ListInstancesResponse> listInstancesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.redis.v1beta1.CloudRedis/ListInstances").setRequestMarshaller(ProtoUtils.marshaller((Message)ListInstancesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListInstancesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetInstanceRequest, Instance> getInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.redis.v1beta1.CloudRedis/GetInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)GetInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Instance.getDefaultInstance())).build();
    private static final MethodDescriptor<GetInstanceAuthStringRequest, InstanceAuthString> getInstanceAuthStringMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.redis.v1beta1.CloudRedis/GetInstanceAuthString").setRequestMarshaller(ProtoUtils.marshaller((Message)GetInstanceAuthStringRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)InstanceAuthString.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateInstanceRequest, Operation> createInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.redis.v1beta1.CloudRedis/CreateInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateInstanceRequest, Operation> updateInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.redis.v1beta1.CloudRedis/UpdateInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpgradeInstanceRequest, Operation> upgradeInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.redis.v1beta1.CloudRedis/UpgradeInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)UpgradeInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ImportInstanceRequest, Operation> importInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.redis.v1beta1.CloudRedis/ImportInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ExportInstanceRequest, Operation> exportInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.redis.v1beta1.CloudRedis/ExportInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<FailoverInstanceRequest, Operation> failoverInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.redis.v1beta1.CloudRedis/FailoverInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)FailoverInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteInstanceRequest, Operation> deleteInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.redis.v1beta1.CloudRedis/DeleteInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<RescheduleMaintenanceRequest, Operation> rescheduleMaintenanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.redis.v1beta1.CloudRedis/RescheduleMaintenance").setRequestMarshaller(ProtoUtils.marshaller((Message)RescheduleMaintenanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable;
    private final UnaryCallable<ListInstancesRequest, CloudRedisClient.ListInstancesPagedResponse> listInstancesPagedCallable;
    private final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable;
    private final UnaryCallable<GetInstanceAuthStringRequest, InstanceAuthString> getInstanceAuthStringCallable;
    private final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable;
    private final OperationCallable<CreateInstanceRequest, Instance, Any> createInstanceOperationCallable;
    private final UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable;
    private final OperationCallable<UpdateInstanceRequest, Instance, Any> updateInstanceOperationCallable;
    private final UnaryCallable<UpgradeInstanceRequest, Operation> upgradeInstanceCallable;
    private final OperationCallable<UpgradeInstanceRequest, Instance, Any> upgradeInstanceOperationCallable;
    private final UnaryCallable<ImportInstanceRequest, Operation> importInstanceCallable;
    private final OperationCallable<ImportInstanceRequest, Instance, Any> importInstanceOperationCallable;
    private final UnaryCallable<ExportInstanceRequest, Operation> exportInstanceCallable;
    private final OperationCallable<ExportInstanceRequest, Instance, Any> exportInstanceOperationCallable;
    private final UnaryCallable<FailoverInstanceRequest, Operation> failoverInstanceCallable;
    private final OperationCallable<FailoverInstanceRequest, Instance, Any> failoverInstanceOperationCallable;
    private final UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable;
    private final OperationCallable<DeleteInstanceRequest, Empty, Any> deleteInstanceOperationCallable;
    private final UnaryCallable<RescheduleMaintenanceRequest, Operation> rescheduleMaintenanceCallable;
    private final OperationCallable<RescheduleMaintenanceRequest, Instance, Any> rescheduleMaintenanceOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCloudRedisStub create(CloudRedisStubSettings settings) throws IOException {
        return new GrpcCloudRedisStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCloudRedisStub create(ClientContext clientContext) throws IOException {
        return new GrpcCloudRedisStub(CloudRedisStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCloudRedisStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCloudRedisStub(CloudRedisStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCloudRedisStub(CloudRedisStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCloudRedisCallableFactory());
    }

    protected GrpcCloudRedisStub(CloudRedisStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listInstancesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listInstancesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getInstanceAuthStringTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getInstanceAuthStringMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"instance.name", (Object)String.valueOf(request.getInstance().getName()));
            return params.build();
        }).build();
        GrpcCallSettings upgradeInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(upgradeInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings importInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings exportInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings failoverInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(failoverInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings rescheduleMaintenanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(rescheduleMaintenanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        this.listInstancesCallable = callableFactory.createUnaryCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.listInstancesPagedCallable = callableFactory.createPagedCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.getInstanceCallable = callableFactory.createUnaryCallable(getInstanceTransportSettings, settings.getInstanceSettings(), clientContext);
        this.getInstanceAuthStringCallable = callableFactory.createUnaryCallable(getInstanceAuthStringTransportSettings, settings.getInstanceAuthStringSettings(), clientContext);
        this.createInstanceCallable = callableFactory.createUnaryCallable(createInstanceTransportSettings, settings.createInstanceSettings(), clientContext);
        this.createInstanceOperationCallable = callableFactory.createOperationCallable(createInstanceTransportSettings, settings.createInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateInstanceCallable = callableFactory.createUnaryCallable(updateInstanceTransportSettings, settings.updateInstanceSettings(), clientContext);
        this.updateInstanceOperationCallable = callableFactory.createOperationCallable(updateInstanceTransportSettings, settings.updateInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.upgradeInstanceCallable = callableFactory.createUnaryCallable(upgradeInstanceTransportSettings, settings.upgradeInstanceSettings(), clientContext);
        this.upgradeInstanceOperationCallable = callableFactory.createOperationCallable(upgradeInstanceTransportSettings, settings.upgradeInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.importInstanceCallable = callableFactory.createUnaryCallable(importInstanceTransportSettings, settings.importInstanceSettings(), clientContext);
        this.importInstanceOperationCallable = callableFactory.createOperationCallable(importInstanceTransportSettings, settings.importInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.exportInstanceCallable = callableFactory.createUnaryCallable(exportInstanceTransportSettings, settings.exportInstanceSettings(), clientContext);
        this.exportInstanceOperationCallable = callableFactory.createOperationCallable(exportInstanceTransportSettings, settings.exportInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.failoverInstanceCallable = callableFactory.createUnaryCallable(failoverInstanceTransportSettings, settings.failoverInstanceSettings(), clientContext);
        this.failoverInstanceOperationCallable = callableFactory.createOperationCallable(failoverInstanceTransportSettings, settings.failoverInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteInstanceCallable = callableFactory.createUnaryCallable(deleteInstanceTransportSettings, settings.deleteInstanceSettings(), clientContext);
        this.deleteInstanceOperationCallable = callableFactory.createOperationCallable(deleteInstanceTransportSettings, settings.deleteInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.rescheduleMaintenanceCallable = callableFactory.createUnaryCallable(rescheduleMaintenanceTransportSettings, settings.rescheduleMaintenanceSettings(), clientContext);
        this.rescheduleMaintenanceOperationCallable = callableFactory.createOperationCallable(rescheduleMaintenanceTransportSettings, settings.rescheduleMaintenanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.listInstancesCallable;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, CloudRedisClient.ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.listInstancesPagedCallable;
    }

    @Override
    public UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.getInstanceCallable;
    }

    @Override
    public UnaryCallable<GetInstanceAuthStringRequest, InstanceAuthString> getInstanceAuthStringCallable() {
        return this.getInstanceAuthStringCallable;
    }

    @Override
    public UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.createInstanceCallable;
    }

    @Override
    public OperationCallable<CreateInstanceRequest, Instance, Any> createInstanceOperationCallable() {
        return this.createInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable() {
        return this.updateInstanceCallable;
    }

    @Override
    public OperationCallable<UpdateInstanceRequest, Instance, Any> updateInstanceOperationCallable() {
        return this.updateInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<UpgradeInstanceRequest, Operation> upgradeInstanceCallable() {
        return this.upgradeInstanceCallable;
    }

    @Override
    public OperationCallable<UpgradeInstanceRequest, Instance, Any> upgradeInstanceOperationCallable() {
        return this.upgradeInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<ImportInstanceRequest, Operation> importInstanceCallable() {
        return this.importInstanceCallable;
    }

    @Override
    public OperationCallable<ImportInstanceRequest, Instance, Any> importInstanceOperationCallable() {
        return this.importInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<ExportInstanceRequest, Operation> exportInstanceCallable() {
        return this.exportInstanceCallable;
    }

    @Override
    public OperationCallable<ExportInstanceRequest, Instance, Any> exportInstanceOperationCallable() {
        return this.exportInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<FailoverInstanceRequest, Operation> failoverInstanceCallable() {
        return this.failoverInstanceCallable;
    }

    @Override
    public OperationCallable<FailoverInstanceRequest, Instance, Any> failoverInstanceOperationCallable() {
        return this.failoverInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable() {
        return this.deleteInstanceCallable;
    }

    @Override
    public OperationCallable<DeleteInstanceRequest, Empty, Any> deleteInstanceOperationCallable() {
        return this.deleteInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<RescheduleMaintenanceRequest, Operation> rescheduleMaintenanceCallable() {
        return this.rescheduleMaintenanceCallable;
    }

    @Override
    public OperationCallable<RescheduleMaintenanceRequest, Instance, Any> rescheduleMaintenanceOperationCallable() {
        return this.rescheduleMaintenanceOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

