/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommender.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.recommender.v1.GetInsightRequest;
import com.google.cloud.recommender.v1.GetInsightTypeConfigRequest;
import com.google.cloud.recommender.v1.GetRecommendationRequest;
import com.google.cloud.recommender.v1.GetRecommenderConfigRequest;
import com.google.cloud.recommender.v1.Insight;
import com.google.cloud.recommender.v1.InsightTypeConfig;
import com.google.cloud.recommender.v1.ListInsightsRequest;
import com.google.cloud.recommender.v1.ListInsightsResponse;
import com.google.cloud.recommender.v1.ListRecommendationsRequest;
import com.google.cloud.recommender.v1.ListRecommendationsResponse;
import com.google.cloud.recommender.v1.MarkInsightAcceptedRequest;
import com.google.cloud.recommender.v1.MarkRecommendationClaimedRequest;
import com.google.cloud.recommender.v1.MarkRecommendationDismissedRequest;
import com.google.cloud.recommender.v1.MarkRecommendationFailedRequest;
import com.google.cloud.recommender.v1.MarkRecommendationSucceededRequest;
import com.google.cloud.recommender.v1.Recommendation;
import com.google.cloud.recommender.v1.RecommenderClient;
import com.google.cloud.recommender.v1.RecommenderConfig;
import com.google.cloud.recommender.v1.UpdateInsightTypeConfigRequest;
import com.google.cloud.recommender.v1.UpdateRecommenderConfigRequest;
import com.google.cloud.recommender.v1.stub.GrpcRecommenderStub;
import com.google.cloud.recommender.v1.stub.HttpJsonRecommenderStub;
import com.google.cloud.recommender.v1.stub.RecommenderStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class RecommenderStubSettings
extends StubSettings<RecommenderStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListInsightsRequest, ListInsightsResponse, RecommenderClient.ListInsightsPagedResponse> listInsightsSettings;
    private final UnaryCallSettings<GetInsightRequest, Insight> getInsightSettings;
    private final UnaryCallSettings<MarkInsightAcceptedRequest, Insight> markInsightAcceptedSettings;
    private final PagedCallSettings<ListRecommendationsRequest, ListRecommendationsResponse, RecommenderClient.ListRecommendationsPagedResponse> listRecommendationsSettings;
    private final UnaryCallSettings<GetRecommendationRequest, Recommendation> getRecommendationSettings;
    private final UnaryCallSettings<MarkRecommendationDismissedRequest, Recommendation> markRecommendationDismissedSettings;
    private final UnaryCallSettings<MarkRecommendationClaimedRequest, Recommendation> markRecommendationClaimedSettings;
    private final UnaryCallSettings<MarkRecommendationSucceededRequest, Recommendation> markRecommendationSucceededSettings;
    private final UnaryCallSettings<MarkRecommendationFailedRequest, Recommendation> markRecommendationFailedSettings;
    private final UnaryCallSettings<GetRecommenderConfigRequest, RecommenderConfig> getRecommenderConfigSettings;
    private final UnaryCallSettings<UpdateRecommenderConfigRequest, RecommenderConfig> updateRecommenderConfigSettings;
    private final UnaryCallSettings<GetInsightTypeConfigRequest, InsightTypeConfig> getInsightTypeConfigSettings;
    private final UnaryCallSettings<UpdateInsightTypeConfigRequest, InsightTypeConfig> updateInsightTypeConfigSettings;
    private static final PagedListDescriptor<ListInsightsRequest, ListInsightsResponse, Insight> LIST_INSIGHTS_PAGE_STR_DESC = new PagedListDescriptor<ListInsightsRequest, ListInsightsResponse, Insight>(){

        public String emptyToken() {
            return "";
        }

        public ListInsightsRequest injectToken(ListInsightsRequest payload, String token) {
            return ListInsightsRequest.newBuilder((ListInsightsRequest)payload).setPageToken(token).build();
        }

        public ListInsightsRequest injectPageSize(ListInsightsRequest payload, int pageSize) {
            return ListInsightsRequest.newBuilder((ListInsightsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInsightsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInsightsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Insight> extractResources(ListInsightsResponse payload) {
            return payload.getInsightsList() == null ? ImmutableList.of() : payload.getInsightsList();
        }
    };
    private static final PagedListDescriptor<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation> LIST_RECOMMENDATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation>(){

        public String emptyToken() {
            return "";
        }

        public ListRecommendationsRequest injectToken(ListRecommendationsRequest payload, String token) {
            return ListRecommendationsRequest.newBuilder((ListRecommendationsRequest)payload).setPageToken(token).build();
        }

        public ListRecommendationsRequest injectPageSize(ListRecommendationsRequest payload, int pageSize) {
            return ListRecommendationsRequest.newBuilder((ListRecommendationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRecommendationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRecommendationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Recommendation> extractResources(ListRecommendationsResponse payload) {
            return payload.getRecommendationsList() == null ? ImmutableList.of() : payload.getRecommendationsList();
        }
    };
    private static final PagedListResponseFactory<ListInsightsRequest, ListInsightsResponse, RecommenderClient.ListInsightsPagedResponse> LIST_INSIGHTS_PAGE_STR_FACT = new PagedListResponseFactory<ListInsightsRequest, ListInsightsResponse, RecommenderClient.ListInsightsPagedResponse>(){

        public ApiFuture<RecommenderClient.ListInsightsPagedResponse> getFuturePagedResponse(UnaryCallable<ListInsightsRequest, ListInsightsResponse> callable, ListInsightsRequest request, ApiCallContext context, ApiFuture<ListInsightsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSIGHTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RecommenderClient.ListInsightsPagedResponse.createAsync((PageContext<ListInsightsRequest, ListInsightsResponse, Insight>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRecommendationsRequest, ListRecommendationsResponse, RecommenderClient.ListRecommendationsPagedResponse> LIST_RECOMMENDATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListRecommendationsRequest, ListRecommendationsResponse, RecommenderClient.ListRecommendationsPagedResponse>(){

        public ApiFuture<RecommenderClient.ListRecommendationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRecommendationsRequest, ListRecommendationsResponse> callable, ListRecommendationsRequest request, ApiCallContext context, ApiFuture<ListRecommendationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RECOMMENDATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RecommenderClient.ListRecommendationsPagedResponse.createAsync((PageContext<ListRecommendationsRequest, ListRecommendationsResponse, Recommendation>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListInsightsRequest, ListInsightsResponse, RecommenderClient.ListInsightsPagedResponse> listInsightsSettings() {
        return this.listInsightsSettings;
    }

    public UnaryCallSettings<GetInsightRequest, Insight> getInsightSettings() {
        return this.getInsightSettings;
    }

    public UnaryCallSettings<MarkInsightAcceptedRequest, Insight> markInsightAcceptedSettings() {
        return this.markInsightAcceptedSettings;
    }

    public PagedCallSettings<ListRecommendationsRequest, ListRecommendationsResponse, RecommenderClient.ListRecommendationsPagedResponse> listRecommendationsSettings() {
        return this.listRecommendationsSettings;
    }

    public UnaryCallSettings<GetRecommendationRequest, Recommendation> getRecommendationSettings() {
        return this.getRecommendationSettings;
    }

    public UnaryCallSettings<MarkRecommendationDismissedRequest, Recommendation> markRecommendationDismissedSettings() {
        return this.markRecommendationDismissedSettings;
    }

    public UnaryCallSettings<MarkRecommendationClaimedRequest, Recommendation> markRecommendationClaimedSettings() {
        return this.markRecommendationClaimedSettings;
    }

    public UnaryCallSettings<MarkRecommendationSucceededRequest, Recommendation> markRecommendationSucceededSettings() {
        return this.markRecommendationSucceededSettings;
    }

    public UnaryCallSettings<MarkRecommendationFailedRequest, Recommendation> markRecommendationFailedSettings() {
        return this.markRecommendationFailedSettings;
    }

    public UnaryCallSettings<GetRecommenderConfigRequest, RecommenderConfig> getRecommenderConfigSettings() {
        return this.getRecommenderConfigSettings;
    }

    public UnaryCallSettings<UpdateRecommenderConfigRequest, RecommenderConfig> updateRecommenderConfigSettings() {
        return this.updateRecommenderConfigSettings;
    }

    public UnaryCallSettings<GetInsightTypeConfigRequest, InsightTypeConfig> getInsightTypeConfigSettings() {
        return this.getInsightTypeConfigSettings;
    }

    public UnaryCallSettings<UpdateInsightTypeConfigRequest, InsightTypeConfig> updateInsightTypeConfigSettings() {
        return this.updateInsightTypeConfigSettings;
    }

    public RecommenderStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcRecommenderStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRecommenderStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return RecommenderStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "recommender";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "recommender.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "recommender.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RecommenderStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RecommenderStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RecommenderStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return RecommenderStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RecommenderStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listInsightsSettings = settingsBuilder.listInsightsSettings().build();
        this.getInsightSettings = settingsBuilder.getInsightSettings().build();
        this.markInsightAcceptedSettings = settingsBuilder.markInsightAcceptedSettings().build();
        this.listRecommendationsSettings = settingsBuilder.listRecommendationsSettings().build();
        this.getRecommendationSettings = settingsBuilder.getRecommendationSettings().build();
        this.markRecommendationDismissedSettings = settingsBuilder.markRecommendationDismissedSettings().build();
        this.markRecommendationClaimedSettings = settingsBuilder.markRecommendationClaimedSettings().build();
        this.markRecommendationSucceededSettings = settingsBuilder.markRecommendationSucceededSettings().build();
        this.markRecommendationFailedSettings = settingsBuilder.markRecommendationFailedSettings().build();
        this.getRecommenderConfigSettings = settingsBuilder.getRecommenderConfigSettings().build();
        this.updateRecommenderConfigSettings = settingsBuilder.updateRecommenderConfigSettings().build();
        this.getInsightTypeConfigSettings = settingsBuilder.getInsightTypeConfigSettings().build();
        this.updateInsightTypeConfigSettings = settingsBuilder.updateInsightTypeConfigSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RecommenderStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListInsightsRequest, ListInsightsResponse, RecommenderClient.ListInsightsPagedResponse> listInsightsSettings;
        private final UnaryCallSettings.Builder<GetInsightRequest, Insight> getInsightSettings;
        private final UnaryCallSettings.Builder<MarkInsightAcceptedRequest, Insight> markInsightAcceptedSettings;
        private final PagedCallSettings.Builder<ListRecommendationsRequest, ListRecommendationsResponse, RecommenderClient.ListRecommendationsPagedResponse> listRecommendationsSettings;
        private final UnaryCallSettings.Builder<GetRecommendationRequest, Recommendation> getRecommendationSettings;
        private final UnaryCallSettings.Builder<MarkRecommendationDismissedRequest, Recommendation> markRecommendationDismissedSettings;
        private final UnaryCallSettings.Builder<MarkRecommendationClaimedRequest, Recommendation> markRecommendationClaimedSettings;
        private final UnaryCallSettings.Builder<MarkRecommendationSucceededRequest, Recommendation> markRecommendationSucceededSettings;
        private final UnaryCallSettings.Builder<MarkRecommendationFailedRequest, Recommendation> markRecommendationFailedSettings;
        private final UnaryCallSettings.Builder<GetRecommenderConfigRequest, RecommenderConfig> getRecommenderConfigSettings;
        private final UnaryCallSettings.Builder<UpdateRecommenderConfigRequest, RecommenderConfig> updateRecommenderConfigSettings;
        private final UnaryCallSettings.Builder<GetInsightTypeConfigRequest, InsightTypeConfig> getInsightTypeConfigSettings;
        private final UnaryCallSettings.Builder<UpdateInsightTypeConfigRequest, InsightTypeConfig> updateInsightTypeConfigSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listInsightsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSIGHTS_PAGE_STR_FACT);
            this.getInsightSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.markInsightAcceptedSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRecommendationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RECOMMENDATIONS_PAGE_STR_FACT);
            this.getRecommendationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.markRecommendationDismissedSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.markRecommendationClaimedSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.markRecommendationSucceededSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.markRecommendationFailedSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRecommenderConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRecommenderConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getInsightTypeConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateInsightTypeConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInsightsSettings, this.getInsightSettings, this.markInsightAcceptedSettings, this.listRecommendationsSettings, this.getRecommendationSettings, this.markRecommendationDismissedSettings, this.markRecommendationClaimedSettings, this.markRecommendationSucceededSettings, this.markRecommendationFailedSettings, this.getRecommenderConfigSettings, this.updateRecommenderConfigSettings, this.getInsightTypeConfigSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateInsightTypeConfigSettings});
            Builder.initDefaults(this);
        }

        protected Builder(RecommenderStubSettings settings) {
            super((StubSettings)settings);
            this.listInsightsSettings = settings.listInsightsSettings.toBuilder();
            this.getInsightSettings = settings.getInsightSettings.toBuilder();
            this.markInsightAcceptedSettings = settings.markInsightAcceptedSettings.toBuilder();
            this.listRecommendationsSettings = settings.listRecommendationsSettings.toBuilder();
            this.getRecommendationSettings = settings.getRecommendationSettings.toBuilder();
            this.markRecommendationDismissedSettings = settings.markRecommendationDismissedSettings.toBuilder();
            this.markRecommendationClaimedSettings = settings.markRecommendationClaimedSettings.toBuilder();
            this.markRecommendationSucceededSettings = settings.markRecommendationSucceededSettings.toBuilder();
            this.markRecommendationFailedSettings = settings.markRecommendationFailedSettings.toBuilder();
            this.getRecommenderConfigSettings = settings.getRecommenderConfigSettings.toBuilder();
            this.updateRecommenderConfigSettings = settings.updateRecommenderConfigSettings.toBuilder();
            this.getInsightTypeConfigSettings = settings.getInsightTypeConfigSettings.toBuilder();
            this.updateInsightTypeConfigSettings = settings.updateInsightTypeConfigSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInsightsSettings, this.getInsightSettings, this.markInsightAcceptedSettings, this.listRecommendationsSettings, this.getRecommendationSettings, this.markRecommendationDismissedSettings, this.markRecommendationClaimedSettings, this.markRecommendationSucceededSettings, this.markRecommendationFailedSettings, this.getRecommenderConfigSettings, this.updateRecommenderConfigSettings, this.getInsightTypeConfigSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateInsightTypeConfigSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RecommenderStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RecommenderStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RecommenderStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RecommenderStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)RecommenderStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)RecommenderStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RecommenderStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RecommenderStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listInsightsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getInsightSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.markInsightAcceptedSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listRecommendationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRecommendationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.markRecommendationDismissedSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.markRecommendationClaimedSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.markRecommendationSucceededSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.markRecommendationFailedSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getRecommenderConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateRecommenderConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getInsightTypeConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateInsightTypeConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListInsightsRequest, ListInsightsResponse, RecommenderClient.ListInsightsPagedResponse> listInsightsSettings() {
            return this.listInsightsSettings;
        }

        public UnaryCallSettings.Builder<GetInsightRequest, Insight> getInsightSettings() {
            return this.getInsightSettings;
        }

        public UnaryCallSettings.Builder<MarkInsightAcceptedRequest, Insight> markInsightAcceptedSettings() {
            return this.markInsightAcceptedSettings;
        }

        public PagedCallSettings.Builder<ListRecommendationsRequest, ListRecommendationsResponse, RecommenderClient.ListRecommendationsPagedResponse> listRecommendationsSettings() {
            return this.listRecommendationsSettings;
        }

        public UnaryCallSettings.Builder<GetRecommendationRequest, Recommendation> getRecommendationSettings() {
            return this.getRecommendationSettings;
        }

        public UnaryCallSettings.Builder<MarkRecommendationDismissedRequest, Recommendation> markRecommendationDismissedSettings() {
            return this.markRecommendationDismissedSettings;
        }

        public UnaryCallSettings.Builder<MarkRecommendationClaimedRequest, Recommendation> markRecommendationClaimedSettings() {
            return this.markRecommendationClaimedSettings;
        }

        public UnaryCallSettings.Builder<MarkRecommendationSucceededRequest, Recommendation> markRecommendationSucceededSettings() {
            return this.markRecommendationSucceededSettings;
        }

        public UnaryCallSettings.Builder<MarkRecommendationFailedRequest, Recommendation> markRecommendationFailedSettings() {
            return this.markRecommendationFailedSettings;
        }

        public UnaryCallSettings.Builder<GetRecommenderConfigRequest, RecommenderConfig> getRecommenderConfigSettings() {
            return this.getRecommenderConfigSettings;
        }

        public UnaryCallSettings.Builder<UpdateRecommenderConfigRequest, RecommenderConfig> updateRecommenderConfigSettings() {
            return this.updateRecommenderConfigSettings;
        }

        public UnaryCallSettings.Builder<GetInsightTypeConfigRequest, InsightTypeConfig> getInsightTypeConfigSettings() {
            return this.getInsightTypeConfigSettings;
        }

        public UnaryCallSettings.Builder<UpdateInsightTypeConfigRequest, InsightTypeConfig> updateInsightTypeConfigSettings() {
            return this.updateInsightTypeConfigSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return RecommenderStubSettings.getDefaultEndpoint();
        }

        public RecommenderStubSettings build() throws IOException {
            return new RecommenderStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

