/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.spi.v1;

import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.StreamingCallable;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.cloud.pubsub.spi.v1.PagedResponseWrappers;
import com.google.cloud.pubsub.spi.v1.SubscriberSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ModifyPushConfigRequest;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.PushConfig;
import com.google.pubsub.v1.StreamingPullRequest;
import com.google.pubsub.v1.StreamingPullResponse;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.SubscriptionName;
import com.google.pubsub.v1.TopicName;
import com.google.pubsub.v1.TopicNameOneof;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class SubscriberClient
implements AutoCloseable {
    private final SubscriberSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<Subscription, Subscription> createSubscriptionCallable;
    private final UnaryCallable<GetSubscriptionRequest, Subscription> getSubscriptionCallable;
    private final UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsCallable;
    private final UnaryCallable<ListSubscriptionsRequest, PagedResponseWrappers.ListSubscriptionsPagedResponse> listSubscriptionsPagedCallable;
    private final UnaryCallable<DeleteSubscriptionRequest, Empty> deleteSubscriptionCallable;
    private final UnaryCallable<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineCallable;
    private final UnaryCallable<AcknowledgeRequest, Empty> acknowledgeCallable;
    private final UnaryCallable<PullRequest, PullResponse> pullCallable;
    private final StreamingCallable<StreamingPullRequest, StreamingPullResponse> streamingPullCallable;
    private final UnaryCallable<ModifyPushConfigRequest, Empty> modifyPushConfigCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;

    public static final SubscriberClient create() throws IOException {
        return SubscriberClient.create(SubscriberSettings.defaultBuilder().build());
    }

    public static final SubscriberClient create(SubscriberSettings settings) throws IOException {
        return new SubscriberClient(settings);
    }

    protected SubscriberClient(SubscriberSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        this.createSubscriptionCallable = UnaryCallable.create(settings.createSubscriptionSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.getSubscriptionCallable = UnaryCallable.create(settings.getSubscriptionSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.listSubscriptionsCallable = UnaryCallable.create(settings.listSubscriptionsSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.listSubscriptionsPagedCallable = UnaryCallable.createPagedVariant(settings.listSubscriptionsSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.deleteSubscriptionCallable = UnaryCallable.create(settings.deleteSubscriptionSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.modifyAckDeadlineCallable = UnaryCallable.create(settings.modifyAckDeadlineSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.acknowledgeCallable = UnaryCallable.create(settings.acknowledgeSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.pullCallable = UnaryCallable.create(settings.pullSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.streamingPullCallable = StreamingCallable.create(settings.streamingPullSettings(), (Channel)this.channel);
        this.modifyPushConfigCallable = UnaryCallable.create(settings.modifyPushConfigSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.setIamPolicyCallable = UnaryCallable.create(settings.setIamPolicySettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.getIamPolicyCallable = UnaryCallable.create(settings.getIamPolicySettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.testIamPermissionsCallable = UnaryCallable.create(settings.testIamPermissionsSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    SubscriberClient.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    SubscriberClient.this.executor.shutdown();
                }
            });
        }
    }

    public final SubscriberSettings getSettings() {
        return this.settings;
    }

    public final Subscription createSubscription(SubscriptionName name, TopicName topic, PushConfig pushConfig, int ackDeadlineSeconds) {
        Subscription request = Subscription.newBuilder().setNameWithSubscriptionName(name).setTopicWithTopicNameOneof(topic == null ? null : TopicNameOneof.from((TopicName)topic)).setPushConfig(pushConfig).setAckDeadlineSeconds(ackDeadlineSeconds).build();
        return this.createSubscription(request);
    }

    public final Subscription createSubscription(Subscription request) {
        return (Subscription)this.createSubscriptionCallable().call((Object)request);
    }

    public final UnaryCallable<Subscription, Subscription> createSubscriptionCallable() {
        return this.createSubscriptionCallable;
    }

    public final Subscription getSubscription(SubscriptionName subscription) {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setSubscriptionWithSubscriptionName(subscription).build();
        return this.getSubscription(request);
    }

    private final Subscription getSubscription(GetSubscriptionRequest request) {
        return (Subscription)this.getSubscriptionCallable().call((Object)request);
    }

    public final UnaryCallable<GetSubscriptionRequest, Subscription> getSubscriptionCallable() {
        return this.getSubscriptionCallable;
    }

    public final PagedResponseWrappers.ListSubscriptionsPagedResponse listSubscriptions(ProjectName project) {
        ListSubscriptionsRequest request = ListSubscriptionsRequest.newBuilder().setProjectWithProjectName(project).build();
        return this.listSubscriptions(request);
    }

    public final PagedResponseWrappers.ListSubscriptionsPagedResponse listSubscriptions(ListSubscriptionsRequest request) {
        return (PagedResponseWrappers.ListSubscriptionsPagedResponse)((Object)this.listSubscriptionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSubscriptionsRequest, PagedResponseWrappers.ListSubscriptionsPagedResponse> listSubscriptionsPagedCallable() {
        return this.listSubscriptionsPagedCallable;
    }

    public final UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsCallable() {
        return this.listSubscriptionsCallable;
    }

    public final void deleteSubscription(SubscriptionName subscription) {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setSubscriptionWithSubscriptionName(subscription).build();
        this.deleteSubscription(request);
    }

    private final void deleteSubscription(DeleteSubscriptionRequest request) {
        this.deleteSubscriptionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSubscriptionRequest, Empty> deleteSubscriptionCallable() {
        return this.deleteSubscriptionCallable;
    }

    public final void modifyAckDeadline(SubscriptionName subscription, List<String> ackIds, int ackDeadlineSeconds) {
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setSubscriptionWithSubscriptionName(subscription).addAllAckIds(ackIds).setAckDeadlineSeconds(ackDeadlineSeconds).build();
        this.modifyAckDeadline(request);
    }

    public final void modifyAckDeadline(ModifyAckDeadlineRequest request) {
        this.modifyAckDeadlineCallable().call((Object)request);
    }

    public final UnaryCallable<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineCallable() {
        return this.modifyAckDeadlineCallable;
    }

    public final void acknowledge(SubscriptionName subscription, List<String> ackIds) {
        AcknowledgeRequest request = AcknowledgeRequest.newBuilder().setSubscriptionWithSubscriptionName(subscription).addAllAckIds(ackIds).build();
        this.acknowledge(request);
    }

    public final void acknowledge(AcknowledgeRequest request) {
        this.acknowledgeCallable().call((Object)request);
    }

    public final UnaryCallable<AcknowledgeRequest, Empty> acknowledgeCallable() {
        return this.acknowledgeCallable;
    }

    public final PullResponse pull(SubscriptionName subscription, boolean returnImmediately, int maxMessages) {
        PullRequest request = PullRequest.newBuilder().setSubscriptionWithSubscriptionName(subscription).setReturnImmediately(returnImmediately).setMaxMessages(maxMessages).build();
        return this.pull(request);
    }

    public final PullResponse pull(PullRequest request) {
        return (PullResponse)this.pullCallable().call((Object)request);
    }

    public final UnaryCallable<PullRequest, PullResponse> pullCallable() {
        return this.pullCallable;
    }

    public final StreamingCallable<StreamingPullRequest, StreamingPullResponse> streamingPullCallable() {
        return this.streamingPullCallable;
    }

    public final void modifyPushConfig(SubscriptionName subscription, PushConfig pushConfig) {
        ModifyPushConfigRequest request = ModifyPushConfigRequest.newBuilder().setSubscriptionWithSubscriptionName(subscription).setPushConfig(pushConfig).build();
        this.modifyPushConfig(request);
    }

    public final void modifyPushConfig(ModifyPushConfigRequest request) {
        this.modifyPushConfigCallable().call((Object)request);
    }

    public final UnaryCallable<ModifyPushConfigRequest, Empty> modifyPushConfigCallable() {
        return this.modifyPushConfigCallable;
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    private final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

