/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.AsyncPage;
import com.google.cloud.Page;
import com.google.cloud.Policy;
import com.google.cloud.pubsub.Message;
import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.cloud.pubsub.SubscriptionId;
import com.google.cloud.pubsub.TopicInfo;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;

public class Topic
extends TopicInfo {
    private static final long serialVersionUID = -2686692223763315944L;
    private final PubSubOptions options;
    private transient PubSub pubsub;

    Topic(PubSub pubsub, TopicInfo.BuilderImpl builder) {
        super(builder);
        this.pubsub = (PubSub)Preconditions.checkNotNull((Object)pubsub);
        this.options = (PubSubOptions)pubsub.getOptions();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{this.options, super.hashCode()});
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Topic.class)) {
            return false;
        }
        Topic other = (Topic)obj;
        return this.baseEquals(other) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Deprecated
    public PubSub pubSub() {
        return this.getPubsub();
    }

    public PubSub getPubsub() {
        return this.pubsub;
    }

    public boolean delete() {
        return this.pubsub.deleteTopic(this.getName());
    }

    public Future<Boolean> deleteAsync() {
        return this.pubsub.deleteTopicAsync(this.getName());
    }

    public Topic reload() {
        return this.pubsub.getTopic(this.getName());
    }

    public Future<Topic> reloadAsync() {
        return this.pubsub.getTopicAsync(this.getName());
    }

    public String publish(Message message) {
        return this.pubsub.publish(this.getName(), message);
    }

    public Future<String> publishAsync(Message message) {
        return this.pubsub.publishAsync(this.getName(), message);
    }

    public List<String> publish(Message message, Message ... messages) {
        return this.pubsub.publish(this.getName(), message, messages);
    }

    public Future<List<String>> publishAsync(Message message, Message ... messages) {
        return this.pubsub.publishAsync(this.getName(), message, messages);
    }

    public List<String> publish(Iterable<Message> messages) {
        return this.pubsub.publish(this.getName(), messages);
    }

    public Future<List<String>> publishAsync(Iterable<Message> messages) {
        return this.pubsub.publishAsync(this.getName(), messages);
    }

    public Page<SubscriptionId> listSubscriptions(PubSub.ListOption ... options) {
        return this.pubsub.listSubscriptions(this.getName(), options);
    }

    public Future<AsyncPage<SubscriptionId>> listSubscriptionsAsync(PubSub.ListOption ... options) {
        return this.pubsub.listSubscriptionsAsync(this.getName(), options);
    }

    public Policy getPolicy() {
        return this.pubsub.getTopicPolicy(this.getName());
    }

    public Future<Policy> getPolicyAsync() {
        return this.pubsub.getTopicPolicyAsync(this.getName());
    }

    public Policy replacePolicy(Policy newPolicy) {
        return this.pubsub.replaceTopicPolicy(this.getName(), newPolicy);
    }

    public Future<Policy> replacePolicyAsync(Policy newPolicy) {
        return this.pubsub.replaceTopicPolicyAsync(this.getName(), newPolicy);
    }

    public List<Boolean> testPermissions(List<String> permissions) {
        return this.pubsub.testTopicPermissions(this.getName(), permissions);
    }

    public Future<List<Boolean>> testPermissionsAsync(List<String> permissions) {
        return this.pubsub.testTopicPermissionsAsync(this.getName(), permissions);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.pubsub = (PubSub)this.options.getService();
    }

    static Topic fromPb(PubSub pubsub, com.google.pubsub.v1.Topic topicPb) {
        TopicInfo topicInfo = TopicInfo.fromPb(topicPb);
        return new Topic(pubsub, new TopicInfo.BuilderImpl(topicInfo));
    }

    static Function<com.google.pubsub.v1.Topic, Topic> fromPbFunction(final PubSub pubsub) {
        return new Function<com.google.pubsub.v1.Topic, Topic>(){

            public Topic apply(com.google.pubsub.v1.Topic topicPb) {
                return topicPb != null ? Topic.fromPb(pubsub, topicPb) : null;
            }
        };
    }

    public static final class Builder
    extends TopicInfo.Builder {
        private final PubSub pubsub;
        private final TopicInfo.BuilderImpl delegate;

        private Builder(Topic topic) {
            this.pubsub = topic.pubsub;
            this.delegate = new TopicInfo.BuilderImpl(topic);
        }

        @Override
        @Deprecated
        public Builder name(String name) {
            return this.setName(name);
        }

        @Override
        public Builder setName(String name) {
            this.delegate.setName(name);
            return this;
        }

        @Override
        public Topic build() {
            return new Topic(this.pubsub, this.delegate);
        }
    }
}

