/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.spi.v1;

import com.google.api.gax.core.PagedListResponse;
import com.google.api.gax.grpc.ApiCallable;
import com.google.api.gax.protobuf.PathTemplate;
import com.google.cloud.pubsub.spi.v1.SubscriberSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ModifyPushConfigRequest;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.PushConfig;
import com.google.pubsub.v1.Subscription;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class SubscriberApi
implements AutoCloseable {
    private final SubscriberSettings settings;
    private final ManagedChannel channel;
    private final ScheduledExecutorService executor;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final ApiCallable<Subscription, Subscription> createSubscriptionCallable;
    private final ApiCallable<GetSubscriptionRequest, Subscription> getSubscriptionCallable;
    private final ApiCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsCallable;
    private final ApiCallable<ListSubscriptionsRequest, PagedListResponse<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription>> listSubscriptionsPagedCallable;
    private final ApiCallable<DeleteSubscriptionRequest, Empty> deleteSubscriptionCallable;
    private final ApiCallable<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineCallable;
    private final ApiCallable<AcknowledgeRequest, Empty> acknowledgeCallable;
    private final ApiCallable<PullRequest, PullResponse> pullCallable;
    private final ApiCallable<ModifyPushConfigRequest, Empty> modifyPushConfigCallable;
    private final ApiCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final ApiCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final ApiCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private static final PathTemplate PROJECT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}");
    private static final PathTemplate SUBSCRIPTION_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/subscriptions/{subscription}");
    private static final PathTemplate TOPIC_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/topics/{topic}");

    public final SubscriberSettings getSettings() {
        return this.settings;
    }

    public static final String formatProjectName(String project) {
        return PROJECT_PATH_TEMPLATE.instantiate(new String[]{"project", project});
    }

    public static final String formatSubscriptionName(String project, String subscription) {
        return SUBSCRIPTION_PATH_TEMPLATE.instantiate(new String[]{"project", project, "subscription", subscription});
    }

    public static final String formatTopicName(String project, String topic) {
        return TOPIC_PATH_TEMPLATE.instantiate(new String[]{"project", project, "topic", topic});
    }

    public static final String parseProjectFromProjectName(String projectName) {
        return PROJECT_PATH_TEMPLATE.parse(projectName).get((Object)"project");
    }

    public static final String parseProjectFromSubscriptionName(String subscriptionName) {
        return SUBSCRIPTION_PATH_TEMPLATE.parse(subscriptionName).get((Object)"project");
    }

    public static final String parseSubscriptionFromSubscriptionName(String subscriptionName) {
        return SUBSCRIPTION_PATH_TEMPLATE.parse(subscriptionName).get((Object)"subscription");
    }

    public static final String parseProjectFromTopicName(String topicName) {
        return TOPIC_PATH_TEMPLATE.parse(topicName).get((Object)"project");
    }

    public static final String parseTopicFromTopicName(String topicName) {
        return TOPIC_PATH_TEMPLATE.parse(topicName).get((Object)"topic");
    }

    public static final SubscriberApi create() throws IOException {
        return SubscriberApi.create(SubscriberSettings.defaultBuilder().build());
    }

    public static final SubscriberApi create(SubscriberSettings settings) throws IOException {
        return new SubscriberApi(settings);
    }

    protected SubscriberApi(SubscriberSettings settings) throws IOException {
        this.settings = settings;
        this.executor = settings.getExecutorProvider().getOrBuildExecutor();
        this.channel = settings.getChannelProvider().getOrBuildChannel((Executor)this.executor);
        this.createSubscriptionCallable = ApiCallable.create(settings.createSubscriptionSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.getSubscriptionCallable = ApiCallable.create(settings.getSubscriptionSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listSubscriptionsCallable = ApiCallable.create(settings.listSubscriptionsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listSubscriptionsPagedCallable = ApiCallable.createPagedVariant(settings.listSubscriptionsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.deleteSubscriptionCallable = ApiCallable.create(settings.deleteSubscriptionSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.modifyAckDeadlineCallable = ApiCallable.create(settings.modifyAckDeadlineSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.acknowledgeCallable = ApiCallable.create(settings.acknowledgeSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.pullCallable = ApiCallable.create(settings.pullSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.modifyPushConfigCallable = ApiCallable.create(settings.modifyPushConfigSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.setIamPolicyCallable = ApiCallable.create(settings.setIamPolicySettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.getIamPolicyCallable = ApiCallable.create(settings.getIamPolicySettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.testIamPermissionsCallable = ApiCallable.create(settings.testIamPermissionsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    SubscriberApi.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    SubscriberApi.this.executor.shutdown();
                }
            });
        }
    }

    public final Subscription createSubscription(String name, String topic, PushConfig pushConfig, int ackDeadlineSeconds) {
        SUBSCRIPTION_PATH_TEMPLATE.validate(name, "createSubscription");
        TOPIC_PATH_TEMPLATE.validate(topic, "createSubscription");
        Subscription request = Subscription.newBuilder().setName(name).setTopic(topic).setPushConfig(pushConfig).setAckDeadlineSeconds(ackDeadlineSeconds).build();
        return this.createSubscription(request);
    }

    public final Subscription createSubscription(Subscription request) {
        return (Subscription)this.createSubscriptionCallable().call((Object)request);
    }

    public final ApiCallable<Subscription, Subscription> createSubscriptionCallable() {
        return this.createSubscriptionCallable;
    }

    public final Subscription getSubscription(String subscription) {
        SUBSCRIPTION_PATH_TEMPLATE.validate(subscription, "getSubscription");
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setSubscription(subscription).build();
        return this.getSubscription(request);
    }

    private final Subscription getSubscription(GetSubscriptionRequest request) {
        return (Subscription)this.getSubscriptionCallable().call((Object)request);
    }

    public final ApiCallable<GetSubscriptionRequest, Subscription> getSubscriptionCallable() {
        return this.getSubscriptionCallable;
    }

    public final PagedListResponse<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> listSubscriptions(String project) {
        PROJECT_PATH_TEMPLATE.validate(project, "listSubscriptions");
        ListSubscriptionsRequest request = ListSubscriptionsRequest.newBuilder().setProject(project).build();
        return this.listSubscriptions(request);
    }

    public final PagedListResponse<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> listSubscriptions(ListSubscriptionsRequest request) {
        return (PagedListResponse)this.listSubscriptionsPagedCallable().call((Object)request);
    }

    public final ApiCallable<ListSubscriptionsRequest, PagedListResponse<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription>> listSubscriptionsPagedCallable() {
        return this.listSubscriptionsPagedCallable;
    }

    public final ApiCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsCallable() {
        return this.listSubscriptionsCallable;
    }

    public final void deleteSubscription(String subscription) {
        SUBSCRIPTION_PATH_TEMPLATE.validate(subscription, "deleteSubscription");
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setSubscription(subscription).build();
        this.deleteSubscription(request);
    }

    private final void deleteSubscription(DeleteSubscriptionRequest request) {
        this.deleteSubscriptionCallable().call((Object)request);
    }

    public final ApiCallable<DeleteSubscriptionRequest, Empty> deleteSubscriptionCallable() {
        return this.deleteSubscriptionCallable;
    }

    public final void modifyAckDeadline(String subscription, List<String> ackIds, int ackDeadlineSeconds) {
        SUBSCRIPTION_PATH_TEMPLATE.validate(subscription, "modifyAckDeadline");
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setSubscription(subscription).addAllAckIds(ackIds).setAckDeadlineSeconds(ackDeadlineSeconds).build();
        this.modifyAckDeadline(request);
    }

    public final void modifyAckDeadline(ModifyAckDeadlineRequest request) {
        this.modifyAckDeadlineCallable().call((Object)request);
    }

    public final ApiCallable<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineCallable() {
        return this.modifyAckDeadlineCallable;
    }

    public final void acknowledge(String subscription, List<String> ackIds) {
        SUBSCRIPTION_PATH_TEMPLATE.validate(subscription, "acknowledge");
        AcknowledgeRequest request = AcknowledgeRequest.newBuilder().setSubscription(subscription).addAllAckIds(ackIds).build();
        this.acknowledge(request);
    }

    public final void acknowledge(AcknowledgeRequest request) {
        this.acknowledgeCallable().call((Object)request);
    }

    public final ApiCallable<AcknowledgeRequest, Empty> acknowledgeCallable() {
        return this.acknowledgeCallable;
    }

    public final PullResponse pull(String subscription, boolean returnImmediately, int maxMessages) {
        SUBSCRIPTION_PATH_TEMPLATE.validate(subscription, "pull");
        PullRequest request = PullRequest.newBuilder().setSubscription(subscription).setReturnImmediately(returnImmediately).setMaxMessages(maxMessages).build();
        return this.pull(request);
    }

    public final PullResponse pull(PullRequest request) {
        return (PullResponse)this.pullCallable().call((Object)request);
    }

    public final ApiCallable<PullRequest, PullResponse> pullCallable() {
        return this.pullCallable;
    }

    public final void modifyPushConfig(String subscription, PushConfig pushConfig) {
        SUBSCRIPTION_PATH_TEMPLATE.validate(subscription, "modifyPushConfig");
        ModifyPushConfigRequest request = ModifyPushConfigRequest.newBuilder().setSubscription(subscription).setPushConfig(pushConfig).build();
        this.modifyPushConfig(request);
    }

    public final void modifyPushConfig(ModifyPushConfigRequest request) {
        this.modifyPushConfigCallable().call((Object)request);
    }

    public final ApiCallable<ModifyPushConfigRequest, Empty> modifyPushConfigCallable() {
        return this.modifyPushConfigCallable;
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SUBSCRIPTION_PATH_TEMPLATE.validate(resource, "setIamPolicy");
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final ApiCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    public final Policy getIamPolicy(String resource) {
        SUBSCRIPTION_PATH_TEMPLATE.validate(resource, "getIamPolicy");
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    private final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final ApiCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        SUBSCRIPTION_PATH_TEMPLATE.validate(resource, "testIamPermissions");
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final ApiCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

