/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.spi.v1;

import com.google.api.gax.core.ConnectionSettings;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.ApiCallSettings;
import com.google.api.gax.grpc.BundlingCallSettings;
import com.google.api.gax.grpc.BundlingDescriptor;
import com.google.api.gax.grpc.BundlingSettings;
import com.google.api.gax.grpc.PageStreamingCallSettings;
import com.google.api.gax.grpc.PageStreamingDescriptor;
import com.google.api.gax.grpc.RequestIssuer;
import com.google.api.gax.grpc.ServiceApiSettings;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.IAMPolicyGrpc;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PublisherGrpc;
import com.google.pubsub.v1.Topic;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.Duration;

public class PublisherSettings
extends ServiceApiSettings {
    private static final String DEFAULT_SERVICE_ADDRESS = "pubsub.googleapis.com";
    private static final int DEFAULT_SERVICE_PORT = 443;
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/pubsub").build();
    public static final ConnectionSettings DEFAULT_CONNECTION_SETTINGS = ConnectionSettings.newBuilder().setServiceAddress("pubsub.googleapis.com").setPort(443).provideCredentialsWith(DEFAULT_SERVICE_SCOPES).build();
    private final SimpleCallSettings<Topic, Topic> createTopicSettings;
    private final BundlingCallSettings<PublishRequest, PublishResponse> publishSettings;
    private final SimpleCallSettings<GetTopicRequest, Topic> getTopicSettings;
    private final PageStreamingCallSettings<ListTopicsRequest, ListTopicsResponse, Topic> listTopicsSettings;
    private final PageStreamingCallSettings<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> listTopicSubscriptionsSettings;
    private final SimpleCallSettings<DeleteTopicRequest, Empty> deleteTopicSettings;
    private final SimpleCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final SimpleCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final SimpleCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static PageStreamingDescriptor<ListTopicsRequest, ListTopicsResponse, Topic> LIST_TOPICS_PAGE_STR_DESC = new PageStreamingDescriptor<ListTopicsRequest, ListTopicsResponse, Topic>(){

        public Object emptyToken() {
            return "";
        }

        public ListTopicsRequest injectToken(ListTopicsRequest payload, Object token) {
            return ListTopicsRequest.newBuilder((ListTopicsRequest)payload).setPageToken((String)token).build();
        }

        public ListTopicsRequest injectPageSize(ListTopicsRequest payload, int pageSize) {
            return ListTopicsRequest.newBuilder((ListTopicsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTopicsRequest payload) {
            return payload.getPageSize();
        }

        public Object extractNextToken(ListTopicsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Topic> extractResources(ListTopicsResponse payload) {
            return payload.getTopicsList();
        }
    };
    private static PageStreamingDescriptor<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_DESC = new PageStreamingDescriptor<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String>(){

        public Object emptyToken() {
            return "";
        }

        public ListTopicSubscriptionsRequest injectToken(ListTopicSubscriptionsRequest payload, Object token) {
            return ListTopicSubscriptionsRequest.newBuilder((ListTopicSubscriptionsRequest)payload).setPageToken((String)token).build();
        }

        public ListTopicSubscriptionsRequest injectPageSize(ListTopicSubscriptionsRequest payload, int pageSize) {
            return ListTopicSubscriptionsRequest.newBuilder((ListTopicSubscriptionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTopicSubscriptionsRequest payload) {
            return payload.getPageSize();
        }

        public Object extractNextToken(ListTopicSubscriptionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<String> extractResources(ListTopicSubscriptionsResponse payload) {
            return payload.getSubscriptionsList();
        }
    };
    private static BundlingDescriptor<PublishRequest, PublishResponse> PUBLISH_BUNDLING_DESC = new BundlingDescriptor<PublishRequest, PublishResponse>(){

        public String getBundlePartitionKey(PublishRequest request) {
            return request.getTopic() + "|";
        }

        public PublishRequest mergeRequests(Collection<PublishRequest> requests) {
            PublishRequest firstRequest = requests.iterator().next();
            ArrayList elements = new ArrayList();
            for (PublishRequest request : requests) {
                elements.addAll(request.getMessagesList());
            }
            PublishRequest bundleRequest = PublishRequest.newBuilder().setTopic(firstRequest.getTopic()).addAllMessages(elements).build();
            return bundleRequest;
        }

        public void splitResponse(PublishResponse bundleResponse, Collection<? extends RequestIssuer<PublishRequest, PublishResponse>> bundle) {
            int bundleMessageIndex = 0;
            for (RequestIssuer<PublishRequest, PublishResponse> requestIssuer : bundle) {
                ArrayList<String> subresponseElements = new ArrayList<String>();
                int subresponseCount = ((PublishRequest)requestIssuer.getRequest()).getMessagesCount();
                for (int i = 0; i < subresponseCount; ++i) {
                    subresponseElements.add(bundleResponse.getMessageIds(bundleMessageIndex));
                    ++bundleMessageIndex;
                }
                PublishResponse response = PublishResponse.newBuilder().addAllMessageIds(subresponseElements).build();
                requestIssuer.setResponse((Object)response);
            }
        }

        public void splitException(Throwable throwable, Collection<? extends RequestIssuer<PublishRequest, PublishResponse>> bundle) {
            for (RequestIssuer<PublishRequest, PublishResponse> requestIssuer : bundle) {
                requestIssuer.setException(throwable);
            }
        }

        public long countElements(PublishRequest request) {
            return request.getMessagesCount();
        }

        public long countBytes(PublishRequest request) {
            return request.getSerializedSize();
        }
    };

    public SimpleCallSettings<Topic, Topic> createTopicSettings() {
        return this.createTopicSettings;
    }

    public BundlingCallSettings<PublishRequest, PublishResponse> publishSettings() {
        return this.publishSettings;
    }

    public SimpleCallSettings<GetTopicRequest, Topic> getTopicSettings() {
        return this.getTopicSettings;
    }

    public PageStreamingCallSettings<ListTopicsRequest, ListTopicsResponse, Topic> listTopicsSettings() {
        return this.listTopicsSettings;
    }

    public PageStreamingCallSettings<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> listTopicSubscriptionsSettings() {
        return this.listTopicSubscriptionsSettings;
    }

    public SimpleCallSettings<DeleteTopicRequest, Empty> deleteTopicSettings() {
        return this.deleteTopicSettings;
    }

    public SimpleCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public SimpleCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public SimpleCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public static String getDefaultServiceAddress() {
        return DEFAULT_SERVICE_ADDRESS;
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static ImmutableList<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private PublisherSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getChannelProvider(), settingsBuilder.getExecutorProvider(), settingsBuilder.getGeneratorName(), settingsBuilder.getGeneratorVersion(), settingsBuilder.getClientLibName(), settingsBuilder.getClientLibVersion());
        this.createTopicSettings = settingsBuilder.createTopicSettings().build();
        this.publishSettings = settingsBuilder.publishSettings().build();
        this.getTopicSettings = settingsBuilder.getTopicSettings().build();
        this.listTopicsSettings = settingsBuilder.listTopicsSettings().build();
        this.listTopicSubscriptionsSettings = settingsBuilder.listTopicSubscriptionsSettings().build();
        this.deleteTopicSettings = settingsBuilder.deleteTopicSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends ServiceApiSettings.Builder {
        private final ImmutableList<ApiCallSettings.Builder> methodSettingsBuilders;
        private SimpleCallSettings.Builder<Topic, Topic> createTopicSettings;
        private BundlingCallSettings.Builder<PublishRequest, PublishResponse> publishSettings;
        private SimpleCallSettings.Builder<GetTopicRequest, Topic> getTopicSettings;
        private PageStreamingCallSettings.Builder<ListTopicsRequest, ListTopicsResponse, Topic> listTopicsSettings;
        private PageStreamingCallSettings.Builder<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> listTopicSubscriptionsSettings;
        private SimpleCallSettings.Builder<DeleteTopicRequest, Empty> deleteTopicSettings;
        private SimpleCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private SimpleCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private SimpleCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(DEFAULT_CONNECTION_SETTINGS);
            this.createTopicSettings = SimpleCallSettings.newBuilder((MethodDescriptor)PublisherGrpc.METHOD_CREATE_TOPIC);
            this.publishSettings = BundlingCallSettings.newBuilder((MethodDescriptor)PublisherGrpc.METHOD_PUBLISH, (BundlingDescriptor)PUBLISH_BUNDLING_DESC).setBundlingSettingsBuilder(BundlingSettings.newBuilder());
            this.getTopicSettings = SimpleCallSettings.newBuilder((MethodDescriptor)PublisherGrpc.METHOD_GET_TOPIC);
            this.listTopicsSettings = PageStreamingCallSettings.newBuilder((MethodDescriptor)PublisherGrpc.METHOD_LIST_TOPICS, (PageStreamingDescriptor)LIST_TOPICS_PAGE_STR_DESC);
            this.listTopicSubscriptionsSettings = PageStreamingCallSettings.newBuilder((MethodDescriptor)PublisherGrpc.METHOD_LIST_TOPIC_SUBSCRIPTIONS, (PageStreamingDescriptor)LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_DESC);
            this.deleteTopicSettings = SimpleCallSettings.newBuilder((MethodDescriptor)PublisherGrpc.METHOD_DELETE_TOPIC);
            this.setIamPolicySettings = SimpleCallSettings.newBuilder((MethodDescriptor)IAMPolicyGrpc.METHOD_SET_IAM_POLICY);
            this.getIamPolicySettings = SimpleCallSettings.newBuilder((MethodDescriptor)IAMPolicyGrpc.METHOD_GET_IAM_POLICY);
            this.testIamPermissionsSettings = SimpleCallSettings.newBuilder((MethodDescriptor)IAMPolicyGrpc.METHOD_TEST_IAM_PERMISSIONS);
            this.methodSettingsBuilders = ImmutableList.of(this.createTopicSettings, this.publishSettings, this.getTopicSettings, this.listTopicsSettings, this.listTopicSubscriptionsSettings, this.deleteTopicSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.createTopicSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.publishSettings().getBundlingSettingsBuilder().setElementCountThreshold(Integer.valueOf(10)).setElementCountLimit(Integer.valueOf(1000)).setRequestByteThreshold(Integer.valueOf(1024)).setRequestByteLimit(Integer.valueOf(0xA00000)).setDelayThreshold(Duration.millis((long)10L)).setBlockingCallCountThreshold(Integer.valueOf(1));
            builder.publishSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"one_plus_delivery")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"messaging"));
            builder.getTopicSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTopicsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTopicSubscriptionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteTopicSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(PublisherSettings settings) {
            super((ServiceApiSettings)settings);
            this.createTopicSettings = settings.createTopicSettings.toBuilder();
            this.publishSettings = settings.publishSettings.toBuilder();
            this.getTopicSettings = settings.getTopicSettings.toBuilder();
            this.listTopicsSettings = settings.listTopicsSettings.toBuilder();
            this.listTopicSubscriptionsSettings = settings.listTopicSubscriptionsSettings.toBuilder();
            this.deleteTopicSettings = settings.deleteTopicSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.methodSettingsBuilders = ImmutableList.of(this.createTopicSettings, this.publishSettings, this.getTopicSettings, this.listTopicsSettings, this.listTopicSubscriptionsSettings, this.deleteTopicSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        protected ConnectionSettings getDefaultConnectionSettings() {
            return DEFAULT_CONNECTION_SETTINGS;
        }

        public Builder provideExecutorWith(ScheduledExecutorService executor, boolean shouldAutoClose) {
            super.provideExecutorWith(executor, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ManagedChannel channel, boolean shouldAutoClose) {
            super.provideChannelWith(channel, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ConnectionSettings settings) {
            super.provideChannelWith(settings);
            return this;
        }

        public Builder provideChannelWith(Credentials credentials) {
            super.provideChannelWith(credentials);
            return this;
        }

        public Builder provideChannelWith(List<String> scopes) {
            super.provideChannelWith(scopes);
            return this;
        }

        public Builder setGeneratorHeader(String name, String version) {
            super.setGeneratorHeader(name, version);
            return this;
        }

        public Builder setClientLibHeader(String name, String version) {
            super.setClientLibHeader(name, version);
            return this;
        }

        public Builder applyToAllApiMethods(ApiCallSettings.Builder apiCallSettings) throws Exception {
            super.applyToAllApiMethods(this.methodSettingsBuilders, apiCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<Topic, Topic> createTopicSettings() {
            return this.createTopicSettings;
        }

        public BundlingCallSettings.Builder<PublishRequest, PublishResponse> publishSettings() {
            return this.publishSettings;
        }

        public SimpleCallSettings.Builder<GetTopicRequest, Topic> getTopicSettings() {
            return this.getTopicSettings;
        }

        public PageStreamingCallSettings.Builder<ListTopicsRequest, ListTopicsResponse, Topic> listTopicsSettings() {
            return this.listTopicsSettings;
        }

        public PageStreamingCallSettings.Builder<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> listTopicSubscriptionsSettings() {
            return this.listTopicSubscriptionsSettings;
        }

        public SimpleCallSettings.Builder<DeleteTopicRequest, Empty> deleteTopicSettings() {
            return this.deleteTopicSettings;
        }

        public SimpleCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public SimpleCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public SimpleCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public PublisherSettings build() throws IOException {
            return new PublisherSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"one_plus_delivery", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.millis((long)60000L)).setInitialRpcTimeout(Duration.millis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.millis((long)60000L)).setTotalTimeout(Duration.millis((long)600000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.millis((long)60000L)).setInitialRpcTimeout(Duration.millis((long)12000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.millis((long)12000L)).setTotalTimeout(Duration.millis((long)600000L));
            definitions.put((Object)"messaging", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

