/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.Policy;
import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.cloud.pubsub.PushConfig;
import com.google.cloud.pubsub.ReceivedMessage;
import com.google.cloud.pubsub.SubscriptionInfo;
import com.google.cloud.pubsub.TopicId;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;

public class Subscription
extends SubscriptionInfo {
    private static final long serialVersionUID = -4153366055659552230L;
    private final PubSubOptions options;
    private transient PubSub pubsub;

    Subscription(PubSub pubsub, SubscriptionInfo.BuilderImpl builder) {
        super(builder);
        this.pubsub = (PubSub)Preconditions.checkNotNull((Object)pubsub);
        this.options = (PubSubOptions)pubsub.options();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{this.options, super.hashCode()});
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Subscription.class)) {
            return false;
        }
        Subscription other = (Subscription)obj;
        return this.baseEquals(other) && Objects.equals((Object)this.options, (Object)other.options);
    }

    public PubSub pubSub() {
        return this.pubsub;
    }

    public boolean delete() {
        return this.pubsub.deleteSubscription(this.name());
    }

    public Future<Boolean> deleteAsync() {
        return this.pubsub.deleteSubscriptionAsync(this.name());
    }

    public Subscription reload() {
        return this.pubsub.getSubscription(this.name());
    }

    public Future<Subscription> reloadAsync() {
        return this.pubsub.getSubscriptionAsync(this.name());
    }

    public void replacePushConfig(PushConfig pushConfig) {
        this.pubsub.replacePushConfig(this.name(), pushConfig);
    }

    public Future<Void> replacePushConfigAsync(PushConfig pushConfig) {
        return this.pubsub.replacePushConfigAsync(this.name(), pushConfig);
    }

    public Iterator<ReceivedMessage> pull(int maxMessages) {
        return this.pubsub.pull(this.name(), maxMessages);
    }

    public Future<Iterator<ReceivedMessage>> pullAsync(int maxMessages) {
        return this.pubsub.pullAsync(this.name(), maxMessages);
    }

    public PubSub.MessageConsumer pullAsync(PubSub.MessageProcessor callback, PubSub.PullOption ... options) {
        return this.pubsub.pullAsync(this.name(), callback, options);
    }

    public Policy getPolicy() {
        return this.pubsub.getSubscriptionPolicy(this.name());
    }

    public Future<Policy> getPolicyAsync() {
        return this.pubsub.getSubscriptionPolicyAsync(this.name());
    }

    public Policy replacePolicy(Policy newPolicy) {
        return this.pubsub.replaceSubscriptionPolicy(this.name(), newPolicy);
    }

    public Future<Policy> replacePolicyAsync(Policy newPolicy) {
        return this.pubsub.replaceSubscriptionPolicyAsync(this.name(), newPolicy);
    }

    public List<Boolean> testPermissions(List<String> permissions) {
        return this.pubsub.testSubscriptionPermissions(this.name(), permissions);
    }

    public Future<List<Boolean>> testPermissionsAsync(List<String> permissions) {
        return this.pubsub.testSubscriptionPermissionsAsync(this.name(), permissions);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.pubsub = (PubSub)this.options.service();
    }

    static Subscription fromPb(PubSub storage, com.google.pubsub.v1.Subscription subscriptionPb) {
        SubscriptionInfo subscriptionInfo = SubscriptionInfo.fromPb(subscriptionPb);
        return new Subscription(storage, new SubscriptionInfo.BuilderImpl(subscriptionInfo));
    }

    static Function<com.google.pubsub.v1.Subscription, Subscription> fromPbFunction(final PubSub pubsub) {
        return new Function<com.google.pubsub.v1.Subscription, Subscription>(){

            public Subscription apply(com.google.pubsub.v1.Subscription subscriptionPb) {
                return subscriptionPb != null ? Subscription.fromPb(pubsub, subscriptionPb) : null;
            }
        };
    }

    public static final class Builder
    extends SubscriptionInfo.Builder {
        private final PubSub pubsub;
        private final SubscriptionInfo.BuilderImpl delegate;

        private Builder(Subscription subscription) {
            this.pubsub = subscription.pubsub;
            this.delegate = new SubscriptionInfo.BuilderImpl(subscription);
        }

        @Override
        public Builder topic(TopicId topic) {
            this.delegate.topic(topic);
            return this;
        }

        @Override
        public Builder topic(String project, String topic) {
            this.delegate.topic(project, topic);
            return this;
        }

        @Override
        public Builder topic(String topic) {
            this.delegate.topic(topic);
            return this;
        }

        @Override
        public Builder name(String name) {
            this.delegate.name(name);
            return this;
        }

        @Override
        public Builder pushConfig(PushConfig pushConfig) {
            this.delegate.pushConfig(pushConfig);
            return this;
        }

        @Override
        public Builder ackDeadLineSeconds(int ackDeadLineSeconds) {
            this.delegate.ackDeadLineSeconds(ackDeadLineSeconds);
            return this;
        }

        @Override
        public Subscription build() {
            return new Subscription(this.pubsub, this.delegate);
        }
    }
}

