/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.batching.PartitionKey;
import com.google.api.gax.batching.RequestBuilder;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.BatchedRequestIssuer;
import com.google.api.gax.rpc.BatchingCallSettings;
import com.google.api.gax.rpc.BatchingDescriptor;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsub.v1.PagedResponseWrappers;
import com.google.cloud.pubsub.v1.stub.GrpcPublisherStub;
import com.google.cloud.pubsub.v1.stub.PublisherStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.UpdateTopicRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class TopicAdminSettings
extends ClientSettings<TopicAdminSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/pubsub").build();
    private final UnaryCallSettings<Topic, Topic> createTopicSettings;
    private final UnaryCallSettings<UpdateTopicRequest, Topic> updateTopicSettings;
    private final BatchingCallSettings<PublishRequest, PublishResponse> publishSettings;
    private final UnaryCallSettings<GetTopicRequest, Topic> getTopicSettings;
    private final PagedCallSettings<ListTopicsRequest, ListTopicsResponse, PagedResponseWrappers.ListTopicsPagedResponse> listTopicsSettings;
    private final PagedCallSettings<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, PagedResponseWrappers.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsSettings;
    private final UnaryCallSettings<DeleteTopicRequest, Empty> deleteTopicSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListTopicsRequest, ListTopicsResponse, Topic> LIST_TOPICS_PAGE_STR_DESC = new PagedListDescriptor<ListTopicsRequest, ListTopicsResponse, Topic>(){

        public String emptyToken() {
            return "";
        }

        public ListTopicsRequest injectToken(ListTopicsRequest payload, String token) {
            return ListTopicsRequest.newBuilder((ListTopicsRequest)payload).setPageToken(token).build();
        }

        public ListTopicsRequest injectPageSize(ListTopicsRequest payload, int pageSize) {
            return ListTopicsRequest.newBuilder((ListTopicsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTopicsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTopicsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Topic> extractResources(ListTopicsResponse payload) {
            return payload.getTopicsList();
        }
    };
    private static final PagedListDescriptor<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String>(){

        public String emptyToken() {
            return "";
        }

        public ListTopicSubscriptionsRequest injectToken(ListTopicSubscriptionsRequest payload, String token) {
            return ListTopicSubscriptionsRequest.newBuilder((ListTopicSubscriptionsRequest)payload).setPageToken(token).build();
        }

        public ListTopicSubscriptionsRequest injectPageSize(ListTopicSubscriptionsRequest payload, int pageSize) {
            return ListTopicSubscriptionsRequest.newBuilder((ListTopicSubscriptionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTopicSubscriptionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTopicSubscriptionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<String> extractResources(ListTopicSubscriptionsResponse payload) {
            return payload.getSubscriptionsList();
        }
    };
    private static final PagedListResponseFactory<ListTopicsRequest, ListTopicsResponse, PagedResponseWrappers.ListTopicsPagedResponse> LIST_TOPICS_PAGE_STR_FACT = new PagedListResponseFactory<ListTopicsRequest, ListTopicsResponse, PagedResponseWrappers.ListTopicsPagedResponse>(){

        public ApiFuture<PagedResponseWrappers.ListTopicsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTopicsRequest, ListTopicsResponse> callable, ListTopicsRequest request, ApiCallContext context, ApiFuture<ListTopicsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TOPICS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PagedResponseWrappers.ListTopicsPagedResponse.createAsync((PageContext<ListTopicsRequest, ListTopicsResponse, Topic>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, PagedResponseWrappers.ListTopicSubscriptionsPagedResponse> LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, PagedResponseWrappers.ListTopicSubscriptionsPagedResponse>(){

        public ApiFuture<PagedResponseWrappers.ListTopicSubscriptionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> callable, ListTopicSubscriptionsRequest request, ApiCallContext context, ApiFuture<ListTopicSubscriptionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PagedResponseWrappers.ListTopicSubscriptionsPagedResponse.createAsync((PageContext<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String>)pageContext, futureResponse);
        }
    };
    private static final BatchingDescriptor<PublishRequest, PublishResponse> PUBLISH_BATCHING_DESC = new BatchingDescriptor<PublishRequest, PublishResponse>(){

        public PartitionKey getBatchPartitionKey(PublishRequest request) {
            return new PartitionKey(new Object[]{request.getTopic()});
        }

        public RequestBuilder<PublishRequest> getRequestBuilder() {
            return new RequestBuilder<PublishRequest>(){
                private PublishRequest.Builder builder;

                public void appendRequest(PublishRequest request) {
                    if (this.builder == null) {
                        this.builder = request.toBuilder();
                    } else {
                        this.builder.addAllMessages((Iterable)request.getMessagesList());
                    }
                }

                public PublishRequest build() {
                    return this.builder.build();
                }
            };
        }

        public void splitResponse(PublishResponse batchResponse, Collection<? extends BatchedRequestIssuer<PublishResponse>> batch) {
            int batchMessageIndex = 0;
            for (BatchedRequestIssuer<PublishResponse> batchedRequestIssuer : batch) {
                ArrayList<String> subresponseElements = new ArrayList<String>();
                long subresponseCount = batchedRequestIssuer.getMessageCount();
                int i = 0;
                while ((long)i < subresponseCount) {
                    subresponseElements.add(batchResponse.getMessageIds(batchMessageIndex));
                    ++batchMessageIndex;
                    ++i;
                }
                PublishResponse response = PublishResponse.newBuilder().addAllMessageIds(subresponseElements).build();
                batchedRequestIssuer.setResponse((Object)response);
            }
        }

        public void splitException(Throwable throwable, Collection<? extends BatchedRequestIssuer<PublishResponse>> batch) {
            for (BatchedRequestIssuer<PublishResponse> batchedRequestIssuer : batch) {
                batchedRequestIssuer.setException(throwable);
            }
        }

        public long countElements(PublishRequest request) {
            return request.getMessagesCount();
        }

        public long countBytes(PublishRequest request) {
            return request.getSerializedSize();
        }
    };

    public UnaryCallSettings<Topic, Topic> createTopicSettings() {
        return this.createTopicSettings;
    }

    public UnaryCallSettings<UpdateTopicRequest, Topic> updateTopicSettings() {
        return this.updateTopicSettings;
    }

    public BatchingCallSettings<PublishRequest, PublishResponse> publishSettings() {
        return this.publishSettings;
    }

    public UnaryCallSettings<GetTopicRequest, Topic> getTopicSettings() {
        return this.getTopicSettings;
    }

    public PagedCallSettings<ListTopicsRequest, ListTopicsResponse, PagedResponseWrappers.ListTopicsPagedResponse> listTopicsSettings() {
        return this.listTopicsSettings;
    }

    public PagedCallSettings<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, PagedResponseWrappers.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsSettings() {
        return this.listTopicSubscriptionsSettings;
    }

    public UnaryCallSettings<DeleteTopicRequest, Empty> deleteTopicSettings() {
        return this.deleteTopicSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public PublisherStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcPublisherStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "pubsub.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TopicAdminSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TopicAdminSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TopicAdminSettings(Builder settingsBuilder) throws IOException {
        super((ClientSettings.Builder)settingsBuilder);
        this.createTopicSettings = settingsBuilder.createTopicSettings().build();
        this.updateTopicSettings = settingsBuilder.updateTopicSettings().build();
        this.publishSettings = settingsBuilder.publishSettings().build();
        this.getTopicSettings = settingsBuilder.getTopicSettings().build();
        this.listTopicsSettings = settingsBuilder.listTopicsSettings().build();
        this.listTopicSubscriptionsSettings = settingsBuilder.listTopicSubscriptionsSettings().build();
        this.deleteTopicSettings = settingsBuilder.deleteTopicSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends ClientSettings.Builder<TopicAdminSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<Topic, Topic> createTopicSettings;
        private final UnaryCallSettings.Builder<UpdateTopicRequest, Topic> updateTopicSettings;
        private final BatchingCallSettings.Builder<PublishRequest, PublishResponse> publishSettings;
        private final UnaryCallSettings.Builder<GetTopicRequest, Topic> getTopicSettings;
        private final PagedCallSettings.Builder<ListTopicsRequest, ListTopicsResponse, PagedResponseWrappers.ListTopicsPagedResponse> listTopicsSettings;
        private final PagedCallSettings.Builder<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, PagedResponseWrappers.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsSettings;
        private final UnaryCallSettings.Builder<DeleteTopicRequest, Empty> deleteTopicSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createTopicSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTopicSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.publishSettings = BatchingCallSettings.newBuilder((BatchingDescriptor)PUBLISH_BATCHING_DESC).setBatchingSettings(BatchingSettings.newBuilder().build());
            this.getTopicSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTopicsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TOPICS_PAGE_STR_FACT);
            this.listTopicSubscriptionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_FACT);
            this.deleteTopicSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTopicSettings, this.updateTopicSettings, this.publishSettings, this.getTopicSettings, this.listTopicsSettings, this.listTopicSubscriptionsSettings, this.deleteTopicSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TopicAdminSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TopicAdminSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TopicAdminSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TopicAdminSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createTopicSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateTopicSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.publishSettings().setBatchingSettings(BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(10L)).setRequestByteThreshold(Long.valueOf(1024L)).setDelayThreshold(Duration.ofMillis((long)10L)).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Ignore).build()).build());
            builder.publishSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"one_plus_delivery")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"messaging"));
            builder.getTopicSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTopicsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTopicSubscriptionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteTopicSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(TopicAdminSettings settings) {
            super((ClientSettings)settings);
            this.createTopicSettings = settings.createTopicSettings.toBuilder();
            this.updateTopicSettings = settings.updateTopicSettings.toBuilder();
            this.publishSettings = settings.publishSettings.toBuilder();
            this.getTopicSettings = settings.getTopicSettings.toBuilder();
            this.listTopicsSettings = settings.listTopicsSettings.toBuilder();
            this.listTopicSubscriptionsSettings = settings.listTopicSubscriptionsSettings.toBuilder();
            this.deleteTopicSettings = settings.deleteTopicSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTopicSettings, this.updateTopicSettings, this.publishSettings, this.getTopicSettings, this.listTopicsSettings, this.listTopicSubscriptionsSettings, this.deleteTopicSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            ClientSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public UnaryCallSettings.Builder<Topic, Topic> createTopicSettings() {
            return this.createTopicSettings;
        }

        public UnaryCallSettings.Builder<UpdateTopicRequest, Topic> updateTopicSettings() {
            return this.updateTopicSettings;
        }

        public BatchingCallSettings.Builder<PublishRequest, PublishResponse> publishSettings() {
            return this.publishSettings;
        }

        public UnaryCallSettings.Builder<GetTopicRequest, Topic> getTopicSettings() {
            return this.getTopicSettings;
        }

        public PagedCallSettings.Builder<ListTopicsRequest, ListTopicsResponse, PagedResponseWrappers.ListTopicsPagedResponse> listTopicsSettings() {
            return this.listTopicsSettings;
        }

        public PagedCallSettings.Builder<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, PagedResponseWrappers.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsSettings() {
            return this.listTopicSubscriptionsSettings;
        }

        public UnaryCallSettings.Builder<DeleteTopicRequest, Empty> deleteTopicSettings() {
            return this.deleteTopicSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public TopicAdminSettings build() throws IOException {
            return new TopicAdminSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"one_plus_delivery", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.CANCELLED, StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.INTERNAL, StatusCode.Code.RESOURCE_EXHAUSTED, StatusCode.Code.UNAVAILABLE, StatusCode.Code.UNKNOWN})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)12000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"messaging", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

