/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.deprecated;

import com.google.cloud.GrpcTransportOptions;
import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceOptions;
import com.google.cloud.TransportOptions;
import com.google.cloud.pubsub.deprecated.PubSub;
import com.google.cloud.pubsub.deprecated.PubSubException;
import com.google.cloud.pubsub.deprecated.PubSubFactory;
import com.google.cloud.pubsub.deprecated.PubSubImpl;
import com.google.cloud.pubsub.deprecated.spi.DefaultPubSubRpc;
import com.google.cloud.pubsub.deprecated.spi.PubSubRpc;
import com.google.cloud.pubsub.deprecated.spi.PubSubRpcFactory;
import com.google.cloud.pubsub.spi.v1.PublisherSettings;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;

public class PubSubOptions
extends ServiceOptions<PubSub, PubSubRpc, PubSubOptions> {
    private static final long serialVersionUID = 5598666986447361352L;
    private static final String API_SHORT_NAME = "PubSub";
    private static final String PUBSUB_SCOPE = "https://www.googleapis.com/auth/pubsub";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/pubsub");
    private static final String EMULATOR_HOST_ENV_VAR = "PUBSUB_EMULATOR_HOST";
    private static final String DEFAULT_HOST = PublisherSettings.getDefaultServiceAddress() + ':' + PublisherSettings.getDefaultServicePort();

    @Deprecated
    public static PubSubOptions defaultInstance() {
        return PubSubOptions.getDefaultInstance();
    }

    public static PubSubOptions getDefaultInstance() {
        return PubSubOptions.newBuilder().build();
    }

    protected String getDefaultHost() {
        String host = System.getProperty(EMULATOR_HOST_ENV_VAR, System.getenv(EMULATOR_HOST_ENV_VAR));
        return host != null ? host : DEFAULT_HOST;
    }

    protected PubSubOptions(Builder builder) {
        super(PubSubFactory.class, PubSubRpcFactory.class, (ServiceOptions.Builder)builder, (ServiceDefaults)new PubSubDefaults());
    }

    public static GrpcTransportOptions getDefaultGrpcTransportOptions() {
        return GrpcTransportOptions.newBuilder().build();
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    public boolean equals(Object obj) {
        return obj instanceof PubSubOptions && this.baseEquals((PubSubOptions)((Object)obj));
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static class PubSubDefaults
    implements ServiceDefaults<PubSub, PubSubRpc, PubSubOptions> {
        private PubSubDefaults() {
        }

        public PubSubFactory getDefaultServiceFactory() {
            return DefaultPubSubFactory.INSTANCE;
        }

        public PubSubRpcFactory getDefaultRpcFactory() {
            return DefaultPubSubRpcFactory.INSTANCE;
        }

        public TransportOptions getDefaultTransportOptions() {
            return PubSubOptions.getDefaultGrpcTransportOptions();
        }
    }

    public static class Builder
    extends ServiceOptions.Builder<PubSub, PubSubRpc, PubSubOptions, Builder> {
        private Builder() {
        }

        private Builder(PubSubOptions options) {
            super((ServiceOptions)options);
        }

        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof GrpcTransportOptions)) {
                throw new IllegalArgumentException("Only grpc transport is allowed for PubSub.");
            }
            return (Builder)super.setTransportOptions(transportOptions);
        }

        public PubSubOptions build() {
            return new PubSubOptions(this);
        }
    }

    public static class DefaultPubSubRpcFactory
    implements PubSubRpcFactory {
        private static final PubSubRpcFactory INSTANCE = new DefaultPubSubRpcFactory();

        public PubSubRpc create(PubSubOptions options) {
            try {
                return new DefaultPubSubRpc(options);
            }
            catch (IOException e) {
                throw new PubSubException(e, true);
            }
        }
    }

    public static class DefaultPubSubFactory
    implements PubSubFactory {
        private static final PubSubFactory INSTANCE = new DefaultPubSubFactory();

        public PubSub create(PubSubOptions options) {
            return new PubSubImpl(options);
        }
    }
}

