/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oslogin.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.oslogin.common.OsLoginProto;
import com.google.cloud.oslogin.v1.CreateSshPublicKeyRequest;
import com.google.cloud.oslogin.v1.DeletePosixAccountRequest;
import com.google.cloud.oslogin.v1.DeleteSshPublicKeyRequest;
import com.google.cloud.oslogin.v1.GetLoginProfileRequest;
import com.google.cloud.oslogin.v1.GetSshPublicKeyRequest;
import com.google.cloud.oslogin.v1.ImportSshPublicKeyRequest;
import com.google.cloud.oslogin.v1.ImportSshPublicKeyResponse;
import com.google.cloud.oslogin.v1.LoginProfile;
import com.google.cloud.oslogin.v1.UpdateSshPublicKeyRequest;
import com.google.cloud.oslogin.v1.stub.GrpcOsLoginServiceStub;
import com.google.cloud.oslogin.v1.stub.HttpJsonOsLoginServiceStub;
import com.google.cloud.oslogin.v1.stub.OsLoginServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class OsLoginServiceStubSettings
extends StubSettings<OsLoginServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").build();
    private final UnaryCallSettings<CreateSshPublicKeyRequest, OsLoginProto.SshPublicKey> createSshPublicKeySettings;
    private final UnaryCallSettings<DeletePosixAccountRequest, Empty> deletePosixAccountSettings;
    private final UnaryCallSettings<DeleteSshPublicKeyRequest, Empty> deleteSshPublicKeySettings;
    private final UnaryCallSettings<GetLoginProfileRequest, LoginProfile> getLoginProfileSettings;
    private final UnaryCallSettings<GetSshPublicKeyRequest, OsLoginProto.SshPublicKey> getSshPublicKeySettings;
    private final UnaryCallSettings<ImportSshPublicKeyRequest, ImportSshPublicKeyResponse> importSshPublicKeySettings;
    private final UnaryCallSettings<UpdateSshPublicKeyRequest, OsLoginProto.SshPublicKey> updateSshPublicKeySettings;

    public UnaryCallSettings<CreateSshPublicKeyRequest, OsLoginProto.SshPublicKey> createSshPublicKeySettings() {
        return this.createSshPublicKeySettings;
    }

    public UnaryCallSettings<DeletePosixAccountRequest, Empty> deletePosixAccountSettings() {
        return this.deletePosixAccountSettings;
    }

    public UnaryCallSettings<DeleteSshPublicKeyRequest, Empty> deleteSshPublicKeySettings() {
        return this.deleteSshPublicKeySettings;
    }

    public UnaryCallSettings<GetLoginProfileRequest, LoginProfile> getLoginProfileSettings() {
        return this.getLoginProfileSettings;
    }

    public UnaryCallSettings<GetSshPublicKeyRequest, OsLoginProto.SshPublicKey> getSshPublicKeySettings() {
        return this.getSshPublicKeySettings;
    }

    public UnaryCallSettings<ImportSshPublicKeyRequest, ImportSshPublicKeyResponse> importSshPublicKeySettings() {
        return this.importSshPublicKeySettings;
    }

    public UnaryCallSettings<UpdateSshPublicKeyRequest, OsLoginProto.SshPublicKey> updateSshPublicKeySettings() {
        return this.updateSshPublicKeySettings;
    }

    public OsLoginServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcOsLoginServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonOsLoginServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "oslogin";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "oslogin.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "oslogin.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return OsLoginServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(OsLoginServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(OsLoginServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return OsLoginServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected OsLoginServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createSshPublicKeySettings = settingsBuilder.createSshPublicKeySettings().build();
        this.deletePosixAccountSettings = settingsBuilder.deletePosixAccountSettings().build();
        this.deleteSshPublicKeySettings = settingsBuilder.deleteSshPublicKeySettings().build();
        this.getLoginProfileSettings = settingsBuilder.getLoginProfileSettings().build();
        this.getSshPublicKeySettings = settingsBuilder.getSshPublicKeySettings().build();
        this.importSshPublicKeySettings = settingsBuilder.importSshPublicKeySettings().build();
        this.updateSshPublicKeySettings = settingsBuilder.updateSshPublicKeySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<OsLoginServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateSshPublicKeyRequest, OsLoginProto.SshPublicKey> createSshPublicKeySettings;
        private final UnaryCallSettings.Builder<DeletePosixAccountRequest, Empty> deletePosixAccountSettings;
        private final UnaryCallSettings.Builder<DeleteSshPublicKeyRequest, Empty> deleteSshPublicKeySettings;
        private final UnaryCallSettings.Builder<GetLoginProfileRequest, LoginProfile> getLoginProfileSettings;
        private final UnaryCallSettings.Builder<GetSshPublicKeyRequest, OsLoginProto.SshPublicKey> getSshPublicKeySettings;
        private final UnaryCallSettings.Builder<ImportSshPublicKeyRequest, ImportSshPublicKeyResponse> importSshPublicKeySettings;
        private final UnaryCallSettings.Builder<UpdateSshPublicKeyRequest, OsLoginProto.SshPublicKey> updateSshPublicKeySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSshPublicKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePosixAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSshPublicKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getLoginProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSshPublicKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importSshPublicKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSshPublicKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSshPublicKeySettings, this.deletePosixAccountSettings, this.deleteSshPublicKeySettings, this.getLoginProfileSettings, this.getSshPublicKeySettings, this.importSshPublicKeySettings, this.updateSshPublicKeySettings);
            Builder.initDefaults(this);
        }

        protected Builder(OsLoginServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createSshPublicKeySettings = settings.createSshPublicKeySettings.toBuilder();
            this.deletePosixAccountSettings = settings.deletePosixAccountSettings.toBuilder();
            this.deleteSshPublicKeySettings = settings.deleteSshPublicKeySettings.toBuilder();
            this.getLoginProfileSettings = settings.getLoginProfileSettings.toBuilder();
            this.getSshPublicKeySettings = settings.getSshPublicKeySettings.toBuilder();
            this.importSshPublicKeySettings = settings.importSshPublicKeySettings.toBuilder();
            this.updateSshPublicKeySettings = settings.updateSshPublicKeySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSshPublicKeySettings, this.deletePosixAccountSettings, this.deleteSshPublicKeySettings, this.getLoginProfileSettings, this.getSshPublicKeySettings, this.importSshPublicKeySettings, this.updateSshPublicKeySettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(OsLoginServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)OsLoginServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)OsLoginServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(OsLoginServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)OsLoginServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)OsLoginServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)OsLoginServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(OsLoginServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSshPublicKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deletePosixAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSshPublicKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLoginProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSshPublicKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.importSshPublicKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateSshPublicKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateSshPublicKeyRequest, OsLoginProto.SshPublicKey> createSshPublicKeySettings() {
            return this.createSshPublicKeySettings;
        }

        public UnaryCallSettings.Builder<DeletePosixAccountRequest, Empty> deletePosixAccountSettings() {
            return this.deletePosixAccountSettings;
        }

        public UnaryCallSettings.Builder<DeleteSshPublicKeyRequest, Empty> deleteSshPublicKeySettings() {
            return this.deleteSshPublicKeySettings;
        }

        public UnaryCallSettings.Builder<GetLoginProfileRequest, LoginProfile> getLoginProfileSettings() {
            return this.getLoginProfileSettings;
        }

        public UnaryCallSettings.Builder<GetSshPublicKeyRequest, OsLoginProto.SshPublicKey> getSshPublicKeySettings() {
            return this.getSshPublicKeySettings;
        }

        public UnaryCallSettings.Builder<ImportSshPublicKeyRequest, ImportSshPublicKeyResponse> importSshPublicKeySettings() {
            return this.importSshPublicKeySettings;
        }

        public UnaryCallSettings.Builder<UpdateSshPublicKeyRequest, OsLoginProto.SshPublicKey> updateSshPublicKeySettings() {
            return this.updateSshPublicKeySettings;
        }

        public OsLoginServiceStubSettings build() throws IOException {
            return new OsLoginServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)10000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)10000L)).setTotalTimeout(Duration.ofMillis((long)10000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

