/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oslogin.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.oslogin.common.OsLoginProto;
import com.google.cloud.oslogin.v1.DeletePosixAccountRequest;
import com.google.cloud.oslogin.v1.DeleteSshPublicKeyRequest;
import com.google.cloud.oslogin.v1.FingerprintName;
import com.google.cloud.oslogin.v1.GetLoginProfileRequest;
import com.google.cloud.oslogin.v1.GetSshPublicKeyRequest;
import com.google.cloud.oslogin.v1.ImportSshPublicKeyRequest;
import com.google.cloud.oslogin.v1.ImportSshPublicKeyResponse;
import com.google.cloud.oslogin.v1.LoginProfile;
import com.google.cloud.oslogin.v1.OsLoginServiceSettings;
import com.google.cloud.oslogin.v1.ProjectName;
import com.google.cloud.oslogin.v1.UpdateSshPublicKeyRequest;
import com.google.cloud.oslogin.v1.UserName;
import com.google.cloud.oslogin.v1.stub.OsLoginServiceStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class OsLoginServiceClient
implements BackgroundResource {
    private final OsLoginServiceSettings settings;
    private final OsLoginServiceStub stub;

    public static final OsLoginServiceClient create() throws IOException {
        return OsLoginServiceClient.create(OsLoginServiceSettings.newBuilder().build());
    }

    public static final OsLoginServiceClient create(OsLoginServiceSettings settings) throws IOException {
        return new OsLoginServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final OsLoginServiceClient create(OsLoginServiceStub stub) {
        return new OsLoginServiceClient(stub);
    }

    protected OsLoginServiceClient(OsLoginServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = settings.createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected OsLoginServiceClient(OsLoginServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final OsLoginServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public OsLoginServiceStub getStub() {
        return this.stub;
    }

    public final void deletePosixAccount(ProjectName name) {
        DeletePosixAccountRequest request = DeletePosixAccountRequest.newBuilder().setName(name.toString()).build();
        this.deletePosixAccount(request);
    }

    private final void deletePosixAccount(DeletePosixAccountRequest request) {
        this.deletePosixAccountCallable().call((Object)request);
    }

    public final UnaryCallable<DeletePosixAccountRequest, Empty> deletePosixAccountCallable() {
        return this.stub.deletePosixAccountCallable();
    }

    public final void deleteSshPublicKey(FingerprintName name) {
        DeleteSshPublicKeyRequest request = DeleteSshPublicKeyRequest.newBuilder().setName(name.toString()).build();
        this.deleteSshPublicKey(request);
    }

    private final void deleteSshPublicKey(DeleteSshPublicKeyRequest request) {
        this.deleteSshPublicKeyCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSshPublicKeyRequest, Empty> deleteSshPublicKeyCallable() {
        return this.stub.deleteSshPublicKeyCallable();
    }

    public final LoginProfile getLoginProfile(UserName name) {
        GetLoginProfileRequest request = GetLoginProfileRequest.newBuilder().setName(name.toString()).build();
        return this.getLoginProfile(request);
    }

    private final LoginProfile getLoginProfile(GetLoginProfileRequest request) {
        return (LoginProfile)this.getLoginProfileCallable().call((Object)request);
    }

    public final UnaryCallable<GetLoginProfileRequest, LoginProfile> getLoginProfileCallable() {
        return this.stub.getLoginProfileCallable();
    }

    public final OsLoginProto.SshPublicKey getSshPublicKey(FingerprintName name) {
        GetSshPublicKeyRequest request = GetSshPublicKeyRequest.newBuilder().setName(name.toString()).build();
        return this.getSshPublicKey(request);
    }

    private final OsLoginProto.SshPublicKey getSshPublicKey(GetSshPublicKeyRequest request) {
        return (OsLoginProto.SshPublicKey)this.getSshPublicKeyCallable().call((Object)request);
    }

    public final UnaryCallable<GetSshPublicKeyRequest, OsLoginProto.SshPublicKey> getSshPublicKeyCallable() {
        return this.stub.getSshPublicKeyCallable();
    }

    public final ImportSshPublicKeyResponse importSshPublicKey(UserName parent, OsLoginProto.SshPublicKey sshPublicKey) {
        ImportSshPublicKeyRequest request = ImportSshPublicKeyRequest.newBuilder().setParent(parent.toString()).setSshPublicKey(sshPublicKey).build();
        return this.importSshPublicKey(request);
    }

    public final ImportSshPublicKeyResponse importSshPublicKey(UserName parent, OsLoginProto.SshPublicKey sshPublicKey, String projectId) {
        ImportSshPublicKeyRequest request = ImportSshPublicKeyRequest.newBuilder().setParent(parent.toString()).setSshPublicKey(sshPublicKey).setProjectId(projectId).build();
        return this.importSshPublicKey(request);
    }

    public final ImportSshPublicKeyResponse importSshPublicKey(ImportSshPublicKeyRequest request) {
        return (ImportSshPublicKeyResponse)this.importSshPublicKeyCallable().call((Object)request);
    }

    public final UnaryCallable<ImportSshPublicKeyRequest, ImportSshPublicKeyResponse> importSshPublicKeyCallable() {
        return this.stub.importSshPublicKeyCallable();
    }

    public final OsLoginProto.SshPublicKey updateSshPublicKey(FingerprintName name, OsLoginProto.SshPublicKey sshPublicKey) {
        UpdateSshPublicKeyRequest request = UpdateSshPublicKeyRequest.newBuilder().setName(name.toString()).setSshPublicKey(sshPublicKey).build();
        return this.updateSshPublicKey(request);
    }

    public final OsLoginProto.SshPublicKey updateSshPublicKey(FingerprintName name, OsLoginProto.SshPublicKey sshPublicKey, FieldMask updateMask) {
        UpdateSshPublicKeyRequest request = UpdateSshPublicKeyRequest.newBuilder().setName(name.toString()).setSshPublicKey(sshPublicKey).setUpdateMask(updateMask).build();
        return this.updateSshPublicKey(request);
    }

    public final OsLoginProto.SshPublicKey updateSshPublicKey(UpdateSshPublicKeyRequest request) {
        return (OsLoginProto.SshPublicKey)this.updateSshPublicKeyCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSshPublicKeyRequest, OsLoginProto.SshPublicKey> updateSshPublicKeyCallable() {
        return this.stub.updateSshPublicKeyCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

