/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.osconfig.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.osconfig.v1.GetInventoryRequest;
import com.google.cloud.osconfig.v1.GetVulnerabilityReportRequest;
import com.google.cloud.osconfig.v1.InstanceName;
import com.google.cloud.osconfig.v1.Inventory;
import com.google.cloud.osconfig.v1.InventoryName;
import com.google.cloud.osconfig.v1.ListInventoriesRequest;
import com.google.cloud.osconfig.v1.ListInventoriesResponse;
import com.google.cloud.osconfig.v1.ListVulnerabilityReportsRequest;
import com.google.cloud.osconfig.v1.ListVulnerabilityReportsResponse;
import com.google.cloud.osconfig.v1.OsConfigZonalServiceSettings;
import com.google.cloud.osconfig.v1.VulnerabilityReport;
import com.google.cloud.osconfig.v1.VulnerabilityReportName;
import com.google.cloud.osconfig.v1.stub.OsConfigZonalServiceStub;
import com.google.cloud.osconfig.v1.stub.OsConfigZonalServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class OsConfigZonalServiceClient
implements BackgroundResource {
    private final OsConfigZonalServiceSettings settings;
    private final OsConfigZonalServiceStub stub;

    public static final OsConfigZonalServiceClient create() throws IOException {
        return OsConfigZonalServiceClient.create(OsConfigZonalServiceSettings.newBuilder().build());
    }

    public static final OsConfigZonalServiceClient create(OsConfigZonalServiceSettings settings) throws IOException {
        return new OsConfigZonalServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final OsConfigZonalServiceClient create(OsConfigZonalServiceStub stub) {
        return new OsConfigZonalServiceClient(stub);
    }

    protected OsConfigZonalServiceClient(OsConfigZonalServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((OsConfigZonalServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected OsConfigZonalServiceClient(OsConfigZonalServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final OsConfigZonalServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public OsConfigZonalServiceStub getStub() {
        return this.stub;
    }

    public final Inventory getInventory(InventoryName name) {
        GetInventoryRequest request = GetInventoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInventory(request);
    }

    public final Inventory getInventory(String name) {
        GetInventoryRequest request = GetInventoryRequest.newBuilder().setName(name).build();
        return this.getInventory(request);
    }

    public final Inventory getInventory(GetInventoryRequest request) {
        return (Inventory)this.getInventoryCallable().call((Object)request);
    }

    public final UnaryCallable<GetInventoryRequest, Inventory> getInventoryCallable() {
        return this.stub.getInventoryCallable();
    }

    public final ListInventoriesPagedResponse listInventories(InstanceName parent) {
        ListInventoriesRequest request = ListInventoriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInventories(request);
    }

    public final ListInventoriesPagedResponse listInventories(String parent) {
        ListInventoriesRequest request = ListInventoriesRequest.newBuilder().setParent(parent).build();
        return this.listInventories(request);
    }

    public final ListInventoriesPagedResponse listInventories(ListInventoriesRequest request) {
        return (ListInventoriesPagedResponse)((Object)this.listInventoriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInventoriesRequest, ListInventoriesPagedResponse> listInventoriesPagedCallable() {
        return this.stub.listInventoriesPagedCallable();
    }

    public final UnaryCallable<ListInventoriesRequest, ListInventoriesResponse> listInventoriesCallable() {
        return this.stub.listInventoriesCallable();
    }

    public final VulnerabilityReport getVulnerabilityReport(VulnerabilityReportName name) {
        GetVulnerabilityReportRequest request = GetVulnerabilityReportRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVulnerabilityReport(request);
    }

    public final VulnerabilityReport getVulnerabilityReport(String name) {
        GetVulnerabilityReportRequest request = GetVulnerabilityReportRequest.newBuilder().setName(name).build();
        return this.getVulnerabilityReport(request);
    }

    public final VulnerabilityReport getVulnerabilityReport(GetVulnerabilityReportRequest request) {
        return (VulnerabilityReport)this.getVulnerabilityReportCallable().call((Object)request);
    }

    public final UnaryCallable<GetVulnerabilityReportRequest, VulnerabilityReport> getVulnerabilityReportCallable() {
        return this.stub.getVulnerabilityReportCallable();
    }

    public final ListVulnerabilityReportsPagedResponse listVulnerabilityReports(InstanceName parent) {
        ListVulnerabilityReportsRequest request = ListVulnerabilityReportsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listVulnerabilityReports(request);
    }

    public final ListVulnerabilityReportsPagedResponse listVulnerabilityReports(String parent) {
        ListVulnerabilityReportsRequest request = ListVulnerabilityReportsRequest.newBuilder().setParent(parent).build();
        return this.listVulnerabilityReports(request);
    }

    public final ListVulnerabilityReportsPagedResponse listVulnerabilityReports(ListVulnerabilityReportsRequest request) {
        return (ListVulnerabilityReportsPagedResponse)((Object)this.listVulnerabilityReportsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVulnerabilityReportsRequest, ListVulnerabilityReportsPagedResponse> listVulnerabilityReportsPagedCallable() {
        return this.stub.listVulnerabilityReportsPagedCallable();
    }

    public final UnaryCallable<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse> listVulnerabilityReportsCallable() {
        return this.stub.listVulnerabilityReportsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListVulnerabilityReportsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse, VulnerabilityReport, ListVulnerabilityReportsPage, ListVulnerabilityReportsFixedSizeCollection> {
        private ListVulnerabilityReportsFixedSizeCollection(List<ListVulnerabilityReportsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVulnerabilityReportsFixedSizeCollection createEmptyCollection() {
            return new ListVulnerabilityReportsFixedSizeCollection(null, 0);
        }

        protected ListVulnerabilityReportsFixedSizeCollection createCollection(List<ListVulnerabilityReportsPage> pages, int collectionSize) {
            return new ListVulnerabilityReportsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVulnerabilityReportsPage
    extends AbstractPage<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse, VulnerabilityReport, ListVulnerabilityReportsPage> {
        private ListVulnerabilityReportsPage(PageContext<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse, VulnerabilityReport> context, ListVulnerabilityReportsResponse response) {
            super(context, (Object)response);
        }

        private static ListVulnerabilityReportsPage createEmptyPage() {
            return new ListVulnerabilityReportsPage(null, null);
        }

        protected ListVulnerabilityReportsPage createPage(PageContext<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse, VulnerabilityReport> context, ListVulnerabilityReportsResponse response) {
            return new ListVulnerabilityReportsPage(context, response);
        }

        public ApiFuture<ListVulnerabilityReportsPage> createPageAsync(PageContext<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse, VulnerabilityReport> context, ApiFuture<ListVulnerabilityReportsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVulnerabilityReportsPagedResponse
    extends AbstractPagedListResponse<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse, VulnerabilityReport, ListVulnerabilityReportsPage, ListVulnerabilityReportsFixedSizeCollection> {
        public static ApiFuture<ListVulnerabilityReportsPagedResponse> createAsync(PageContext<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse, VulnerabilityReport> context, ApiFuture<ListVulnerabilityReportsResponse> futureResponse) {
            ApiFuture<ListVulnerabilityReportsPage> futurePage = ListVulnerabilityReportsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVulnerabilityReportsPagedResponse((ListVulnerabilityReportsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVulnerabilityReportsPagedResponse(ListVulnerabilityReportsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVulnerabilityReportsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInventoriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInventoriesRequest, ListInventoriesResponse, Inventory, ListInventoriesPage, ListInventoriesFixedSizeCollection> {
        private ListInventoriesFixedSizeCollection(List<ListInventoriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInventoriesFixedSizeCollection createEmptyCollection() {
            return new ListInventoriesFixedSizeCollection(null, 0);
        }

        protected ListInventoriesFixedSizeCollection createCollection(List<ListInventoriesPage> pages, int collectionSize) {
            return new ListInventoriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInventoriesPage
    extends AbstractPage<ListInventoriesRequest, ListInventoriesResponse, Inventory, ListInventoriesPage> {
        private ListInventoriesPage(PageContext<ListInventoriesRequest, ListInventoriesResponse, Inventory> context, ListInventoriesResponse response) {
            super(context, (Object)response);
        }

        private static ListInventoriesPage createEmptyPage() {
            return new ListInventoriesPage(null, null);
        }

        protected ListInventoriesPage createPage(PageContext<ListInventoriesRequest, ListInventoriesResponse, Inventory> context, ListInventoriesResponse response) {
            return new ListInventoriesPage(context, response);
        }

        public ApiFuture<ListInventoriesPage> createPageAsync(PageContext<ListInventoriesRequest, ListInventoriesResponse, Inventory> context, ApiFuture<ListInventoriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInventoriesPagedResponse
    extends AbstractPagedListResponse<ListInventoriesRequest, ListInventoriesResponse, Inventory, ListInventoriesPage, ListInventoriesFixedSizeCollection> {
        public static ApiFuture<ListInventoriesPagedResponse> createAsync(PageContext<ListInventoriesRequest, ListInventoriesResponse, Inventory> context, ApiFuture<ListInventoriesResponse> futureResponse) {
            ApiFuture<ListInventoriesPage> futurePage = ListInventoriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInventoriesPagedResponse((ListInventoriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInventoriesPagedResponse(ListInventoriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInventoriesFixedSizeCollection.createEmptyCollection());
        }
    }
}

