/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oracledatabase.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.OperationsClient;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.oracledatabase.v1.AutonomousDatabase;
import com.google.cloud.oracledatabase.v1.AutonomousDatabaseBackup;
import com.google.cloud.oracledatabase.v1.AutonomousDatabaseCharacterSet;
import com.google.cloud.oracledatabase.v1.AutonomousDatabaseName;
import com.google.cloud.oracledatabase.v1.AutonomousDbVersion;
import com.google.cloud.oracledatabase.v1.CloudExadataInfrastructure;
import com.google.cloud.oracledatabase.v1.CloudExadataInfrastructureName;
import com.google.cloud.oracledatabase.v1.CloudVmCluster;
import com.google.cloud.oracledatabase.v1.CloudVmClusterName;
import com.google.cloud.oracledatabase.v1.CreateAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.CreateCloudExadataInfrastructureRequest;
import com.google.cloud.oracledatabase.v1.CreateCloudVmClusterRequest;
import com.google.cloud.oracledatabase.v1.DbNode;
import com.google.cloud.oracledatabase.v1.DbServer;
import com.google.cloud.oracledatabase.v1.DbSystemShape;
import com.google.cloud.oracledatabase.v1.DeleteAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.DeleteCloudExadataInfrastructureRequest;
import com.google.cloud.oracledatabase.v1.DeleteCloudVmClusterRequest;
import com.google.cloud.oracledatabase.v1.Entitlement;
import com.google.cloud.oracledatabase.v1.GenerateAutonomousDatabaseWalletRequest;
import com.google.cloud.oracledatabase.v1.GenerateAutonomousDatabaseWalletResponse;
import com.google.cloud.oracledatabase.v1.GenerateType;
import com.google.cloud.oracledatabase.v1.GetAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.GetCloudExadataInfrastructureRequest;
import com.google.cloud.oracledatabase.v1.GetCloudVmClusterRequest;
import com.google.cloud.oracledatabase.v1.GiVersion;
import com.google.cloud.oracledatabase.v1.ListAutonomousDatabaseBackupsRequest;
import com.google.cloud.oracledatabase.v1.ListAutonomousDatabaseBackupsResponse;
import com.google.cloud.oracledatabase.v1.ListAutonomousDatabaseCharacterSetsRequest;
import com.google.cloud.oracledatabase.v1.ListAutonomousDatabaseCharacterSetsResponse;
import com.google.cloud.oracledatabase.v1.ListAutonomousDatabasesRequest;
import com.google.cloud.oracledatabase.v1.ListAutonomousDatabasesResponse;
import com.google.cloud.oracledatabase.v1.ListAutonomousDbVersionsRequest;
import com.google.cloud.oracledatabase.v1.ListAutonomousDbVersionsResponse;
import com.google.cloud.oracledatabase.v1.ListCloudExadataInfrastructuresRequest;
import com.google.cloud.oracledatabase.v1.ListCloudExadataInfrastructuresResponse;
import com.google.cloud.oracledatabase.v1.ListCloudVmClustersRequest;
import com.google.cloud.oracledatabase.v1.ListCloudVmClustersResponse;
import com.google.cloud.oracledatabase.v1.ListDbNodesRequest;
import com.google.cloud.oracledatabase.v1.ListDbNodesResponse;
import com.google.cloud.oracledatabase.v1.ListDbServersRequest;
import com.google.cloud.oracledatabase.v1.ListDbServersResponse;
import com.google.cloud.oracledatabase.v1.ListDbSystemShapesRequest;
import com.google.cloud.oracledatabase.v1.ListDbSystemShapesResponse;
import com.google.cloud.oracledatabase.v1.ListEntitlementsRequest;
import com.google.cloud.oracledatabase.v1.ListEntitlementsResponse;
import com.google.cloud.oracledatabase.v1.ListGiVersionsRequest;
import com.google.cloud.oracledatabase.v1.ListGiVersionsResponse;
import com.google.cloud.oracledatabase.v1.LocationName;
import com.google.cloud.oracledatabase.v1.OperationMetadata;
import com.google.cloud.oracledatabase.v1.OracleDatabaseSettings;
import com.google.cloud.oracledatabase.v1.RestartAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.RestoreAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.StartAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.StopAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.stub.OracleDatabaseStub;
import com.google.cloud.oracledatabase.v1.stub.OracleDatabaseStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class OracleDatabaseClient
implements BackgroundResource {
    private final OracleDatabaseSettings settings;
    private final OracleDatabaseStub stub;
    private final OperationsClient httpJsonOperationsClient;

    public static final OracleDatabaseClient create() throws IOException {
        return OracleDatabaseClient.create(OracleDatabaseSettings.newBuilder().build());
    }

    public static final OracleDatabaseClient create(OracleDatabaseSettings settings) throws IOException {
        return new OracleDatabaseClient(settings);
    }

    public static final OracleDatabaseClient create(OracleDatabaseStub stub) {
        return new OracleDatabaseClient(stub);
    }

    protected OracleDatabaseClient(OracleDatabaseSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((OracleDatabaseStubSettings)settings.getStubSettings()).createStub();
        this.httpJsonOperationsClient = OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected OracleDatabaseClient(OracleDatabaseStub stub) {
        this.settings = null;
        this.stub = stub;
        this.httpJsonOperationsClient = OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final OracleDatabaseSettings getSettings() {
        return this.settings;
    }

    public OracleDatabaseStub getStub() {
        return this.stub;
    }

    public final OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListCloudExadataInfrastructuresPagedResponse listCloudExadataInfrastructures(LocationName parent) {
        ListCloudExadataInfrastructuresRequest request = ListCloudExadataInfrastructuresRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCloudExadataInfrastructures(request);
    }

    public final ListCloudExadataInfrastructuresPagedResponse listCloudExadataInfrastructures(String parent) {
        ListCloudExadataInfrastructuresRequest request = ListCloudExadataInfrastructuresRequest.newBuilder().setParent(parent).build();
        return this.listCloudExadataInfrastructures(request);
    }

    public final ListCloudExadataInfrastructuresPagedResponse listCloudExadataInfrastructures(ListCloudExadataInfrastructuresRequest request) {
        return (ListCloudExadataInfrastructuresPagedResponse)((Object)this.listCloudExadataInfrastructuresPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresPagedResponse> listCloudExadataInfrastructuresPagedCallable() {
        return this.stub.listCloudExadataInfrastructuresPagedCallable();
    }

    public final UnaryCallable<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse> listCloudExadataInfrastructuresCallable() {
        return this.stub.listCloudExadataInfrastructuresCallable();
    }

    public final CloudExadataInfrastructure getCloudExadataInfrastructure(CloudExadataInfrastructureName name) {
        GetCloudExadataInfrastructureRequest request = GetCloudExadataInfrastructureRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCloudExadataInfrastructure(request);
    }

    public final CloudExadataInfrastructure getCloudExadataInfrastructure(String name) {
        GetCloudExadataInfrastructureRequest request = GetCloudExadataInfrastructureRequest.newBuilder().setName(name).build();
        return this.getCloudExadataInfrastructure(request);
    }

    public final CloudExadataInfrastructure getCloudExadataInfrastructure(GetCloudExadataInfrastructureRequest request) {
        return (CloudExadataInfrastructure)this.getCloudExadataInfrastructureCallable().call((Object)request);
    }

    public final UnaryCallable<GetCloudExadataInfrastructureRequest, CloudExadataInfrastructure> getCloudExadataInfrastructureCallable() {
        return this.stub.getCloudExadataInfrastructureCallable();
    }

    public final OperationFuture<CloudExadataInfrastructure, OperationMetadata> createCloudExadataInfrastructureAsync(LocationName parent, CloudExadataInfrastructure cloudExadataInfrastructure, String cloudExadataInfrastructureId) {
        CreateCloudExadataInfrastructureRequest request = CreateCloudExadataInfrastructureRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCloudExadataInfrastructure(cloudExadataInfrastructure).setCloudExadataInfrastructureId(cloudExadataInfrastructureId).build();
        return this.createCloudExadataInfrastructureAsync(request);
    }

    public final OperationFuture<CloudExadataInfrastructure, OperationMetadata> createCloudExadataInfrastructureAsync(String parent, CloudExadataInfrastructure cloudExadataInfrastructure, String cloudExadataInfrastructureId) {
        CreateCloudExadataInfrastructureRequest request = CreateCloudExadataInfrastructureRequest.newBuilder().setParent(parent).setCloudExadataInfrastructure(cloudExadataInfrastructure).setCloudExadataInfrastructureId(cloudExadataInfrastructureId).build();
        return this.createCloudExadataInfrastructureAsync(request);
    }

    public final OperationFuture<CloudExadataInfrastructure, OperationMetadata> createCloudExadataInfrastructureAsync(CreateCloudExadataInfrastructureRequest request) {
        return this.createCloudExadataInfrastructureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCloudExadataInfrastructureRequest, CloudExadataInfrastructure, OperationMetadata> createCloudExadataInfrastructureOperationCallable() {
        return this.stub.createCloudExadataInfrastructureOperationCallable();
    }

    public final UnaryCallable<CreateCloudExadataInfrastructureRequest, Operation> createCloudExadataInfrastructureCallable() {
        return this.stub.createCloudExadataInfrastructureCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCloudExadataInfrastructureAsync(CloudExadataInfrastructureName name) {
        DeleteCloudExadataInfrastructureRequest request = DeleteCloudExadataInfrastructureRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCloudExadataInfrastructureAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCloudExadataInfrastructureAsync(String name) {
        DeleteCloudExadataInfrastructureRequest request = DeleteCloudExadataInfrastructureRequest.newBuilder().setName(name).build();
        return this.deleteCloudExadataInfrastructureAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCloudExadataInfrastructureAsync(DeleteCloudExadataInfrastructureRequest request) {
        return this.deleteCloudExadataInfrastructureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCloudExadataInfrastructureRequest, Empty, OperationMetadata> deleteCloudExadataInfrastructureOperationCallable() {
        return this.stub.deleteCloudExadataInfrastructureOperationCallable();
    }

    public final UnaryCallable<DeleteCloudExadataInfrastructureRequest, Operation> deleteCloudExadataInfrastructureCallable() {
        return this.stub.deleteCloudExadataInfrastructureCallable();
    }

    public final ListCloudVmClustersPagedResponse listCloudVmClusters(LocationName parent) {
        ListCloudVmClustersRequest request = ListCloudVmClustersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCloudVmClusters(request);
    }

    public final ListCloudVmClustersPagedResponse listCloudVmClusters(String parent) {
        ListCloudVmClustersRequest request = ListCloudVmClustersRequest.newBuilder().setParent(parent).build();
        return this.listCloudVmClusters(request);
    }

    public final ListCloudVmClustersPagedResponse listCloudVmClusters(ListCloudVmClustersRequest request) {
        return (ListCloudVmClustersPagedResponse)((Object)this.listCloudVmClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCloudVmClustersRequest, ListCloudVmClustersPagedResponse> listCloudVmClustersPagedCallable() {
        return this.stub.listCloudVmClustersPagedCallable();
    }

    public final UnaryCallable<ListCloudVmClustersRequest, ListCloudVmClustersResponse> listCloudVmClustersCallable() {
        return this.stub.listCloudVmClustersCallable();
    }

    public final CloudVmCluster getCloudVmCluster(CloudVmClusterName name) {
        GetCloudVmClusterRequest request = GetCloudVmClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCloudVmCluster(request);
    }

    public final CloudVmCluster getCloudVmCluster(String name) {
        GetCloudVmClusterRequest request = GetCloudVmClusterRequest.newBuilder().setName(name).build();
        return this.getCloudVmCluster(request);
    }

    public final CloudVmCluster getCloudVmCluster(GetCloudVmClusterRequest request) {
        return (CloudVmCluster)this.getCloudVmClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetCloudVmClusterRequest, CloudVmCluster> getCloudVmClusterCallable() {
        return this.stub.getCloudVmClusterCallable();
    }

    public final OperationFuture<CloudVmCluster, OperationMetadata> createCloudVmClusterAsync(LocationName parent, CloudVmCluster cloudVmCluster, String cloudVmClusterId) {
        CreateCloudVmClusterRequest request = CreateCloudVmClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCloudVmCluster(cloudVmCluster).setCloudVmClusterId(cloudVmClusterId).build();
        return this.createCloudVmClusterAsync(request);
    }

    public final OperationFuture<CloudVmCluster, OperationMetadata> createCloudVmClusterAsync(String parent, CloudVmCluster cloudVmCluster, String cloudVmClusterId) {
        CreateCloudVmClusterRequest request = CreateCloudVmClusterRequest.newBuilder().setParent(parent).setCloudVmCluster(cloudVmCluster).setCloudVmClusterId(cloudVmClusterId).build();
        return this.createCloudVmClusterAsync(request);
    }

    public final OperationFuture<CloudVmCluster, OperationMetadata> createCloudVmClusterAsync(CreateCloudVmClusterRequest request) {
        return this.createCloudVmClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCloudVmClusterRequest, CloudVmCluster, OperationMetadata> createCloudVmClusterOperationCallable() {
        return this.stub.createCloudVmClusterOperationCallable();
    }

    public final UnaryCallable<CreateCloudVmClusterRequest, Operation> createCloudVmClusterCallable() {
        return this.stub.createCloudVmClusterCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCloudVmClusterAsync(CloudVmClusterName name) {
        DeleteCloudVmClusterRequest request = DeleteCloudVmClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCloudVmClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCloudVmClusterAsync(String name) {
        DeleteCloudVmClusterRequest request = DeleteCloudVmClusterRequest.newBuilder().setName(name).build();
        return this.deleteCloudVmClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCloudVmClusterAsync(DeleteCloudVmClusterRequest request) {
        return this.deleteCloudVmClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCloudVmClusterRequest, Empty, OperationMetadata> deleteCloudVmClusterOperationCallable() {
        return this.stub.deleteCloudVmClusterOperationCallable();
    }

    public final UnaryCallable<DeleteCloudVmClusterRequest, Operation> deleteCloudVmClusterCallable() {
        return this.stub.deleteCloudVmClusterCallable();
    }

    public final ListEntitlementsPagedResponse listEntitlements(LocationName parent) {
        ListEntitlementsRequest request = ListEntitlementsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEntitlements(request);
    }

    public final ListEntitlementsPagedResponse listEntitlements(String parent) {
        ListEntitlementsRequest request = ListEntitlementsRequest.newBuilder().setParent(parent).build();
        return this.listEntitlements(request);
    }

    public final ListEntitlementsPagedResponse listEntitlements(ListEntitlementsRequest request) {
        return (ListEntitlementsPagedResponse)((Object)this.listEntitlementsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEntitlementsRequest, ListEntitlementsPagedResponse> listEntitlementsPagedCallable() {
        return this.stub.listEntitlementsPagedCallable();
    }

    public final UnaryCallable<ListEntitlementsRequest, ListEntitlementsResponse> listEntitlementsCallable() {
        return this.stub.listEntitlementsCallable();
    }

    public final ListDbServersPagedResponse listDbServers(CloudExadataInfrastructureName parent) {
        ListDbServersRequest request = ListDbServersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDbServers(request);
    }

    public final ListDbServersPagedResponse listDbServers(String parent) {
        ListDbServersRequest request = ListDbServersRequest.newBuilder().setParent(parent).build();
        return this.listDbServers(request);
    }

    public final ListDbServersPagedResponse listDbServers(ListDbServersRequest request) {
        return (ListDbServersPagedResponse)((Object)this.listDbServersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDbServersRequest, ListDbServersPagedResponse> listDbServersPagedCallable() {
        return this.stub.listDbServersPagedCallable();
    }

    public final UnaryCallable<ListDbServersRequest, ListDbServersResponse> listDbServersCallable() {
        return this.stub.listDbServersCallable();
    }

    public final ListDbNodesPagedResponse listDbNodes(CloudVmClusterName parent) {
        ListDbNodesRequest request = ListDbNodesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDbNodes(request);
    }

    public final ListDbNodesPagedResponse listDbNodes(String parent) {
        ListDbNodesRequest request = ListDbNodesRequest.newBuilder().setParent(parent).build();
        return this.listDbNodes(request);
    }

    public final ListDbNodesPagedResponse listDbNodes(ListDbNodesRequest request) {
        return (ListDbNodesPagedResponse)((Object)this.listDbNodesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDbNodesRequest, ListDbNodesPagedResponse> listDbNodesPagedCallable() {
        return this.stub.listDbNodesPagedCallable();
    }

    public final UnaryCallable<ListDbNodesRequest, ListDbNodesResponse> listDbNodesCallable() {
        return this.stub.listDbNodesCallable();
    }

    public final ListGiVersionsPagedResponse listGiVersions(LocationName parent) {
        ListGiVersionsRequest request = ListGiVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGiVersions(request);
    }

    public final ListGiVersionsPagedResponse listGiVersions(String parent) {
        ListGiVersionsRequest request = ListGiVersionsRequest.newBuilder().setParent(parent).build();
        return this.listGiVersions(request);
    }

    public final ListGiVersionsPagedResponse listGiVersions(ListGiVersionsRequest request) {
        return (ListGiVersionsPagedResponse)((Object)this.listGiVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGiVersionsRequest, ListGiVersionsPagedResponse> listGiVersionsPagedCallable() {
        return this.stub.listGiVersionsPagedCallable();
    }

    public final UnaryCallable<ListGiVersionsRequest, ListGiVersionsResponse> listGiVersionsCallable() {
        return this.stub.listGiVersionsCallable();
    }

    public final ListDbSystemShapesPagedResponse listDbSystemShapes(LocationName parent) {
        ListDbSystemShapesRequest request = ListDbSystemShapesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDbSystemShapes(request);
    }

    public final ListDbSystemShapesPagedResponse listDbSystemShapes(String parent) {
        ListDbSystemShapesRequest request = ListDbSystemShapesRequest.newBuilder().setParent(parent).build();
        return this.listDbSystemShapes(request);
    }

    public final ListDbSystemShapesPagedResponse listDbSystemShapes(ListDbSystemShapesRequest request) {
        return (ListDbSystemShapesPagedResponse)((Object)this.listDbSystemShapesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDbSystemShapesRequest, ListDbSystemShapesPagedResponse> listDbSystemShapesPagedCallable() {
        return this.stub.listDbSystemShapesPagedCallable();
    }

    public final UnaryCallable<ListDbSystemShapesRequest, ListDbSystemShapesResponse> listDbSystemShapesCallable() {
        return this.stub.listDbSystemShapesCallable();
    }

    public final ListAutonomousDatabasesPagedResponse listAutonomousDatabases(LocationName parent) {
        ListAutonomousDatabasesRequest request = ListAutonomousDatabasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAutonomousDatabases(request);
    }

    public final ListAutonomousDatabasesPagedResponse listAutonomousDatabases(String parent) {
        ListAutonomousDatabasesRequest request = ListAutonomousDatabasesRequest.newBuilder().setParent(parent).build();
        return this.listAutonomousDatabases(request);
    }

    public final ListAutonomousDatabasesPagedResponse listAutonomousDatabases(ListAutonomousDatabasesRequest request) {
        return (ListAutonomousDatabasesPagedResponse)((Object)this.listAutonomousDatabasesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAutonomousDatabasesRequest, ListAutonomousDatabasesPagedResponse> listAutonomousDatabasesPagedCallable() {
        return this.stub.listAutonomousDatabasesPagedCallable();
    }

    public final UnaryCallable<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse> listAutonomousDatabasesCallable() {
        return this.stub.listAutonomousDatabasesCallable();
    }

    public final AutonomousDatabase getAutonomousDatabase(AutonomousDatabaseName name) {
        GetAutonomousDatabaseRequest request = GetAutonomousDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAutonomousDatabase(request);
    }

    public final AutonomousDatabase getAutonomousDatabase(String name) {
        GetAutonomousDatabaseRequest request = GetAutonomousDatabaseRequest.newBuilder().setName(name).build();
        return this.getAutonomousDatabase(request);
    }

    public final AutonomousDatabase getAutonomousDatabase(GetAutonomousDatabaseRequest request) {
        return (AutonomousDatabase)this.getAutonomousDatabaseCallable().call((Object)request);
    }

    public final UnaryCallable<GetAutonomousDatabaseRequest, AutonomousDatabase> getAutonomousDatabaseCallable() {
        return this.stub.getAutonomousDatabaseCallable();
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> createAutonomousDatabaseAsync(LocationName parent, AutonomousDatabase autonomousDatabase, String autonomousDatabaseId) {
        CreateAutonomousDatabaseRequest request = CreateAutonomousDatabaseRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAutonomousDatabase(autonomousDatabase).setAutonomousDatabaseId(autonomousDatabaseId).build();
        return this.createAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> createAutonomousDatabaseAsync(String parent, AutonomousDatabase autonomousDatabase, String autonomousDatabaseId) {
        CreateAutonomousDatabaseRequest request = CreateAutonomousDatabaseRequest.newBuilder().setParent(parent).setAutonomousDatabase(autonomousDatabase).setAutonomousDatabaseId(autonomousDatabaseId).build();
        return this.createAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> createAutonomousDatabaseAsync(CreateAutonomousDatabaseRequest request) {
        return this.createAutonomousDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> createAutonomousDatabaseOperationCallable() {
        return this.stub.createAutonomousDatabaseOperationCallable();
    }

    public final UnaryCallable<CreateAutonomousDatabaseRequest, Operation> createAutonomousDatabaseCallable() {
        return this.stub.createAutonomousDatabaseCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAutonomousDatabaseAsync(AutonomousDatabaseName name) {
        DeleteAutonomousDatabaseRequest request = DeleteAutonomousDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAutonomousDatabaseAsync(String name) {
        DeleteAutonomousDatabaseRequest request = DeleteAutonomousDatabaseRequest.newBuilder().setName(name).build();
        return this.deleteAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAutonomousDatabaseAsync(DeleteAutonomousDatabaseRequest request) {
        return this.deleteAutonomousDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAutonomousDatabaseRequest, Empty, OperationMetadata> deleteAutonomousDatabaseOperationCallable() {
        return this.stub.deleteAutonomousDatabaseOperationCallable();
    }

    public final UnaryCallable<DeleteAutonomousDatabaseRequest, Operation> deleteAutonomousDatabaseCallable() {
        return this.stub.deleteAutonomousDatabaseCallable();
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> restoreAutonomousDatabaseAsync(AutonomousDatabaseName name, Timestamp restoreTime) {
        RestoreAutonomousDatabaseRequest request = RestoreAutonomousDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).setRestoreTime(restoreTime).build();
        return this.restoreAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> restoreAutonomousDatabaseAsync(String name, Timestamp restoreTime) {
        RestoreAutonomousDatabaseRequest request = RestoreAutonomousDatabaseRequest.newBuilder().setName(name).setRestoreTime(restoreTime).build();
        return this.restoreAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> restoreAutonomousDatabaseAsync(RestoreAutonomousDatabaseRequest request) {
        return this.restoreAutonomousDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestoreAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> restoreAutonomousDatabaseOperationCallable() {
        return this.stub.restoreAutonomousDatabaseOperationCallable();
    }

    public final UnaryCallable<RestoreAutonomousDatabaseRequest, Operation> restoreAutonomousDatabaseCallable() {
        return this.stub.restoreAutonomousDatabaseCallable();
    }

    public final GenerateAutonomousDatabaseWalletResponse generateAutonomousDatabaseWallet(AutonomousDatabaseName name, GenerateType type, boolean isRegional, String password) {
        GenerateAutonomousDatabaseWalletRequest request = GenerateAutonomousDatabaseWalletRequest.newBuilder().setName(name == null ? null : name.toString()).setType(type).setIsRegional(isRegional).setPassword(password).build();
        return this.generateAutonomousDatabaseWallet(request);
    }

    public final GenerateAutonomousDatabaseWalletResponse generateAutonomousDatabaseWallet(String name, GenerateType type, boolean isRegional, String password) {
        GenerateAutonomousDatabaseWalletRequest request = GenerateAutonomousDatabaseWalletRequest.newBuilder().setName(name).setType(type).setIsRegional(isRegional).setPassword(password).build();
        return this.generateAutonomousDatabaseWallet(request);
    }

    public final GenerateAutonomousDatabaseWalletResponse generateAutonomousDatabaseWallet(GenerateAutonomousDatabaseWalletRequest request) {
        return (GenerateAutonomousDatabaseWalletResponse)this.generateAutonomousDatabaseWalletCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateAutonomousDatabaseWalletRequest, GenerateAutonomousDatabaseWalletResponse> generateAutonomousDatabaseWalletCallable() {
        return this.stub.generateAutonomousDatabaseWalletCallable();
    }

    public final ListAutonomousDbVersionsPagedResponse listAutonomousDbVersions(LocationName parent) {
        ListAutonomousDbVersionsRequest request = ListAutonomousDbVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAutonomousDbVersions(request);
    }

    public final ListAutonomousDbVersionsPagedResponse listAutonomousDbVersions(String parent) {
        ListAutonomousDbVersionsRequest request = ListAutonomousDbVersionsRequest.newBuilder().setParent(parent).build();
        return this.listAutonomousDbVersions(request);
    }

    public final ListAutonomousDbVersionsPagedResponse listAutonomousDbVersions(ListAutonomousDbVersionsRequest request) {
        return (ListAutonomousDbVersionsPagedResponse)((Object)this.listAutonomousDbVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsPagedResponse> listAutonomousDbVersionsPagedCallable() {
        return this.stub.listAutonomousDbVersionsPagedCallable();
    }

    public final UnaryCallable<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse> listAutonomousDbVersionsCallable() {
        return this.stub.listAutonomousDbVersionsCallable();
    }

    public final ListAutonomousDatabaseCharacterSetsPagedResponse listAutonomousDatabaseCharacterSets(LocationName parent) {
        ListAutonomousDatabaseCharacterSetsRequest request = ListAutonomousDatabaseCharacterSetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAutonomousDatabaseCharacterSets(request);
    }

    public final ListAutonomousDatabaseCharacterSetsPagedResponse listAutonomousDatabaseCharacterSets(String parent) {
        ListAutonomousDatabaseCharacterSetsRequest request = ListAutonomousDatabaseCharacterSetsRequest.newBuilder().setParent(parent).build();
        return this.listAutonomousDatabaseCharacterSets(request);
    }

    public final ListAutonomousDatabaseCharacterSetsPagedResponse listAutonomousDatabaseCharacterSets(ListAutonomousDatabaseCharacterSetsRequest request) {
        return (ListAutonomousDatabaseCharacterSetsPagedResponse)((Object)this.listAutonomousDatabaseCharacterSetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsPagedResponse> listAutonomousDatabaseCharacterSetsPagedCallable() {
        return this.stub.listAutonomousDatabaseCharacterSetsPagedCallable();
    }

    public final UnaryCallable<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse> listAutonomousDatabaseCharacterSetsCallable() {
        return this.stub.listAutonomousDatabaseCharacterSetsCallable();
    }

    public final ListAutonomousDatabaseBackupsPagedResponse listAutonomousDatabaseBackups(LocationName parent) {
        ListAutonomousDatabaseBackupsRequest request = ListAutonomousDatabaseBackupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAutonomousDatabaseBackups(request);
    }

    public final ListAutonomousDatabaseBackupsPagedResponse listAutonomousDatabaseBackups(String parent) {
        ListAutonomousDatabaseBackupsRequest request = ListAutonomousDatabaseBackupsRequest.newBuilder().setParent(parent).build();
        return this.listAutonomousDatabaseBackups(request);
    }

    public final ListAutonomousDatabaseBackupsPagedResponse listAutonomousDatabaseBackups(ListAutonomousDatabaseBackupsRequest request) {
        return (ListAutonomousDatabaseBackupsPagedResponse)((Object)this.listAutonomousDatabaseBackupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsPagedResponse> listAutonomousDatabaseBackupsPagedCallable() {
        return this.stub.listAutonomousDatabaseBackupsPagedCallable();
    }

    public final UnaryCallable<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse> listAutonomousDatabaseBackupsCallable() {
        return this.stub.listAutonomousDatabaseBackupsCallable();
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> stopAutonomousDatabaseAsync(AutonomousDatabaseName name) {
        StopAutonomousDatabaseRequest request = StopAutonomousDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.stopAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> stopAutonomousDatabaseAsync(String name) {
        StopAutonomousDatabaseRequest request = StopAutonomousDatabaseRequest.newBuilder().setName(name).build();
        return this.stopAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> stopAutonomousDatabaseAsync(StopAutonomousDatabaseRequest request) {
        return this.stopAutonomousDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StopAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> stopAutonomousDatabaseOperationCallable() {
        return this.stub.stopAutonomousDatabaseOperationCallable();
    }

    public final UnaryCallable<StopAutonomousDatabaseRequest, Operation> stopAutonomousDatabaseCallable() {
        return this.stub.stopAutonomousDatabaseCallable();
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> startAutonomousDatabaseAsync(AutonomousDatabaseName name) {
        StartAutonomousDatabaseRequest request = StartAutonomousDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.startAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> startAutonomousDatabaseAsync(String name) {
        StartAutonomousDatabaseRequest request = StartAutonomousDatabaseRequest.newBuilder().setName(name).build();
        return this.startAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> startAutonomousDatabaseAsync(StartAutonomousDatabaseRequest request) {
        return this.startAutonomousDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StartAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> startAutonomousDatabaseOperationCallable() {
        return this.stub.startAutonomousDatabaseOperationCallable();
    }

    public final UnaryCallable<StartAutonomousDatabaseRequest, Operation> startAutonomousDatabaseCallable() {
        return this.stub.startAutonomousDatabaseCallable();
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> restartAutonomousDatabaseAsync(AutonomousDatabaseName name) {
        RestartAutonomousDatabaseRequest request = RestartAutonomousDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.restartAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> restartAutonomousDatabaseAsync(String name) {
        RestartAutonomousDatabaseRequest request = RestartAutonomousDatabaseRequest.newBuilder().setName(name).build();
        return this.restartAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> restartAutonomousDatabaseAsync(RestartAutonomousDatabaseRequest request) {
        return this.restartAutonomousDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestartAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> restartAutonomousDatabaseOperationCallable() {
        return this.stub.restartAutonomousDatabaseOperationCallable();
    }

    public final UnaryCallable<RestartAutonomousDatabaseRequest, Operation> restartAutonomousDatabaseCallable() {
        return this.stub.restartAutonomousDatabaseCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAutonomousDatabaseBackupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, AutonomousDatabaseBackup, ListAutonomousDatabaseBackupsPage, ListAutonomousDatabaseBackupsFixedSizeCollection> {
        private ListAutonomousDatabaseBackupsFixedSizeCollection(List<ListAutonomousDatabaseBackupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAutonomousDatabaseBackupsFixedSizeCollection createEmptyCollection() {
            return new ListAutonomousDatabaseBackupsFixedSizeCollection(null, 0);
        }

        protected ListAutonomousDatabaseBackupsFixedSizeCollection createCollection(List<ListAutonomousDatabaseBackupsPage> pages, int collectionSize) {
            return new ListAutonomousDatabaseBackupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAutonomousDatabaseBackupsPage
    extends AbstractPage<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, AutonomousDatabaseBackup, ListAutonomousDatabaseBackupsPage> {
        private ListAutonomousDatabaseBackupsPage(PageContext<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, AutonomousDatabaseBackup> context, ListAutonomousDatabaseBackupsResponse response) {
            super(context, (Object)response);
        }

        private static ListAutonomousDatabaseBackupsPage createEmptyPage() {
            return new ListAutonomousDatabaseBackupsPage(null, null);
        }

        protected ListAutonomousDatabaseBackupsPage createPage(PageContext<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, AutonomousDatabaseBackup> context, ListAutonomousDatabaseBackupsResponse response) {
            return new ListAutonomousDatabaseBackupsPage(context, response);
        }

        public ApiFuture<ListAutonomousDatabaseBackupsPage> createPageAsync(PageContext<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, AutonomousDatabaseBackup> context, ApiFuture<ListAutonomousDatabaseBackupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAutonomousDatabaseBackupsPagedResponse
    extends AbstractPagedListResponse<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, AutonomousDatabaseBackup, ListAutonomousDatabaseBackupsPage, ListAutonomousDatabaseBackupsFixedSizeCollection> {
        public static ApiFuture<ListAutonomousDatabaseBackupsPagedResponse> createAsync(PageContext<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, AutonomousDatabaseBackup> context, ApiFuture<ListAutonomousDatabaseBackupsResponse> futureResponse) {
            ApiFuture<ListAutonomousDatabaseBackupsPage> futurePage = ListAutonomousDatabaseBackupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAutonomousDatabaseBackupsPagedResponse((ListAutonomousDatabaseBackupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAutonomousDatabaseBackupsPagedResponse(ListAutonomousDatabaseBackupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAutonomousDatabaseBackupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAutonomousDatabaseCharacterSetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, AutonomousDatabaseCharacterSet, ListAutonomousDatabaseCharacterSetsPage, ListAutonomousDatabaseCharacterSetsFixedSizeCollection> {
        private ListAutonomousDatabaseCharacterSetsFixedSizeCollection(List<ListAutonomousDatabaseCharacterSetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAutonomousDatabaseCharacterSetsFixedSizeCollection createEmptyCollection() {
            return new ListAutonomousDatabaseCharacterSetsFixedSizeCollection(null, 0);
        }

        protected ListAutonomousDatabaseCharacterSetsFixedSizeCollection createCollection(List<ListAutonomousDatabaseCharacterSetsPage> pages, int collectionSize) {
            return new ListAutonomousDatabaseCharacterSetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAutonomousDatabaseCharacterSetsPage
    extends AbstractPage<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, AutonomousDatabaseCharacterSet, ListAutonomousDatabaseCharacterSetsPage> {
        private ListAutonomousDatabaseCharacterSetsPage(PageContext<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, AutonomousDatabaseCharacterSet> context, ListAutonomousDatabaseCharacterSetsResponse response) {
            super(context, (Object)response);
        }

        private static ListAutonomousDatabaseCharacterSetsPage createEmptyPage() {
            return new ListAutonomousDatabaseCharacterSetsPage(null, null);
        }

        protected ListAutonomousDatabaseCharacterSetsPage createPage(PageContext<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, AutonomousDatabaseCharacterSet> context, ListAutonomousDatabaseCharacterSetsResponse response) {
            return new ListAutonomousDatabaseCharacterSetsPage(context, response);
        }

        public ApiFuture<ListAutonomousDatabaseCharacterSetsPage> createPageAsync(PageContext<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, AutonomousDatabaseCharacterSet> context, ApiFuture<ListAutonomousDatabaseCharacterSetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAutonomousDatabaseCharacterSetsPagedResponse
    extends AbstractPagedListResponse<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, AutonomousDatabaseCharacterSet, ListAutonomousDatabaseCharacterSetsPage, ListAutonomousDatabaseCharacterSetsFixedSizeCollection> {
        public static ApiFuture<ListAutonomousDatabaseCharacterSetsPagedResponse> createAsync(PageContext<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, AutonomousDatabaseCharacterSet> context, ApiFuture<ListAutonomousDatabaseCharacterSetsResponse> futureResponse) {
            ApiFuture<ListAutonomousDatabaseCharacterSetsPage> futurePage = ListAutonomousDatabaseCharacterSetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAutonomousDatabaseCharacterSetsPagedResponse((ListAutonomousDatabaseCharacterSetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAutonomousDatabaseCharacterSetsPagedResponse(ListAutonomousDatabaseCharacterSetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAutonomousDatabaseCharacterSetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAutonomousDbVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, AutonomousDbVersion, ListAutonomousDbVersionsPage, ListAutonomousDbVersionsFixedSizeCollection> {
        private ListAutonomousDbVersionsFixedSizeCollection(List<ListAutonomousDbVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAutonomousDbVersionsFixedSizeCollection createEmptyCollection() {
            return new ListAutonomousDbVersionsFixedSizeCollection(null, 0);
        }

        protected ListAutonomousDbVersionsFixedSizeCollection createCollection(List<ListAutonomousDbVersionsPage> pages, int collectionSize) {
            return new ListAutonomousDbVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAutonomousDbVersionsPage
    extends AbstractPage<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, AutonomousDbVersion, ListAutonomousDbVersionsPage> {
        private ListAutonomousDbVersionsPage(PageContext<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, AutonomousDbVersion> context, ListAutonomousDbVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListAutonomousDbVersionsPage createEmptyPage() {
            return new ListAutonomousDbVersionsPage(null, null);
        }

        protected ListAutonomousDbVersionsPage createPage(PageContext<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, AutonomousDbVersion> context, ListAutonomousDbVersionsResponse response) {
            return new ListAutonomousDbVersionsPage(context, response);
        }

        public ApiFuture<ListAutonomousDbVersionsPage> createPageAsync(PageContext<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, AutonomousDbVersion> context, ApiFuture<ListAutonomousDbVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAutonomousDbVersionsPagedResponse
    extends AbstractPagedListResponse<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, AutonomousDbVersion, ListAutonomousDbVersionsPage, ListAutonomousDbVersionsFixedSizeCollection> {
        public static ApiFuture<ListAutonomousDbVersionsPagedResponse> createAsync(PageContext<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, AutonomousDbVersion> context, ApiFuture<ListAutonomousDbVersionsResponse> futureResponse) {
            ApiFuture<ListAutonomousDbVersionsPage> futurePage = ListAutonomousDbVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAutonomousDbVersionsPagedResponse((ListAutonomousDbVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAutonomousDbVersionsPagedResponse(ListAutonomousDbVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAutonomousDbVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAutonomousDatabasesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, AutonomousDatabase, ListAutonomousDatabasesPage, ListAutonomousDatabasesFixedSizeCollection> {
        private ListAutonomousDatabasesFixedSizeCollection(List<ListAutonomousDatabasesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAutonomousDatabasesFixedSizeCollection createEmptyCollection() {
            return new ListAutonomousDatabasesFixedSizeCollection(null, 0);
        }

        protected ListAutonomousDatabasesFixedSizeCollection createCollection(List<ListAutonomousDatabasesPage> pages, int collectionSize) {
            return new ListAutonomousDatabasesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAutonomousDatabasesPage
    extends AbstractPage<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, AutonomousDatabase, ListAutonomousDatabasesPage> {
        private ListAutonomousDatabasesPage(PageContext<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, AutonomousDatabase> context, ListAutonomousDatabasesResponse response) {
            super(context, (Object)response);
        }

        private static ListAutonomousDatabasesPage createEmptyPage() {
            return new ListAutonomousDatabasesPage(null, null);
        }

        protected ListAutonomousDatabasesPage createPage(PageContext<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, AutonomousDatabase> context, ListAutonomousDatabasesResponse response) {
            return new ListAutonomousDatabasesPage(context, response);
        }

        public ApiFuture<ListAutonomousDatabasesPage> createPageAsync(PageContext<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, AutonomousDatabase> context, ApiFuture<ListAutonomousDatabasesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAutonomousDatabasesPagedResponse
    extends AbstractPagedListResponse<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, AutonomousDatabase, ListAutonomousDatabasesPage, ListAutonomousDatabasesFixedSizeCollection> {
        public static ApiFuture<ListAutonomousDatabasesPagedResponse> createAsync(PageContext<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, AutonomousDatabase> context, ApiFuture<ListAutonomousDatabasesResponse> futureResponse) {
            ApiFuture<ListAutonomousDatabasesPage> futurePage = ListAutonomousDatabasesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAutonomousDatabasesPagedResponse((ListAutonomousDatabasesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAutonomousDatabasesPagedResponse(ListAutonomousDatabasesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAutonomousDatabasesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDbSystemShapesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDbSystemShapesRequest, ListDbSystemShapesResponse, DbSystemShape, ListDbSystemShapesPage, ListDbSystemShapesFixedSizeCollection> {
        private ListDbSystemShapesFixedSizeCollection(List<ListDbSystemShapesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDbSystemShapesFixedSizeCollection createEmptyCollection() {
            return new ListDbSystemShapesFixedSizeCollection(null, 0);
        }

        protected ListDbSystemShapesFixedSizeCollection createCollection(List<ListDbSystemShapesPage> pages, int collectionSize) {
            return new ListDbSystemShapesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDbSystemShapesPage
    extends AbstractPage<ListDbSystemShapesRequest, ListDbSystemShapesResponse, DbSystemShape, ListDbSystemShapesPage> {
        private ListDbSystemShapesPage(PageContext<ListDbSystemShapesRequest, ListDbSystemShapesResponse, DbSystemShape> context, ListDbSystemShapesResponse response) {
            super(context, (Object)response);
        }

        private static ListDbSystemShapesPage createEmptyPage() {
            return new ListDbSystemShapesPage(null, null);
        }

        protected ListDbSystemShapesPage createPage(PageContext<ListDbSystemShapesRequest, ListDbSystemShapesResponse, DbSystemShape> context, ListDbSystemShapesResponse response) {
            return new ListDbSystemShapesPage(context, response);
        }

        public ApiFuture<ListDbSystemShapesPage> createPageAsync(PageContext<ListDbSystemShapesRequest, ListDbSystemShapesResponse, DbSystemShape> context, ApiFuture<ListDbSystemShapesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDbSystemShapesPagedResponse
    extends AbstractPagedListResponse<ListDbSystemShapesRequest, ListDbSystemShapesResponse, DbSystemShape, ListDbSystemShapesPage, ListDbSystemShapesFixedSizeCollection> {
        public static ApiFuture<ListDbSystemShapesPagedResponse> createAsync(PageContext<ListDbSystemShapesRequest, ListDbSystemShapesResponse, DbSystemShape> context, ApiFuture<ListDbSystemShapesResponse> futureResponse) {
            ApiFuture<ListDbSystemShapesPage> futurePage = ListDbSystemShapesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDbSystemShapesPagedResponse((ListDbSystemShapesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDbSystemShapesPagedResponse(ListDbSystemShapesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDbSystemShapesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGiVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGiVersionsRequest, ListGiVersionsResponse, GiVersion, ListGiVersionsPage, ListGiVersionsFixedSizeCollection> {
        private ListGiVersionsFixedSizeCollection(List<ListGiVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGiVersionsFixedSizeCollection createEmptyCollection() {
            return new ListGiVersionsFixedSizeCollection(null, 0);
        }

        protected ListGiVersionsFixedSizeCollection createCollection(List<ListGiVersionsPage> pages, int collectionSize) {
            return new ListGiVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGiVersionsPage
    extends AbstractPage<ListGiVersionsRequest, ListGiVersionsResponse, GiVersion, ListGiVersionsPage> {
        private ListGiVersionsPage(PageContext<ListGiVersionsRequest, ListGiVersionsResponse, GiVersion> context, ListGiVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListGiVersionsPage createEmptyPage() {
            return new ListGiVersionsPage(null, null);
        }

        protected ListGiVersionsPage createPage(PageContext<ListGiVersionsRequest, ListGiVersionsResponse, GiVersion> context, ListGiVersionsResponse response) {
            return new ListGiVersionsPage(context, response);
        }

        public ApiFuture<ListGiVersionsPage> createPageAsync(PageContext<ListGiVersionsRequest, ListGiVersionsResponse, GiVersion> context, ApiFuture<ListGiVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGiVersionsPagedResponse
    extends AbstractPagedListResponse<ListGiVersionsRequest, ListGiVersionsResponse, GiVersion, ListGiVersionsPage, ListGiVersionsFixedSizeCollection> {
        public static ApiFuture<ListGiVersionsPagedResponse> createAsync(PageContext<ListGiVersionsRequest, ListGiVersionsResponse, GiVersion> context, ApiFuture<ListGiVersionsResponse> futureResponse) {
            ApiFuture<ListGiVersionsPage> futurePage = ListGiVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGiVersionsPagedResponse((ListGiVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGiVersionsPagedResponse(ListGiVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGiVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDbNodesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDbNodesRequest, ListDbNodesResponse, DbNode, ListDbNodesPage, ListDbNodesFixedSizeCollection> {
        private ListDbNodesFixedSizeCollection(List<ListDbNodesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDbNodesFixedSizeCollection createEmptyCollection() {
            return new ListDbNodesFixedSizeCollection(null, 0);
        }

        protected ListDbNodesFixedSizeCollection createCollection(List<ListDbNodesPage> pages, int collectionSize) {
            return new ListDbNodesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDbNodesPage
    extends AbstractPage<ListDbNodesRequest, ListDbNodesResponse, DbNode, ListDbNodesPage> {
        private ListDbNodesPage(PageContext<ListDbNodesRequest, ListDbNodesResponse, DbNode> context, ListDbNodesResponse response) {
            super(context, (Object)response);
        }

        private static ListDbNodesPage createEmptyPage() {
            return new ListDbNodesPage(null, null);
        }

        protected ListDbNodesPage createPage(PageContext<ListDbNodesRequest, ListDbNodesResponse, DbNode> context, ListDbNodesResponse response) {
            return new ListDbNodesPage(context, response);
        }

        public ApiFuture<ListDbNodesPage> createPageAsync(PageContext<ListDbNodesRequest, ListDbNodesResponse, DbNode> context, ApiFuture<ListDbNodesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDbNodesPagedResponse
    extends AbstractPagedListResponse<ListDbNodesRequest, ListDbNodesResponse, DbNode, ListDbNodesPage, ListDbNodesFixedSizeCollection> {
        public static ApiFuture<ListDbNodesPagedResponse> createAsync(PageContext<ListDbNodesRequest, ListDbNodesResponse, DbNode> context, ApiFuture<ListDbNodesResponse> futureResponse) {
            ApiFuture<ListDbNodesPage> futurePage = ListDbNodesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDbNodesPagedResponse((ListDbNodesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDbNodesPagedResponse(ListDbNodesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDbNodesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDbServersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDbServersRequest, ListDbServersResponse, DbServer, ListDbServersPage, ListDbServersFixedSizeCollection> {
        private ListDbServersFixedSizeCollection(List<ListDbServersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDbServersFixedSizeCollection createEmptyCollection() {
            return new ListDbServersFixedSizeCollection(null, 0);
        }

        protected ListDbServersFixedSizeCollection createCollection(List<ListDbServersPage> pages, int collectionSize) {
            return new ListDbServersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDbServersPage
    extends AbstractPage<ListDbServersRequest, ListDbServersResponse, DbServer, ListDbServersPage> {
        private ListDbServersPage(PageContext<ListDbServersRequest, ListDbServersResponse, DbServer> context, ListDbServersResponse response) {
            super(context, (Object)response);
        }

        private static ListDbServersPage createEmptyPage() {
            return new ListDbServersPage(null, null);
        }

        protected ListDbServersPage createPage(PageContext<ListDbServersRequest, ListDbServersResponse, DbServer> context, ListDbServersResponse response) {
            return new ListDbServersPage(context, response);
        }

        public ApiFuture<ListDbServersPage> createPageAsync(PageContext<ListDbServersRequest, ListDbServersResponse, DbServer> context, ApiFuture<ListDbServersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDbServersPagedResponse
    extends AbstractPagedListResponse<ListDbServersRequest, ListDbServersResponse, DbServer, ListDbServersPage, ListDbServersFixedSizeCollection> {
        public static ApiFuture<ListDbServersPagedResponse> createAsync(PageContext<ListDbServersRequest, ListDbServersResponse, DbServer> context, ApiFuture<ListDbServersResponse> futureResponse) {
            ApiFuture<ListDbServersPage> futurePage = ListDbServersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDbServersPagedResponse((ListDbServersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDbServersPagedResponse(ListDbServersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDbServersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEntitlementsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement, ListEntitlementsPage, ListEntitlementsFixedSizeCollection> {
        private ListEntitlementsFixedSizeCollection(List<ListEntitlementsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEntitlementsFixedSizeCollection createEmptyCollection() {
            return new ListEntitlementsFixedSizeCollection(null, 0);
        }

        protected ListEntitlementsFixedSizeCollection createCollection(List<ListEntitlementsPage> pages, int collectionSize) {
            return new ListEntitlementsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEntitlementsPage
    extends AbstractPage<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement, ListEntitlementsPage> {
        private ListEntitlementsPage(PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> context, ListEntitlementsResponse response) {
            super(context, (Object)response);
        }

        private static ListEntitlementsPage createEmptyPage() {
            return new ListEntitlementsPage(null, null);
        }

        protected ListEntitlementsPage createPage(PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> context, ListEntitlementsResponse response) {
            return new ListEntitlementsPage(context, response);
        }

        public ApiFuture<ListEntitlementsPage> createPageAsync(PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> context, ApiFuture<ListEntitlementsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEntitlementsPagedResponse
    extends AbstractPagedListResponse<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement, ListEntitlementsPage, ListEntitlementsFixedSizeCollection> {
        public static ApiFuture<ListEntitlementsPagedResponse> createAsync(PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> context, ApiFuture<ListEntitlementsResponse> futureResponse) {
            ApiFuture<ListEntitlementsPage> futurePage = ListEntitlementsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEntitlementsPagedResponse((ListEntitlementsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEntitlementsPagedResponse(ListEntitlementsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEntitlementsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCloudVmClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCloudVmClustersRequest, ListCloudVmClustersResponse, CloudVmCluster, ListCloudVmClustersPage, ListCloudVmClustersFixedSizeCollection> {
        private ListCloudVmClustersFixedSizeCollection(List<ListCloudVmClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCloudVmClustersFixedSizeCollection createEmptyCollection() {
            return new ListCloudVmClustersFixedSizeCollection(null, 0);
        }

        protected ListCloudVmClustersFixedSizeCollection createCollection(List<ListCloudVmClustersPage> pages, int collectionSize) {
            return new ListCloudVmClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCloudVmClustersPage
    extends AbstractPage<ListCloudVmClustersRequest, ListCloudVmClustersResponse, CloudVmCluster, ListCloudVmClustersPage> {
        private ListCloudVmClustersPage(PageContext<ListCloudVmClustersRequest, ListCloudVmClustersResponse, CloudVmCluster> context, ListCloudVmClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListCloudVmClustersPage createEmptyPage() {
            return new ListCloudVmClustersPage(null, null);
        }

        protected ListCloudVmClustersPage createPage(PageContext<ListCloudVmClustersRequest, ListCloudVmClustersResponse, CloudVmCluster> context, ListCloudVmClustersResponse response) {
            return new ListCloudVmClustersPage(context, response);
        }

        public ApiFuture<ListCloudVmClustersPage> createPageAsync(PageContext<ListCloudVmClustersRequest, ListCloudVmClustersResponse, CloudVmCluster> context, ApiFuture<ListCloudVmClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCloudVmClustersPagedResponse
    extends AbstractPagedListResponse<ListCloudVmClustersRequest, ListCloudVmClustersResponse, CloudVmCluster, ListCloudVmClustersPage, ListCloudVmClustersFixedSizeCollection> {
        public static ApiFuture<ListCloudVmClustersPagedResponse> createAsync(PageContext<ListCloudVmClustersRequest, ListCloudVmClustersResponse, CloudVmCluster> context, ApiFuture<ListCloudVmClustersResponse> futureResponse) {
            ApiFuture<ListCloudVmClustersPage> futurePage = ListCloudVmClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCloudVmClustersPagedResponse((ListCloudVmClustersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCloudVmClustersPagedResponse(ListCloudVmClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCloudVmClustersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCloudExadataInfrastructuresFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, CloudExadataInfrastructure, ListCloudExadataInfrastructuresPage, ListCloudExadataInfrastructuresFixedSizeCollection> {
        private ListCloudExadataInfrastructuresFixedSizeCollection(List<ListCloudExadataInfrastructuresPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCloudExadataInfrastructuresFixedSizeCollection createEmptyCollection() {
            return new ListCloudExadataInfrastructuresFixedSizeCollection(null, 0);
        }

        protected ListCloudExadataInfrastructuresFixedSizeCollection createCollection(List<ListCloudExadataInfrastructuresPage> pages, int collectionSize) {
            return new ListCloudExadataInfrastructuresFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCloudExadataInfrastructuresPage
    extends AbstractPage<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, CloudExadataInfrastructure, ListCloudExadataInfrastructuresPage> {
        private ListCloudExadataInfrastructuresPage(PageContext<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, CloudExadataInfrastructure> context, ListCloudExadataInfrastructuresResponse response) {
            super(context, (Object)response);
        }

        private static ListCloudExadataInfrastructuresPage createEmptyPage() {
            return new ListCloudExadataInfrastructuresPage(null, null);
        }

        protected ListCloudExadataInfrastructuresPage createPage(PageContext<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, CloudExadataInfrastructure> context, ListCloudExadataInfrastructuresResponse response) {
            return new ListCloudExadataInfrastructuresPage(context, response);
        }

        public ApiFuture<ListCloudExadataInfrastructuresPage> createPageAsync(PageContext<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, CloudExadataInfrastructure> context, ApiFuture<ListCloudExadataInfrastructuresResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCloudExadataInfrastructuresPagedResponse
    extends AbstractPagedListResponse<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, CloudExadataInfrastructure, ListCloudExadataInfrastructuresPage, ListCloudExadataInfrastructuresFixedSizeCollection> {
        public static ApiFuture<ListCloudExadataInfrastructuresPagedResponse> createAsync(PageContext<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, CloudExadataInfrastructure> context, ApiFuture<ListCloudExadataInfrastructuresResponse> futureResponse) {
            ApiFuture<ListCloudExadataInfrastructuresPage> futurePage = ListCloudExadataInfrastructuresPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCloudExadataInfrastructuresPagedResponse((ListCloudExadataInfrastructuresPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCloudExadataInfrastructuresPagedResponse(ListCloudExadataInfrastructuresPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCloudExadataInfrastructuresFixedSizeCollection.createEmptyCollection());
        }
    }
}

