/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.optimization.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.optimization.v1.AsyncModelMetadata;
import com.google.cloud.optimization.v1.BatchOptimizeToursRequest;
import com.google.cloud.optimization.v1.BatchOptimizeToursResponse;
import com.google.cloud.optimization.v1.OptimizeToursRequest;
import com.google.cloud.optimization.v1.OptimizeToursResponse;
import com.google.cloud.optimization.v1.stub.FleetRoutingStub;
import com.google.cloud.optimization.v1.stub.FleetRoutingStubSettings;
import com.google.cloud.optimization.v1.stub.HttpJsonFleetRoutingCallableFactory;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonFleetRoutingStub
extends FleetRoutingStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(BatchOptimizeToursResponse.getDescriptor()).add(AsyncModelMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<OptimizeToursRequest, OptimizeToursResponse> optimizeToursMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.optimization.v1.FleetRouting/OptimizeTours").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}:optimizeTours", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*}:optimizeTours"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)OptimizeToursResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchOptimizeToursRequest, Operation> batchOptimizeToursMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.optimization.v1.FleetRouting/BatchOptimizeTours").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}:batchOptimizeTours", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*}:batchOptimizeTours"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<OptimizeToursRequest, OptimizeToursResponse> optimizeToursCallable;
    private final UnaryCallable<BatchOptimizeToursRequest, Operation> batchOptimizeToursCallable;
    private final OperationCallable<BatchOptimizeToursRequest, BatchOptimizeToursResponse, AsyncModelMetadata> batchOptimizeToursOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonFleetRoutingStub create(FleetRoutingStubSettings settings) throws IOException {
        return new HttpJsonFleetRoutingStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonFleetRoutingStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonFleetRoutingStub(FleetRoutingStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonFleetRoutingStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonFleetRoutingStub(FleetRoutingStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonFleetRoutingStub(FleetRoutingStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonFleetRoutingCallableFactory());
    }

    protected HttpJsonFleetRoutingStub(FleetRoutingStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings optimizeToursTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(optimizeToursMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings batchOptimizeToursTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchOptimizeToursMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.optimizeToursCallable = callableFactory.createUnaryCallable(optimizeToursTransportSettings, settings.optimizeToursSettings(), clientContext);
        this.batchOptimizeToursCallable = callableFactory.createUnaryCallable(batchOptimizeToursTransportSettings, settings.batchOptimizeToursSettings(), clientContext);
        this.batchOptimizeToursOperationCallable = callableFactory.createOperationCallable(batchOptimizeToursTransportSettings, settings.batchOptimizeToursOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(optimizeToursMethodDescriptor);
        methodDescriptors.add(batchOptimizeToursMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<OptimizeToursRequest, OptimizeToursResponse> optimizeToursCallable() {
        return this.optimizeToursCallable;
    }

    @Override
    public UnaryCallable<BatchOptimizeToursRequest, Operation> batchOptimizeToursCallable() {
        return this.batchOptimizeToursCallable;
    }

    @Override
    public OperationCallable<BatchOptimizeToursRequest, BatchOptimizeToursResponse, AsyncModelMetadata> batchOptimizeToursOperationCallable() {
        return this.batchOptimizeToursOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

