/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.notebooks.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.notebooks.v1.CreateEnvironmentRequest;
import com.google.cloud.notebooks.v1.CreateExecutionRequest;
import com.google.cloud.notebooks.v1.CreateInstanceRequest;
import com.google.cloud.notebooks.v1.CreateScheduleRequest;
import com.google.cloud.notebooks.v1.DeleteEnvironmentRequest;
import com.google.cloud.notebooks.v1.DeleteExecutionRequest;
import com.google.cloud.notebooks.v1.DeleteInstanceRequest;
import com.google.cloud.notebooks.v1.DeleteScheduleRequest;
import com.google.cloud.notebooks.v1.DiagnoseInstanceRequest;
import com.google.cloud.notebooks.v1.DiagnosticConfig;
import com.google.cloud.notebooks.v1.Environment;
import com.google.cloud.notebooks.v1.Execution;
import com.google.cloud.notebooks.v1.ExecutionName;
import com.google.cloud.notebooks.v1.GetEnvironmentRequest;
import com.google.cloud.notebooks.v1.GetExecutionRequest;
import com.google.cloud.notebooks.v1.GetInstanceHealthRequest;
import com.google.cloud.notebooks.v1.GetInstanceHealthResponse;
import com.google.cloud.notebooks.v1.GetInstanceRequest;
import com.google.cloud.notebooks.v1.GetScheduleRequest;
import com.google.cloud.notebooks.v1.Instance;
import com.google.cloud.notebooks.v1.InstanceName;
import com.google.cloud.notebooks.v1.IsInstanceUpgradeableRequest;
import com.google.cloud.notebooks.v1.IsInstanceUpgradeableResponse;
import com.google.cloud.notebooks.v1.ListEnvironmentsRequest;
import com.google.cloud.notebooks.v1.ListEnvironmentsResponse;
import com.google.cloud.notebooks.v1.ListExecutionsRequest;
import com.google.cloud.notebooks.v1.ListExecutionsResponse;
import com.google.cloud.notebooks.v1.ListInstancesRequest;
import com.google.cloud.notebooks.v1.ListInstancesResponse;
import com.google.cloud.notebooks.v1.ListSchedulesRequest;
import com.google.cloud.notebooks.v1.ListSchedulesResponse;
import com.google.cloud.notebooks.v1.NotebookServiceSettings;
import com.google.cloud.notebooks.v1.OperationMetadata;
import com.google.cloud.notebooks.v1.RegisterInstanceRequest;
import com.google.cloud.notebooks.v1.ReportInstanceInfoRequest;
import com.google.cloud.notebooks.v1.ResetInstanceRequest;
import com.google.cloud.notebooks.v1.RollbackInstanceRequest;
import com.google.cloud.notebooks.v1.Schedule;
import com.google.cloud.notebooks.v1.ScheduleName;
import com.google.cloud.notebooks.v1.SetInstanceAcceleratorRequest;
import com.google.cloud.notebooks.v1.SetInstanceLabelsRequest;
import com.google.cloud.notebooks.v1.SetInstanceMachineTypeRequest;
import com.google.cloud.notebooks.v1.StartInstanceRequest;
import com.google.cloud.notebooks.v1.StopInstanceRequest;
import com.google.cloud.notebooks.v1.TriggerScheduleRequest;
import com.google.cloud.notebooks.v1.UpdateInstanceConfigRequest;
import com.google.cloud.notebooks.v1.UpdateInstanceMetadataItemsRequest;
import com.google.cloud.notebooks.v1.UpdateInstanceMetadataItemsResponse;
import com.google.cloud.notebooks.v1.UpdateShieldedInstanceConfigRequest;
import com.google.cloud.notebooks.v1.UpgradeInstanceInternalRequest;
import com.google.cloud.notebooks.v1.UpgradeInstanceRequest;
import com.google.cloud.notebooks.v1.stub.NotebookServiceStub;
import com.google.cloud.notebooks.v1.stub.NotebookServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class NotebookServiceClient
implements BackgroundResource {
    private final NotebookServiceSettings settings;
    private final NotebookServiceStub stub;
    private final OperationsClient operationsClient;

    public static final NotebookServiceClient create() throws IOException {
        return NotebookServiceClient.create(NotebookServiceSettings.newBuilder().build());
    }

    public static final NotebookServiceClient create(NotebookServiceSettings settings) throws IOException {
        return new NotebookServiceClient(settings);
    }

    public static final NotebookServiceClient create(NotebookServiceStub stub) {
        return new NotebookServiceClient(stub);
    }

    protected NotebookServiceClient(NotebookServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NotebookServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected NotebookServiceClient(NotebookServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final NotebookServiceSettings getSettings() {
        return this.settings;
    }

    public NotebookServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListInstancesPagedResponse listInstances(String parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(ListInstancesRequest request) {
        return (ListInstancesPagedResponse)((Object)this.listInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.stub.listInstancesPagedCallable();
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    public final Instance getInstance(String name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(GetInstanceRequest request) {
        return (Instance)this.getInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.stub.getInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(String parent, Instance instance, String instanceId) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent).setInstance(instance).setInstanceId(instanceId).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(CreateInstanceRequest request) {
        return this.createInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable() {
        return this.stub.createInstanceOperationCallable();
    }

    public final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.stub.createInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> registerInstanceAsync(RegisterInstanceRequest request) {
        return this.registerInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RegisterInstanceRequest, Instance, OperationMetadata> registerInstanceOperationCallable() {
        return this.stub.registerInstanceOperationCallable();
    }

    public final UnaryCallable<RegisterInstanceRequest, Operation> registerInstanceCallable() {
        return this.stub.registerInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> setInstanceAcceleratorAsync(SetInstanceAcceleratorRequest request) {
        return this.setInstanceAcceleratorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetInstanceAcceleratorRequest, Instance, OperationMetadata> setInstanceAcceleratorOperationCallable() {
        return this.stub.setInstanceAcceleratorOperationCallable();
    }

    public final UnaryCallable<SetInstanceAcceleratorRequest, Operation> setInstanceAcceleratorCallable() {
        return this.stub.setInstanceAcceleratorCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> setInstanceMachineTypeAsync(SetInstanceMachineTypeRequest request) {
        return this.setInstanceMachineTypeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetInstanceMachineTypeRequest, Instance, OperationMetadata> setInstanceMachineTypeOperationCallable() {
        return this.stub.setInstanceMachineTypeOperationCallable();
    }

    public final UnaryCallable<SetInstanceMachineTypeRequest, Operation> setInstanceMachineTypeCallable() {
        return this.stub.setInstanceMachineTypeCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> updateInstanceConfigAsync(UpdateInstanceConfigRequest request) {
        return this.updateInstanceConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateInstanceConfigRequest, Instance, OperationMetadata> updateInstanceConfigOperationCallable() {
        return this.stub.updateInstanceConfigOperationCallable();
    }

    public final UnaryCallable<UpdateInstanceConfigRequest, Operation> updateInstanceConfigCallable() {
        return this.stub.updateInstanceConfigCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> updateShieldedInstanceConfigAsync(UpdateShieldedInstanceConfigRequest request) {
        return this.updateShieldedInstanceConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateShieldedInstanceConfigRequest, Instance, OperationMetadata> updateShieldedInstanceConfigOperationCallable() {
        return this.stub.updateShieldedInstanceConfigOperationCallable();
    }

    public final UnaryCallable<UpdateShieldedInstanceConfigRequest, Operation> updateShieldedInstanceConfigCallable() {
        return this.stub.updateShieldedInstanceConfigCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> setInstanceLabelsAsync(SetInstanceLabelsRequest request) {
        return this.setInstanceLabelsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetInstanceLabelsRequest, Instance, OperationMetadata> setInstanceLabelsOperationCallable() {
        return this.stub.setInstanceLabelsOperationCallable();
    }

    public final UnaryCallable<SetInstanceLabelsRequest, Operation> setInstanceLabelsCallable() {
        return this.stub.setInstanceLabelsCallable();
    }

    public final UpdateInstanceMetadataItemsResponse updateInstanceMetadataItems(UpdateInstanceMetadataItemsRequest request) {
        return (UpdateInstanceMetadataItemsResponse)this.updateInstanceMetadataItemsCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateInstanceMetadataItemsRequest, UpdateInstanceMetadataItemsResponse> updateInstanceMetadataItemsCallable() {
        return this.stub.updateInstanceMetadataItemsCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(String name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name).build();
        return this.deleteInstanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(DeleteInstanceRequest request) {
        return this.deleteInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable() {
        return this.stub.deleteInstanceOperationCallable();
    }

    public final UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable() {
        return this.stub.deleteInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> startInstanceAsync(StartInstanceRequest request) {
        return this.startInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StartInstanceRequest, Instance, OperationMetadata> startInstanceOperationCallable() {
        return this.stub.startInstanceOperationCallable();
    }

    public final UnaryCallable<StartInstanceRequest, Operation> startInstanceCallable() {
        return this.stub.startInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> stopInstanceAsync(StopInstanceRequest request) {
        return this.stopInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StopInstanceRequest, Instance, OperationMetadata> stopInstanceOperationCallable() {
        return this.stub.stopInstanceOperationCallable();
    }

    public final UnaryCallable<StopInstanceRequest, Operation> stopInstanceCallable() {
        return this.stub.stopInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> resetInstanceAsync(ResetInstanceRequest request) {
        return this.resetInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResetInstanceRequest, Instance, OperationMetadata> resetInstanceOperationCallable() {
        return this.stub.resetInstanceOperationCallable();
    }

    public final UnaryCallable<ResetInstanceRequest, Operation> resetInstanceCallable() {
        return this.stub.resetInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> reportInstanceInfoAsync(ReportInstanceInfoRequest request) {
        return this.reportInstanceInfoOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ReportInstanceInfoRequest, Instance, OperationMetadata> reportInstanceInfoOperationCallable() {
        return this.stub.reportInstanceInfoOperationCallable();
    }

    public final UnaryCallable<ReportInstanceInfoRequest, Operation> reportInstanceInfoCallable() {
        return this.stub.reportInstanceInfoCallable();
    }

    public final IsInstanceUpgradeableResponse isInstanceUpgradeable(IsInstanceUpgradeableRequest request) {
        return (IsInstanceUpgradeableResponse)this.isInstanceUpgradeableCallable().call((Object)request);
    }

    public final UnaryCallable<IsInstanceUpgradeableRequest, IsInstanceUpgradeableResponse> isInstanceUpgradeableCallable() {
        return this.stub.isInstanceUpgradeableCallable();
    }

    public final GetInstanceHealthResponse getInstanceHealth(InstanceName name) {
        GetInstanceHealthRequest request = GetInstanceHealthRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstanceHealth(request);
    }

    public final GetInstanceHealthResponse getInstanceHealth(String name) {
        GetInstanceHealthRequest request = GetInstanceHealthRequest.newBuilder().setName(name).build();
        return this.getInstanceHealth(request);
    }

    public final GetInstanceHealthResponse getInstanceHealth(GetInstanceHealthRequest request) {
        return (GetInstanceHealthResponse)this.getInstanceHealthCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceHealthRequest, GetInstanceHealthResponse> getInstanceHealthCallable() {
        return this.stub.getInstanceHealthCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> upgradeInstanceAsync(UpgradeInstanceRequest request) {
        return this.upgradeInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationCallable() {
        return this.stub.upgradeInstanceOperationCallable();
    }

    public final UnaryCallable<UpgradeInstanceRequest, Operation> upgradeInstanceCallable() {
        return this.stub.upgradeInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> rollbackInstanceAsync(RollbackInstanceRequest request) {
        return this.rollbackInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RollbackInstanceRequest, Instance, OperationMetadata> rollbackInstanceOperationCallable() {
        return this.stub.rollbackInstanceOperationCallable();
    }

    public final UnaryCallable<RollbackInstanceRequest, Operation> rollbackInstanceCallable() {
        return this.stub.rollbackInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> diagnoseInstanceAsync(InstanceName name, DiagnosticConfig diagnosticConfig) {
        DiagnoseInstanceRequest request = DiagnoseInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).setDiagnosticConfig(diagnosticConfig).build();
        return this.diagnoseInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> diagnoseInstanceAsync(String name, DiagnosticConfig diagnosticConfig) {
        DiagnoseInstanceRequest request = DiagnoseInstanceRequest.newBuilder().setName(name).setDiagnosticConfig(diagnosticConfig).build();
        return this.diagnoseInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> diagnoseInstanceAsync(DiagnoseInstanceRequest request) {
        return this.diagnoseInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DiagnoseInstanceRequest, Instance, OperationMetadata> diagnoseInstanceOperationCallable() {
        return this.stub.diagnoseInstanceOperationCallable();
    }

    public final UnaryCallable<DiagnoseInstanceRequest, Operation> diagnoseInstanceCallable() {
        return this.stub.diagnoseInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> upgradeInstanceInternalAsync(UpgradeInstanceInternalRequest request) {
        return this.upgradeInstanceInternalOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpgradeInstanceInternalRequest, Instance, OperationMetadata> upgradeInstanceInternalOperationCallable() {
        return this.stub.upgradeInstanceInternalOperationCallable();
    }

    public final UnaryCallable<UpgradeInstanceInternalRequest, Operation> upgradeInstanceInternalCallable() {
        return this.stub.upgradeInstanceInternalCallable();
    }

    public final ListEnvironmentsPagedResponse listEnvironments(String parent) {
        ListEnvironmentsRequest request = ListEnvironmentsRequest.newBuilder().setParent(parent).build();
        return this.listEnvironments(request);
    }

    public final ListEnvironmentsPagedResponse listEnvironments(ListEnvironmentsRequest request) {
        return (ListEnvironmentsPagedResponse)((Object)this.listEnvironmentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsPagedResponse> listEnvironmentsPagedCallable() {
        return this.stub.listEnvironmentsPagedCallable();
    }

    public final UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsResponse> listEnvironmentsCallable() {
        return this.stub.listEnvironmentsCallable();
    }

    public final Environment getEnvironment(String name) {
        GetEnvironmentRequest request = GetEnvironmentRequest.newBuilder().setName(name).build();
        return this.getEnvironment(request);
    }

    public final Environment getEnvironment(GetEnvironmentRequest request) {
        return (Environment)this.getEnvironmentCallable().call((Object)request);
    }

    public final UnaryCallable<GetEnvironmentRequest, Environment> getEnvironmentCallable() {
        return this.stub.getEnvironmentCallable();
    }

    public final OperationFuture<Environment, OperationMetadata> createEnvironmentAsync(String parent, Environment environment, String environmentId) {
        CreateEnvironmentRequest request = CreateEnvironmentRequest.newBuilder().setParent(parent).setEnvironment(environment).setEnvironmentId(environmentId).build();
        return this.createEnvironmentAsync(request);
    }

    public final OperationFuture<Environment, OperationMetadata> createEnvironmentAsync(CreateEnvironmentRequest request) {
        return this.createEnvironmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationCallable() {
        return this.stub.createEnvironmentOperationCallable();
    }

    public final UnaryCallable<CreateEnvironmentRequest, Operation> createEnvironmentCallable() {
        return this.stub.createEnvironmentCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEnvironmentAsync(String name) {
        DeleteEnvironmentRequest request = DeleteEnvironmentRequest.newBuilder().setName(name).build();
        return this.deleteEnvironmentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEnvironmentAsync(DeleteEnvironmentRequest request) {
        return this.deleteEnvironmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationCallable() {
        return this.stub.deleteEnvironmentOperationCallable();
    }

    public final UnaryCallable<DeleteEnvironmentRequest, Operation> deleteEnvironmentCallable() {
        return this.stub.deleteEnvironmentCallable();
    }

    public final ListSchedulesPagedResponse listSchedules(ScheduleName parent) {
        ListSchedulesRequest request = ListSchedulesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSchedules(request);
    }

    public final ListSchedulesPagedResponse listSchedules(String parent) {
        ListSchedulesRequest request = ListSchedulesRequest.newBuilder().setParent(parent).build();
        return this.listSchedules(request);
    }

    public final ListSchedulesPagedResponse listSchedules(ListSchedulesRequest request) {
        return (ListSchedulesPagedResponse)((Object)this.listSchedulesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSchedulesRequest, ListSchedulesPagedResponse> listSchedulesPagedCallable() {
        return this.stub.listSchedulesPagedCallable();
    }

    public final UnaryCallable<ListSchedulesRequest, ListSchedulesResponse> listSchedulesCallable() {
        return this.stub.listSchedulesCallable();
    }

    public final Schedule getSchedule(ScheduleName name) {
        GetScheduleRequest request = GetScheduleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSchedule(request);
    }

    public final Schedule getSchedule(String name) {
        GetScheduleRequest request = GetScheduleRequest.newBuilder().setName(name).build();
        return this.getSchedule(request);
    }

    public final Schedule getSchedule(GetScheduleRequest request) {
        return (Schedule)this.getScheduleCallable().call((Object)request);
    }

    public final UnaryCallable<GetScheduleRequest, Schedule> getScheduleCallable() {
        return this.stub.getScheduleCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteScheduleAsync(ScheduleName name) {
        DeleteScheduleRequest request = DeleteScheduleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteScheduleAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteScheduleAsync(String name) {
        DeleteScheduleRequest request = DeleteScheduleRequest.newBuilder().setName(name).build();
        return this.deleteScheduleAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteScheduleAsync(DeleteScheduleRequest request) {
        return this.deleteScheduleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteScheduleRequest, Empty, OperationMetadata> deleteScheduleOperationCallable() {
        return this.stub.deleteScheduleOperationCallable();
    }

    public final UnaryCallable<DeleteScheduleRequest, Operation> deleteScheduleCallable() {
        return this.stub.deleteScheduleCallable();
    }

    public final OperationFuture<Schedule, OperationMetadata> createScheduleAsync(ScheduleName parent, Schedule schedule, String scheduleId) {
        CreateScheduleRequest request = CreateScheduleRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSchedule(schedule).setScheduleId(scheduleId).build();
        return this.createScheduleAsync(request);
    }

    public final OperationFuture<Schedule, OperationMetadata> createScheduleAsync(String parent, Schedule schedule, String scheduleId) {
        CreateScheduleRequest request = CreateScheduleRequest.newBuilder().setParent(parent).setSchedule(schedule).setScheduleId(scheduleId).build();
        return this.createScheduleAsync(request);
    }

    public final OperationFuture<Schedule, OperationMetadata> createScheduleAsync(CreateScheduleRequest request) {
        return this.createScheduleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateScheduleRequest, Schedule, OperationMetadata> createScheduleOperationCallable() {
        return this.stub.createScheduleOperationCallable();
    }

    public final UnaryCallable<CreateScheduleRequest, Operation> createScheduleCallable() {
        return this.stub.createScheduleCallable();
    }

    public final OperationFuture<Schedule, OperationMetadata> triggerScheduleAsync(TriggerScheduleRequest request) {
        return this.triggerScheduleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<TriggerScheduleRequest, Schedule, OperationMetadata> triggerScheduleOperationCallable() {
        return this.stub.triggerScheduleOperationCallable();
    }

    public final UnaryCallable<TriggerScheduleRequest, Operation> triggerScheduleCallable() {
        return this.stub.triggerScheduleCallable();
    }

    public final ListExecutionsPagedResponse listExecutions(ExecutionName parent) {
        ListExecutionsRequest request = ListExecutionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listExecutions(request);
    }

    public final ListExecutionsPagedResponse listExecutions(String parent) {
        ListExecutionsRequest request = ListExecutionsRequest.newBuilder().setParent(parent).build();
        return this.listExecutions(request);
    }

    public final ListExecutionsPagedResponse listExecutions(ListExecutionsRequest request) {
        return (ListExecutionsPagedResponse)((Object)this.listExecutionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListExecutionsRequest, ListExecutionsPagedResponse> listExecutionsPagedCallable() {
        return this.stub.listExecutionsPagedCallable();
    }

    public final UnaryCallable<ListExecutionsRequest, ListExecutionsResponse> listExecutionsCallable() {
        return this.stub.listExecutionsCallable();
    }

    public final Execution getExecution(ExecutionName name) {
        GetExecutionRequest request = GetExecutionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getExecution(request);
    }

    public final Execution getExecution(String name) {
        GetExecutionRequest request = GetExecutionRequest.newBuilder().setName(name).build();
        return this.getExecution(request);
    }

    public final Execution getExecution(GetExecutionRequest request) {
        return (Execution)this.getExecutionCallable().call((Object)request);
    }

    public final UnaryCallable<GetExecutionRequest, Execution> getExecutionCallable() {
        return this.stub.getExecutionCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteExecutionAsync(ExecutionName name) {
        DeleteExecutionRequest request = DeleteExecutionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteExecutionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteExecutionAsync(String name) {
        DeleteExecutionRequest request = DeleteExecutionRequest.newBuilder().setName(name).build();
        return this.deleteExecutionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteExecutionAsync(DeleteExecutionRequest request) {
        return this.deleteExecutionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteExecutionRequest, Empty, OperationMetadata> deleteExecutionOperationCallable() {
        return this.stub.deleteExecutionOperationCallable();
    }

    public final UnaryCallable<DeleteExecutionRequest, Operation> deleteExecutionCallable() {
        return this.stub.deleteExecutionCallable();
    }

    public final OperationFuture<Execution, OperationMetadata> createExecutionAsync(ExecutionName parent, Execution execution, String executionId) {
        CreateExecutionRequest request = CreateExecutionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setExecution(execution).setExecutionId(executionId).build();
        return this.createExecutionAsync(request);
    }

    public final OperationFuture<Execution, OperationMetadata> createExecutionAsync(String parent, Execution execution, String executionId) {
        CreateExecutionRequest request = CreateExecutionRequest.newBuilder().setParent(parent).setExecution(execution).setExecutionId(executionId).build();
        return this.createExecutionAsync(request);
    }

    public final OperationFuture<Execution, OperationMetadata> createExecutionAsync(CreateExecutionRequest request) {
        return this.createExecutionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateExecutionRequest, Execution, OperationMetadata> createExecutionOperationCallable() {
        return this.stub.createExecutionOperationCallable();
    }

    public final UnaryCallable<CreateExecutionRequest, Operation> createExecutionCallable() {
        return this.stub.createExecutionCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListExecutionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListExecutionsRequest, ListExecutionsResponse, Execution, ListExecutionsPage, ListExecutionsFixedSizeCollection> {
        private ListExecutionsFixedSizeCollection(List<ListExecutionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListExecutionsFixedSizeCollection createEmptyCollection() {
            return new ListExecutionsFixedSizeCollection(null, 0);
        }

        protected ListExecutionsFixedSizeCollection createCollection(List<ListExecutionsPage> pages, int collectionSize) {
            return new ListExecutionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListExecutionsPage
    extends AbstractPage<ListExecutionsRequest, ListExecutionsResponse, Execution, ListExecutionsPage> {
        private ListExecutionsPage(PageContext<ListExecutionsRequest, ListExecutionsResponse, Execution> context, ListExecutionsResponse response) {
            super(context, (Object)response);
        }

        private static ListExecutionsPage createEmptyPage() {
            return new ListExecutionsPage(null, null);
        }

        protected ListExecutionsPage createPage(PageContext<ListExecutionsRequest, ListExecutionsResponse, Execution> context, ListExecutionsResponse response) {
            return new ListExecutionsPage(context, response);
        }

        public ApiFuture<ListExecutionsPage> createPageAsync(PageContext<ListExecutionsRequest, ListExecutionsResponse, Execution> context, ApiFuture<ListExecutionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListExecutionsPagedResponse
    extends AbstractPagedListResponse<ListExecutionsRequest, ListExecutionsResponse, Execution, ListExecutionsPage, ListExecutionsFixedSizeCollection> {
        public static ApiFuture<ListExecutionsPagedResponse> createAsync(PageContext<ListExecutionsRequest, ListExecutionsResponse, Execution> context, ApiFuture<ListExecutionsResponse> futureResponse) {
            ApiFuture<ListExecutionsPage> futurePage = ListExecutionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListExecutionsPagedResponse((ListExecutionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListExecutionsPagedResponse(ListExecutionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListExecutionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSchedulesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSchedulesRequest, ListSchedulesResponse, Schedule, ListSchedulesPage, ListSchedulesFixedSizeCollection> {
        private ListSchedulesFixedSizeCollection(List<ListSchedulesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSchedulesFixedSizeCollection createEmptyCollection() {
            return new ListSchedulesFixedSizeCollection(null, 0);
        }

        protected ListSchedulesFixedSizeCollection createCollection(List<ListSchedulesPage> pages, int collectionSize) {
            return new ListSchedulesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSchedulesPage
    extends AbstractPage<ListSchedulesRequest, ListSchedulesResponse, Schedule, ListSchedulesPage> {
        private ListSchedulesPage(PageContext<ListSchedulesRequest, ListSchedulesResponse, Schedule> context, ListSchedulesResponse response) {
            super(context, (Object)response);
        }

        private static ListSchedulesPage createEmptyPage() {
            return new ListSchedulesPage(null, null);
        }

        protected ListSchedulesPage createPage(PageContext<ListSchedulesRequest, ListSchedulesResponse, Schedule> context, ListSchedulesResponse response) {
            return new ListSchedulesPage(context, response);
        }

        public ApiFuture<ListSchedulesPage> createPageAsync(PageContext<ListSchedulesRequest, ListSchedulesResponse, Schedule> context, ApiFuture<ListSchedulesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSchedulesPagedResponse
    extends AbstractPagedListResponse<ListSchedulesRequest, ListSchedulesResponse, Schedule, ListSchedulesPage, ListSchedulesFixedSizeCollection> {
        public static ApiFuture<ListSchedulesPagedResponse> createAsync(PageContext<ListSchedulesRequest, ListSchedulesResponse, Schedule> context, ApiFuture<ListSchedulesResponse> futureResponse) {
            ApiFuture<ListSchedulesPage> futurePage = ListSchedulesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSchedulesPagedResponse((ListSchedulesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSchedulesPagedResponse(ListSchedulesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSchedulesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEnvironmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment, ListEnvironmentsPage, ListEnvironmentsFixedSizeCollection> {
        private ListEnvironmentsFixedSizeCollection(List<ListEnvironmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEnvironmentsFixedSizeCollection createEmptyCollection() {
            return new ListEnvironmentsFixedSizeCollection(null, 0);
        }

        protected ListEnvironmentsFixedSizeCollection createCollection(List<ListEnvironmentsPage> pages, int collectionSize) {
            return new ListEnvironmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEnvironmentsPage
    extends AbstractPage<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment, ListEnvironmentsPage> {
        private ListEnvironmentsPage(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ListEnvironmentsResponse response) {
            super(context, (Object)response);
        }

        private static ListEnvironmentsPage createEmptyPage() {
            return new ListEnvironmentsPage(null, null);
        }

        protected ListEnvironmentsPage createPage(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ListEnvironmentsResponse response) {
            return new ListEnvironmentsPage(context, response);
        }

        public ApiFuture<ListEnvironmentsPage> createPageAsync(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ApiFuture<ListEnvironmentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEnvironmentsPagedResponse
    extends AbstractPagedListResponse<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment, ListEnvironmentsPage, ListEnvironmentsFixedSizeCollection> {
        public static ApiFuture<ListEnvironmentsPagedResponse> createAsync(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ApiFuture<ListEnvironmentsResponse> futureResponse) {
            ApiFuture<ListEnvironmentsPage> futurePage = ListEnvironmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEnvironmentsPagedResponse((ListEnvironmentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEnvironmentsPagedResponse(ListEnvironmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEnvironmentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        private ListInstancesFixedSizeCollection(List<ListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesFixedSizeCollection createEmptyCollection() {
            return new ListInstancesFixedSizeCollection(null, 0);
        }

        protected ListInstancesFixedSizeCollection createCollection(List<ListInstancesPage> pages, int collectionSize) {
            return new ListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesPage
    extends AbstractPage<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage> {
        private ListInstancesPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            super(context, (Object)response);
        }

        private static ListInstancesPage createEmptyPage() {
            return new ListInstancesPage(null, null);
        }

        protected ListInstancesPage createPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            return new ListInstancesPage(context, response);
        }

        public ApiFuture<ListInstancesPage> createPageAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesPagedResponse
    extends AbstractPagedListResponse<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        public static ApiFuture<ListInstancesPagedResponse> createAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            ApiFuture<ListInstancesPage> futurePage = ListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInstancesPagedResponse((ListInstancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancesPagedResponse(ListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }
}

