/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.notebooks.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.notebooks.v2.CheckInstanceUpgradabilityRequest;
import com.google.cloud.notebooks.v2.CheckInstanceUpgradabilityResponse;
import com.google.cloud.notebooks.v2.CreateInstanceRequest;
import com.google.cloud.notebooks.v2.DeleteInstanceRequest;
import com.google.cloud.notebooks.v2.DiagnoseInstanceRequest;
import com.google.cloud.notebooks.v2.GetInstanceRequest;
import com.google.cloud.notebooks.v2.Instance;
import com.google.cloud.notebooks.v2.ListInstancesRequest;
import com.google.cloud.notebooks.v2.ListInstancesResponse;
import com.google.cloud.notebooks.v2.NotebookServiceClient;
import com.google.cloud.notebooks.v2.OperationMetadata;
import com.google.cloud.notebooks.v2.ResetInstanceRequest;
import com.google.cloud.notebooks.v2.RollbackInstanceRequest;
import com.google.cloud.notebooks.v2.StartInstanceRequest;
import com.google.cloud.notebooks.v2.StopInstanceRequest;
import com.google.cloud.notebooks.v2.UpdateInstanceRequest;
import com.google.cloud.notebooks.v2.UpgradeInstanceRequest;
import com.google.cloud.notebooks.v2.stub.GrpcNotebookServiceStub;
import com.google.cloud.notebooks.v2.stub.HttpJsonNotebookServiceStub;
import com.google.cloud.notebooks.v2.stub.NotebookServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class NotebookServiceStubSettings
extends StubSettings<NotebookServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListInstancesRequest, ListInstancesResponse, NotebookServiceClient.ListInstancesPagedResponse> listInstancesSettings;
    private final UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings;
    private final UnaryCallSettings<CreateInstanceRequest, Operation> createInstanceSettings;
    private final OperationCallSettings<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings;
    private final UnaryCallSettings<UpdateInstanceRequest, Operation> updateInstanceSettings;
    private final OperationCallSettings<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings;
    private final UnaryCallSettings<DeleteInstanceRequest, Operation> deleteInstanceSettings;
    private final OperationCallSettings<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings;
    private final UnaryCallSettings<StartInstanceRequest, Operation> startInstanceSettings;
    private final OperationCallSettings<StartInstanceRequest, Instance, OperationMetadata> startInstanceOperationSettings;
    private final UnaryCallSettings<StopInstanceRequest, Operation> stopInstanceSettings;
    private final OperationCallSettings<StopInstanceRequest, Instance, OperationMetadata> stopInstanceOperationSettings;
    private final UnaryCallSettings<ResetInstanceRequest, Operation> resetInstanceSettings;
    private final OperationCallSettings<ResetInstanceRequest, Instance, OperationMetadata> resetInstanceOperationSettings;
    private final UnaryCallSettings<CheckInstanceUpgradabilityRequest, CheckInstanceUpgradabilityResponse> checkInstanceUpgradabilitySettings;
    private final UnaryCallSettings<UpgradeInstanceRequest, Operation> upgradeInstanceSettings;
    private final OperationCallSettings<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationSettings;
    private final UnaryCallSettings<RollbackInstanceRequest, Operation> rollbackInstanceSettings;
    private final OperationCallSettings<RollbackInstanceRequest, Instance, OperationMetadata> rollbackInstanceOperationSettings;
    private final UnaryCallSettings<DiagnoseInstanceRequest, Operation> diagnoseInstanceSettings;
    private final OperationCallSettings<DiagnoseInstanceRequest, Instance, OperationMetadata> diagnoseInstanceOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, NotebookServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance> LIST_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance>(){

        public String emptyToken() {
            return "";
        }

        public ListInstancesRequest injectToken(ListInstancesRequest payload, String token) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageToken(token).build();
        }

        public ListInstancesRequest injectPageSize(ListInstancesRequest payload, int pageSize) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInstancesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInstancesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Instance> extractResources(ListInstancesResponse payload) {
            return payload.getInstancesList() == null ? ImmutableList.of() : payload.getInstancesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, NotebookServiceClient.ListInstancesPagedResponse> LIST_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, NotebookServiceClient.ListInstancesPagedResponse>(){

        public ApiFuture<NotebookServiceClient.ListInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstancesRequest, ListInstancesResponse> callable, ListInstancesRequest request, ApiCallContext context, ApiFuture<ListInstancesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NotebookServiceClient.ListInstancesPagedResponse.createAsync((PageContext<ListInstancesRequest, ListInstancesResponse, Instance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, NotebookServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, NotebookServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<NotebookServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NotebookServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListInstancesRequest, ListInstancesResponse, NotebookServiceClient.ListInstancesPagedResponse> listInstancesSettings() {
        return this.listInstancesSettings;
    }

    public UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings() {
        return this.getInstanceSettings;
    }

    public UnaryCallSettings<CreateInstanceRequest, Operation> createInstanceSettings() {
        return this.createInstanceSettings;
    }

    public OperationCallSettings<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings() {
        return this.createInstanceOperationSettings;
    }

    public UnaryCallSettings<UpdateInstanceRequest, Operation> updateInstanceSettings() {
        return this.updateInstanceSettings;
    }

    public OperationCallSettings<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings() {
        return this.updateInstanceOperationSettings;
    }

    public UnaryCallSettings<DeleteInstanceRequest, Operation> deleteInstanceSettings() {
        return this.deleteInstanceSettings;
    }

    public OperationCallSettings<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings() {
        return this.deleteInstanceOperationSettings;
    }

    public UnaryCallSettings<StartInstanceRequest, Operation> startInstanceSettings() {
        return this.startInstanceSettings;
    }

    public OperationCallSettings<StartInstanceRequest, Instance, OperationMetadata> startInstanceOperationSettings() {
        return this.startInstanceOperationSettings;
    }

    public UnaryCallSettings<StopInstanceRequest, Operation> stopInstanceSettings() {
        return this.stopInstanceSettings;
    }

    public OperationCallSettings<StopInstanceRequest, Instance, OperationMetadata> stopInstanceOperationSettings() {
        return this.stopInstanceOperationSettings;
    }

    public UnaryCallSettings<ResetInstanceRequest, Operation> resetInstanceSettings() {
        return this.resetInstanceSettings;
    }

    public OperationCallSettings<ResetInstanceRequest, Instance, OperationMetadata> resetInstanceOperationSettings() {
        return this.resetInstanceOperationSettings;
    }

    public UnaryCallSettings<CheckInstanceUpgradabilityRequest, CheckInstanceUpgradabilityResponse> checkInstanceUpgradabilitySettings() {
        return this.checkInstanceUpgradabilitySettings;
    }

    public UnaryCallSettings<UpgradeInstanceRequest, Operation> upgradeInstanceSettings() {
        return this.upgradeInstanceSettings;
    }

    public OperationCallSettings<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationSettings() {
        return this.upgradeInstanceOperationSettings;
    }

    public UnaryCallSettings<RollbackInstanceRequest, Operation> rollbackInstanceSettings() {
        return this.rollbackInstanceSettings;
    }

    public OperationCallSettings<RollbackInstanceRequest, Instance, OperationMetadata> rollbackInstanceOperationSettings() {
        return this.rollbackInstanceOperationSettings;
    }

    public UnaryCallSettings<DiagnoseInstanceRequest, Operation> diagnoseInstanceSettings() {
        return this.diagnoseInstanceSettings;
    }

    public OperationCallSettings<DiagnoseInstanceRequest, Instance, OperationMetadata> diagnoseInstanceOperationSettings() {
        return this.diagnoseInstanceOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, NotebookServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public NotebookServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcNotebookServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonNotebookServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return NotebookServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "notebooks";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "notebooks.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "notebooks.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return NotebookServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(NotebookServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(NotebookServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return NotebookServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected NotebookServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listInstancesSettings = settingsBuilder.listInstancesSettings().build();
        this.getInstanceSettings = settingsBuilder.getInstanceSettings().build();
        this.createInstanceSettings = settingsBuilder.createInstanceSettings().build();
        this.createInstanceOperationSettings = settingsBuilder.createInstanceOperationSettings().build();
        this.updateInstanceSettings = settingsBuilder.updateInstanceSettings().build();
        this.updateInstanceOperationSettings = settingsBuilder.updateInstanceOperationSettings().build();
        this.deleteInstanceSettings = settingsBuilder.deleteInstanceSettings().build();
        this.deleteInstanceOperationSettings = settingsBuilder.deleteInstanceOperationSettings().build();
        this.startInstanceSettings = settingsBuilder.startInstanceSettings().build();
        this.startInstanceOperationSettings = settingsBuilder.startInstanceOperationSettings().build();
        this.stopInstanceSettings = settingsBuilder.stopInstanceSettings().build();
        this.stopInstanceOperationSettings = settingsBuilder.stopInstanceOperationSettings().build();
        this.resetInstanceSettings = settingsBuilder.resetInstanceSettings().build();
        this.resetInstanceOperationSettings = settingsBuilder.resetInstanceOperationSettings().build();
        this.checkInstanceUpgradabilitySettings = settingsBuilder.checkInstanceUpgradabilitySettings().build();
        this.upgradeInstanceSettings = settingsBuilder.upgradeInstanceSettings().build();
        this.upgradeInstanceOperationSettings = settingsBuilder.upgradeInstanceOperationSettings().build();
        this.rollbackInstanceSettings = settingsBuilder.rollbackInstanceSettings().build();
        this.rollbackInstanceOperationSettings = settingsBuilder.rollbackInstanceOperationSettings().build();
        this.diagnoseInstanceSettings = settingsBuilder.diagnoseInstanceSettings().build();
        this.diagnoseInstanceOperationSettings = settingsBuilder.diagnoseInstanceOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<NotebookServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, NotebookServiceClient.ListInstancesPagedResponse> listInstancesSettings;
        private final UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings;
        private final UnaryCallSettings.Builder<CreateInstanceRequest, Operation> createInstanceSettings;
        private final OperationCallSettings.Builder<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings;
        private final UnaryCallSettings.Builder<UpdateInstanceRequest, Operation> updateInstanceSettings;
        private final OperationCallSettings.Builder<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings;
        private final UnaryCallSettings.Builder<DeleteInstanceRequest, Operation> deleteInstanceSettings;
        private final OperationCallSettings.Builder<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings;
        private final UnaryCallSettings.Builder<StartInstanceRequest, Operation> startInstanceSettings;
        private final OperationCallSettings.Builder<StartInstanceRequest, Instance, OperationMetadata> startInstanceOperationSettings;
        private final UnaryCallSettings.Builder<StopInstanceRequest, Operation> stopInstanceSettings;
        private final OperationCallSettings.Builder<StopInstanceRequest, Instance, OperationMetadata> stopInstanceOperationSettings;
        private final UnaryCallSettings.Builder<ResetInstanceRequest, Operation> resetInstanceSettings;
        private final OperationCallSettings.Builder<ResetInstanceRequest, Instance, OperationMetadata> resetInstanceOperationSettings;
        private final UnaryCallSettings.Builder<CheckInstanceUpgradabilityRequest, CheckInstanceUpgradabilityResponse> checkInstanceUpgradabilitySettings;
        private final UnaryCallSettings.Builder<UpgradeInstanceRequest, Operation> upgradeInstanceSettings;
        private final OperationCallSettings.Builder<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationSettings;
        private final UnaryCallSettings.Builder<RollbackInstanceRequest, Operation> rollbackInstanceSettings;
        private final OperationCallSettings.Builder<RollbackInstanceRequest, Instance, OperationMetadata> rollbackInstanceOperationSettings;
        private final UnaryCallSettings.Builder<DiagnoseInstanceRequest, Operation> diagnoseInstanceSettings;
        private final OperationCallSettings.Builder<DiagnoseInstanceRequest, Instance, OperationMetadata> diagnoseInstanceOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, NotebookServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCES_PAGE_STR_FACT);
            this.getInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.updateInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.deleteInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.startInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.stopInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.stopInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.resetInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resetInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.checkInstanceUpgradabilitySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.upgradeInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.upgradeInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.rollbackInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.rollbackInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.diagnoseInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.diagnoseInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInstancesSettings, this.getInstanceSettings, this.createInstanceSettings, this.updateInstanceSettings, this.deleteInstanceSettings, this.startInstanceSettings, this.stopInstanceSettings, this.resetInstanceSettings, this.checkInstanceUpgradabilitySettings, this.upgradeInstanceSettings, this.rollbackInstanceSettings, this.diagnoseInstanceSettings, (Object[])new UnaryCallSettings.Builder[]{this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(NotebookServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listInstancesSettings = settings.listInstancesSettings.toBuilder();
            this.getInstanceSettings = settings.getInstanceSettings.toBuilder();
            this.createInstanceSettings = settings.createInstanceSettings.toBuilder();
            this.createInstanceOperationSettings = settings.createInstanceOperationSettings.toBuilder();
            this.updateInstanceSettings = settings.updateInstanceSettings.toBuilder();
            this.updateInstanceOperationSettings = settings.updateInstanceOperationSettings.toBuilder();
            this.deleteInstanceSettings = settings.deleteInstanceSettings.toBuilder();
            this.deleteInstanceOperationSettings = settings.deleteInstanceOperationSettings.toBuilder();
            this.startInstanceSettings = settings.startInstanceSettings.toBuilder();
            this.startInstanceOperationSettings = settings.startInstanceOperationSettings.toBuilder();
            this.stopInstanceSettings = settings.stopInstanceSettings.toBuilder();
            this.stopInstanceOperationSettings = settings.stopInstanceOperationSettings.toBuilder();
            this.resetInstanceSettings = settings.resetInstanceSettings.toBuilder();
            this.resetInstanceOperationSettings = settings.resetInstanceOperationSettings.toBuilder();
            this.checkInstanceUpgradabilitySettings = settings.checkInstanceUpgradabilitySettings.toBuilder();
            this.upgradeInstanceSettings = settings.upgradeInstanceSettings.toBuilder();
            this.upgradeInstanceOperationSettings = settings.upgradeInstanceOperationSettings.toBuilder();
            this.rollbackInstanceSettings = settings.rollbackInstanceSettings.toBuilder();
            this.rollbackInstanceOperationSettings = settings.rollbackInstanceOperationSettings.toBuilder();
            this.diagnoseInstanceSettings = settings.diagnoseInstanceSettings.toBuilder();
            this.diagnoseInstanceOperationSettings = settings.diagnoseInstanceOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInstancesSettings, this.getInstanceSettings, this.createInstanceSettings, this.updateInstanceSettings, this.deleteInstanceSettings, this.startInstanceSettings, this.stopInstanceSettings, this.resetInstanceSettings, this.checkInstanceUpgradabilitySettings, this.upgradeInstanceSettings, this.rollbackInstanceSettings, this.diagnoseInstanceSettings, (Object[])new UnaryCallSettings.Builder[]{this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(NotebookServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)NotebookServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)NotebookServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(NotebookServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)NotebookServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)NotebookServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)NotebookServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(NotebookServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.startInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.stopInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.resetInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.checkInstanceUpgradabilitySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.upgradeInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.rollbackInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.diagnoseInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.startInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.stopInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.resetInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.upgradeInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.rollbackInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.diagnoseInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, NotebookServiceClient.ListInstancesPagedResponse> listInstancesSettings() {
            return this.listInstancesSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings() {
            return this.getInstanceSettings;
        }

        public UnaryCallSettings.Builder<CreateInstanceRequest, Operation> createInstanceSettings() {
            return this.createInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings() {
            return this.createInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateInstanceRequest, Operation> updateInstanceSettings() {
            return this.updateInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings() {
            return this.updateInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstanceRequest, Operation> deleteInstanceSettings() {
            return this.deleteInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings() {
            return this.deleteInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<StartInstanceRequest, Operation> startInstanceSettings() {
            return this.startInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StartInstanceRequest, Instance, OperationMetadata> startInstanceOperationSettings() {
            return this.startInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<StopInstanceRequest, Operation> stopInstanceSettings() {
            return this.stopInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StopInstanceRequest, Instance, OperationMetadata> stopInstanceOperationSettings() {
            return this.stopInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<ResetInstanceRequest, Operation> resetInstanceSettings() {
            return this.resetInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ResetInstanceRequest, Instance, OperationMetadata> resetInstanceOperationSettings() {
            return this.resetInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<CheckInstanceUpgradabilityRequest, CheckInstanceUpgradabilityResponse> checkInstanceUpgradabilitySettings() {
            return this.checkInstanceUpgradabilitySettings;
        }

        public UnaryCallSettings.Builder<UpgradeInstanceRequest, Operation> upgradeInstanceSettings() {
            return this.upgradeInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationSettings() {
            return this.upgradeInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<RollbackInstanceRequest, Operation> rollbackInstanceSettings() {
            return this.rollbackInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RollbackInstanceRequest, Instance, OperationMetadata> rollbackInstanceOperationSettings() {
            return this.rollbackInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<DiagnoseInstanceRequest, Operation> diagnoseInstanceSettings() {
            return this.diagnoseInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DiagnoseInstanceRequest, Instance, OperationMetadata> diagnoseInstanceOperationSettings() {
            return this.diagnoseInstanceOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, NotebookServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return NotebookServiceStubSettings.getDefaultEndpoint();
        }

        public NotebookServiceStubSettings build() throws IOException {
            return new NotebookServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

