/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.notebooks.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.notebooks.v1.CreateRuntimeRequest;
import com.google.cloud.notebooks.v1.DeleteRuntimeRequest;
import com.google.cloud.notebooks.v1.GetRuntimeRequest;
import com.google.cloud.notebooks.v1.ListRuntimesRequest;
import com.google.cloud.notebooks.v1.ListRuntimesResponse;
import com.google.cloud.notebooks.v1.LocationName;
import com.google.cloud.notebooks.v1.ManagedNotebookServiceSettings;
import com.google.cloud.notebooks.v1.OperationMetadata;
import com.google.cloud.notebooks.v1.ReportRuntimeEventRequest;
import com.google.cloud.notebooks.v1.ResetRuntimeRequest;
import com.google.cloud.notebooks.v1.Runtime;
import com.google.cloud.notebooks.v1.RuntimeName;
import com.google.cloud.notebooks.v1.StartRuntimeRequest;
import com.google.cloud.notebooks.v1.StopRuntimeRequest;
import com.google.cloud.notebooks.v1.SwitchRuntimeRequest;
import com.google.cloud.notebooks.v1.stub.ManagedNotebookServiceStub;
import com.google.cloud.notebooks.v1.stub.ManagedNotebookServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ManagedNotebookServiceClient
implements BackgroundResource {
    private final ManagedNotebookServiceSettings settings;
    private final ManagedNotebookServiceStub stub;
    private final OperationsClient operationsClient;

    public static final ManagedNotebookServiceClient create() throws IOException {
        return ManagedNotebookServiceClient.create(ManagedNotebookServiceSettings.newBuilder().build());
    }

    public static final ManagedNotebookServiceClient create(ManagedNotebookServiceSettings settings) throws IOException {
        return new ManagedNotebookServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ManagedNotebookServiceClient create(ManagedNotebookServiceStub stub) {
        return new ManagedNotebookServiceClient(stub);
    }

    protected ManagedNotebookServiceClient(ManagedNotebookServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ManagedNotebookServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ManagedNotebookServiceClient(ManagedNotebookServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ManagedNotebookServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ManagedNotebookServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListRuntimesPagedResponse listRuntimes(LocationName parent) {
        ListRuntimesRequest request = ListRuntimesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRuntimes(request);
    }

    public final ListRuntimesPagedResponse listRuntimes(String parent) {
        ListRuntimesRequest request = ListRuntimesRequest.newBuilder().setParent(parent).build();
        return this.listRuntimes(request);
    }

    public final ListRuntimesPagedResponse listRuntimes(ListRuntimesRequest request) {
        return (ListRuntimesPagedResponse)((Object)this.listRuntimesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRuntimesRequest, ListRuntimesPagedResponse> listRuntimesPagedCallable() {
        return this.stub.listRuntimesPagedCallable();
    }

    public final UnaryCallable<ListRuntimesRequest, ListRuntimesResponse> listRuntimesCallable() {
        return this.stub.listRuntimesCallable();
    }

    public final Runtime getRuntime(RuntimeName name) {
        GetRuntimeRequest request = GetRuntimeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRuntime(request);
    }

    public final Runtime getRuntime(String name) {
        GetRuntimeRequest request = GetRuntimeRequest.newBuilder().setName(name).build();
        return this.getRuntime(request);
    }

    public final Runtime getRuntime(GetRuntimeRequest request) {
        return (Runtime)this.getRuntimeCallable().call((Object)request);
    }

    public final UnaryCallable<GetRuntimeRequest, Runtime> getRuntimeCallable() {
        return this.stub.getRuntimeCallable();
    }

    public final OperationFuture<Runtime, OperationMetadata> createRuntimeAsync(RuntimeName parent, String runtimeId, Runtime runtime) {
        CreateRuntimeRequest request = CreateRuntimeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRuntimeId(runtimeId).setRuntime(runtime).build();
        return this.createRuntimeAsync(request);
    }

    public final OperationFuture<Runtime, OperationMetadata> createRuntimeAsync(String parent, String runtimeId, Runtime runtime) {
        CreateRuntimeRequest request = CreateRuntimeRequest.newBuilder().setParent(parent).setRuntimeId(runtimeId).setRuntime(runtime).build();
        return this.createRuntimeAsync(request);
    }

    public final OperationFuture<Runtime, OperationMetadata> createRuntimeAsync(CreateRuntimeRequest request) {
        return this.createRuntimeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateRuntimeRequest, Runtime, OperationMetadata> createRuntimeOperationCallable() {
        return this.stub.createRuntimeOperationCallable();
    }

    public final UnaryCallable<CreateRuntimeRequest, Operation> createRuntimeCallable() {
        return this.stub.createRuntimeCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRuntimeAsync(RuntimeName name) {
        DeleteRuntimeRequest request = DeleteRuntimeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteRuntimeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRuntimeAsync(String name) {
        DeleteRuntimeRequest request = DeleteRuntimeRequest.newBuilder().setName(name).build();
        return this.deleteRuntimeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRuntimeAsync(DeleteRuntimeRequest request) {
        return this.deleteRuntimeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRuntimeRequest, Empty, OperationMetadata> deleteRuntimeOperationCallable() {
        return this.stub.deleteRuntimeOperationCallable();
    }

    public final UnaryCallable<DeleteRuntimeRequest, Operation> deleteRuntimeCallable() {
        return this.stub.deleteRuntimeCallable();
    }

    public final OperationFuture<Runtime, OperationMetadata> startRuntimeAsync(String name) {
        StartRuntimeRequest request = StartRuntimeRequest.newBuilder().setName(name).build();
        return this.startRuntimeAsync(request);
    }

    public final OperationFuture<Runtime, OperationMetadata> startRuntimeAsync(StartRuntimeRequest request) {
        return this.startRuntimeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StartRuntimeRequest, Runtime, OperationMetadata> startRuntimeOperationCallable() {
        return this.stub.startRuntimeOperationCallable();
    }

    public final UnaryCallable<StartRuntimeRequest, Operation> startRuntimeCallable() {
        return this.stub.startRuntimeCallable();
    }

    public final OperationFuture<Runtime, OperationMetadata> stopRuntimeAsync(String name) {
        StopRuntimeRequest request = StopRuntimeRequest.newBuilder().setName(name).build();
        return this.stopRuntimeAsync(request);
    }

    public final OperationFuture<Runtime, OperationMetadata> stopRuntimeAsync(StopRuntimeRequest request) {
        return this.stopRuntimeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StopRuntimeRequest, Runtime, OperationMetadata> stopRuntimeOperationCallable() {
        return this.stub.stopRuntimeOperationCallable();
    }

    public final UnaryCallable<StopRuntimeRequest, Operation> stopRuntimeCallable() {
        return this.stub.stopRuntimeCallable();
    }

    public final OperationFuture<Runtime, OperationMetadata> switchRuntimeAsync(String name) {
        SwitchRuntimeRequest request = SwitchRuntimeRequest.newBuilder().setName(name).build();
        return this.switchRuntimeAsync(request);
    }

    public final OperationFuture<Runtime, OperationMetadata> switchRuntimeAsync(SwitchRuntimeRequest request) {
        return this.switchRuntimeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SwitchRuntimeRequest, Runtime, OperationMetadata> switchRuntimeOperationCallable() {
        return this.stub.switchRuntimeOperationCallable();
    }

    public final UnaryCallable<SwitchRuntimeRequest, Operation> switchRuntimeCallable() {
        return this.stub.switchRuntimeCallable();
    }

    public final OperationFuture<Runtime, OperationMetadata> resetRuntimeAsync(String name) {
        ResetRuntimeRequest request = ResetRuntimeRequest.newBuilder().setName(name).build();
        return this.resetRuntimeAsync(request);
    }

    public final OperationFuture<Runtime, OperationMetadata> resetRuntimeAsync(ResetRuntimeRequest request) {
        return this.resetRuntimeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResetRuntimeRequest, Runtime, OperationMetadata> resetRuntimeOperationCallable() {
        return this.stub.resetRuntimeOperationCallable();
    }

    public final UnaryCallable<ResetRuntimeRequest, Operation> resetRuntimeCallable() {
        return this.stub.resetRuntimeCallable();
    }

    public final OperationFuture<Runtime, OperationMetadata> reportRuntimeEventAsync(RuntimeName name) {
        ReportRuntimeEventRequest request = ReportRuntimeEventRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.reportRuntimeEventAsync(request);
    }

    public final OperationFuture<Runtime, OperationMetadata> reportRuntimeEventAsync(String name) {
        ReportRuntimeEventRequest request = ReportRuntimeEventRequest.newBuilder().setName(name).build();
        return this.reportRuntimeEventAsync(request);
    }

    public final OperationFuture<Runtime, OperationMetadata> reportRuntimeEventAsync(ReportRuntimeEventRequest request) {
        return this.reportRuntimeEventOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ReportRuntimeEventRequest, Runtime, OperationMetadata> reportRuntimeEventOperationCallable() {
        return this.stub.reportRuntimeEventOperationCallable();
    }

    public final UnaryCallable<ReportRuntimeEventRequest, Operation> reportRuntimeEventCallable() {
        return this.stub.reportRuntimeEventCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRuntimesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRuntimesRequest, ListRuntimesResponse, Runtime, ListRuntimesPage, ListRuntimesFixedSizeCollection> {
        private ListRuntimesFixedSizeCollection(List<ListRuntimesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRuntimesFixedSizeCollection createEmptyCollection() {
            return new ListRuntimesFixedSizeCollection(null, 0);
        }

        protected ListRuntimesFixedSizeCollection createCollection(List<ListRuntimesPage> pages, int collectionSize) {
            return new ListRuntimesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRuntimesPage
    extends AbstractPage<ListRuntimesRequest, ListRuntimesResponse, Runtime, ListRuntimesPage> {
        private ListRuntimesPage(PageContext<ListRuntimesRequest, ListRuntimesResponse, Runtime> context, ListRuntimesResponse response) {
            super(context, (Object)response);
        }

        private static ListRuntimesPage createEmptyPage() {
            return new ListRuntimesPage(null, null);
        }

        protected ListRuntimesPage createPage(PageContext<ListRuntimesRequest, ListRuntimesResponse, Runtime> context, ListRuntimesResponse response) {
            return new ListRuntimesPage(context, response);
        }

        public ApiFuture<ListRuntimesPage> createPageAsync(PageContext<ListRuntimesRequest, ListRuntimesResponse, Runtime> context, ApiFuture<ListRuntimesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRuntimesPagedResponse
    extends AbstractPagedListResponse<ListRuntimesRequest, ListRuntimesResponse, Runtime, ListRuntimesPage, ListRuntimesFixedSizeCollection> {
        public static ApiFuture<ListRuntimesPagedResponse> createAsync(PageContext<ListRuntimesRequest, ListRuntimesResponse, Runtime> context, ApiFuture<ListRuntimesResponse> futureResponse) {
            ApiFuture<ListRuntimesPage> futurePage = ListRuntimesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRuntimesPagedResponse((ListRuntimesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRuntimesPagedResponse(ListRuntimesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRuntimesFixedSizeCollection.createEmptyCollection());
        }
    }
}

