/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networkservices.v1.CreateEndpointPolicyRequest;
import com.google.cloud.networkservices.v1.CreateGatewayRequest;
import com.google.cloud.networkservices.v1.CreateGrpcRouteRequest;
import com.google.cloud.networkservices.v1.CreateHttpRouteRequest;
import com.google.cloud.networkservices.v1.CreateMeshRequest;
import com.google.cloud.networkservices.v1.CreateServiceBindingRequest;
import com.google.cloud.networkservices.v1.CreateTcpRouteRequest;
import com.google.cloud.networkservices.v1.CreateTlsRouteRequest;
import com.google.cloud.networkservices.v1.DeleteEndpointPolicyRequest;
import com.google.cloud.networkservices.v1.DeleteGatewayRequest;
import com.google.cloud.networkservices.v1.DeleteGrpcRouteRequest;
import com.google.cloud.networkservices.v1.DeleteHttpRouteRequest;
import com.google.cloud.networkservices.v1.DeleteMeshRequest;
import com.google.cloud.networkservices.v1.DeleteServiceBindingRequest;
import com.google.cloud.networkservices.v1.DeleteTcpRouteRequest;
import com.google.cloud.networkservices.v1.DeleteTlsRouteRequest;
import com.google.cloud.networkservices.v1.EndpointPolicy;
import com.google.cloud.networkservices.v1.Gateway;
import com.google.cloud.networkservices.v1.GetEndpointPolicyRequest;
import com.google.cloud.networkservices.v1.GetGatewayRequest;
import com.google.cloud.networkservices.v1.GetGrpcRouteRequest;
import com.google.cloud.networkservices.v1.GetHttpRouteRequest;
import com.google.cloud.networkservices.v1.GetMeshRequest;
import com.google.cloud.networkservices.v1.GetServiceBindingRequest;
import com.google.cloud.networkservices.v1.GetTcpRouteRequest;
import com.google.cloud.networkservices.v1.GetTlsRouteRequest;
import com.google.cloud.networkservices.v1.GrpcRoute;
import com.google.cloud.networkservices.v1.HttpRoute;
import com.google.cloud.networkservices.v1.ListEndpointPoliciesRequest;
import com.google.cloud.networkservices.v1.ListEndpointPoliciesResponse;
import com.google.cloud.networkservices.v1.ListGatewaysRequest;
import com.google.cloud.networkservices.v1.ListGatewaysResponse;
import com.google.cloud.networkservices.v1.ListGrpcRoutesRequest;
import com.google.cloud.networkservices.v1.ListGrpcRoutesResponse;
import com.google.cloud.networkservices.v1.ListHttpRoutesRequest;
import com.google.cloud.networkservices.v1.ListHttpRoutesResponse;
import com.google.cloud.networkservices.v1.ListMeshesRequest;
import com.google.cloud.networkservices.v1.ListMeshesResponse;
import com.google.cloud.networkservices.v1.ListServiceBindingsRequest;
import com.google.cloud.networkservices.v1.ListServiceBindingsResponse;
import com.google.cloud.networkservices.v1.ListTcpRoutesRequest;
import com.google.cloud.networkservices.v1.ListTcpRoutesResponse;
import com.google.cloud.networkservices.v1.ListTlsRoutesRequest;
import com.google.cloud.networkservices.v1.ListTlsRoutesResponse;
import com.google.cloud.networkservices.v1.Mesh;
import com.google.cloud.networkservices.v1.NetworkServicesClient;
import com.google.cloud.networkservices.v1.OperationMetadata;
import com.google.cloud.networkservices.v1.ServiceBinding;
import com.google.cloud.networkservices.v1.TcpRoute;
import com.google.cloud.networkservices.v1.TlsRoute;
import com.google.cloud.networkservices.v1.UpdateEndpointPolicyRequest;
import com.google.cloud.networkservices.v1.UpdateGatewayRequest;
import com.google.cloud.networkservices.v1.UpdateGrpcRouteRequest;
import com.google.cloud.networkservices.v1.UpdateHttpRouteRequest;
import com.google.cloud.networkservices.v1.UpdateMeshRequest;
import com.google.cloud.networkservices.v1.UpdateTcpRouteRequest;
import com.google.cloud.networkservices.v1.UpdateTlsRouteRequest;
import com.google.cloud.networkservices.v1.stub.GrpcNetworkServicesStub;
import com.google.cloud.networkservices.v1.stub.HttpJsonNetworkServicesStub;
import com.google.cloud.networkservices.v1.stub.NetworkServicesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class NetworkServicesStubSettings
extends StubSettings<NetworkServicesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListEndpointPoliciesRequest, ListEndpointPoliciesResponse, NetworkServicesClient.ListEndpointPoliciesPagedResponse> listEndpointPoliciesSettings;
    private final UnaryCallSettings<GetEndpointPolicyRequest, EndpointPolicy> getEndpointPolicySettings;
    private final UnaryCallSettings<CreateEndpointPolicyRequest, Operation> createEndpointPolicySettings;
    private final OperationCallSettings<CreateEndpointPolicyRequest, EndpointPolicy, OperationMetadata> createEndpointPolicyOperationSettings;
    private final UnaryCallSettings<UpdateEndpointPolicyRequest, Operation> updateEndpointPolicySettings;
    private final OperationCallSettings<UpdateEndpointPolicyRequest, EndpointPolicy, OperationMetadata> updateEndpointPolicyOperationSettings;
    private final UnaryCallSettings<DeleteEndpointPolicyRequest, Operation> deleteEndpointPolicySettings;
    private final OperationCallSettings<DeleteEndpointPolicyRequest, Empty, OperationMetadata> deleteEndpointPolicyOperationSettings;
    private final PagedCallSettings<ListGatewaysRequest, ListGatewaysResponse, NetworkServicesClient.ListGatewaysPagedResponse> listGatewaysSettings;
    private final UnaryCallSettings<GetGatewayRequest, Gateway> getGatewaySettings;
    private final UnaryCallSettings<CreateGatewayRequest, Operation> createGatewaySettings;
    private final OperationCallSettings<CreateGatewayRequest, Gateway, OperationMetadata> createGatewayOperationSettings;
    private final UnaryCallSettings<UpdateGatewayRequest, Operation> updateGatewaySettings;
    private final OperationCallSettings<UpdateGatewayRequest, Gateway, OperationMetadata> updateGatewayOperationSettings;
    private final UnaryCallSettings<DeleteGatewayRequest, Operation> deleteGatewaySettings;
    private final OperationCallSettings<DeleteGatewayRequest, Empty, OperationMetadata> deleteGatewayOperationSettings;
    private final PagedCallSettings<ListGrpcRoutesRequest, ListGrpcRoutesResponse, NetworkServicesClient.ListGrpcRoutesPagedResponse> listGrpcRoutesSettings;
    private final UnaryCallSettings<GetGrpcRouteRequest, GrpcRoute> getGrpcRouteSettings;
    private final UnaryCallSettings<CreateGrpcRouteRequest, Operation> createGrpcRouteSettings;
    private final OperationCallSettings<CreateGrpcRouteRequest, GrpcRoute, OperationMetadata> createGrpcRouteOperationSettings;
    private final UnaryCallSettings<UpdateGrpcRouteRequest, Operation> updateGrpcRouteSettings;
    private final OperationCallSettings<UpdateGrpcRouteRequest, GrpcRoute, OperationMetadata> updateGrpcRouteOperationSettings;
    private final UnaryCallSettings<DeleteGrpcRouteRequest, Operation> deleteGrpcRouteSettings;
    private final OperationCallSettings<DeleteGrpcRouteRequest, Empty, OperationMetadata> deleteGrpcRouteOperationSettings;
    private final PagedCallSettings<ListHttpRoutesRequest, ListHttpRoutesResponse, NetworkServicesClient.ListHttpRoutesPagedResponse> listHttpRoutesSettings;
    private final UnaryCallSettings<GetHttpRouteRequest, HttpRoute> getHttpRouteSettings;
    private final UnaryCallSettings<CreateHttpRouteRequest, Operation> createHttpRouteSettings;
    private final OperationCallSettings<CreateHttpRouteRequest, HttpRoute, OperationMetadata> createHttpRouteOperationSettings;
    private final UnaryCallSettings<UpdateHttpRouteRequest, Operation> updateHttpRouteSettings;
    private final OperationCallSettings<UpdateHttpRouteRequest, HttpRoute, OperationMetadata> updateHttpRouteOperationSettings;
    private final UnaryCallSettings<DeleteHttpRouteRequest, Operation> deleteHttpRouteSettings;
    private final OperationCallSettings<DeleteHttpRouteRequest, Empty, OperationMetadata> deleteHttpRouteOperationSettings;
    private final PagedCallSettings<ListTcpRoutesRequest, ListTcpRoutesResponse, NetworkServicesClient.ListTcpRoutesPagedResponse> listTcpRoutesSettings;
    private final UnaryCallSettings<GetTcpRouteRequest, TcpRoute> getTcpRouteSettings;
    private final UnaryCallSettings<CreateTcpRouteRequest, Operation> createTcpRouteSettings;
    private final OperationCallSettings<CreateTcpRouteRequest, TcpRoute, OperationMetadata> createTcpRouteOperationSettings;
    private final UnaryCallSettings<UpdateTcpRouteRequest, Operation> updateTcpRouteSettings;
    private final OperationCallSettings<UpdateTcpRouteRequest, TcpRoute, OperationMetadata> updateTcpRouteOperationSettings;
    private final UnaryCallSettings<DeleteTcpRouteRequest, Operation> deleteTcpRouteSettings;
    private final OperationCallSettings<DeleteTcpRouteRequest, Empty, OperationMetadata> deleteTcpRouteOperationSettings;
    private final PagedCallSettings<ListTlsRoutesRequest, ListTlsRoutesResponse, NetworkServicesClient.ListTlsRoutesPagedResponse> listTlsRoutesSettings;
    private final UnaryCallSettings<GetTlsRouteRequest, TlsRoute> getTlsRouteSettings;
    private final UnaryCallSettings<CreateTlsRouteRequest, Operation> createTlsRouteSettings;
    private final OperationCallSettings<CreateTlsRouteRequest, TlsRoute, OperationMetadata> createTlsRouteOperationSettings;
    private final UnaryCallSettings<UpdateTlsRouteRequest, Operation> updateTlsRouteSettings;
    private final OperationCallSettings<UpdateTlsRouteRequest, TlsRoute, OperationMetadata> updateTlsRouteOperationSettings;
    private final UnaryCallSettings<DeleteTlsRouteRequest, Operation> deleteTlsRouteSettings;
    private final OperationCallSettings<DeleteTlsRouteRequest, Empty, OperationMetadata> deleteTlsRouteOperationSettings;
    private final PagedCallSettings<ListServiceBindingsRequest, ListServiceBindingsResponse, NetworkServicesClient.ListServiceBindingsPagedResponse> listServiceBindingsSettings;
    private final UnaryCallSettings<GetServiceBindingRequest, ServiceBinding> getServiceBindingSettings;
    private final UnaryCallSettings<CreateServiceBindingRequest, Operation> createServiceBindingSettings;
    private final OperationCallSettings<CreateServiceBindingRequest, ServiceBinding, OperationMetadata> createServiceBindingOperationSettings;
    private final UnaryCallSettings<DeleteServiceBindingRequest, Operation> deleteServiceBindingSettings;
    private final OperationCallSettings<DeleteServiceBindingRequest, Empty, OperationMetadata> deleteServiceBindingOperationSettings;
    private final PagedCallSettings<ListMeshesRequest, ListMeshesResponse, NetworkServicesClient.ListMeshesPagedResponse> listMeshesSettings;
    private final UnaryCallSettings<GetMeshRequest, Mesh> getMeshSettings;
    private final UnaryCallSettings<CreateMeshRequest, Operation> createMeshSettings;
    private final OperationCallSettings<CreateMeshRequest, Mesh, OperationMetadata> createMeshOperationSettings;
    private final UnaryCallSettings<UpdateMeshRequest, Operation> updateMeshSettings;
    private final OperationCallSettings<UpdateMeshRequest, Mesh, OperationMetadata> updateMeshOperationSettings;
    private final UnaryCallSettings<DeleteMeshRequest, Operation> deleteMeshSettings;
    private final OperationCallSettings<DeleteMeshRequest, Empty, OperationMetadata> deleteMeshOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, NetworkServicesClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListEndpointPoliciesRequest, ListEndpointPoliciesResponse, EndpointPolicy> LIST_ENDPOINT_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<ListEndpointPoliciesRequest, ListEndpointPoliciesResponse, EndpointPolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListEndpointPoliciesRequest injectToken(ListEndpointPoliciesRequest payload, String token) {
            return ListEndpointPoliciesRequest.newBuilder((ListEndpointPoliciesRequest)payload).setPageToken(token).build();
        }

        public ListEndpointPoliciesRequest injectPageSize(ListEndpointPoliciesRequest payload, int pageSize) {
            return ListEndpointPoliciesRequest.newBuilder((ListEndpointPoliciesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEndpointPoliciesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEndpointPoliciesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<EndpointPolicy> extractResources(ListEndpointPoliciesResponse payload) {
            return payload.getEndpointPoliciesList();
        }
    };
    private static final PagedListDescriptor<ListGatewaysRequest, ListGatewaysResponse, Gateway> LIST_GATEWAYS_PAGE_STR_DESC = new PagedListDescriptor<ListGatewaysRequest, ListGatewaysResponse, Gateway>(){

        public String emptyToken() {
            return "";
        }

        public ListGatewaysRequest injectToken(ListGatewaysRequest payload, String token) {
            return ListGatewaysRequest.newBuilder((ListGatewaysRequest)payload).setPageToken(token).build();
        }

        public ListGatewaysRequest injectPageSize(ListGatewaysRequest payload, int pageSize) {
            return ListGatewaysRequest.newBuilder((ListGatewaysRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGatewaysRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGatewaysResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Gateway> extractResources(ListGatewaysResponse payload) {
            return payload.getGatewaysList();
        }
    };
    private static final PagedListDescriptor<ListGrpcRoutesRequest, ListGrpcRoutesResponse, GrpcRoute> LIST_GRPC_ROUTES_PAGE_STR_DESC = new PagedListDescriptor<ListGrpcRoutesRequest, ListGrpcRoutesResponse, GrpcRoute>(){

        public String emptyToken() {
            return "";
        }

        public ListGrpcRoutesRequest injectToken(ListGrpcRoutesRequest payload, String token) {
            return ListGrpcRoutesRequest.newBuilder((ListGrpcRoutesRequest)payload).setPageToken(token).build();
        }

        public ListGrpcRoutesRequest injectPageSize(ListGrpcRoutesRequest payload, int pageSize) {
            return ListGrpcRoutesRequest.newBuilder((ListGrpcRoutesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGrpcRoutesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGrpcRoutesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GrpcRoute> extractResources(ListGrpcRoutesResponse payload) {
            return payload.getGrpcRoutesList();
        }
    };
    private static final PagedListDescriptor<ListHttpRoutesRequest, ListHttpRoutesResponse, HttpRoute> LIST_HTTP_ROUTES_PAGE_STR_DESC = new PagedListDescriptor<ListHttpRoutesRequest, ListHttpRoutesResponse, HttpRoute>(){

        public String emptyToken() {
            return "";
        }

        public ListHttpRoutesRequest injectToken(ListHttpRoutesRequest payload, String token) {
            return ListHttpRoutesRequest.newBuilder((ListHttpRoutesRequest)payload).setPageToken(token).build();
        }

        public ListHttpRoutesRequest injectPageSize(ListHttpRoutesRequest payload, int pageSize) {
            return ListHttpRoutesRequest.newBuilder((ListHttpRoutesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListHttpRoutesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListHttpRoutesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<HttpRoute> extractResources(ListHttpRoutesResponse payload) {
            return payload.getHttpRoutesList();
        }
    };
    private static final PagedListDescriptor<ListTcpRoutesRequest, ListTcpRoutesResponse, TcpRoute> LIST_TCP_ROUTES_PAGE_STR_DESC = new PagedListDescriptor<ListTcpRoutesRequest, ListTcpRoutesResponse, TcpRoute>(){

        public String emptyToken() {
            return "";
        }

        public ListTcpRoutesRequest injectToken(ListTcpRoutesRequest payload, String token) {
            return ListTcpRoutesRequest.newBuilder((ListTcpRoutesRequest)payload).setPageToken(token).build();
        }

        public ListTcpRoutesRequest injectPageSize(ListTcpRoutesRequest payload, int pageSize) {
            return ListTcpRoutesRequest.newBuilder((ListTcpRoutesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTcpRoutesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTcpRoutesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TcpRoute> extractResources(ListTcpRoutesResponse payload) {
            return payload.getTcpRoutesList();
        }
    };
    private static final PagedListDescriptor<ListTlsRoutesRequest, ListTlsRoutesResponse, TlsRoute> LIST_TLS_ROUTES_PAGE_STR_DESC = new PagedListDescriptor<ListTlsRoutesRequest, ListTlsRoutesResponse, TlsRoute>(){

        public String emptyToken() {
            return "";
        }

        public ListTlsRoutesRequest injectToken(ListTlsRoutesRequest payload, String token) {
            return ListTlsRoutesRequest.newBuilder((ListTlsRoutesRequest)payload).setPageToken(token).build();
        }

        public ListTlsRoutesRequest injectPageSize(ListTlsRoutesRequest payload, int pageSize) {
            return ListTlsRoutesRequest.newBuilder((ListTlsRoutesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTlsRoutesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTlsRoutesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TlsRoute> extractResources(ListTlsRoutesResponse payload) {
            return payload.getTlsRoutesList();
        }
    };
    private static final PagedListDescriptor<ListServiceBindingsRequest, ListServiceBindingsResponse, ServiceBinding> LIST_SERVICE_BINDINGS_PAGE_STR_DESC = new PagedListDescriptor<ListServiceBindingsRequest, ListServiceBindingsResponse, ServiceBinding>(){

        public String emptyToken() {
            return "";
        }

        public ListServiceBindingsRequest injectToken(ListServiceBindingsRequest payload, String token) {
            return ListServiceBindingsRequest.newBuilder((ListServiceBindingsRequest)payload).setPageToken(token).build();
        }

        public ListServiceBindingsRequest injectPageSize(ListServiceBindingsRequest payload, int pageSize) {
            return ListServiceBindingsRequest.newBuilder((ListServiceBindingsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServiceBindingsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServiceBindingsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ServiceBinding> extractResources(ListServiceBindingsResponse payload) {
            return payload.getServiceBindingsList();
        }
    };
    private static final PagedListDescriptor<ListMeshesRequest, ListMeshesResponse, Mesh> LIST_MESHES_PAGE_STR_DESC = new PagedListDescriptor<ListMeshesRequest, ListMeshesResponse, Mesh>(){

        public String emptyToken() {
            return "";
        }

        public ListMeshesRequest injectToken(ListMeshesRequest payload, String token) {
            return ListMeshesRequest.newBuilder((ListMeshesRequest)payload).setPageToken(token).build();
        }

        public ListMeshesRequest injectPageSize(ListMeshesRequest payload, int pageSize) {
            return ListMeshesRequest.newBuilder((ListMeshesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMeshesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMeshesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Mesh> extractResources(ListMeshesResponse payload) {
            return payload.getMeshesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListEndpointPoliciesRequest, ListEndpointPoliciesResponse, NetworkServicesClient.ListEndpointPoliciesPagedResponse> LIST_ENDPOINT_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<ListEndpointPoliciesRequest, ListEndpointPoliciesResponse, NetworkServicesClient.ListEndpointPoliciesPagedResponse>(){

        public ApiFuture<NetworkServicesClient.ListEndpointPoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<ListEndpointPoliciesRequest, ListEndpointPoliciesResponse> callable, ListEndpointPoliciesRequest request, ApiCallContext context, ApiFuture<ListEndpointPoliciesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENDPOINT_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworkServicesClient.ListEndpointPoliciesPagedResponse.createAsync((PageContext<ListEndpointPoliciesRequest, ListEndpointPoliciesResponse, EndpointPolicy>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListGatewaysRequest, ListGatewaysResponse, NetworkServicesClient.ListGatewaysPagedResponse> LIST_GATEWAYS_PAGE_STR_FACT = new PagedListResponseFactory<ListGatewaysRequest, ListGatewaysResponse, NetworkServicesClient.ListGatewaysPagedResponse>(){

        public ApiFuture<NetworkServicesClient.ListGatewaysPagedResponse> getFuturePagedResponse(UnaryCallable<ListGatewaysRequest, ListGatewaysResponse> callable, ListGatewaysRequest request, ApiCallContext context, ApiFuture<ListGatewaysResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GATEWAYS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworkServicesClient.ListGatewaysPagedResponse.createAsync((PageContext<ListGatewaysRequest, ListGatewaysResponse, Gateway>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListGrpcRoutesRequest, ListGrpcRoutesResponse, NetworkServicesClient.ListGrpcRoutesPagedResponse> LIST_GRPC_ROUTES_PAGE_STR_FACT = new PagedListResponseFactory<ListGrpcRoutesRequest, ListGrpcRoutesResponse, NetworkServicesClient.ListGrpcRoutesPagedResponse>(){

        public ApiFuture<NetworkServicesClient.ListGrpcRoutesPagedResponse> getFuturePagedResponse(UnaryCallable<ListGrpcRoutesRequest, ListGrpcRoutesResponse> callable, ListGrpcRoutesRequest request, ApiCallContext context, ApiFuture<ListGrpcRoutesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GRPC_ROUTES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworkServicesClient.ListGrpcRoutesPagedResponse.createAsync((PageContext<ListGrpcRoutesRequest, ListGrpcRoutesResponse, GrpcRoute>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListHttpRoutesRequest, ListHttpRoutesResponse, NetworkServicesClient.ListHttpRoutesPagedResponse> LIST_HTTP_ROUTES_PAGE_STR_FACT = new PagedListResponseFactory<ListHttpRoutesRequest, ListHttpRoutesResponse, NetworkServicesClient.ListHttpRoutesPagedResponse>(){

        public ApiFuture<NetworkServicesClient.ListHttpRoutesPagedResponse> getFuturePagedResponse(UnaryCallable<ListHttpRoutesRequest, ListHttpRoutesResponse> callable, ListHttpRoutesRequest request, ApiCallContext context, ApiFuture<ListHttpRoutesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_HTTP_ROUTES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworkServicesClient.ListHttpRoutesPagedResponse.createAsync((PageContext<ListHttpRoutesRequest, ListHttpRoutesResponse, HttpRoute>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTcpRoutesRequest, ListTcpRoutesResponse, NetworkServicesClient.ListTcpRoutesPagedResponse> LIST_TCP_ROUTES_PAGE_STR_FACT = new PagedListResponseFactory<ListTcpRoutesRequest, ListTcpRoutesResponse, NetworkServicesClient.ListTcpRoutesPagedResponse>(){

        public ApiFuture<NetworkServicesClient.ListTcpRoutesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTcpRoutesRequest, ListTcpRoutesResponse> callable, ListTcpRoutesRequest request, ApiCallContext context, ApiFuture<ListTcpRoutesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TCP_ROUTES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworkServicesClient.ListTcpRoutesPagedResponse.createAsync((PageContext<ListTcpRoutesRequest, ListTcpRoutesResponse, TcpRoute>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTlsRoutesRequest, ListTlsRoutesResponse, NetworkServicesClient.ListTlsRoutesPagedResponse> LIST_TLS_ROUTES_PAGE_STR_FACT = new PagedListResponseFactory<ListTlsRoutesRequest, ListTlsRoutesResponse, NetworkServicesClient.ListTlsRoutesPagedResponse>(){

        public ApiFuture<NetworkServicesClient.ListTlsRoutesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTlsRoutesRequest, ListTlsRoutesResponse> callable, ListTlsRoutesRequest request, ApiCallContext context, ApiFuture<ListTlsRoutesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TLS_ROUTES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworkServicesClient.ListTlsRoutesPagedResponse.createAsync((PageContext<ListTlsRoutesRequest, ListTlsRoutesResponse, TlsRoute>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListServiceBindingsRequest, ListServiceBindingsResponse, NetworkServicesClient.ListServiceBindingsPagedResponse> LIST_SERVICE_BINDINGS_PAGE_STR_FACT = new PagedListResponseFactory<ListServiceBindingsRequest, ListServiceBindingsResponse, NetworkServicesClient.ListServiceBindingsPagedResponse>(){

        public ApiFuture<NetworkServicesClient.ListServiceBindingsPagedResponse> getFuturePagedResponse(UnaryCallable<ListServiceBindingsRequest, ListServiceBindingsResponse> callable, ListServiceBindingsRequest request, ApiCallContext context, ApiFuture<ListServiceBindingsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICE_BINDINGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworkServicesClient.ListServiceBindingsPagedResponse.createAsync((PageContext<ListServiceBindingsRequest, ListServiceBindingsResponse, ServiceBinding>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListMeshesRequest, ListMeshesResponse, NetworkServicesClient.ListMeshesPagedResponse> LIST_MESHES_PAGE_STR_FACT = new PagedListResponseFactory<ListMeshesRequest, ListMeshesResponse, NetworkServicesClient.ListMeshesPagedResponse>(){

        public ApiFuture<NetworkServicesClient.ListMeshesPagedResponse> getFuturePagedResponse(UnaryCallable<ListMeshesRequest, ListMeshesResponse> callable, ListMeshesRequest request, ApiCallContext context, ApiFuture<ListMeshesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MESHES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworkServicesClient.ListMeshesPagedResponse.createAsync((PageContext<ListMeshesRequest, ListMeshesResponse, Mesh>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, NetworkServicesClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, NetworkServicesClient.ListLocationsPagedResponse>(){

        public ApiFuture<NetworkServicesClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworkServicesClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListEndpointPoliciesRequest, ListEndpointPoliciesResponse, NetworkServicesClient.ListEndpointPoliciesPagedResponse> listEndpointPoliciesSettings() {
        return this.listEndpointPoliciesSettings;
    }

    public UnaryCallSettings<GetEndpointPolicyRequest, EndpointPolicy> getEndpointPolicySettings() {
        return this.getEndpointPolicySettings;
    }

    public UnaryCallSettings<CreateEndpointPolicyRequest, Operation> createEndpointPolicySettings() {
        return this.createEndpointPolicySettings;
    }

    public OperationCallSettings<CreateEndpointPolicyRequest, EndpointPolicy, OperationMetadata> createEndpointPolicyOperationSettings() {
        return this.createEndpointPolicyOperationSettings;
    }

    public UnaryCallSettings<UpdateEndpointPolicyRequest, Operation> updateEndpointPolicySettings() {
        return this.updateEndpointPolicySettings;
    }

    public OperationCallSettings<UpdateEndpointPolicyRequest, EndpointPolicy, OperationMetadata> updateEndpointPolicyOperationSettings() {
        return this.updateEndpointPolicyOperationSettings;
    }

    public UnaryCallSettings<DeleteEndpointPolicyRequest, Operation> deleteEndpointPolicySettings() {
        return this.deleteEndpointPolicySettings;
    }

    public OperationCallSettings<DeleteEndpointPolicyRequest, Empty, OperationMetadata> deleteEndpointPolicyOperationSettings() {
        return this.deleteEndpointPolicyOperationSettings;
    }

    public PagedCallSettings<ListGatewaysRequest, ListGatewaysResponse, NetworkServicesClient.ListGatewaysPagedResponse> listGatewaysSettings() {
        return this.listGatewaysSettings;
    }

    public UnaryCallSettings<GetGatewayRequest, Gateway> getGatewaySettings() {
        return this.getGatewaySettings;
    }

    public UnaryCallSettings<CreateGatewayRequest, Operation> createGatewaySettings() {
        return this.createGatewaySettings;
    }

    public OperationCallSettings<CreateGatewayRequest, Gateway, OperationMetadata> createGatewayOperationSettings() {
        return this.createGatewayOperationSettings;
    }

    public UnaryCallSettings<UpdateGatewayRequest, Operation> updateGatewaySettings() {
        return this.updateGatewaySettings;
    }

    public OperationCallSettings<UpdateGatewayRequest, Gateway, OperationMetadata> updateGatewayOperationSettings() {
        return this.updateGatewayOperationSettings;
    }

    public UnaryCallSettings<DeleteGatewayRequest, Operation> deleteGatewaySettings() {
        return this.deleteGatewaySettings;
    }

    public OperationCallSettings<DeleteGatewayRequest, Empty, OperationMetadata> deleteGatewayOperationSettings() {
        return this.deleteGatewayOperationSettings;
    }

    public PagedCallSettings<ListGrpcRoutesRequest, ListGrpcRoutesResponse, NetworkServicesClient.ListGrpcRoutesPagedResponse> listGrpcRoutesSettings() {
        return this.listGrpcRoutesSettings;
    }

    public UnaryCallSettings<GetGrpcRouteRequest, GrpcRoute> getGrpcRouteSettings() {
        return this.getGrpcRouteSettings;
    }

    public UnaryCallSettings<CreateGrpcRouteRequest, Operation> createGrpcRouteSettings() {
        return this.createGrpcRouteSettings;
    }

    public OperationCallSettings<CreateGrpcRouteRequest, GrpcRoute, OperationMetadata> createGrpcRouteOperationSettings() {
        return this.createGrpcRouteOperationSettings;
    }

    public UnaryCallSettings<UpdateGrpcRouteRequest, Operation> updateGrpcRouteSettings() {
        return this.updateGrpcRouteSettings;
    }

    public OperationCallSettings<UpdateGrpcRouteRequest, GrpcRoute, OperationMetadata> updateGrpcRouteOperationSettings() {
        return this.updateGrpcRouteOperationSettings;
    }

    public UnaryCallSettings<DeleteGrpcRouteRequest, Operation> deleteGrpcRouteSettings() {
        return this.deleteGrpcRouteSettings;
    }

    public OperationCallSettings<DeleteGrpcRouteRequest, Empty, OperationMetadata> deleteGrpcRouteOperationSettings() {
        return this.deleteGrpcRouteOperationSettings;
    }

    public PagedCallSettings<ListHttpRoutesRequest, ListHttpRoutesResponse, NetworkServicesClient.ListHttpRoutesPagedResponse> listHttpRoutesSettings() {
        return this.listHttpRoutesSettings;
    }

    public UnaryCallSettings<GetHttpRouteRequest, HttpRoute> getHttpRouteSettings() {
        return this.getHttpRouteSettings;
    }

    public UnaryCallSettings<CreateHttpRouteRequest, Operation> createHttpRouteSettings() {
        return this.createHttpRouteSettings;
    }

    public OperationCallSettings<CreateHttpRouteRequest, HttpRoute, OperationMetadata> createHttpRouteOperationSettings() {
        return this.createHttpRouteOperationSettings;
    }

    public UnaryCallSettings<UpdateHttpRouteRequest, Operation> updateHttpRouteSettings() {
        return this.updateHttpRouteSettings;
    }

    public OperationCallSettings<UpdateHttpRouteRequest, HttpRoute, OperationMetadata> updateHttpRouteOperationSettings() {
        return this.updateHttpRouteOperationSettings;
    }

    public UnaryCallSettings<DeleteHttpRouteRequest, Operation> deleteHttpRouteSettings() {
        return this.deleteHttpRouteSettings;
    }

    public OperationCallSettings<DeleteHttpRouteRequest, Empty, OperationMetadata> deleteHttpRouteOperationSettings() {
        return this.deleteHttpRouteOperationSettings;
    }

    public PagedCallSettings<ListTcpRoutesRequest, ListTcpRoutesResponse, NetworkServicesClient.ListTcpRoutesPagedResponse> listTcpRoutesSettings() {
        return this.listTcpRoutesSettings;
    }

    public UnaryCallSettings<GetTcpRouteRequest, TcpRoute> getTcpRouteSettings() {
        return this.getTcpRouteSettings;
    }

    public UnaryCallSettings<CreateTcpRouteRequest, Operation> createTcpRouteSettings() {
        return this.createTcpRouteSettings;
    }

    public OperationCallSettings<CreateTcpRouteRequest, TcpRoute, OperationMetadata> createTcpRouteOperationSettings() {
        return this.createTcpRouteOperationSettings;
    }

    public UnaryCallSettings<UpdateTcpRouteRequest, Operation> updateTcpRouteSettings() {
        return this.updateTcpRouteSettings;
    }

    public OperationCallSettings<UpdateTcpRouteRequest, TcpRoute, OperationMetadata> updateTcpRouteOperationSettings() {
        return this.updateTcpRouteOperationSettings;
    }

    public UnaryCallSettings<DeleteTcpRouteRequest, Operation> deleteTcpRouteSettings() {
        return this.deleteTcpRouteSettings;
    }

    public OperationCallSettings<DeleteTcpRouteRequest, Empty, OperationMetadata> deleteTcpRouteOperationSettings() {
        return this.deleteTcpRouteOperationSettings;
    }

    public PagedCallSettings<ListTlsRoutesRequest, ListTlsRoutesResponse, NetworkServicesClient.ListTlsRoutesPagedResponse> listTlsRoutesSettings() {
        return this.listTlsRoutesSettings;
    }

    public UnaryCallSettings<GetTlsRouteRequest, TlsRoute> getTlsRouteSettings() {
        return this.getTlsRouteSettings;
    }

    public UnaryCallSettings<CreateTlsRouteRequest, Operation> createTlsRouteSettings() {
        return this.createTlsRouteSettings;
    }

    public OperationCallSettings<CreateTlsRouteRequest, TlsRoute, OperationMetadata> createTlsRouteOperationSettings() {
        return this.createTlsRouteOperationSettings;
    }

    public UnaryCallSettings<UpdateTlsRouteRequest, Operation> updateTlsRouteSettings() {
        return this.updateTlsRouteSettings;
    }

    public OperationCallSettings<UpdateTlsRouteRequest, TlsRoute, OperationMetadata> updateTlsRouteOperationSettings() {
        return this.updateTlsRouteOperationSettings;
    }

    public UnaryCallSettings<DeleteTlsRouteRequest, Operation> deleteTlsRouteSettings() {
        return this.deleteTlsRouteSettings;
    }

    public OperationCallSettings<DeleteTlsRouteRequest, Empty, OperationMetadata> deleteTlsRouteOperationSettings() {
        return this.deleteTlsRouteOperationSettings;
    }

    public PagedCallSettings<ListServiceBindingsRequest, ListServiceBindingsResponse, NetworkServicesClient.ListServiceBindingsPagedResponse> listServiceBindingsSettings() {
        return this.listServiceBindingsSettings;
    }

    public UnaryCallSettings<GetServiceBindingRequest, ServiceBinding> getServiceBindingSettings() {
        return this.getServiceBindingSettings;
    }

    public UnaryCallSettings<CreateServiceBindingRequest, Operation> createServiceBindingSettings() {
        return this.createServiceBindingSettings;
    }

    public OperationCallSettings<CreateServiceBindingRequest, ServiceBinding, OperationMetadata> createServiceBindingOperationSettings() {
        return this.createServiceBindingOperationSettings;
    }

    public UnaryCallSettings<DeleteServiceBindingRequest, Operation> deleteServiceBindingSettings() {
        return this.deleteServiceBindingSettings;
    }

    public OperationCallSettings<DeleteServiceBindingRequest, Empty, OperationMetadata> deleteServiceBindingOperationSettings() {
        return this.deleteServiceBindingOperationSettings;
    }

    public PagedCallSettings<ListMeshesRequest, ListMeshesResponse, NetworkServicesClient.ListMeshesPagedResponse> listMeshesSettings() {
        return this.listMeshesSettings;
    }

    public UnaryCallSettings<GetMeshRequest, Mesh> getMeshSettings() {
        return this.getMeshSettings;
    }

    public UnaryCallSettings<CreateMeshRequest, Operation> createMeshSettings() {
        return this.createMeshSettings;
    }

    public OperationCallSettings<CreateMeshRequest, Mesh, OperationMetadata> createMeshOperationSettings() {
        return this.createMeshOperationSettings;
    }

    public UnaryCallSettings<UpdateMeshRequest, Operation> updateMeshSettings() {
        return this.updateMeshSettings;
    }

    public OperationCallSettings<UpdateMeshRequest, Mesh, OperationMetadata> updateMeshOperationSettings() {
        return this.updateMeshOperationSettings;
    }

    public UnaryCallSettings<DeleteMeshRequest, Operation> deleteMeshSettings() {
        return this.deleteMeshSettings;
    }

    public OperationCallSettings<DeleteMeshRequest, Empty, OperationMetadata> deleteMeshOperationSettings() {
        return this.deleteMeshOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, NetworkServicesClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public NetworkServicesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcNetworkServicesStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonNetworkServicesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "networkservices";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "networkservices.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "networkservices.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return NetworkServicesStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(NetworkServicesStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(NetworkServicesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return NetworkServicesStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected NetworkServicesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listEndpointPoliciesSettings = settingsBuilder.listEndpointPoliciesSettings().build();
        this.getEndpointPolicySettings = settingsBuilder.getEndpointPolicySettings().build();
        this.createEndpointPolicySettings = settingsBuilder.createEndpointPolicySettings().build();
        this.createEndpointPolicyOperationSettings = settingsBuilder.createEndpointPolicyOperationSettings().build();
        this.updateEndpointPolicySettings = settingsBuilder.updateEndpointPolicySettings().build();
        this.updateEndpointPolicyOperationSettings = settingsBuilder.updateEndpointPolicyOperationSettings().build();
        this.deleteEndpointPolicySettings = settingsBuilder.deleteEndpointPolicySettings().build();
        this.deleteEndpointPolicyOperationSettings = settingsBuilder.deleteEndpointPolicyOperationSettings().build();
        this.listGatewaysSettings = settingsBuilder.listGatewaysSettings().build();
        this.getGatewaySettings = settingsBuilder.getGatewaySettings().build();
        this.createGatewaySettings = settingsBuilder.createGatewaySettings().build();
        this.createGatewayOperationSettings = settingsBuilder.createGatewayOperationSettings().build();
        this.updateGatewaySettings = settingsBuilder.updateGatewaySettings().build();
        this.updateGatewayOperationSettings = settingsBuilder.updateGatewayOperationSettings().build();
        this.deleteGatewaySettings = settingsBuilder.deleteGatewaySettings().build();
        this.deleteGatewayOperationSettings = settingsBuilder.deleteGatewayOperationSettings().build();
        this.listGrpcRoutesSettings = settingsBuilder.listGrpcRoutesSettings().build();
        this.getGrpcRouteSettings = settingsBuilder.getGrpcRouteSettings().build();
        this.createGrpcRouteSettings = settingsBuilder.createGrpcRouteSettings().build();
        this.createGrpcRouteOperationSettings = settingsBuilder.createGrpcRouteOperationSettings().build();
        this.updateGrpcRouteSettings = settingsBuilder.updateGrpcRouteSettings().build();
        this.updateGrpcRouteOperationSettings = settingsBuilder.updateGrpcRouteOperationSettings().build();
        this.deleteGrpcRouteSettings = settingsBuilder.deleteGrpcRouteSettings().build();
        this.deleteGrpcRouteOperationSettings = settingsBuilder.deleteGrpcRouteOperationSettings().build();
        this.listHttpRoutesSettings = settingsBuilder.listHttpRoutesSettings().build();
        this.getHttpRouteSettings = settingsBuilder.getHttpRouteSettings().build();
        this.createHttpRouteSettings = settingsBuilder.createHttpRouteSettings().build();
        this.createHttpRouteOperationSettings = settingsBuilder.createHttpRouteOperationSettings().build();
        this.updateHttpRouteSettings = settingsBuilder.updateHttpRouteSettings().build();
        this.updateHttpRouteOperationSettings = settingsBuilder.updateHttpRouteOperationSettings().build();
        this.deleteHttpRouteSettings = settingsBuilder.deleteHttpRouteSettings().build();
        this.deleteHttpRouteOperationSettings = settingsBuilder.deleteHttpRouteOperationSettings().build();
        this.listTcpRoutesSettings = settingsBuilder.listTcpRoutesSettings().build();
        this.getTcpRouteSettings = settingsBuilder.getTcpRouteSettings().build();
        this.createTcpRouteSettings = settingsBuilder.createTcpRouteSettings().build();
        this.createTcpRouteOperationSettings = settingsBuilder.createTcpRouteOperationSettings().build();
        this.updateTcpRouteSettings = settingsBuilder.updateTcpRouteSettings().build();
        this.updateTcpRouteOperationSettings = settingsBuilder.updateTcpRouteOperationSettings().build();
        this.deleteTcpRouteSettings = settingsBuilder.deleteTcpRouteSettings().build();
        this.deleteTcpRouteOperationSettings = settingsBuilder.deleteTcpRouteOperationSettings().build();
        this.listTlsRoutesSettings = settingsBuilder.listTlsRoutesSettings().build();
        this.getTlsRouteSettings = settingsBuilder.getTlsRouteSettings().build();
        this.createTlsRouteSettings = settingsBuilder.createTlsRouteSettings().build();
        this.createTlsRouteOperationSettings = settingsBuilder.createTlsRouteOperationSettings().build();
        this.updateTlsRouteSettings = settingsBuilder.updateTlsRouteSettings().build();
        this.updateTlsRouteOperationSettings = settingsBuilder.updateTlsRouteOperationSettings().build();
        this.deleteTlsRouteSettings = settingsBuilder.deleteTlsRouteSettings().build();
        this.deleteTlsRouteOperationSettings = settingsBuilder.deleteTlsRouteOperationSettings().build();
        this.listServiceBindingsSettings = settingsBuilder.listServiceBindingsSettings().build();
        this.getServiceBindingSettings = settingsBuilder.getServiceBindingSettings().build();
        this.createServiceBindingSettings = settingsBuilder.createServiceBindingSettings().build();
        this.createServiceBindingOperationSettings = settingsBuilder.createServiceBindingOperationSettings().build();
        this.deleteServiceBindingSettings = settingsBuilder.deleteServiceBindingSettings().build();
        this.deleteServiceBindingOperationSettings = settingsBuilder.deleteServiceBindingOperationSettings().build();
        this.listMeshesSettings = settingsBuilder.listMeshesSettings().build();
        this.getMeshSettings = settingsBuilder.getMeshSettings().build();
        this.createMeshSettings = settingsBuilder.createMeshSettings().build();
        this.createMeshOperationSettings = settingsBuilder.createMeshOperationSettings().build();
        this.updateMeshSettings = settingsBuilder.updateMeshSettings().build();
        this.updateMeshOperationSettings = settingsBuilder.updateMeshOperationSettings().build();
        this.deleteMeshSettings = settingsBuilder.deleteMeshSettings().build();
        this.deleteMeshOperationSettings = settingsBuilder.deleteMeshOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<NetworkServicesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListEndpointPoliciesRequest, ListEndpointPoliciesResponse, NetworkServicesClient.ListEndpointPoliciesPagedResponse> listEndpointPoliciesSettings;
        private final UnaryCallSettings.Builder<GetEndpointPolicyRequest, EndpointPolicy> getEndpointPolicySettings;
        private final UnaryCallSettings.Builder<CreateEndpointPolicyRequest, Operation> createEndpointPolicySettings;
        private final OperationCallSettings.Builder<CreateEndpointPolicyRequest, EndpointPolicy, OperationMetadata> createEndpointPolicyOperationSettings;
        private final UnaryCallSettings.Builder<UpdateEndpointPolicyRequest, Operation> updateEndpointPolicySettings;
        private final OperationCallSettings.Builder<UpdateEndpointPolicyRequest, EndpointPolicy, OperationMetadata> updateEndpointPolicyOperationSettings;
        private final UnaryCallSettings.Builder<DeleteEndpointPolicyRequest, Operation> deleteEndpointPolicySettings;
        private final OperationCallSettings.Builder<DeleteEndpointPolicyRequest, Empty, OperationMetadata> deleteEndpointPolicyOperationSettings;
        private final PagedCallSettings.Builder<ListGatewaysRequest, ListGatewaysResponse, NetworkServicesClient.ListGatewaysPagedResponse> listGatewaysSettings;
        private final UnaryCallSettings.Builder<GetGatewayRequest, Gateway> getGatewaySettings;
        private final UnaryCallSettings.Builder<CreateGatewayRequest, Operation> createGatewaySettings;
        private final OperationCallSettings.Builder<CreateGatewayRequest, Gateway, OperationMetadata> createGatewayOperationSettings;
        private final UnaryCallSettings.Builder<UpdateGatewayRequest, Operation> updateGatewaySettings;
        private final OperationCallSettings.Builder<UpdateGatewayRequest, Gateway, OperationMetadata> updateGatewayOperationSettings;
        private final UnaryCallSettings.Builder<DeleteGatewayRequest, Operation> deleteGatewaySettings;
        private final OperationCallSettings.Builder<DeleteGatewayRequest, Empty, OperationMetadata> deleteGatewayOperationSettings;
        private final PagedCallSettings.Builder<ListGrpcRoutesRequest, ListGrpcRoutesResponse, NetworkServicesClient.ListGrpcRoutesPagedResponse> listGrpcRoutesSettings;
        private final UnaryCallSettings.Builder<GetGrpcRouteRequest, GrpcRoute> getGrpcRouteSettings;
        private final UnaryCallSettings.Builder<CreateGrpcRouteRequest, Operation> createGrpcRouteSettings;
        private final OperationCallSettings.Builder<CreateGrpcRouteRequest, GrpcRoute, OperationMetadata> createGrpcRouteOperationSettings;
        private final UnaryCallSettings.Builder<UpdateGrpcRouteRequest, Operation> updateGrpcRouteSettings;
        private final OperationCallSettings.Builder<UpdateGrpcRouteRequest, GrpcRoute, OperationMetadata> updateGrpcRouteOperationSettings;
        private final UnaryCallSettings.Builder<DeleteGrpcRouteRequest, Operation> deleteGrpcRouteSettings;
        private final OperationCallSettings.Builder<DeleteGrpcRouteRequest, Empty, OperationMetadata> deleteGrpcRouteOperationSettings;
        private final PagedCallSettings.Builder<ListHttpRoutesRequest, ListHttpRoutesResponse, NetworkServicesClient.ListHttpRoutesPagedResponse> listHttpRoutesSettings;
        private final UnaryCallSettings.Builder<GetHttpRouteRequest, HttpRoute> getHttpRouteSettings;
        private final UnaryCallSettings.Builder<CreateHttpRouteRequest, Operation> createHttpRouteSettings;
        private final OperationCallSettings.Builder<CreateHttpRouteRequest, HttpRoute, OperationMetadata> createHttpRouteOperationSettings;
        private final UnaryCallSettings.Builder<UpdateHttpRouteRequest, Operation> updateHttpRouteSettings;
        private final OperationCallSettings.Builder<UpdateHttpRouteRequest, HttpRoute, OperationMetadata> updateHttpRouteOperationSettings;
        private final UnaryCallSettings.Builder<DeleteHttpRouteRequest, Operation> deleteHttpRouteSettings;
        private final OperationCallSettings.Builder<DeleteHttpRouteRequest, Empty, OperationMetadata> deleteHttpRouteOperationSettings;
        private final PagedCallSettings.Builder<ListTcpRoutesRequest, ListTcpRoutesResponse, NetworkServicesClient.ListTcpRoutesPagedResponse> listTcpRoutesSettings;
        private final UnaryCallSettings.Builder<GetTcpRouteRequest, TcpRoute> getTcpRouteSettings;
        private final UnaryCallSettings.Builder<CreateTcpRouteRequest, Operation> createTcpRouteSettings;
        private final OperationCallSettings.Builder<CreateTcpRouteRequest, TcpRoute, OperationMetadata> createTcpRouteOperationSettings;
        private final UnaryCallSettings.Builder<UpdateTcpRouteRequest, Operation> updateTcpRouteSettings;
        private final OperationCallSettings.Builder<UpdateTcpRouteRequest, TcpRoute, OperationMetadata> updateTcpRouteOperationSettings;
        private final UnaryCallSettings.Builder<DeleteTcpRouteRequest, Operation> deleteTcpRouteSettings;
        private final OperationCallSettings.Builder<DeleteTcpRouteRequest, Empty, OperationMetadata> deleteTcpRouteOperationSettings;
        private final PagedCallSettings.Builder<ListTlsRoutesRequest, ListTlsRoutesResponse, NetworkServicesClient.ListTlsRoutesPagedResponse> listTlsRoutesSettings;
        private final UnaryCallSettings.Builder<GetTlsRouteRequest, TlsRoute> getTlsRouteSettings;
        private final UnaryCallSettings.Builder<CreateTlsRouteRequest, Operation> createTlsRouteSettings;
        private final OperationCallSettings.Builder<CreateTlsRouteRequest, TlsRoute, OperationMetadata> createTlsRouteOperationSettings;
        private final UnaryCallSettings.Builder<UpdateTlsRouteRequest, Operation> updateTlsRouteSettings;
        private final OperationCallSettings.Builder<UpdateTlsRouteRequest, TlsRoute, OperationMetadata> updateTlsRouteOperationSettings;
        private final UnaryCallSettings.Builder<DeleteTlsRouteRequest, Operation> deleteTlsRouteSettings;
        private final OperationCallSettings.Builder<DeleteTlsRouteRequest, Empty, OperationMetadata> deleteTlsRouteOperationSettings;
        private final PagedCallSettings.Builder<ListServiceBindingsRequest, ListServiceBindingsResponse, NetworkServicesClient.ListServiceBindingsPagedResponse> listServiceBindingsSettings;
        private final UnaryCallSettings.Builder<GetServiceBindingRequest, ServiceBinding> getServiceBindingSettings;
        private final UnaryCallSettings.Builder<CreateServiceBindingRequest, Operation> createServiceBindingSettings;
        private final OperationCallSettings.Builder<CreateServiceBindingRequest, ServiceBinding, OperationMetadata> createServiceBindingOperationSettings;
        private final UnaryCallSettings.Builder<DeleteServiceBindingRequest, Operation> deleteServiceBindingSettings;
        private final OperationCallSettings.Builder<DeleteServiceBindingRequest, Empty, OperationMetadata> deleteServiceBindingOperationSettings;
        private final PagedCallSettings.Builder<ListMeshesRequest, ListMeshesResponse, NetworkServicesClient.ListMeshesPagedResponse> listMeshesSettings;
        private final UnaryCallSettings.Builder<GetMeshRequest, Mesh> getMeshSettings;
        private final UnaryCallSettings.Builder<CreateMeshRequest, Operation> createMeshSettings;
        private final OperationCallSettings.Builder<CreateMeshRequest, Mesh, OperationMetadata> createMeshOperationSettings;
        private final UnaryCallSettings.Builder<UpdateMeshRequest, Operation> updateMeshSettings;
        private final OperationCallSettings.Builder<UpdateMeshRequest, Mesh, OperationMetadata> updateMeshOperationSettings;
        private final UnaryCallSettings.Builder<DeleteMeshRequest, Operation> deleteMeshSettings;
        private final OperationCallSettings.Builder<DeleteMeshRequest, Empty, OperationMetadata> deleteMeshOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, NetworkServicesClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listEndpointPoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENDPOINT_POLICIES_PAGE_STR_FACT);
            this.getEndpointPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEndpointPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEndpointPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.updateEndpointPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEndpointPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.deleteEndpointPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEndpointPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.listGatewaysSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GATEWAYS_PAGE_STR_FACT);
            this.getGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGatewayOperationSettings = OperationCallSettings.newBuilder();
            this.updateGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGatewayOperationSettings = OperationCallSettings.newBuilder();
            this.deleteGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGatewayOperationSettings = OperationCallSettings.newBuilder();
            this.listGrpcRoutesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GRPC_ROUTES_PAGE_STR_FACT);
            this.getGrpcRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGrpcRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGrpcRouteOperationSettings = OperationCallSettings.newBuilder();
            this.updateGrpcRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGrpcRouteOperationSettings = OperationCallSettings.newBuilder();
            this.deleteGrpcRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGrpcRouteOperationSettings = OperationCallSettings.newBuilder();
            this.listHttpRoutesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_HTTP_ROUTES_PAGE_STR_FACT);
            this.getHttpRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createHttpRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createHttpRouteOperationSettings = OperationCallSettings.newBuilder();
            this.updateHttpRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateHttpRouteOperationSettings = OperationCallSettings.newBuilder();
            this.deleteHttpRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteHttpRouteOperationSettings = OperationCallSettings.newBuilder();
            this.listTcpRoutesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TCP_ROUTES_PAGE_STR_FACT);
            this.getTcpRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTcpRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTcpRouteOperationSettings = OperationCallSettings.newBuilder();
            this.updateTcpRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTcpRouteOperationSettings = OperationCallSettings.newBuilder();
            this.deleteTcpRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTcpRouteOperationSettings = OperationCallSettings.newBuilder();
            this.listTlsRoutesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TLS_ROUTES_PAGE_STR_FACT);
            this.getTlsRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTlsRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTlsRouteOperationSettings = OperationCallSettings.newBuilder();
            this.updateTlsRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTlsRouteOperationSettings = OperationCallSettings.newBuilder();
            this.deleteTlsRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTlsRouteOperationSettings = OperationCallSettings.newBuilder();
            this.listServiceBindingsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICE_BINDINGS_PAGE_STR_FACT);
            this.getServiceBindingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceBindingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceBindingOperationSettings = OperationCallSettings.newBuilder();
            this.deleteServiceBindingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServiceBindingOperationSettings = OperationCallSettings.newBuilder();
            this.listMeshesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MESHES_PAGE_STR_FACT);
            this.getMeshSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMeshSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMeshOperationSettings = OperationCallSettings.newBuilder();
            this.updateMeshSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateMeshOperationSettings = OperationCallSettings.newBuilder();
            this.deleteMeshSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteMeshOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listEndpointPoliciesSettings, this.getEndpointPolicySettings, this.createEndpointPolicySettings, this.updateEndpointPolicySettings, this.deleteEndpointPolicySettings, this.listGatewaysSettings, this.getGatewaySettings, this.createGatewaySettings, this.updateGatewaySettings, this.deleteGatewaySettings, this.listGrpcRoutesSettings, this.getGrpcRouteSettings, (Object[])new UnaryCallSettings.Builder[]{this.createGrpcRouteSettings, this.updateGrpcRouteSettings, this.deleteGrpcRouteSettings, this.listHttpRoutesSettings, this.getHttpRouteSettings, this.createHttpRouteSettings, this.updateHttpRouteSettings, this.deleteHttpRouteSettings, this.listTcpRoutesSettings, this.getTcpRouteSettings, this.createTcpRouteSettings, this.updateTcpRouteSettings, this.deleteTcpRouteSettings, this.listTlsRoutesSettings, this.getTlsRouteSettings, this.createTlsRouteSettings, this.updateTlsRouteSettings, this.deleteTlsRouteSettings, this.listServiceBindingsSettings, this.getServiceBindingSettings, this.createServiceBindingSettings, this.deleteServiceBindingSettings, this.listMeshesSettings, this.getMeshSettings, this.createMeshSettings, this.updateMeshSettings, this.deleteMeshSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(NetworkServicesStubSettings settings) {
            super((StubSettings)settings);
            this.listEndpointPoliciesSettings = settings.listEndpointPoliciesSettings.toBuilder();
            this.getEndpointPolicySettings = settings.getEndpointPolicySettings.toBuilder();
            this.createEndpointPolicySettings = settings.createEndpointPolicySettings.toBuilder();
            this.createEndpointPolicyOperationSettings = settings.createEndpointPolicyOperationSettings.toBuilder();
            this.updateEndpointPolicySettings = settings.updateEndpointPolicySettings.toBuilder();
            this.updateEndpointPolicyOperationSettings = settings.updateEndpointPolicyOperationSettings.toBuilder();
            this.deleteEndpointPolicySettings = settings.deleteEndpointPolicySettings.toBuilder();
            this.deleteEndpointPolicyOperationSettings = settings.deleteEndpointPolicyOperationSettings.toBuilder();
            this.listGatewaysSettings = settings.listGatewaysSettings.toBuilder();
            this.getGatewaySettings = settings.getGatewaySettings.toBuilder();
            this.createGatewaySettings = settings.createGatewaySettings.toBuilder();
            this.createGatewayOperationSettings = settings.createGatewayOperationSettings.toBuilder();
            this.updateGatewaySettings = settings.updateGatewaySettings.toBuilder();
            this.updateGatewayOperationSettings = settings.updateGatewayOperationSettings.toBuilder();
            this.deleteGatewaySettings = settings.deleteGatewaySettings.toBuilder();
            this.deleteGatewayOperationSettings = settings.deleteGatewayOperationSettings.toBuilder();
            this.listGrpcRoutesSettings = settings.listGrpcRoutesSettings.toBuilder();
            this.getGrpcRouteSettings = settings.getGrpcRouteSettings.toBuilder();
            this.createGrpcRouteSettings = settings.createGrpcRouteSettings.toBuilder();
            this.createGrpcRouteOperationSettings = settings.createGrpcRouteOperationSettings.toBuilder();
            this.updateGrpcRouteSettings = settings.updateGrpcRouteSettings.toBuilder();
            this.updateGrpcRouteOperationSettings = settings.updateGrpcRouteOperationSettings.toBuilder();
            this.deleteGrpcRouteSettings = settings.deleteGrpcRouteSettings.toBuilder();
            this.deleteGrpcRouteOperationSettings = settings.deleteGrpcRouteOperationSettings.toBuilder();
            this.listHttpRoutesSettings = settings.listHttpRoutesSettings.toBuilder();
            this.getHttpRouteSettings = settings.getHttpRouteSettings.toBuilder();
            this.createHttpRouteSettings = settings.createHttpRouteSettings.toBuilder();
            this.createHttpRouteOperationSettings = settings.createHttpRouteOperationSettings.toBuilder();
            this.updateHttpRouteSettings = settings.updateHttpRouteSettings.toBuilder();
            this.updateHttpRouteOperationSettings = settings.updateHttpRouteOperationSettings.toBuilder();
            this.deleteHttpRouteSettings = settings.deleteHttpRouteSettings.toBuilder();
            this.deleteHttpRouteOperationSettings = settings.deleteHttpRouteOperationSettings.toBuilder();
            this.listTcpRoutesSettings = settings.listTcpRoutesSettings.toBuilder();
            this.getTcpRouteSettings = settings.getTcpRouteSettings.toBuilder();
            this.createTcpRouteSettings = settings.createTcpRouteSettings.toBuilder();
            this.createTcpRouteOperationSettings = settings.createTcpRouteOperationSettings.toBuilder();
            this.updateTcpRouteSettings = settings.updateTcpRouteSettings.toBuilder();
            this.updateTcpRouteOperationSettings = settings.updateTcpRouteOperationSettings.toBuilder();
            this.deleteTcpRouteSettings = settings.deleteTcpRouteSettings.toBuilder();
            this.deleteTcpRouteOperationSettings = settings.deleteTcpRouteOperationSettings.toBuilder();
            this.listTlsRoutesSettings = settings.listTlsRoutesSettings.toBuilder();
            this.getTlsRouteSettings = settings.getTlsRouteSettings.toBuilder();
            this.createTlsRouteSettings = settings.createTlsRouteSettings.toBuilder();
            this.createTlsRouteOperationSettings = settings.createTlsRouteOperationSettings.toBuilder();
            this.updateTlsRouteSettings = settings.updateTlsRouteSettings.toBuilder();
            this.updateTlsRouteOperationSettings = settings.updateTlsRouteOperationSettings.toBuilder();
            this.deleteTlsRouteSettings = settings.deleteTlsRouteSettings.toBuilder();
            this.deleteTlsRouteOperationSettings = settings.deleteTlsRouteOperationSettings.toBuilder();
            this.listServiceBindingsSettings = settings.listServiceBindingsSettings.toBuilder();
            this.getServiceBindingSettings = settings.getServiceBindingSettings.toBuilder();
            this.createServiceBindingSettings = settings.createServiceBindingSettings.toBuilder();
            this.createServiceBindingOperationSettings = settings.createServiceBindingOperationSettings.toBuilder();
            this.deleteServiceBindingSettings = settings.deleteServiceBindingSettings.toBuilder();
            this.deleteServiceBindingOperationSettings = settings.deleteServiceBindingOperationSettings.toBuilder();
            this.listMeshesSettings = settings.listMeshesSettings.toBuilder();
            this.getMeshSettings = settings.getMeshSettings.toBuilder();
            this.createMeshSettings = settings.createMeshSettings.toBuilder();
            this.createMeshOperationSettings = settings.createMeshOperationSettings.toBuilder();
            this.updateMeshSettings = settings.updateMeshSettings.toBuilder();
            this.updateMeshOperationSettings = settings.updateMeshOperationSettings.toBuilder();
            this.deleteMeshSettings = settings.deleteMeshSettings.toBuilder();
            this.deleteMeshOperationSettings = settings.deleteMeshOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listEndpointPoliciesSettings, this.getEndpointPolicySettings, this.createEndpointPolicySettings, this.updateEndpointPolicySettings, this.deleteEndpointPolicySettings, this.listGatewaysSettings, this.getGatewaySettings, this.createGatewaySettings, this.updateGatewaySettings, this.deleteGatewaySettings, this.listGrpcRoutesSettings, this.getGrpcRouteSettings, (Object[])new UnaryCallSettings.Builder[]{this.createGrpcRouteSettings, this.updateGrpcRouteSettings, this.deleteGrpcRouteSettings, this.listHttpRoutesSettings, this.getHttpRouteSettings, this.createHttpRouteSettings, this.updateHttpRouteSettings, this.deleteHttpRouteSettings, this.listTcpRoutesSettings, this.getTcpRouteSettings, this.createTcpRouteSettings, this.updateTcpRouteSettings, this.deleteTcpRouteSettings, this.listTlsRoutesSettings, this.getTlsRouteSettings, this.createTlsRouteSettings, this.updateTlsRouteSettings, this.deleteTlsRouteSettings, this.listServiceBindingsSettings, this.getServiceBindingSettings, this.createServiceBindingSettings, this.deleteServiceBindingSettings, this.listMeshesSettings, this.getMeshSettings, this.createMeshSettings, this.updateMeshSettings, this.deleteMeshSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(NetworkServicesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)NetworkServicesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)NetworkServicesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(NetworkServicesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)NetworkServicesStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)NetworkServicesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)NetworkServicesStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(NetworkServicesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listEndpointPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getEndpointPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createEndpointPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateEndpointPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteEndpointPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listGatewaysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listGrpcRoutesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getGrpcRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createGrpcRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateGrpcRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteGrpcRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listHttpRoutesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getHttpRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createHttpRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateHttpRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteHttpRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listTcpRoutesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getTcpRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createTcpRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateTcpRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteTcpRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listTlsRoutesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getTlsRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createTlsRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateTlsRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteTlsRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listServiceBindingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getServiceBindingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createServiceBindingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteServiceBindingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listMeshesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getMeshSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createMeshSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateMeshSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteMeshSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createEndpointPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(EndpointPolicy.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateEndpointPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(EndpointPolicy.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteEndpointPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createGatewayOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Gateway.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateGatewayOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Gateway.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteGatewayOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createGrpcRouteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GrpcRoute.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateGrpcRouteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GrpcRoute.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteGrpcRouteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createHttpRouteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(HttpRoute.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateHttpRouteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(HttpRoute.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteHttpRouteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createTcpRouteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(TcpRoute.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateTcpRouteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(TcpRoute.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteTcpRouteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createTlsRouteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(TlsRoute.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateTlsRouteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(TlsRoute.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteTlsRouteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createServiceBindingOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ServiceBinding.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteServiceBindingOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createMeshOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Mesh.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateMeshOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Mesh.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteMeshOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListEndpointPoliciesRequest, ListEndpointPoliciesResponse, NetworkServicesClient.ListEndpointPoliciesPagedResponse> listEndpointPoliciesSettings() {
            return this.listEndpointPoliciesSettings;
        }

        public UnaryCallSettings.Builder<GetEndpointPolicyRequest, EndpointPolicy> getEndpointPolicySettings() {
            return this.getEndpointPolicySettings;
        }

        public UnaryCallSettings.Builder<CreateEndpointPolicyRequest, Operation> createEndpointPolicySettings() {
            return this.createEndpointPolicySettings;
        }

        public OperationCallSettings.Builder<CreateEndpointPolicyRequest, EndpointPolicy, OperationMetadata> createEndpointPolicyOperationSettings() {
            return this.createEndpointPolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateEndpointPolicyRequest, Operation> updateEndpointPolicySettings() {
            return this.updateEndpointPolicySettings;
        }

        public OperationCallSettings.Builder<UpdateEndpointPolicyRequest, EndpointPolicy, OperationMetadata> updateEndpointPolicyOperationSettings() {
            return this.updateEndpointPolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteEndpointPolicyRequest, Operation> deleteEndpointPolicySettings() {
            return this.deleteEndpointPolicySettings;
        }

        public OperationCallSettings.Builder<DeleteEndpointPolicyRequest, Empty, OperationMetadata> deleteEndpointPolicyOperationSettings() {
            return this.deleteEndpointPolicyOperationSettings;
        }

        public PagedCallSettings.Builder<ListGatewaysRequest, ListGatewaysResponse, NetworkServicesClient.ListGatewaysPagedResponse> listGatewaysSettings() {
            return this.listGatewaysSettings;
        }

        public UnaryCallSettings.Builder<GetGatewayRequest, Gateway> getGatewaySettings() {
            return this.getGatewaySettings;
        }

        public UnaryCallSettings.Builder<CreateGatewayRequest, Operation> createGatewaySettings() {
            return this.createGatewaySettings;
        }

        public OperationCallSettings.Builder<CreateGatewayRequest, Gateway, OperationMetadata> createGatewayOperationSettings() {
            return this.createGatewayOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateGatewayRequest, Operation> updateGatewaySettings() {
            return this.updateGatewaySettings;
        }

        public OperationCallSettings.Builder<UpdateGatewayRequest, Gateway, OperationMetadata> updateGatewayOperationSettings() {
            return this.updateGatewayOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteGatewayRequest, Operation> deleteGatewaySettings() {
            return this.deleteGatewaySettings;
        }

        public OperationCallSettings.Builder<DeleteGatewayRequest, Empty, OperationMetadata> deleteGatewayOperationSettings() {
            return this.deleteGatewayOperationSettings;
        }

        public PagedCallSettings.Builder<ListGrpcRoutesRequest, ListGrpcRoutesResponse, NetworkServicesClient.ListGrpcRoutesPagedResponse> listGrpcRoutesSettings() {
            return this.listGrpcRoutesSettings;
        }

        public UnaryCallSettings.Builder<GetGrpcRouteRequest, GrpcRoute> getGrpcRouteSettings() {
            return this.getGrpcRouteSettings;
        }

        public UnaryCallSettings.Builder<CreateGrpcRouteRequest, Operation> createGrpcRouteSettings() {
            return this.createGrpcRouteSettings;
        }

        public OperationCallSettings.Builder<CreateGrpcRouteRequest, GrpcRoute, OperationMetadata> createGrpcRouteOperationSettings() {
            return this.createGrpcRouteOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateGrpcRouteRequest, Operation> updateGrpcRouteSettings() {
            return this.updateGrpcRouteSettings;
        }

        public OperationCallSettings.Builder<UpdateGrpcRouteRequest, GrpcRoute, OperationMetadata> updateGrpcRouteOperationSettings() {
            return this.updateGrpcRouteOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteGrpcRouteRequest, Operation> deleteGrpcRouteSettings() {
            return this.deleteGrpcRouteSettings;
        }

        public OperationCallSettings.Builder<DeleteGrpcRouteRequest, Empty, OperationMetadata> deleteGrpcRouteOperationSettings() {
            return this.deleteGrpcRouteOperationSettings;
        }

        public PagedCallSettings.Builder<ListHttpRoutesRequest, ListHttpRoutesResponse, NetworkServicesClient.ListHttpRoutesPagedResponse> listHttpRoutesSettings() {
            return this.listHttpRoutesSettings;
        }

        public UnaryCallSettings.Builder<GetHttpRouteRequest, HttpRoute> getHttpRouteSettings() {
            return this.getHttpRouteSettings;
        }

        public UnaryCallSettings.Builder<CreateHttpRouteRequest, Operation> createHttpRouteSettings() {
            return this.createHttpRouteSettings;
        }

        public OperationCallSettings.Builder<CreateHttpRouteRequest, HttpRoute, OperationMetadata> createHttpRouteOperationSettings() {
            return this.createHttpRouteOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateHttpRouteRequest, Operation> updateHttpRouteSettings() {
            return this.updateHttpRouteSettings;
        }

        public OperationCallSettings.Builder<UpdateHttpRouteRequest, HttpRoute, OperationMetadata> updateHttpRouteOperationSettings() {
            return this.updateHttpRouteOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteHttpRouteRequest, Operation> deleteHttpRouteSettings() {
            return this.deleteHttpRouteSettings;
        }

        public OperationCallSettings.Builder<DeleteHttpRouteRequest, Empty, OperationMetadata> deleteHttpRouteOperationSettings() {
            return this.deleteHttpRouteOperationSettings;
        }

        public PagedCallSettings.Builder<ListTcpRoutesRequest, ListTcpRoutesResponse, NetworkServicesClient.ListTcpRoutesPagedResponse> listTcpRoutesSettings() {
            return this.listTcpRoutesSettings;
        }

        public UnaryCallSettings.Builder<GetTcpRouteRequest, TcpRoute> getTcpRouteSettings() {
            return this.getTcpRouteSettings;
        }

        public UnaryCallSettings.Builder<CreateTcpRouteRequest, Operation> createTcpRouteSettings() {
            return this.createTcpRouteSettings;
        }

        public OperationCallSettings.Builder<CreateTcpRouteRequest, TcpRoute, OperationMetadata> createTcpRouteOperationSettings() {
            return this.createTcpRouteOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateTcpRouteRequest, Operation> updateTcpRouteSettings() {
            return this.updateTcpRouteSettings;
        }

        public OperationCallSettings.Builder<UpdateTcpRouteRequest, TcpRoute, OperationMetadata> updateTcpRouteOperationSettings() {
            return this.updateTcpRouteOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteTcpRouteRequest, Operation> deleteTcpRouteSettings() {
            return this.deleteTcpRouteSettings;
        }

        public OperationCallSettings.Builder<DeleteTcpRouteRequest, Empty, OperationMetadata> deleteTcpRouteOperationSettings() {
            return this.deleteTcpRouteOperationSettings;
        }

        public PagedCallSettings.Builder<ListTlsRoutesRequest, ListTlsRoutesResponse, NetworkServicesClient.ListTlsRoutesPagedResponse> listTlsRoutesSettings() {
            return this.listTlsRoutesSettings;
        }

        public UnaryCallSettings.Builder<GetTlsRouteRequest, TlsRoute> getTlsRouteSettings() {
            return this.getTlsRouteSettings;
        }

        public UnaryCallSettings.Builder<CreateTlsRouteRequest, Operation> createTlsRouteSettings() {
            return this.createTlsRouteSettings;
        }

        public OperationCallSettings.Builder<CreateTlsRouteRequest, TlsRoute, OperationMetadata> createTlsRouteOperationSettings() {
            return this.createTlsRouteOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateTlsRouteRequest, Operation> updateTlsRouteSettings() {
            return this.updateTlsRouteSettings;
        }

        public OperationCallSettings.Builder<UpdateTlsRouteRequest, TlsRoute, OperationMetadata> updateTlsRouteOperationSettings() {
            return this.updateTlsRouteOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteTlsRouteRequest, Operation> deleteTlsRouteSettings() {
            return this.deleteTlsRouteSettings;
        }

        public OperationCallSettings.Builder<DeleteTlsRouteRequest, Empty, OperationMetadata> deleteTlsRouteOperationSettings() {
            return this.deleteTlsRouteOperationSettings;
        }

        public PagedCallSettings.Builder<ListServiceBindingsRequest, ListServiceBindingsResponse, NetworkServicesClient.ListServiceBindingsPagedResponse> listServiceBindingsSettings() {
            return this.listServiceBindingsSettings;
        }

        public UnaryCallSettings.Builder<GetServiceBindingRequest, ServiceBinding> getServiceBindingSettings() {
            return this.getServiceBindingSettings;
        }

        public UnaryCallSettings.Builder<CreateServiceBindingRequest, Operation> createServiceBindingSettings() {
            return this.createServiceBindingSettings;
        }

        public OperationCallSettings.Builder<CreateServiceBindingRequest, ServiceBinding, OperationMetadata> createServiceBindingOperationSettings() {
            return this.createServiceBindingOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteServiceBindingRequest, Operation> deleteServiceBindingSettings() {
            return this.deleteServiceBindingSettings;
        }

        public OperationCallSettings.Builder<DeleteServiceBindingRequest, Empty, OperationMetadata> deleteServiceBindingOperationSettings() {
            return this.deleteServiceBindingOperationSettings;
        }

        public PagedCallSettings.Builder<ListMeshesRequest, ListMeshesResponse, NetworkServicesClient.ListMeshesPagedResponse> listMeshesSettings() {
            return this.listMeshesSettings;
        }

        public UnaryCallSettings.Builder<GetMeshRequest, Mesh> getMeshSettings() {
            return this.getMeshSettings;
        }

        public UnaryCallSettings.Builder<CreateMeshRequest, Operation> createMeshSettings() {
            return this.createMeshSettings;
        }

        public OperationCallSettings.Builder<CreateMeshRequest, Mesh, OperationMetadata> createMeshOperationSettings() {
            return this.createMeshOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateMeshRequest, Operation> updateMeshSettings() {
            return this.updateMeshSettings;
        }

        public OperationCallSettings.Builder<UpdateMeshRequest, Mesh, OperationMetadata> updateMeshOperationSettings() {
            return this.updateMeshOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteMeshRequest, Operation> deleteMeshSettings() {
            return this.deleteMeshSettings;
        }

        public OperationCallSettings.Builder<DeleteMeshRequest, Empty, OperationMetadata> deleteMeshOperationSettings() {
            return this.deleteMeshOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, NetworkServicesClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public NetworkServicesStubSettings build() throws IOException {
            return new NetworkServicesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

