/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networkconnectivity.v1.AcceptHubSpokeRequest;
import com.google.cloud.networkconnectivity.v1.AcceptHubSpokeResponse;
import com.google.cloud.networkconnectivity.v1.CreateHubRequest;
import com.google.cloud.networkconnectivity.v1.CreateSpokeRequest;
import com.google.cloud.networkconnectivity.v1.DeleteHubRequest;
import com.google.cloud.networkconnectivity.v1.DeleteSpokeRequest;
import com.google.cloud.networkconnectivity.v1.GetGroupRequest;
import com.google.cloud.networkconnectivity.v1.GetHubRequest;
import com.google.cloud.networkconnectivity.v1.GetRouteRequest;
import com.google.cloud.networkconnectivity.v1.GetRouteTableRequest;
import com.google.cloud.networkconnectivity.v1.GetSpokeRequest;
import com.google.cloud.networkconnectivity.v1.Group;
import com.google.cloud.networkconnectivity.v1.Hub;
import com.google.cloud.networkconnectivity.v1.HubServiceClient;
import com.google.cloud.networkconnectivity.v1.HubStatusEntry;
import com.google.cloud.networkconnectivity.v1.ListGroupsRequest;
import com.google.cloud.networkconnectivity.v1.ListGroupsResponse;
import com.google.cloud.networkconnectivity.v1.ListHubSpokesRequest;
import com.google.cloud.networkconnectivity.v1.ListHubSpokesResponse;
import com.google.cloud.networkconnectivity.v1.ListHubsRequest;
import com.google.cloud.networkconnectivity.v1.ListHubsResponse;
import com.google.cloud.networkconnectivity.v1.ListRouteTablesRequest;
import com.google.cloud.networkconnectivity.v1.ListRouteTablesResponse;
import com.google.cloud.networkconnectivity.v1.ListRoutesRequest;
import com.google.cloud.networkconnectivity.v1.ListRoutesResponse;
import com.google.cloud.networkconnectivity.v1.ListSpokesRequest;
import com.google.cloud.networkconnectivity.v1.ListSpokesResponse;
import com.google.cloud.networkconnectivity.v1.OperationMetadata;
import com.google.cloud.networkconnectivity.v1.QueryHubStatusRequest;
import com.google.cloud.networkconnectivity.v1.QueryHubStatusResponse;
import com.google.cloud.networkconnectivity.v1.RejectHubSpokeRequest;
import com.google.cloud.networkconnectivity.v1.RejectHubSpokeResponse;
import com.google.cloud.networkconnectivity.v1.Route;
import com.google.cloud.networkconnectivity.v1.RouteTable;
import com.google.cloud.networkconnectivity.v1.Spoke;
import com.google.cloud.networkconnectivity.v1.UpdateGroupRequest;
import com.google.cloud.networkconnectivity.v1.UpdateHubRequest;
import com.google.cloud.networkconnectivity.v1.UpdateSpokeRequest;
import com.google.cloud.networkconnectivity.v1.stub.GrpcHubServiceStub;
import com.google.cloud.networkconnectivity.v1.stub.HubServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class HubServiceStubSettings
extends StubSettings<HubServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListHubsRequest, ListHubsResponse, HubServiceClient.ListHubsPagedResponse> listHubsSettings;
    private final UnaryCallSettings<GetHubRequest, Hub> getHubSettings;
    private final UnaryCallSettings<CreateHubRequest, Operation> createHubSettings;
    private final OperationCallSettings<CreateHubRequest, Hub, OperationMetadata> createHubOperationSettings;
    private final UnaryCallSettings<UpdateHubRequest, Operation> updateHubSettings;
    private final OperationCallSettings<UpdateHubRequest, Hub, OperationMetadata> updateHubOperationSettings;
    private final UnaryCallSettings<DeleteHubRequest, Operation> deleteHubSettings;
    private final OperationCallSettings<DeleteHubRequest, Empty, OperationMetadata> deleteHubOperationSettings;
    private final PagedCallSettings<ListHubSpokesRequest, ListHubSpokesResponse, HubServiceClient.ListHubSpokesPagedResponse> listHubSpokesSettings;
    private final PagedCallSettings<QueryHubStatusRequest, QueryHubStatusResponse, HubServiceClient.QueryHubStatusPagedResponse> queryHubStatusSettings;
    private final PagedCallSettings<ListSpokesRequest, ListSpokesResponse, HubServiceClient.ListSpokesPagedResponse> listSpokesSettings;
    private final UnaryCallSettings<GetSpokeRequest, Spoke> getSpokeSettings;
    private final UnaryCallSettings<CreateSpokeRequest, Operation> createSpokeSettings;
    private final OperationCallSettings<CreateSpokeRequest, Spoke, OperationMetadata> createSpokeOperationSettings;
    private final UnaryCallSettings<UpdateSpokeRequest, Operation> updateSpokeSettings;
    private final OperationCallSettings<UpdateSpokeRequest, Spoke, OperationMetadata> updateSpokeOperationSettings;
    private final UnaryCallSettings<RejectHubSpokeRequest, Operation> rejectHubSpokeSettings;
    private final OperationCallSettings<RejectHubSpokeRequest, RejectHubSpokeResponse, OperationMetadata> rejectHubSpokeOperationSettings;
    private final UnaryCallSettings<AcceptHubSpokeRequest, Operation> acceptHubSpokeSettings;
    private final OperationCallSettings<AcceptHubSpokeRequest, AcceptHubSpokeResponse, OperationMetadata> acceptHubSpokeOperationSettings;
    private final UnaryCallSettings<DeleteSpokeRequest, Operation> deleteSpokeSettings;
    private final OperationCallSettings<DeleteSpokeRequest, Empty, OperationMetadata> deleteSpokeOperationSettings;
    private final UnaryCallSettings<GetRouteTableRequest, RouteTable> getRouteTableSettings;
    private final UnaryCallSettings<GetRouteRequest, Route> getRouteSettings;
    private final PagedCallSettings<ListRoutesRequest, ListRoutesResponse, HubServiceClient.ListRoutesPagedResponse> listRoutesSettings;
    private final PagedCallSettings<ListRouteTablesRequest, ListRouteTablesResponse, HubServiceClient.ListRouteTablesPagedResponse> listRouteTablesSettings;
    private final UnaryCallSettings<GetGroupRequest, Group> getGroupSettings;
    private final PagedCallSettings<ListGroupsRequest, ListGroupsResponse, HubServiceClient.ListGroupsPagedResponse> listGroupsSettings;
    private final UnaryCallSettings<UpdateGroupRequest, Operation> updateGroupSettings;
    private final OperationCallSettings<UpdateGroupRequest, Group, OperationMetadata> updateGroupOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, HubServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListHubsRequest, ListHubsResponse, Hub> LIST_HUBS_PAGE_STR_DESC = new PagedListDescriptor<ListHubsRequest, ListHubsResponse, Hub>(){

        public String emptyToken() {
            return "";
        }

        public ListHubsRequest injectToken(ListHubsRequest payload, String token) {
            return ListHubsRequest.newBuilder((ListHubsRequest)payload).setPageToken(token).build();
        }

        public ListHubsRequest injectPageSize(ListHubsRequest payload, int pageSize) {
            return ListHubsRequest.newBuilder((ListHubsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListHubsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListHubsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Hub> extractResources(ListHubsResponse payload) {
            return payload.getHubsList();
        }
    };
    private static final PagedListDescriptor<ListHubSpokesRequest, ListHubSpokesResponse, Spoke> LIST_HUB_SPOKES_PAGE_STR_DESC = new PagedListDescriptor<ListHubSpokesRequest, ListHubSpokesResponse, Spoke>(){

        public String emptyToken() {
            return "";
        }

        public ListHubSpokesRequest injectToken(ListHubSpokesRequest payload, String token) {
            return ListHubSpokesRequest.newBuilder((ListHubSpokesRequest)payload).setPageToken(token).build();
        }

        public ListHubSpokesRequest injectPageSize(ListHubSpokesRequest payload, int pageSize) {
            return ListHubSpokesRequest.newBuilder((ListHubSpokesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListHubSpokesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListHubSpokesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Spoke> extractResources(ListHubSpokesResponse payload) {
            return payload.getSpokesList();
        }
    };
    private static final PagedListDescriptor<QueryHubStatusRequest, QueryHubStatusResponse, HubStatusEntry> QUERY_HUB_STATUS_PAGE_STR_DESC = new PagedListDescriptor<QueryHubStatusRequest, QueryHubStatusResponse, HubStatusEntry>(){

        public String emptyToken() {
            return "";
        }

        public QueryHubStatusRequest injectToken(QueryHubStatusRequest payload, String token) {
            return QueryHubStatusRequest.newBuilder((QueryHubStatusRequest)payload).setPageToken(token).build();
        }

        public QueryHubStatusRequest injectPageSize(QueryHubStatusRequest payload, int pageSize) {
            return QueryHubStatusRequest.newBuilder((QueryHubStatusRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(QueryHubStatusRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(QueryHubStatusResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<HubStatusEntry> extractResources(QueryHubStatusResponse payload) {
            return payload.getHubStatusEntriesList();
        }
    };
    private static final PagedListDescriptor<ListSpokesRequest, ListSpokesResponse, Spoke> LIST_SPOKES_PAGE_STR_DESC = new PagedListDescriptor<ListSpokesRequest, ListSpokesResponse, Spoke>(){

        public String emptyToken() {
            return "";
        }

        public ListSpokesRequest injectToken(ListSpokesRequest payload, String token) {
            return ListSpokesRequest.newBuilder((ListSpokesRequest)payload).setPageToken(token).build();
        }

        public ListSpokesRequest injectPageSize(ListSpokesRequest payload, int pageSize) {
            return ListSpokesRequest.newBuilder((ListSpokesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSpokesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSpokesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Spoke> extractResources(ListSpokesResponse payload) {
            return payload.getSpokesList();
        }
    };
    private static final PagedListDescriptor<ListRoutesRequest, ListRoutesResponse, Route> LIST_ROUTES_PAGE_STR_DESC = new PagedListDescriptor<ListRoutesRequest, ListRoutesResponse, Route>(){

        public String emptyToken() {
            return "";
        }

        public ListRoutesRequest injectToken(ListRoutesRequest payload, String token) {
            return ListRoutesRequest.newBuilder((ListRoutesRequest)payload).setPageToken(token).build();
        }

        public ListRoutesRequest injectPageSize(ListRoutesRequest payload, int pageSize) {
            return ListRoutesRequest.newBuilder((ListRoutesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRoutesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRoutesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Route> extractResources(ListRoutesResponse payload) {
            return payload.getRoutesList();
        }
    };
    private static final PagedListDescriptor<ListRouteTablesRequest, ListRouteTablesResponse, RouteTable> LIST_ROUTE_TABLES_PAGE_STR_DESC = new PagedListDescriptor<ListRouteTablesRequest, ListRouteTablesResponse, RouteTable>(){

        public String emptyToken() {
            return "";
        }

        public ListRouteTablesRequest injectToken(ListRouteTablesRequest payload, String token) {
            return ListRouteTablesRequest.newBuilder((ListRouteTablesRequest)payload).setPageToken(token).build();
        }

        public ListRouteTablesRequest injectPageSize(ListRouteTablesRequest payload, int pageSize) {
            return ListRouteTablesRequest.newBuilder((ListRouteTablesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRouteTablesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRouteTablesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<RouteTable> extractResources(ListRouteTablesResponse payload) {
            return payload.getRouteTablesList();
        }
    };
    private static final PagedListDescriptor<ListGroupsRequest, ListGroupsResponse, Group> LIST_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListGroupsRequest, ListGroupsResponse, Group>(){

        public String emptyToken() {
            return "";
        }

        public ListGroupsRequest injectToken(ListGroupsRequest payload, String token) {
            return ListGroupsRequest.newBuilder((ListGroupsRequest)payload).setPageToken(token).build();
        }

        public ListGroupsRequest injectPageSize(ListGroupsRequest payload, int pageSize) {
            return ListGroupsRequest.newBuilder((ListGroupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGroupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGroupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Group> extractResources(ListGroupsResponse payload) {
            return payload.getGroupsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListHubsRequest, ListHubsResponse, HubServiceClient.ListHubsPagedResponse> LIST_HUBS_PAGE_STR_FACT = new PagedListResponseFactory<ListHubsRequest, ListHubsResponse, HubServiceClient.ListHubsPagedResponse>(){

        public ApiFuture<HubServiceClient.ListHubsPagedResponse> getFuturePagedResponse(UnaryCallable<ListHubsRequest, ListHubsResponse> callable, ListHubsRequest request, ApiCallContext context, ApiFuture<ListHubsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_HUBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return HubServiceClient.ListHubsPagedResponse.createAsync((PageContext<ListHubsRequest, ListHubsResponse, Hub>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListHubSpokesRequest, ListHubSpokesResponse, HubServiceClient.ListHubSpokesPagedResponse> LIST_HUB_SPOKES_PAGE_STR_FACT = new PagedListResponseFactory<ListHubSpokesRequest, ListHubSpokesResponse, HubServiceClient.ListHubSpokesPagedResponse>(){

        public ApiFuture<HubServiceClient.ListHubSpokesPagedResponse> getFuturePagedResponse(UnaryCallable<ListHubSpokesRequest, ListHubSpokesResponse> callable, ListHubSpokesRequest request, ApiCallContext context, ApiFuture<ListHubSpokesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_HUB_SPOKES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return HubServiceClient.ListHubSpokesPagedResponse.createAsync((PageContext<ListHubSpokesRequest, ListHubSpokesResponse, Spoke>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<QueryHubStatusRequest, QueryHubStatusResponse, HubServiceClient.QueryHubStatusPagedResponse> QUERY_HUB_STATUS_PAGE_STR_FACT = new PagedListResponseFactory<QueryHubStatusRequest, QueryHubStatusResponse, HubServiceClient.QueryHubStatusPagedResponse>(){

        public ApiFuture<HubServiceClient.QueryHubStatusPagedResponse> getFuturePagedResponse(UnaryCallable<QueryHubStatusRequest, QueryHubStatusResponse> callable, QueryHubStatusRequest request, ApiCallContext context, ApiFuture<QueryHubStatusResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)QUERY_HUB_STATUS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return HubServiceClient.QueryHubStatusPagedResponse.createAsync((PageContext<QueryHubStatusRequest, QueryHubStatusResponse, HubStatusEntry>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSpokesRequest, ListSpokesResponse, HubServiceClient.ListSpokesPagedResponse> LIST_SPOKES_PAGE_STR_FACT = new PagedListResponseFactory<ListSpokesRequest, ListSpokesResponse, HubServiceClient.ListSpokesPagedResponse>(){

        public ApiFuture<HubServiceClient.ListSpokesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSpokesRequest, ListSpokesResponse> callable, ListSpokesRequest request, ApiCallContext context, ApiFuture<ListSpokesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SPOKES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return HubServiceClient.ListSpokesPagedResponse.createAsync((PageContext<ListSpokesRequest, ListSpokesResponse, Spoke>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRoutesRequest, ListRoutesResponse, HubServiceClient.ListRoutesPagedResponse> LIST_ROUTES_PAGE_STR_FACT = new PagedListResponseFactory<ListRoutesRequest, ListRoutesResponse, HubServiceClient.ListRoutesPagedResponse>(){

        public ApiFuture<HubServiceClient.ListRoutesPagedResponse> getFuturePagedResponse(UnaryCallable<ListRoutesRequest, ListRoutesResponse> callable, ListRoutesRequest request, ApiCallContext context, ApiFuture<ListRoutesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ROUTES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return HubServiceClient.ListRoutesPagedResponse.createAsync((PageContext<ListRoutesRequest, ListRoutesResponse, Route>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRouteTablesRequest, ListRouteTablesResponse, HubServiceClient.ListRouteTablesPagedResponse> LIST_ROUTE_TABLES_PAGE_STR_FACT = new PagedListResponseFactory<ListRouteTablesRequest, ListRouteTablesResponse, HubServiceClient.ListRouteTablesPagedResponse>(){

        public ApiFuture<HubServiceClient.ListRouteTablesPagedResponse> getFuturePagedResponse(UnaryCallable<ListRouteTablesRequest, ListRouteTablesResponse> callable, ListRouteTablesRequest request, ApiCallContext context, ApiFuture<ListRouteTablesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ROUTE_TABLES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return HubServiceClient.ListRouteTablesPagedResponse.createAsync((PageContext<ListRouteTablesRequest, ListRouteTablesResponse, RouteTable>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListGroupsRequest, ListGroupsResponse, HubServiceClient.ListGroupsPagedResponse> LIST_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListGroupsRequest, ListGroupsResponse, HubServiceClient.ListGroupsPagedResponse>(){

        public ApiFuture<HubServiceClient.ListGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListGroupsRequest, ListGroupsResponse> callable, ListGroupsRequest request, ApiCallContext context, ApiFuture<ListGroupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return HubServiceClient.ListGroupsPagedResponse.createAsync((PageContext<ListGroupsRequest, ListGroupsResponse, Group>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, HubServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, HubServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<HubServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return HubServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListHubsRequest, ListHubsResponse, HubServiceClient.ListHubsPagedResponse> listHubsSettings() {
        return this.listHubsSettings;
    }

    public UnaryCallSettings<GetHubRequest, Hub> getHubSettings() {
        return this.getHubSettings;
    }

    public UnaryCallSettings<CreateHubRequest, Operation> createHubSettings() {
        return this.createHubSettings;
    }

    public OperationCallSettings<CreateHubRequest, Hub, OperationMetadata> createHubOperationSettings() {
        return this.createHubOperationSettings;
    }

    public UnaryCallSettings<UpdateHubRequest, Operation> updateHubSettings() {
        return this.updateHubSettings;
    }

    public OperationCallSettings<UpdateHubRequest, Hub, OperationMetadata> updateHubOperationSettings() {
        return this.updateHubOperationSettings;
    }

    public UnaryCallSettings<DeleteHubRequest, Operation> deleteHubSettings() {
        return this.deleteHubSettings;
    }

    public OperationCallSettings<DeleteHubRequest, Empty, OperationMetadata> deleteHubOperationSettings() {
        return this.deleteHubOperationSettings;
    }

    public PagedCallSettings<ListHubSpokesRequest, ListHubSpokesResponse, HubServiceClient.ListHubSpokesPagedResponse> listHubSpokesSettings() {
        return this.listHubSpokesSettings;
    }

    public PagedCallSettings<QueryHubStatusRequest, QueryHubStatusResponse, HubServiceClient.QueryHubStatusPagedResponse> queryHubStatusSettings() {
        return this.queryHubStatusSettings;
    }

    public PagedCallSettings<ListSpokesRequest, ListSpokesResponse, HubServiceClient.ListSpokesPagedResponse> listSpokesSettings() {
        return this.listSpokesSettings;
    }

    public UnaryCallSettings<GetSpokeRequest, Spoke> getSpokeSettings() {
        return this.getSpokeSettings;
    }

    public UnaryCallSettings<CreateSpokeRequest, Operation> createSpokeSettings() {
        return this.createSpokeSettings;
    }

    public OperationCallSettings<CreateSpokeRequest, Spoke, OperationMetadata> createSpokeOperationSettings() {
        return this.createSpokeOperationSettings;
    }

    public UnaryCallSettings<UpdateSpokeRequest, Operation> updateSpokeSettings() {
        return this.updateSpokeSettings;
    }

    public OperationCallSettings<UpdateSpokeRequest, Spoke, OperationMetadata> updateSpokeOperationSettings() {
        return this.updateSpokeOperationSettings;
    }

    public UnaryCallSettings<RejectHubSpokeRequest, Operation> rejectHubSpokeSettings() {
        return this.rejectHubSpokeSettings;
    }

    public OperationCallSettings<RejectHubSpokeRequest, RejectHubSpokeResponse, OperationMetadata> rejectHubSpokeOperationSettings() {
        return this.rejectHubSpokeOperationSettings;
    }

    public UnaryCallSettings<AcceptHubSpokeRequest, Operation> acceptHubSpokeSettings() {
        return this.acceptHubSpokeSettings;
    }

    public OperationCallSettings<AcceptHubSpokeRequest, AcceptHubSpokeResponse, OperationMetadata> acceptHubSpokeOperationSettings() {
        return this.acceptHubSpokeOperationSettings;
    }

    public UnaryCallSettings<DeleteSpokeRequest, Operation> deleteSpokeSettings() {
        return this.deleteSpokeSettings;
    }

    public OperationCallSettings<DeleteSpokeRequest, Empty, OperationMetadata> deleteSpokeOperationSettings() {
        return this.deleteSpokeOperationSettings;
    }

    public UnaryCallSettings<GetRouteTableRequest, RouteTable> getRouteTableSettings() {
        return this.getRouteTableSettings;
    }

    public UnaryCallSettings<GetRouteRequest, Route> getRouteSettings() {
        return this.getRouteSettings;
    }

    public PagedCallSettings<ListRoutesRequest, ListRoutesResponse, HubServiceClient.ListRoutesPagedResponse> listRoutesSettings() {
        return this.listRoutesSettings;
    }

    public PagedCallSettings<ListRouteTablesRequest, ListRouteTablesResponse, HubServiceClient.ListRouteTablesPagedResponse> listRouteTablesSettings() {
        return this.listRouteTablesSettings;
    }

    public UnaryCallSettings<GetGroupRequest, Group> getGroupSettings() {
        return this.getGroupSettings;
    }

    public PagedCallSettings<ListGroupsRequest, ListGroupsResponse, HubServiceClient.ListGroupsPagedResponse> listGroupsSettings() {
        return this.listGroupsSettings;
    }

    public UnaryCallSettings<UpdateGroupRequest, Operation> updateGroupSettings() {
        return this.updateGroupSettings;
    }

    public OperationCallSettings<UpdateGroupRequest, Group, OperationMetadata> updateGroupOperationSettings() {
        return this.updateGroupOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, HubServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public HubServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcHubServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "networkconnectivity";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "networkconnectivity.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "networkconnectivity.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return HubServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(HubServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected HubServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listHubsSettings = settingsBuilder.listHubsSettings().build();
        this.getHubSettings = settingsBuilder.getHubSettings().build();
        this.createHubSettings = settingsBuilder.createHubSettings().build();
        this.createHubOperationSettings = settingsBuilder.createHubOperationSettings().build();
        this.updateHubSettings = settingsBuilder.updateHubSettings().build();
        this.updateHubOperationSettings = settingsBuilder.updateHubOperationSettings().build();
        this.deleteHubSettings = settingsBuilder.deleteHubSettings().build();
        this.deleteHubOperationSettings = settingsBuilder.deleteHubOperationSettings().build();
        this.listHubSpokesSettings = settingsBuilder.listHubSpokesSettings().build();
        this.queryHubStatusSettings = settingsBuilder.queryHubStatusSettings().build();
        this.listSpokesSettings = settingsBuilder.listSpokesSettings().build();
        this.getSpokeSettings = settingsBuilder.getSpokeSettings().build();
        this.createSpokeSettings = settingsBuilder.createSpokeSettings().build();
        this.createSpokeOperationSettings = settingsBuilder.createSpokeOperationSettings().build();
        this.updateSpokeSettings = settingsBuilder.updateSpokeSettings().build();
        this.updateSpokeOperationSettings = settingsBuilder.updateSpokeOperationSettings().build();
        this.rejectHubSpokeSettings = settingsBuilder.rejectHubSpokeSettings().build();
        this.rejectHubSpokeOperationSettings = settingsBuilder.rejectHubSpokeOperationSettings().build();
        this.acceptHubSpokeSettings = settingsBuilder.acceptHubSpokeSettings().build();
        this.acceptHubSpokeOperationSettings = settingsBuilder.acceptHubSpokeOperationSettings().build();
        this.deleteSpokeSettings = settingsBuilder.deleteSpokeSettings().build();
        this.deleteSpokeOperationSettings = settingsBuilder.deleteSpokeOperationSettings().build();
        this.getRouteTableSettings = settingsBuilder.getRouteTableSettings().build();
        this.getRouteSettings = settingsBuilder.getRouteSettings().build();
        this.listRoutesSettings = settingsBuilder.listRoutesSettings().build();
        this.listRouteTablesSettings = settingsBuilder.listRouteTablesSettings().build();
        this.getGroupSettings = settingsBuilder.getGroupSettings().build();
        this.listGroupsSettings = settingsBuilder.listGroupsSettings().build();
        this.updateGroupSettings = settingsBuilder.updateGroupSettings().build();
        this.updateGroupOperationSettings = settingsBuilder.updateGroupOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<HubServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListHubsRequest, ListHubsResponse, HubServiceClient.ListHubsPagedResponse> listHubsSettings;
        private final UnaryCallSettings.Builder<GetHubRequest, Hub> getHubSettings;
        private final UnaryCallSettings.Builder<CreateHubRequest, Operation> createHubSettings;
        private final OperationCallSettings.Builder<CreateHubRequest, Hub, OperationMetadata> createHubOperationSettings;
        private final UnaryCallSettings.Builder<UpdateHubRequest, Operation> updateHubSettings;
        private final OperationCallSettings.Builder<UpdateHubRequest, Hub, OperationMetadata> updateHubOperationSettings;
        private final UnaryCallSettings.Builder<DeleteHubRequest, Operation> deleteHubSettings;
        private final OperationCallSettings.Builder<DeleteHubRequest, Empty, OperationMetadata> deleteHubOperationSettings;
        private final PagedCallSettings.Builder<ListHubSpokesRequest, ListHubSpokesResponse, HubServiceClient.ListHubSpokesPagedResponse> listHubSpokesSettings;
        private final PagedCallSettings.Builder<QueryHubStatusRequest, QueryHubStatusResponse, HubServiceClient.QueryHubStatusPagedResponse> queryHubStatusSettings;
        private final PagedCallSettings.Builder<ListSpokesRequest, ListSpokesResponse, HubServiceClient.ListSpokesPagedResponse> listSpokesSettings;
        private final UnaryCallSettings.Builder<GetSpokeRequest, Spoke> getSpokeSettings;
        private final UnaryCallSettings.Builder<CreateSpokeRequest, Operation> createSpokeSettings;
        private final OperationCallSettings.Builder<CreateSpokeRequest, Spoke, OperationMetadata> createSpokeOperationSettings;
        private final UnaryCallSettings.Builder<UpdateSpokeRequest, Operation> updateSpokeSettings;
        private final OperationCallSettings.Builder<UpdateSpokeRequest, Spoke, OperationMetadata> updateSpokeOperationSettings;
        private final UnaryCallSettings.Builder<RejectHubSpokeRequest, Operation> rejectHubSpokeSettings;
        private final OperationCallSettings.Builder<RejectHubSpokeRequest, RejectHubSpokeResponse, OperationMetadata> rejectHubSpokeOperationSettings;
        private final UnaryCallSettings.Builder<AcceptHubSpokeRequest, Operation> acceptHubSpokeSettings;
        private final OperationCallSettings.Builder<AcceptHubSpokeRequest, AcceptHubSpokeResponse, OperationMetadata> acceptHubSpokeOperationSettings;
        private final UnaryCallSettings.Builder<DeleteSpokeRequest, Operation> deleteSpokeSettings;
        private final OperationCallSettings.Builder<DeleteSpokeRequest, Empty, OperationMetadata> deleteSpokeOperationSettings;
        private final UnaryCallSettings.Builder<GetRouteTableRequest, RouteTable> getRouteTableSettings;
        private final UnaryCallSettings.Builder<GetRouteRequest, Route> getRouteSettings;
        private final PagedCallSettings.Builder<ListRoutesRequest, ListRoutesResponse, HubServiceClient.ListRoutesPagedResponse> listRoutesSettings;
        private final PagedCallSettings.Builder<ListRouteTablesRequest, ListRouteTablesResponse, HubServiceClient.ListRouteTablesPagedResponse> listRouteTablesSettings;
        private final UnaryCallSettings.Builder<GetGroupRequest, Group> getGroupSettings;
        private final PagedCallSettings.Builder<ListGroupsRequest, ListGroupsResponse, HubServiceClient.ListGroupsPagedResponse> listGroupsSettings;
        private final UnaryCallSettings.Builder<UpdateGroupRequest, Operation> updateGroupSettings;
        private final OperationCallSettings.Builder<UpdateGroupRequest, Group, OperationMetadata> updateGroupOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, HubServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listHubsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_HUBS_PAGE_STR_FACT);
            this.getHubSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createHubSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createHubOperationSettings = OperationCallSettings.newBuilder();
            this.updateHubSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateHubOperationSettings = OperationCallSettings.newBuilder();
            this.deleteHubSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteHubOperationSettings = OperationCallSettings.newBuilder();
            this.listHubSpokesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_HUB_SPOKES_PAGE_STR_FACT);
            this.queryHubStatusSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)QUERY_HUB_STATUS_PAGE_STR_FACT);
            this.listSpokesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SPOKES_PAGE_STR_FACT);
            this.getSpokeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSpokeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSpokeOperationSettings = OperationCallSettings.newBuilder();
            this.updateSpokeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSpokeOperationSettings = OperationCallSettings.newBuilder();
            this.rejectHubSpokeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.rejectHubSpokeOperationSettings = OperationCallSettings.newBuilder();
            this.acceptHubSpokeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.acceptHubSpokeOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSpokeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSpokeOperationSettings = OperationCallSettings.newBuilder();
            this.getRouteTableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRoutesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ROUTES_PAGE_STR_FACT);
            this.listRouteTablesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ROUTE_TABLES_PAGE_STR_FACT);
            this.getGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GROUPS_PAGE_STR_FACT);
            this.updateGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGroupOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listHubsSettings, this.getHubSettings, this.createHubSettings, this.updateHubSettings, this.deleteHubSettings, this.listHubSpokesSettings, this.queryHubStatusSettings, this.listSpokesSettings, this.getSpokeSettings, this.createSpokeSettings, this.updateSpokeSettings, this.rejectHubSpokeSettings, (Object[])new UnaryCallSettings.Builder[]{this.acceptHubSpokeSettings, this.deleteSpokeSettings, this.getRouteTableSettings, this.getRouteSettings, this.listRoutesSettings, this.listRouteTablesSettings, this.getGroupSettings, this.listGroupsSettings, this.updateGroupSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(HubServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listHubsSettings = settings.listHubsSettings.toBuilder();
            this.getHubSettings = settings.getHubSettings.toBuilder();
            this.createHubSettings = settings.createHubSettings.toBuilder();
            this.createHubOperationSettings = settings.createHubOperationSettings.toBuilder();
            this.updateHubSettings = settings.updateHubSettings.toBuilder();
            this.updateHubOperationSettings = settings.updateHubOperationSettings.toBuilder();
            this.deleteHubSettings = settings.deleteHubSettings.toBuilder();
            this.deleteHubOperationSettings = settings.deleteHubOperationSettings.toBuilder();
            this.listHubSpokesSettings = settings.listHubSpokesSettings.toBuilder();
            this.queryHubStatusSettings = settings.queryHubStatusSettings.toBuilder();
            this.listSpokesSettings = settings.listSpokesSettings.toBuilder();
            this.getSpokeSettings = settings.getSpokeSettings.toBuilder();
            this.createSpokeSettings = settings.createSpokeSettings.toBuilder();
            this.createSpokeOperationSettings = settings.createSpokeOperationSettings.toBuilder();
            this.updateSpokeSettings = settings.updateSpokeSettings.toBuilder();
            this.updateSpokeOperationSettings = settings.updateSpokeOperationSettings.toBuilder();
            this.rejectHubSpokeSettings = settings.rejectHubSpokeSettings.toBuilder();
            this.rejectHubSpokeOperationSettings = settings.rejectHubSpokeOperationSettings.toBuilder();
            this.acceptHubSpokeSettings = settings.acceptHubSpokeSettings.toBuilder();
            this.acceptHubSpokeOperationSettings = settings.acceptHubSpokeOperationSettings.toBuilder();
            this.deleteSpokeSettings = settings.deleteSpokeSettings.toBuilder();
            this.deleteSpokeOperationSettings = settings.deleteSpokeOperationSettings.toBuilder();
            this.getRouteTableSettings = settings.getRouteTableSettings.toBuilder();
            this.getRouteSettings = settings.getRouteSettings.toBuilder();
            this.listRoutesSettings = settings.listRoutesSettings.toBuilder();
            this.listRouteTablesSettings = settings.listRouteTablesSettings.toBuilder();
            this.getGroupSettings = settings.getGroupSettings.toBuilder();
            this.listGroupsSettings = settings.listGroupsSettings.toBuilder();
            this.updateGroupSettings = settings.updateGroupSettings.toBuilder();
            this.updateGroupOperationSettings = settings.updateGroupOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listHubsSettings, this.getHubSettings, this.createHubSettings, this.updateHubSettings, this.deleteHubSettings, this.listHubSpokesSettings, this.queryHubStatusSettings, this.listSpokesSettings, this.getSpokeSettings, this.createSpokeSettings, this.updateSpokeSettings, this.rejectHubSpokeSettings, (Object[])new UnaryCallSettings.Builder[]{this.acceptHubSpokeSettings, this.deleteSpokeSettings, this.getRouteTableSettings, this.getRouteSettings, this.listRoutesSettings, this.listRouteTablesSettings, this.getGroupSettings, this.listGroupsSettings, this.updateGroupSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(HubServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)HubServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)HubServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(HubServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listHubsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getHubSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createHubSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateHubSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteHubSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listHubSpokesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.queryHubStatusSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSpokesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSpokeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createSpokeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateSpokeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.rejectHubSpokeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.acceptHubSpokeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSpokeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getRouteTableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listRoutesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listRouteTablesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createHubOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Hub.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateHubOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Hub.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteHubOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createSpokeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Spoke.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateSpokeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Spoke.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.rejectHubSpokeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(RejectHubSpokeResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.acceptHubSpokeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AcceptHubSpokeResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteSpokeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateGroupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Group.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListHubsRequest, ListHubsResponse, HubServiceClient.ListHubsPagedResponse> listHubsSettings() {
            return this.listHubsSettings;
        }

        public UnaryCallSettings.Builder<GetHubRequest, Hub> getHubSettings() {
            return this.getHubSettings;
        }

        public UnaryCallSettings.Builder<CreateHubRequest, Operation> createHubSettings() {
            return this.createHubSettings;
        }

        public OperationCallSettings.Builder<CreateHubRequest, Hub, OperationMetadata> createHubOperationSettings() {
            return this.createHubOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateHubRequest, Operation> updateHubSettings() {
            return this.updateHubSettings;
        }

        public OperationCallSettings.Builder<UpdateHubRequest, Hub, OperationMetadata> updateHubOperationSettings() {
            return this.updateHubOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteHubRequest, Operation> deleteHubSettings() {
            return this.deleteHubSettings;
        }

        public OperationCallSettings.Builder<DeleteHubRequest, Empty, OperationMetadata> deleteHubOperationSettings() {
            return this.deleteHubOperationSettings;
        }

        public PagedCallSettings.Builder<ListHubSpokesRequest, ListHubSpokesResponse, HubServiceClient.ListHubSpokesPagedResponse> listHubSpokesSettings() {
            return this.listHubSpokesSettings;
        }

        public PagedCallSettings.Builder<QueryHubStatusRequest, QueryHubStatusResponse, HubServiceClient.QueryHubStatusPagedResponse> queryHubStatusSettings() {
            return this.queryHubStatusSettings;
        }

        public PagedCallSettings.Builder<ListSpokesRequest, ListSpokesResponse, HubServiceClient.ListSpokesPagedResponse> listSpokesSettings() {
            return this.listSpokesSettings;
        }

        public UnaryCallSettings.Builder<GetSpokeRequest, Spoke> getSpokeSettings() {
            return this.getSpokeSettings;
        }

        public UnaryCallSettings.Builder<CreateSpokeRequest, Operation> createSpokeSettings() {
            return this.createSpokeSettings;
        }

        public OperationCallSettings.Builder<CreateSpokeRequest, Spoke, OperationMetadata> createSpokeOperationSettings() {
            return this.createSpokeOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateSpokeRequest, Operation> updateSpokeSettings() {
            return this.updateSpokeSettings;
        }

        public OperationCallSettings.Builder<UpdateSpokeRequest, Spoke, OperationMetadata> updateSpokeOperationSettings() {
            return this.updateSpokeOperationSettings;
        }

        public UnaryCallSettings.Builder<RejectHubSpokeRequest, Operation> rejectHubSpokeSettings() {
            return this.rejectHubSpokeSettings;
        }

        public OperationCallSettings.Builder<RejectHubSpokeRequest, RejectHubSpokeResponse, OperationMetadata> rejectHubSpokeOperationSettings() {
            return this.rejectHubSpokeOperationSettings;
        }

        public UnaryCallSettings.Builder<AcceptHubSpokeRequest, Operation> acceptHubSpokeSettings() {
            return this.acceptHubSpokeSettings;
        }

        public OperationCallSettings.Builder<AcceptHubSpokeRequest, AcceptHubSpokeResponse, OperationMetadata> acceptHubSpokeOperationSettings() {
            return this.acceptHubSpokeOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteSpokeRequest, Operation> deleteSpokeSettings() {
            return this.deleteSpokeSettings;
        }

        public OperationCallSettings.Builder<DeleteSpokeRequest, Empty, OperationMetadata> deleteSpokeOperationSettings() {
            return this.deleteSpokeOperationSettings;
        }

        public UnaryCallSettings.Builder<GetRouteTableRequest, RouteTable> getRouteTableSettings() {
            return this.getRouteTableSettings;
        }

        public UnaryCallSettings.Builder<GetRouteRequest, Route> getRouteSettings() {
            return this.getRouteSettings;
        }

        public PagedCallSettings.Builder<ListRoutesRequest, ListRoutesResponse, HubServiceClient.ListRoutesPagedResponse> listRoutesSettings() {
            return this.listRoutesSettings;
        }

        public PagedCallSettings.Builder<ListRouteTablesRequest, ListRouteTablesResponse, HubServiceClient.ListRouteTablesPagedResponse> listRouteTablesSettings() {
            return this.listRouteTablesSettings;
        }

        public UnaryCallSettings.Builder<GetGroupRequest, Group> getGroupSettings() {
            return this.getGroupSettings;
        }

        public PagedCallSettings.Builder<ListGroupsRequest, ListGroupsResponse, HubServiceClient.ListGroupsPagedResponse> listGroupsSettings() {
            return this.listGroupsSettings;
        }

        public UnaryCallSettings.Builder<UpdateGroupRequest, Operation> updateGroupSettings() {
            return this.updateGroupSettings;
        }

        public OperationCallSettings.Builder<UpdateGroupRequest, Group, OperationMetadata> updateGroupOperationSettings() {
            return this.updateGroupOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, HubServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public HubServiceStubSettings build() throws IOException {
            return new HubServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

