/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networksecurity.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networksecurity.v1beta1.CreateDnsThreatDetectorRequest;
import com.google.cloud.networksecurity.v1beta1.DeleteDnsThreatDetectorRequest;
import com.google.cloud.networksecurity.v1beta1.DnsThreatDetector;
import com.google.cloud.networksecurity.v1beta1.DnsThreatDetectorName;
import com.google.cloud.networksecurity.v1beta1.DnsThreatDetectorServiceSettings;
import com.google.cloud.networksecurity.v1beta1.GetDnsThreatDetectorRequest;
import com.google.cloud.networksecurity.v1beta1.ListDnsThreatDetectorsRequest;
import com.google.cloud.networksecurity.v1beta1.ListDnsThreatDetectorsResponse;
import com.google.cloud.networksecurity.v1beta1.LocationName;
import com.google.cloud.networksecurity.v1beta1.UpdateDnsThreatDetectorRequest;
import com.google.cloud.networksecurity.v1beta1.stub.DnsThreatDetectorServiceStub;
import com.google.cloud.networksecurity.v1beta1.stub.DnsThreatDetectorServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DnsThreatDetectorServiceClient
implements BackgroundResource {
    private final DnsThreatDetectorServiceSettings settings;
    private final DnsThreatDetectorServiceStub stub;

    public static final DnsThreatDetectorServiceClient create() throws IOException {
        return DnsThreatDetectorServiceClient.create(DnsThreatDetectorServiceSettings.newBuilder().build());
    }

    public static final DnsThreatDetectorServiceClient create(DnsThreatDetectorServiceSettings settings) throws IOException {
        return new DnsThreatDetectorServiceClient(settings);
    }

    public static final DnsThreatDetectorServiceClient create(DnsThreatDetectorServiceStub stub) {
        return new DnsThreatDetectorServiceClient(stub);
    }

    protected DnsThreatDetectorServiceClient(DnsThreatDetectorServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DnsThreatDetectorServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected DnsThreatDetectorServiceClient(DnsThreatDetectorServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DnsThreatDetectorServiceSettings getSettings() {
        return this.settings;
    }

    public DnsThreatDetectorServiceStub getStub() {
        return this.stub;
    }

    public final ListDnsThreatDetectorsPagedResponse listDnsThreatDetectors(LocationName parent) {
        ListDnsThreatDetectorsRequest request = ListDnsThreatDetectorsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDnsThreatDetectors(request);
    }

    public final ListDnsThreatDetectorsPagedResponse listDnsThreatDetectors(String parent) {
        ListDnsThreatDetectorsRequest request = ListDnsThreatDetectorsRequest.newBuilder().setParent(parent).build();
        return this.listDnsThreatDetectors(request);
    }

    public final ListDnsThreatDetectorsPagedResponse listDnsThreatDetectors(ListDnsThreatDetectorsRequest request) {
        return (ListDnsThreatDetectorsPagedResponse)((Object)this.listDnsThreatDetectorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsPagedResponse> listDnsThreatDetectorsPagedCallable() {
        return this.stub.listDnsThreatDetectorsPagedCallable();
    }

    public final UnaryCallable<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsResponse> listDnsThreatDetectorsCallable() {
        return this.stub.listDnsThreatDetectorsCallable();
    }

    public final DnsThreatDetector getDnsThreatDetector(DnsThreatDetectorName name) {
        GetDnsThreatDetectorRequest request = GetDnsThreatDetectorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDnsThreatDetector(request);
    }

    public final DnsThreatDetector getDnsThreatDetector(String name) {
        GetDnsThreatDetectorRequest request = GetDnsThreatDetectorRequest.newBuilder().setName(name).build();
        return this.getDnsThreatDetector(request);
    }

    public final DnsThreatDetector getDnsThreatDetector(GetDnsThreatDetectorRequest request) {
        return (DnsThreatDetector)this.getDnsThreatDetectorCallable().call((Object)request);
    }

    public final UnaryCallable<GetDnsThreatDetectorRequest, DnsThreatDetector> getDnsThreatDetectorCallable() {
        return this.stub.getDnsThreatDetectorCallable();
    }

    public final DnsThreatDetector createDnsThreatDetector(LocationName parent, DnsThreatDetector dnsThreatDetector, String dnsThreatDetectorId) {
        CreateDnsThreatDetectorRequest request = CreateDnsThreatDetectorRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDnsThreatDetector(dnsThreatDetector).setDnsThreatDetectorId(dnsThreatDetectorId).build();
        return this.createDnsThreatDetector(request);
    }

    public final DnsThreatDetector createDnsThreatDetector(String parent, DnsThreatDetector dnsThreatDetector, String dnsThreatDetectorId) {
        CreateDnsThreatDetectorRequest request = CreateDnsThreatDetectorRequest.newBuilder().setParent(parent).setDnsThreatDetector(dnsThreatDetector).setDnsThreatDetectorId(dnsThreatDetectorId).build();
        return this.createDnsThreatDetector(request);
    }

    public final DnsThreatDetector createDnsThreatDetector(CreateDnsThreatDetectorRequest request) {
        return (DnsThreatDetector)this.createDnsThreatDetectorCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDnsThreatDetectorRequest, DnsThreatDetector> createDnsThreatDetectorCallable() {
        return this.stub.createDnsThreatDetectorCallable();
    }

    public final DnsThreatDetector updateDnsThreatDetector(DnsThreatDetector dnsThreatDetector, FieldMask updateMask) {
        UpdateDnsThreatDetectorRequest request = UpdateDnsThreatDetectorRequest.newBuilder().setDnsThreatDetector(dnsThreatDetector).setUpdateMask(updateMask).build();
        return this.updateDnsThreatDetector(request);
    }

    public final DnsThreatDetector updateDnsThreatDetector(UpdateDnsThreatDetectorRequest request) {
        return (DnsThreatDetector)this.updateDnsThreatDetectorCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDnsThreatDetectorRequest, DnsThreatDetector> updateDnsThreatDetectorCallable() {
        return this.stub.updateDnsThreatDetectorCallable();
    }

    public final void deleteDnsThreatDetector(DnsThreatDetectorName name) {
        DeleteDnsThreatDetectorRequest request = DeleteDnsThreatDetectorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDnsThreatDetector(request);
    }

    public final void deleteDnsThreatDetector(String name) {
        DeleteDnsThreatDetectorRequest request = DeleteDnsThreatDetectorRequest.newBuilder().setName(name).build();
        this.deleteDnsThreatDetector(request);
    }

    public final void deleteDnsThreatDetector(DeleteDnsThreatDetectorRequest request) {
        this.deleteDnsThreatDetectorCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDnsThreatDetectorRequest, Empty> deleteDnsThreatDetectorCallable() {
        return this.stub.deleteDnsThreatDetectorCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDnsThreatDetectorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsResponse, DnsThreatDetector, ListDnsThreatDetectorsPage, ListDnsThreatDetectorsFixedSizeCollection> {
        private ListDnsThreatDetectorsFixedSizeCollection(List<ListDnsThreatDetectorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDnsThreatDetectorsFixedSizeCollection createEmptyCollection() {
            return new ListDnsThreatDetectorsFixedSizeCollection(null, 0);
        }

        protected ListDnsThreatDetectorsFixedSizeCollection createCollection(List<ListDnsThreatDetectorsPage> pages, int collectionSize) {
            return new ListDnsThreatDetectorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDnsThreatDetectorsPage
    extends AbstractPage<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsResponse, DnsThreatDetector, ListDnsThreatDetectorsPage> {
        private ListDnsThreatDetectorsPage(PageContext<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsResponse, DnsThreatDetector> context, ListDnsThreatDetectorsResponse response) {
            super(context, (Object)response);
        }

        private static ListDnsThreatDetectorsPage createEmptyPage() {
            return new ListDnsThreatDetectorsPage(null, null);
        }

        protected ListDnsThreatDetectorsPage createPage(PageContext<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsResponse, DnsThreatDetector> context, ListDnsThreatDetectorsResponse response) {
            return new ListDnsThreatDetectorsPage(context, response);
        }

        public ApiFuture<ListDnsThreatDetectorsPage> createPageAsync(PageContext<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsResponse, DnsThreatDetector> context, ApiFuture<ListDnsThreatDetectorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDnsThreatDetectorsPagedResponse
    extends AbstractPagedListResponse<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsResponse, DnsThreatDetector, ListDnsThreatDetectorsPage, ListDnsThreatDetectorsFixedSizeCollection> {
        public static ApiFuture<ListDnsThreatDetectorsPagedResponse> createAsync(PageContext<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsResponse, DnsThreatDetector> context, ApiFuture<ListDnsThreatDetectorsResponse> futureResponse) {
            ApiFuture<ListDnsThreatDetectorsPage> futurePage = ListDnsThreatDetectorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDnsThreatDetectorsPagedResponse((ListDnsThreatDetectorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDnsThreatDetectorsPagedResponse(ListDnsThreatDetectorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDnsThreatDetectorsFixedSizeCollection.createEmptyCollection());
        }
    }
}

