/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networksecurity.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networksecurity.v1.AddAddressGroupItemsRequest;
import com.google.cloud.networksecurity.v1.AddressGroup;
import com.google.cloud.networksecurity.v1.AddressGroupServiceClient;
import com.google.cloud.networksecurity.v1.CloneAddressGroupItemsRequest;
import com.google.cloud.networksecurity.v1.CreateAddressGroupRequest;
import com.google.cloud.networksecurity.v1.DeleteAddressGroupRequest;
import com.google.cloud.networksecurity.v1.GetAddressGroupRequest;
import com.google.cloud.networksecurity.v1.ListAddressGroupReferencesRequest;
import com.google.cloud.networksecurity.v1.ListAddressGroupReferencesResponse;
import com.google.cloud.networksecurity.v1.ListAddressGroupsRequest;
import com.google.cloud.networksecurity.v1.ListAddressGroupsResponse;
import com.google.cloud.networksecurity.v1.OperationMetadata;
import com.google.cloud.networksecurity.v1.RemoveAddressGroupItemsRequest;
import com.google.cloud.networksecurity.v1.UpdateAddressGroupRequest;
import com.google.cloud.networksecurity.v1.stub.AddressGroupServiceStub;
import com.google.cloud.networksecurity.v1.stub.AddressGroupServiceStubSettings;
import com.google.cloud.networksecurity.v1.stub.GrpcAddressGroupServiceCallableFactory;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAddressGroupServiceStub
extends AddressGroupServiceStub {
    private static final MethodDescriptor<ListAddressGroupsRequest, ListAddressGroupsResponse> listAddressGroupsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networksecurity.v1.AddressGroupService/ListAddressGroups").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAddressGroupsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAddressGroupsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetAddressGroupRequest, AddressGroup> getAddressGroupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networksecurity.v1.AddressGroupService/GetAddressGroup").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAddressGroupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AddressGroup.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateAddressGroupRequest, Operation> createAddressGroupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networksecurity.v1.AddressGroupService/CreateAddressGroup").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateAddressGroupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateAddressGroupRequest, Operation> updateAddressGroupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networksecurity.v1.AddressGroupService/UpdateAddressGroup").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateAddressGroupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<AddAddressGroupItemsRequest, Operation> addAddressGroupItemsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networksecurity.v1.AddressGroupService/AddAddressGroupItems").setRequestMarshaller(ProtoUtils.marshaller((Message)AddAddressGroupItemsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<RemoveAddressGroupItemsRequest, Operation> removeAddressGroupItemsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networksecurity.v1.AddressGroupService/RemoveAddressGroupItems").setRequestMarshaller(ProtoUtils.marshaller((Message)RemoveAddressGroupItemsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CloneAddressGroupItemsRequest, Operation> cloneAddressGroupItemsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networksecurity.v1.AddressGroupService/CloneAddressGroupItems").setRequestMarshaller(ProtoUtils.marshaller((Message)CloneAddressGroupItemsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteAddressGroupRequest, Operation> deleteAddressGroupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networksecurity.v1.AddressGroupService/DeleteAddressGroup").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteAddressGroupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse> listAddressGroupReferencesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networksecurity.v1.AddressGroupService/ListAddressGroupReferences").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAddressGroupReferencesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAddressGroupReferencesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListAddressGroupsRequest, ListAddressGroupsResponse> listAddressGroupsCallable;
    private final UnaryCallable<ListAddressGroupsRequest, AddressGroupServiceClient.ListAddressGroupsPagedResponse> listAddressGroupsPagedCallable;
    private final UnaryCallable<GetAddressGroupRequest, AddressGroup> getAddressGroupCallable;
    private final UnaryCallable<CreateAddressGroupRequest, Operation> createAddressGroupCallable;
    private final OperationCallable<CreateAddressGroupRequest, AddressGroup, OperationMetadata> createAddressGroupOperationCallable;
    private final UnaryCallable<UpdateAddressGroupRequest, Operation> updateAddressGroupCallable;
    private final OperationCallable<UpdateAddressGroupRequest, AddressGroup, OperationMetadata> updateAddressGroupOperationCallable;
    private final UnaryCallable<AddAddressGroupItemsRequest, Operation> addAddressGroupItemsCallable;
    private final OperationCallable<AddAddressGroupItemsRequest, AddressGroup, OperationMetadata> addAddressGroupItemsOperationCallable;
    private final UnaryCallable<RemoveAddressGroupItemsRequest, Operation> removeAddressGroupItemsCallable;
    private final OperationCallable<RemoveAddressGroupItemsRequest, AddressGroup, OperationMetadata> removeAddressGroupItemsOperationCallable;
    private final UnaryCallable<CloneAddressGroupItemsRequest, Operation> cloneAddressGroupItemsCallable;
    private final OperationCallable<CloneAddressGroupItemsRequest, AddressGroup, OperationMetadata> cloneAddressGroupItemsOperationCallable;
    private final UnaryCallable<DeleteAddressGroupRequest, Operation> deleteAddressGroupCallable;
    private final OperationCallable<DeleteAddressGroupRequest, Empty, OperationMetadata> deleteAddressGroupOperationCallable;
    private final UnaryCallable<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse> listAddressGroupReferencesCallable;
    private final UnaryCallable<ListAddressGroupReferencesRequest, AddressGroupServiceClient.ListAddressGroupReferencesPagedResponse> listAddressGroupReferencesPagedCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, AddressGroupServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAddressGroupServiceStub create(AddressGroupServiceStubSettings settings) throws IOException {
        return new GrpcAddressGroupServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAddressGroupServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAddressGroupServiceStub(AddressGroupServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAddressGroupServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAddressGroupServiceStub(AddressGroupServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAddressGroupServiceStub(AddressGroupServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAddressGroupServiceCallableFactory());
    }

    protected GrpcAddressGroupServiceStub(AddressGroupServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listAddressGroupsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAddressGroupsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getAddressGroupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAddressGroupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createAddressGroupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createAddressGroupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateAddressGroupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateAddressGroupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("address_group.name", String.valueOf(request.getAddressGroup().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings addAddressGroupItemsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(addAddressGroupItemsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("address_group", String.valueOf(request.getAddressGroup()));
            return builder.build();
        }).build();
        GrpcCallSettings removeAddressGroupItemsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(removeAddressGroupItemsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("address_group", String.valueOf(request.getAddressGroup()));
            return builder.build();
        }).build();
        GrpcCallSettings cloneAddressGroupItemsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(cloneAddressGroupItemsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("address_group", String.valueOf(request.getAddressGroup()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteAddressGroupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteAddressGroupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listAddressGroupReferencesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAddressGroupReferencesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("address_group", String.valueOf(request.getAddressGroup()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.listAddressGroupsCallable = callableFactory.createUnaryCallable(listAddressGroupsTransportSettings, settings.listAddressGroupsSettings(), clientContext);
        this.listAddressGroupsPagedCallable = callableFactory.createPagedCallable(listAddressGroupsTransportSettings, settings.listAddressGroupsSettings(), clientContext);
        this.getAddressGroupCallable = callableFactory.createUnaryCallable(getAddressGroupTransportSettings, settings.getAddressGroupSettings(), clientContext);
        this.createAddressGroupCallable = callableFactory.createUnaryCallable(createAddressGroupTransportSettings, settings.createAddressGroupSettings(), clientContext);
        this.createAddressGroupOperationCallable = callableFactory.createOperationCallable(createAddressGroupTransportSettings, settings.createAddressGroupOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateAddressGroupCallable = callableFactory.createUnaryCallable(updateAddressGroupTransportSettings, settings.updateAddressGroupSettings(), clientContext);
        this.updateAddressGroupOperationCallable = callableFactory.createOperationCallable(updateAddressGroupTransportSettings, settings.updateAddressGroupOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.addAddressGroupItemsCallable = callableFactory.createUnaryCallable(addAddressGroupItemsTransportSettings, settings.addAddressGroupItemsSettings(), clientContext);
        this.addAddressGroupItemsOperationCallable = callableFactory.createOperationCallable(addAddressGroupItemsTransportSettings, settings.addAddressGroupItemsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.removeAddressGroupItemsCallable = callableFactory.createUnaryCallable(removeAddressGroupItemsTransportSettings, settings.removeAddressGroupItemsSettings(), clientContext);
        this.removeAddressGroupItemsOperationCallable = callableFactory.createOperationCallable(removeAddressGroupItemsTransportSettings, settings.removeAddressGroupItemsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.cloneAddressGroupItemsCallable = callableFactory.createUnaryCallable(cloneAddressGroupItemsTransportSettings, settings.cloneAddressGroupItemsSettings(), clientContext);
        this.cloneAddressGroupItemsOperationCallable = callableFactory.createOperationCallable(cloneAddressGroupItemsTransportSettings, settings.cloneAddressGroupItemsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteAddressGroupCallable = callableFactory.createUnaryCallable(deleteAddressGroupTransportSettings, settings.deleteAddressGroupSettings(), clientContext);
        this.deleteAddressGroupOperationCallable = callableFactory.createOperationCallable(deleteAddressGroupTransportSettings, settings.deleteAddressGroupOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listAddressGroupReferencesCallable = callableFactory.createUnaryCallable(listAddressGroupReferencesTransportSettings, settings.listAddressGroupReferencesSettings(), clientContext);
        this.listAddressGroupReferencesPagedCallable = callableFactory.createPagedCallable(listAddressGroupReferencesTransportSettings, settings.listAddressGroupReferencesSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListAddressGroupsRequest, ListAddressGroupsResponse> listAddressGroupsCallable() {
        return this.listAddressGroupsCallable;
    }

    @Override
    public UnaryCallable<ListAddressGroupsRequest, AddressGroupServiceClient.ListAddressGroupsPagedResponse> listAddressGroupsPagedCallable() {
        return this.listAddressGroupsPagedCallable;
    }

    @Override
    public UnaryCallable<GetAddressGroupRequest, AddressGroup> getAddressGroupCallable() {
        return this.getAddressGroupCallable;
    }

    @Override
    public UnaryCallable<CreateAddressGroupRequest, Operation> createAddressGroupCallable() {
        return this.createAddressGroupCallable;
    }

    @Override
    public OperationCallable<CreateAddressGroupRequest, AddressGroup, OperationMetadata> createAddressGroupOperationCallable() {
        return this.createAddressGroupOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateAddressGroupRequest, Operation> updateAddressGroupCallable() {
        return this.updateAddressGroupCallable;
    }

    @Override
    public OperationCallable<UpdateAddressGroupRequest, AddressGroup, OperationMetadata> updateAddressGroupOperationCallable() {
        return this.updateAddressGroupOperationCallable;
    }

    @Override
    public UnaryCallable<AddAddressGroupItemsRequest, Operation> addAddressGroupItemsCallable() {
        return this.addAddressGroupItemsCallable;
    }

    @Override
    public OperationCallable<AddAddressGroupItemsRequest, AddressGroup, OperationMetadata> addAddressGroupItemsOperationCallable() {
        return this.addAddressGroupItemsOperationCallable;
    }

    @Override
    public UnaryCallable<RemoveAddressGroupItemsRequest, Operation> removeAddressGroupItemsCallable() {
        return this.removeAddressGroupItemsCallable;
    }

    @Override
    public OperationCallable<RemoveAddressGroupItemsRequest, AddressGroup, OperationMetadata> removeAddressGroupItemsOperationCallable() {
        return this.removeAddressGroupItemsOperationCallable;
    }

    @Override
    public UnaryCallable<CloneAddressGroupItemsRequest, Operation> cloneAddressGroupItemsCallable() {
        return this.cloneAddressGroupItemsCallable;
    }

    @Override
    public OperationCallable<CloneAddressGroupItemsRequest, AddressGroup, OperationMetadata> cloneAddressGroupItemsOperationCallable() {
        return this.cloneAddressGroupItemsOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteAddressGroupRequest, Operation> deleteAddressGroupCallable() {
        return this.deleteAddressGroupCallable;
    }

    @Override
    public OperationCallable<DeleteAddressGroupRequest, Empty, OperationMetadata> deleteAddressGroupOperationCallable() {
        return this.deleteAddressGroupOperationCallable;
    }

    @Override
    public UnaryCallable<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse> listAddressGroupReferencesCallable() {
        return this.listAddressGroupReferencesCallable;
    }

    @Override
    public UnaryCallable<ListAddressGroupReferencesRequest, AddressGroupServiceClient.ListAddressGroupReferencesPagedResponse> listAddressGroupReferencesPagedCallable() {
        return this.listAddressGroupReferencesPagedCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, AddressGroupServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

