/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkmanagement.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.networkmanagement.v1beta1.ConnectivityTest;
import com.google.cloud.networkmanagement.v1beta1.CreateConnectivityTestRequest;
import com.google.cloud.networkmanagement.v1beta1.DeleteConnectivityTestRequest;
import com.google.cloud.networkmanagement.v1beta1.GetConnectivityTestRequest;
import com.google.cloud.networkmanagement.v1beta1.ListConnectivityTestsRequest;
import com.google.cloud.networkmanagement.v1beta1.ListConnectivityTestsResponse;
import com.google.cloud.networkmanagement.v1beta1.OperationMetadata;
import com.google.cloud.networkmanagement.v1beta1.ReachabilityServiceClient;
import com.google.cloud.networkmanagement.v1beta1.RerunConnectivityTestRequest;
import com.google.cloud.networkmanagement.v1beta1.UpdateConnectivityTestRequest;
import com.google.cloud.networkmanagement.v1beta1.stub.GrpcReachabilityServiceStub;
import com.google.cloud.networkmanagement.v1beta1.stub.ReachabilityServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ReachabilityServiceStubSettings
extends StubSettings<ReachabilityServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListConnectivityTestsRequest, ListConnectivityTestsResponse, ReachabilityServiceClient.ListConnectivityTestsPagedResponse> listConnectivityTestsSettings;
    private final UnaryCallSettings<GetConnectivityTestRequest, ConnectivityTest> getConnectivityTestSettings;
    private final UnaryCallSettings<CreateConnectivityTestRequest, Operation> createConnectivityTestSettings;
    private final OperationCallSettings<CreateConnectivityTestRequest, ConnectivityTest, OperationMetadata> createConnectivityTestOperationSettings;
    private final UnaryCallSettings<UpdateConnectivityTestRequest, Operation> updateConnectivityTestSettings;
    private final OperationCallSettings<UpdateConnectivityTestRequest, ConnectivityTest, OperationMetadata> updateConnectivityTestOperationSettings;
    private final UnaryCallSettings<RerunConnectivityTestRequest, Operation> rerunConnectivityTestSettings;
    private final OperationCallSettings<RerunConnectivityTestRequest, ConnectivityTest, OperationMetadata> rerunConnectivityTestOperationSettings;
    private final UnaryCallSettings<DeleteConnectivityTestRequest, Operation> deleteConnectivityTestSettings;
    private final OperationCallSettings<DeleteConnectivityTestRequest, Empty, OperationMetadata> deleteConnectivityTestOperationSettings;
    private static final PagedListDescriptor<ListConnectivityTestsRequest, ListConnectivityTestsResponse, ConnectivityTest> LIST_CONNECTIVITY_TESTS_PAGE_STR_DESC = new PagedListDescriptor<ListConnectivityTestsRequest, ListConnectivityTestsResponse, ConnectivityTest>(){

        public String emptyToken() {
            return "";
        }

        public ListConnectivityTestsRequest injectToken(ListConnectivityTestsRequest payload, String token) {
            return ListConnectivityTestsRequest.newBuilder((ListConnectivityTestsRequest)payload).setPageToken(token).build();
        }

        public ListConnectivityTestsRequest injectPageSize(ListConnectivityTestsRequest payload, int pageSize) {
            return ListConnectivityTestsRequest.newBuilder((ListConnectivityTestsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConnectivityTestsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConnectivityTestsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ConnectivityTest> extractResources(ListConnectivityTestsResponse payload) {
            return payload.getResourcesList() == null ? ImmutableList.of() : payload.getResourcesList();
        }
    };
    private static final PagedListResponseFactory<ListConnectivityTestsRequest, ListConnectivityTestsResponse, ReachabilityServiceClient.ListConnectivityTestsPagedResponse> LIST_CONNECTIVITY_TESTS_PAGE_STR_FACT = new PagedListResponseFactory<ListConnectivityTestsRequest, ListConnectivityTestsResponse, ReachabilityServiceClient.ListConnectivityTestsPagedResponse>(){

        public ApiFuture<ReachabilityServiceClient.ListConnectivityTestsPagedResponse> getFuturePagedResponse(UnaryCallable<ListConnectivityTestsRequest, ListConnectivityTestsResponse> callable, ListConnectivityTestsRequest request, ApiCallContext context, ApiFuture<ListConnectivityTestsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONNECTIVITY_TESTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ReachabilityServiceClient.ListConnectivityTestsPagedResponse.createAsync((PageContext<ListConnectivityTestsRequest, ListConnectivityTestsResponse, ConnectivityTest>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListConnectivityTestsRequest, ListConnectivityTestsResponse, ReachabilityServiceClient.ListConnectivityTestsPagedResponse> listConnectivityTestsSettings() {
        return this.listConnectivityTestsSettings;
    }

    public UnaryCallSettings<GetConnectivityTestRequest, ConnectivityTest> getConnectivityTestSettings() {
        return this.getConnectivityTestSettings;
    }

    public UnaryCallSettings<CreateConnectivityTestRequest, Operation> createConnectivityTestSettings() {
        return this.createConnectivityTestSettings;
    }

    public OperationCallSettings<CreateConnectivityTestRequest, ConnectivityTest, OperationMetadata> createConnectivityTestOperationSettings() {
        return this.createConnectivityTestOperationSettings;
    }

    public UnaryCallSettings<UpdateConnectivityTestRequest, Operation> updateConnectivityTestSettings() {
        return this.updateConnectivityTestSettings;
    }

    public OperationCallSettings<UpdateConnectivityTestRequest, ConnectivityTest, OperationMetadata> updateConnectivityTestOperationSettings() {
        return this.updateConnectivityTestOperationSettings;
    }

    public UnaryCallSettings<RerunConnectivityTestRequest, Operation> rerunConnectivityTestSettings() {
        return this.rerunConnectivityTestSettings;
    }

    public OperationCallSettings<RerunConnectivityTestRequest, ConnectivityTest, OperationMetadata> rerunConnectivityTestOperationSettings() {
        return this.rerunConnectivityTestOperationSettings;
    }

    public UnaryCallSettings<DeleteConnectivityTestRequest, Operation> deleteConnectivityTestSettings() {
        return this.deleteConnectivityTestSettings;
    }

    public OperationCallSettings<DeleteConnectivityTestRequest, Empty, OperationMetadata> deleteConnectivityTestOperationSettings() {
        return this.deleteConnectivityTestOperationSettings;
    }

    public ReachabilityServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcReachabilityServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "networkmanagement.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "networkmanagement.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ReachabilityServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ReachabilityServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ReachabilityServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listConnectivityTestsSettings = settingsBuilder.listConnectivityTestsSettings().build();
        this.getConnectivityTestSettings = settingsBuilder.getConnectivityTestSettings().build();
        this.createConnectivityTestSettings = settingsBuilder.createConnectivityTestSettings().build();
        this.createConnectivityTestOperationSettings = settingsBuilder.createConnectivityTestOperationSettings().build();
        this.updateConnectivityTestSettings = settingsBuilder.updateConnectivityTestSettings().build();
        this.updateConnectivityTestOperationSettings = settingsBuilder.updateConnectivityTestOperationSettings().build();
        this.rerunConnectivityTestSettings = settingsBuilder.rerunConnectivityTestSettings().build();
        this.rerunConnectivityTestOperationSettings = settingsBuilder.rerunConnectivityTestOperationSettings().build();
        this.deleteConnectivityTestSettings = settingsBuilder.deleteConnectivityTestSettings().build();
        this.deleteConnectivityTestOperationSettings = settingsBuilder.deleteConnectivityTestOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ReachabilityServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListConnectivityTestsRequest, ListConnectivityTestsResponse, ReachabilityServiceClient.ListConnectivityTestsPagedResponse> listConnectivityTestsSettings;
        private final UnaryCallSettings.Builder<GetConnectivityTestRequest, ConnectivityTest> getConnectivityTestSettings;
        private final UnaryCallSettings.Builder<CreateConnectivityTestRequest, Operation> createConnectivityTestSettings;
        private final OperationCallSettings.Builder<CreateConnectivityTestRequest, ConnectivityTest, OperationMetadata> createConnectivityTestOperationSettings;
        private final UnaryCallSettings.Builder<UpdateConnectivityTestRequest, Operation> updateConnectivityTestSettings;
        private final OperationCallSettings.Builder<UpdateConnectivityTestRequest, ConnectivityTest, OperationMetadata> updateConnectivityTestOperationSettings;
        private final UnaryCallSettings.Builder<RerunConnectivityTestRequest, Operation> rerunConnectivityTestSettings;
        private final OperationCallSettings.Builder<RerunConnectivityTestRequest, ConnectivityTest, OperationMetadata> rerunConnectivityTestOperationSettings;
        private final UnaryCallSettings.Builder<DeleteConnectivityTestRequest, Operation> deleteConnectivityTestSettings;
        private final OperationCallSettings.Builder<DeleteConnectivityTestRequest, Empty, OperationMetadata> deleteConnectivityTestOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listConnectivityTestsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONNECTIVITY_TESTS_PAGE_STR_FACT);
            this.getConnectivityTestSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConnectivityTestSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConnectivityTestOperationSettings = OperationCallSettings.newBuilder();
            this.updateConnectivityTestSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateConnectivityTestOperationSettings = OperationCallSettings.newBuilder();
            this.rerunConnectivityTestSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.rerunConnectivityTestOperationSettings = OperationCallSettings.newBuilder();
            this.deleteConnectivityTestSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteConnectivityTestOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listConnectivityTestsSettings, this.getConnectivityTestSettings, this.createConnectivityTestSettings, this.updateConnectivityTestSettings, this.rerunConnectivityTestSettings, this.deleteConnectivityTestSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ReachabilityServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listConnectivityTestsSettings = settings.listConnectivityTestsSettings.toBuilder();
            this.getConnectivityTestSettings = settings.getConnectivityTestSettings.toBuilder();
            this.createConnectivityTestSettings = settings.createConnectivityTestSettings.toBuilder();
            this.createConnectivityTestOperationSettings = settings.createConnectivityTestOperationSettings.toBuilder();
            this.updateConnectivityTestSettings = settings.updateConnectivityTestSettings.toBuilder();
            this.updateConnectivityTestOperationSettings = settings.updateConnectivityTestOperationSettings.toBuilder();
            this.rerunConnectivityTestSettings = settings.rerunConnectivityTestSettings.toBuilder();
            this.rerunConnectivityTestOperationSettings = settings.rerunConnectivityTestOperationSettings.toBuilder();
            this.deleteConnectivityTestSettings = settings.deleteConnectivityTestSettings.toBuilder();
            this.deleteConnectivityTestOperationSettings = settings.deleteConnectivityTestOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listConnectivityTestsSettings, this.getConnectivityTestSettings, this.createConnectivityTestSettings, this.updateConnectivityTestSettings, this.rerunConnectivityTestSettings, this.deleteConnectivityTestSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ReachabilityServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ReachabilityServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ReachabilityServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ReachabilityServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ReachabilityServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listConnectivityTestsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getConnectivityTestSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createConnectivityTestSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateConnectivityTestSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.rerunConnectivityTestSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteConnectivityTestSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createConnectivityTestOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ConnectivityTest.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateConnectivityTestOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ConnectivityTest.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.rerunConnectivityTestOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ConnectivityTest.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteConnectivityTestOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListConnectivityTestsRequest, ListConnectivityTestsResponse, ReachabilityServiceClient.ListConnectivityTestsPagedResponse> listConnectivityTestsSettings() {
            return this.listConnectivityTestsSettings;
        }

        public UnaryCallSettings.Builder<GetConnectivityTestRequest, ConnectivityTest> getConnectivityTestSettings() {
            return this.getConnectivityTestSettings;
        }

        public UnaryCallSettings.Builder<CreateConnectivityTestRequest, Operation> createConnectivityTestSettings() {
            return this.createConnectivityTestSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateConnectivityTestRequest, ConnectivityTest, OperationMetadata> createConnectivityTestOperationSettings() {
            return this.createConnectivityTestOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateConnectivityTestRequest, Operation> updateConnectivityTestSettings() {
            return this.updateConnectivityTestSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateConnectivityTestRequest, ConnectivityTest, OperationMetadata> updateConnectivityTestOperationSettings() {
            return this.updateConnectivityTestOperationSettings;
        }

        public UnaryCallSettings.Builder<RerunConnectivityTestRequest, Operation> rerunConnectivityTestSettings() {
            return this.rerunConnectivityTestSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RerunConnectivityTestRequest, ConnectivityTest, OperationMetadata> rerunConnectivityTestOperationSettings() {
            return this.rerunConnectivityTestOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteConnectivityTestRequest, Operation> deleteConnectivityTestSettings() {
            return this.deleteConnectivityTestSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteConnectivityTestRequest, Empty, OperationMetadata> deleteConnectivityTestOperationSettings() {
            return this.deleteConnectivityTestOperationSettings;
        }

        public ReachabilityServiceStubSettings build() throws IOException {
            return new ReachabilityServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

