/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.memcache.v1beta2.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.memcache.v1beta2.ApplyParametersRequest;
import com.google.cloud.memcache.v1beta2.ApplySoftwareUpdateRequest;
import com.google.cloud.memcache.v1beta2.CloudMemcacheClient;
import com.google.cloud.memcache.v1beta2.CreateInstanceRequest;
import com.google.cloud.memcache.v1beta2.DeleteInstanceRequest;
import com.google.cloud.memcache.v1beta2.GetInstanceRequest;
import com.google.cloud.memcache.v1beta2.Instance;
import com.google.cloud.memcache.v1beta2.ListInstancesRequest;
import com.google.cloud.memcache.v1beta2.ListInstancesResponse;
import com.google.cloud.memcache.v1beta2.OperationMetadata;
import com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest;
import com.google.cloud.memcache.v1beta2.UpdateInstanceRequest;
import com.google.cloud.memcache.v1beta2.UpdateParametersRequest;
import com.google.cloud.memcache.v1beta2.stub.CloudMemcacheStub;
import com.google.cloud.memcache.v1beta2.stub.CloudMemcacheStubSettings;
import com.google.cloud.memcache.v1beta2.stub.GrpcCloudMemcacheCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcCloudMemcacheStub
extends CloudMemcacheStub {
    private static final MethodDescriptor<ListInstancesRequest, ListInstancesResponse> listInstancesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.memcache.v1beta2.CloudMemcache/ListInstances").setRequestMarshaller(ProtoUtils.marshaller((Message)ListInstancesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListInstancesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetInstanceRequest, Instance> getInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.memcache.v1beta2.CloudMemcache/GetInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)GetInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Instance.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateInstanceRequest, Operation> createInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.memcache.v1beta2.CloudMemcache/CreateInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateInstanceRequest, Operation> updateInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.memcache.v1beta2.CloudMemcache/UpdateInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateParametersRequest, Operation> updateParametersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.memcache.v1beta2.CloudMemcache/UpdateParameters").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateParametersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteInstanceRequest, Operation> deleteInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.memcache.v1beta2.CloudMemcache/DeleteInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ApplyParametersRequest, Operation> applyParametersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.memcache.v1beta2.CloudMemcache/ApplyParameters").setRequestMarshaller(ProtoUtils.marshaller((Message)ApplyParametersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ApplySoftwareUpdateRequest, Operation> applySoftwareUpdateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.memcache.v1beta2.CloudMemcache/ApplySoftwareUpdate").setRequestMarshaller(ProtoUtils.marshaller((Message)ApplySoftwareUpdateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<RescheduleMaintenanceRequest, Operation> rescheduleMaintenanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.memcache.v1beta2.CloudMemcache/RescheduleMaintenance").setRequestMarshaller(ProtoUtils.marshaller((Message)RescheduleMaintenanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable;
    private final UnaryCallable<ListInstancesRequest, CloudMemcacheClient.ListInstancesPagedResponse> listInstancesPagedCallable;
    private final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable;
    private final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable;
    private final OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable;
    private final UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable;
    private final OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable;
    private final UnaryCallable<UpdateParametersRequest, Operation> updateParametersCallable;
    private final OperationCallable<UpdateParametersRequest, Instance, OperationMetadata> updateParametersOperationCallable;
    private final UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable;
    private final OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable;
    private final UnaryCallable<ApplyParametersRequest, Operation> applyParametersCallable;
    private final OperationCallable<ApplyParametersRequest, Instance, OperationMetadata> applyParametersOperationCallable;
    private final UnaryCallable<ApplySoftwareUpdateRequest, Operation> applySoftwareUpdateCallable;
    private final OperationCallable<ApplySoftwareUpdateRequest, Instance, OperationMetadata> applySoftwareUpdateOperationCallable;
    private final UnaryCallable<RescheduleMaintenanceRequest, Operation> rescheduleMaintenanceCallable;
    private final OperationCallable<RescheduleMaintenanceRequest, Instance, OperationMetadata> rescheduleMaintenanceOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, CloudMemcacheClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCloudMemcacheStub create(CloudMemcacheStubSettings settings) throws IOException {
        return new GrpcCloudMemcacheStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCloudMemcacheStub create(ClientContext clientContext) throws IOException {
        return new GrpcCloudMemcacheStub(CloudMemcacheStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCloudMemcacheStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCloudMemcacheStub(CloudMemcacheStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCloudMemcacheStub(CloudMemcacheStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCloudMemcacheCallableFactory());
    }

    protected GrpcCloudMemcacheStub(CloudMemcacheStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listInstancesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listInstancesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource.name", (Object)String.valueOf(request.getResource().getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateParametersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateParametersMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteInstanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings applyParametersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(applyParametersMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings applySoftwareUpdateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(applySoftwareUpdateMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"instance", (Object)String.valueOf(request.getInstance()));
            return params.build();
        }).build();
        GrpcCallSettings rescheduleMaintenanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(rescheduleMaintenanceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"instance", (Object)String.valueOf(request.getInstance()));
            return params.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        this.listInstancesCallable = callableFactory.createUnaryCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.listInstancesPagedCallable = callableFactory.createPagedCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.getInstanceCallable = callableFactory.createUnaryCallable(getInstanceTransportSettings, settings.getInstanceSettings(), clientContext);
        this.createInstanceCallable = callableFactory.createUnaryCallable(createInstanceTransportSettings, settings.createInstanceSettings(), clientContext);
        this.createInstanceOperationCallable = callableFactory.createOperationCallable(createInstanceTransportSettings, settings.createInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateInstanceCallable = callableFactory.createUnaryCallable(updateInstanceTransportSettings, settings.updateInstanceSettings(), clientContext);
        this.updateInstanceOperationCallable = callableFactory.createOperationCallable(updateInstanceTransportSettings, settings.updateInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateParametersCallable = callableFactory.createUnaryCallable(updateParametersTransportSettings, settings.updateParametersSettings(), clientContext);
        this.updateParametersOperationCallable = callableFactory.createOperationCallable(updateParametersTransportSettings, settings.updateParametersOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteInstanceCallable = callableFactory.createUnaryCallable(deleteInstanceTransportSettings, settings.deleteInstanceSettings(), clientContext);
        this.deleteInstanceOperationCallable = callableFactory.createOperationCallable(deleteInstanceTransportSettings, settings.deleteInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.applyParametersCallable = callableFactory.createUnaryCallable(applyParametersTransportSettings, settings.applyParametersSettings(), clientContext);
        this.applyParametersOperationCallable = callableFactory.createOperationCallable(applyParametersTransportSettings, settings.applyParametersOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.applySoftwareUpdateCallable = callableFactory.createUnaryCallable(applySoftwareUpdateTransportSettings, settings.applySoftwareUpdateSettings(), clientContext);
        this.applySoftwareUpdateOperationCallable = callableFactory.createOperationCallable(applySoftwareUpdateTransportSettings, settings.applySoftwareUpdateOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.rescheduleMaintenanceCallable = callableFactory.createUnaryCallable(rescheduleMaintenanceTransportSettings, settings.rescheduleMaintenanceSettings(), clientContext);
        this.rescheduleMaintenanceOperationCallable = callableFactory.createOperationCallable(rescheduleMaintenanceTransportSettings, settings.rescheduleMaintenanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.listInstancesCallable;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, CloudMemcacheClient.ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.listInstancesPagedCallable;
    }

    @Override
    public UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.getInstanceCallable;
    }

    @Override
    public UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.createInstanceCallable;
    }

    @Override
    public OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable() {
        return this.createInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable() {
        return this.updateInstanceCallable;
    }

    @Override
    public OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable() {
        return this.updateInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateParametersRequest, Operation> updateParametersCallable() {
        return this.updateParametersCallable;
    }

    @Override
    public OperationCallable<UpdateParametersRequest, Instance, OperationMetadata> updateParametersOperationCallable() {
        return this.updateParametersOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable() {
        return this.deleteInstanceCallable;
    }

    @Override
    public OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable() {
        return this.deleteInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<ApplyParametersRequest, Operation> applyParametersCallable() {
        return this.applyParametersCallable;
    }

    @Override
    public OperationCallable<ApplyParametersRequest, Instance, OperationMetadata> applyParametersOperationCallable() {
        return this.applyParametersOperationCallable;
    }

    @Override
    public UnaryCallable<ApplySoftwareUpdateRequest, Operation> applySoftwareUpdateCallable() {
        return this.applySoftwareUpdateCallable;
    }

    @Override
    public OperationCallable<ApplySoftwareUpdateRequest, Instance, OperationMetadata> applySoftwareUpdateOperationCallable() {
        return this.applySoftwareUpdateOperationCallable;
    }

    @Override
    public UnaryCallable<RescheduleMaintenanceRequest, Operation> rescheduleMaintenanceCallable() {
        return this.rescheduleMaintenanceCallable;
    }

    @Override
    public OperationCallable<RescheduleMaintenanceRequest, Instance, OperationMetadata> rescheduleMaintenanceOperationCallable() {
        return this.rescheduleMaintenanceOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, CloudMemcacheClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

