/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.licensemanager.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.licensemanager.v1.AggregateUsageRequest;
import com.google.cloud.licensemanager.v1.AggregateUsageResponse;
import com.google.cloud.licensemanager.v1.Configuration;
import com.google.cloud.licensemanager.v1.CreateConfigurationRequest;
import com.google.cloud.licensemanager.v1.DeactivateConfigurationRequest;
import com.google.cloud.licensemanager.v1.DeleteConfigurationRequest;
import com.google.cloud.licensemanager.v1.GetConfigurationRequest;
import com.google.cloud.licensemanager.v1.GetInstanceRequest;
import com.google.cloud.licensemanager.v1.GetProductRequest;
import com.google.cloud.licensemanager.v1.Instance;
import com.google.cloud.licensemanager.v1.LicenseManagerClient;
import com.google.cloud.licensemanager.v1.ListConfigurationsRequest;
import com.google.cloud.licensemanager.v1.ListConfigurationsResponse;
import com.google.cloud.licensemanager.v1.ListInstancesRequest;
import com.google.cloud.licensemanager.v1.ListInstancesResponse;
import com.google.cloud.licensemanager.v1.ListProductsRequest;
import com.google.cloud.licensemanager.v1.ListProductsResponse;
import com.google.cloud.licensemanager.v1.OperationMetadata;
import com.google.cloud.licensemanager.v1.Product;
import com.google.cloud.licensemanager.v1.QueryConfigurationLicenseUsageRequest;
import com.google.cloud.licensemanager.v1.QueryConfigurationLicenseUsageResponse;
import com.google.cloud.licensemanager.v1.ReactivateConfigurationRequest;
import com.google.cloud.licensemanager.v1.UpdateConfigurationRequest;
import com.google.cloud.licensemanager.v1.stub.HttpJsonLicenseManagerCallableFactory;
import com.google.cloud.licensemanager.v1.stub.LicenseManagerStub;
import com.google.cloud.licensemanager.v1.stub.LicenseManagerStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonLicenseManagerStub
extends LicenseManagerStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(OperationMetadata.getDescriptor()).add(Configuration.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListConfigurationsRequest, ListConfigurationsResponse> listConfigurationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/ListConfigurations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/configurations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListConfigurationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetConfigurationRequest, Configuration> getConfigurationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/GetConfiguration").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/configurations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Configuration.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateConfigurationRequest, Operation> createConfigurationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/CreateConfiguration").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/configurations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "configurationId", (Object)request.getConfigurationId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("configuration", (Message)request.getConfiguration(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateConfigurationRequest, Operation> updateConfigurationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/UpdateConfiguration").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{configuration.name=projects/*/locations/*/configurations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "configuration.name", (Object)request.getConfiguration().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("configuration", (Message)request.getConfiguration(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteConfigurationRequest, Operation> deleteConfigurationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/DeleteConfiguration").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/configurations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListInstancesRequest, ListInstancesResponse> listInstancesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/ListInstances").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/instances", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListInstancesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetInstanceRequest, Instance> getInstanceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/GetInstance").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/instances/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Instance.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeactivateConfigurationRequest, Operation> deactivateConfigurationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/DeactivateConfiguration").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/configurations/*}:deactivate", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ReactivateConfigurationRequest, Operation> reactivateConfigurationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/ReactivateConfiguration").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/configurations/*}:reactivate", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<QueryConfigurationLicenseUsageRequest, QueryConfigurationLicenseUsageResponse> queryConfigurationLicenseUsageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/QueryConfigurationLicenseUsage").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/configurations/*}:queryLicenseUsage", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "endTime", (Object)request.getEndTime());
        serializer.putQueryParam(fields, "startTime", (Object)request.getStartTime());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)QueryConfigurationLicenseUsageResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<AggregateUsageRequest, AggregateUsageResponse> aggregateUsageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/AggregateUsage").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/configurations/*}:aggregateUsage", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "endTime", (Object)request.getEndTime());
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "startTime", (Object)request.getStartTime());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AggregateUsageResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListProductsRequest, ListProductsResponse> listProductsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/ListProducts").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/products", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListProductsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetProductRequest, Product> getProductMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/GetProduct").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/products/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Product.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListConfigurationsRequest, ListConfigurationsResponse> listConfigurationsCallable;
    private final UnaryCallable<ListConfigurationsRequest, LicenseManagerClient.ListConfigurationsPagedResponse> listConfigurationsPagedCallable;
    private final UnaryCallable<GetConfigurationRequest, Configuration> getConfigurationCallable;
    private final UnaryCallable<CreateConfigurationRequest, Operation> createConfigurationCallable;
    private final OperationCallable<CreateConfigurationRequest, Configuration, OperationMetadata> createConfigurationOperationCallable;
    private final UnaryCallable<UpdateConfigurationRequest, Operation> updateConfigurationCallable;
    private final OperationCallable<UpdateConfigurationRequest, Configuration, OperationMetadata> updateConfigurationOperationCallable;
    private final UnaryCallable<DeleteConfigurationRequest, Operation> deleteConfigurationCallable;
    private final OperationCallable<DeleteConfigurationRequest, Empty, OperationMetadata> deleteConfigurationOperationCallable;
    private final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable;
    private final UnaryCallable<ListInstancesRequest, LicenseManagerClient.ListInstancesPagedResponse> listInstancesPagedCallable;
    private final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable;
    private final UnaryCallable<DeactivateConfigurationRequest, Operation> deactivateConfigurationCallable;
    private final OperationCallable<DeactivateConfigurationRequest, Configuration, OperationMetadata> deactivateConfigurationOperationCallable;
    private final UnaryCallable<ReactivateConfigurationRequest, Operation> reactivateConfigurationCallable;
    private final OperationCallable<ReactivateConfigurationRequest, Configuration, OperationMetadata> reactivateConfigurationOperationCallable;
    private final UnaryCallable<QueryConfigurationLicenseUsageRequest, QueryConfigurationLicenseUsageResponse> queryConfigurationLicenseUsageCallable;
    private final UnaryCallable<AggregateUsageRequest, AggregateUsageResponse> aggregateUsageCallable;
    private final UnaryCallable<AggregateUsageRequest, LicenseManagerClient.AggregateUsagePagedResponse> aggregateUsagePagedCallable;
    private final UnaryCallable<ListProductsRequest, ListProductsResponse> listProductsCallable;
    private final UnaryCallable<ListProductsRequest, LicenseManagerClient.ListProductsPagedResponse> listProductsPagedCallable;
    private final UnaryCallable<GetProductRequest, Product> getProductCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, LicenseManagerClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonLicenseManagerStub create(LicenseManagerStubSettings settings) throws IOException {
        return new HttpJsonLicenseManagerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonLicenseManagerStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonLicenseManagerStub(LicenseManagerStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonLicenseManagerStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonLicenseManagerStub(LicenseManagerStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonLicenseManagerStub(LicenseManagerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonLicenseManagerCallableFactory());
    }

    protected HttpJsonLicenseManagerStub(LicenseManagerStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=projects/*/locations/*/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*}/operations").build()).build());
        HttpJsonCallSettings listConfigurationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listConfigurationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getConfigurationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getConfigurationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createConfigurationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createConfigurationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateConfigurationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateConfigurationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("configuration.name", String.valueOf(request.getConfiguration().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteConfigurationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteConfigurationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listInstancesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listInstancesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getInstanceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getInstanceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deactivateConfigurationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deactivateConfigurationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings reactivateConfigurationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(reactivateConfigurationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings queryConfigurationLicenseUsageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(queryConfigurationLicenseUsageMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings aggregateUsageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(aggregateUsageMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listProductsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listProductsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getProductTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getProductMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listConfigurationsCallable = callableFactory.createUnaryCallable(listConfigurationsTransportSettings, settings.listConfigurationsSettings(), clientContext);
        this.listConfigurationsPagedCallable = callableFactory.createPagedCallable(listConfigurationsTransportSettings, settings.listConfigurationsSettings(), clientContext);
        this.getConfigurationCallable = callableFactory.createUnaryCallable(getConfigurationTransportSettings, settings.getConfigurationSettings(), clientContext);
        this.createConfigurationCallable = callableFactory.createUnaryCallable(createConfigurationTransportSettings, settings.createConfigurationSettings(), clientContext);
        this.createConfigurationOperationCallable = callableFactory.createOperationCallable(createConfigurationTransportSettings, settings.createConfigurationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateConfigurationCallable = callableFactory.createUnaryCallable(updateConfigurationTransportSettings, settings.updateConfigurationSettings(), clientContext);
        this.updateConfigurationOperationCallable = callableFactory.createOperationCallable(updateConfigurationTransportSettings, settings.updateConfigurationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteConfigurationCallable = callableFactory.createUnaryCallable(deleteConfigurationTransportSettings, settings.deleteConfigurationSettings(), clientContext);
        this.deleteConfigurationOperationCallable = callableFactory.createOperationCallable(deleteConfigurationTransportSettings, settings.deleteConfigurationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listInstancesCallable = callableFactory.createUnaryCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.listInstancesPagedCallable = callableFactory.createPagedCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.getInstanceCallable = callableFactory.createUnaryCallable(getInstanceTransportSettings, settings.getInstanceSettings(), clientContext);
        this.deactivateConfigurationCallable = callableFactory.createUnaryCallable(deactivateConfigurationTransportSettings, settings.deactivateConfigurationSettings(), clientContext);
        this.deactivateConfigurationOperationCallable = callableFactory.createOperationCallable(deactivateConfigurationTransportSettings, settings.deactivateConfigurationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.reactivateConfigurationCallable = callableFactory.createUnaryCallable(reactivateConfigurationTransportSettings, settings.reactivateConfigurationSettings(), clientContext);
        this.reactivateConfigurationOperationCallable = callableFactory.createOperationCallable(reactivateConfigurationTransportSettings, settings.reactivateConfigurationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.queryConfigurationLicenseUsageCallable = callableFactory.createUnaryCallable(queryConfigurationLicenseUsageTransportSettings, settings.queryConfigurationLicenseUsageSettings(), clientContext);
        this.aggregateUsageCallable = callableFactory.createUnaryCallable(aggregateUsageTransportSettings, settings.aggregateUsageSettings(), clientContext);
        this.aggregateUsagePagedCallable = callableFactory.createPagedCallable(aggregateUsageTransportSettings, settings.aggregateUsageSettings(), clientContext);
        this.listProductsCallable = callableFactory.createUnaryCallable(listProductsTransportSettings, settings.listProductsSettings(), clientContext);
        this.listProductsPagedCallable = callableFactory.createPagedCallable(listProductsTransportSettings, settings.listProductsSettings(), clientContext);
        this.getProductCallable = callableFactory.createUnaryCallable(getProductTransportSettings, settings.getProductSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listConfigurationsMethodDescriptor);
        methodDescriptors.add(getConfigurationMethodDescriptor);
        methodDescriptors.add(createConfigurationMethodDescriptor);
        methodDescriptors.add(updateConfigurationMethodDescriptor);
        methodDescriptors.add(deleteConfigurationMethodDescriptor);
        methodDescriptors.add(listInstancesMethodDescriptor);
        methodDescriptors.add(getInstanceMethodDescriptor);
        methodDescriptors.add(deactivateConfigurationMethodDescriptor);
        methodDescriptors.add(reactivateConfigurationMethodDescriptor);
        methodDescriptors.add(queryConfigurationLicenseUsageMethodDescriptor);
        methodDescriptors.add(aggregateUsageMethodDescriptor);
        methodDescriptors.add(listProductsMethodDescriptor);
        methodDescriptors.add(getProductMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListConfigurationsRequest, ListConfigurationsResponse> listConfigurationsCallable() {
        return this.listConfigurationsCallable;
    }

    @Override
    public UnaryCallable<ListConfigurationsRequest, LicenseManagerClient.ListConfigurationsPagedResponse> listConfigurationsPagedCallable() {
        return this.listConfigurationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetConfigurationRequest, Configuration> getConfigurationCallable() {
        return this.getConfigurationCallable;
    }

    @Override
    public UnaryCallable<CreateConfigurationRequest, Operation> createConfigurationCallable() {
        return this.createConfigurationCallable;
    }

    @Override
    public OperationCallable<CreateConfigurationRequest, Configuration, OperationMetadata> createConfigurationOperationCallable() {
        return this.createConfigurationOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateConfigurationRequest, Operation> updateConfigurationCallable() {
        return this.updateConfigurationCallable;
    }

    @Override
    public OperationCallable<UpdateConfigurationRequest, Configuration, OperationMetadata> updateConfigurationOperationCallable() {
        return this.updateConfigurationOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteConfigurationRequest, Operation> deleteConfigurationCallable() {
        return this.deleteConfigurationCallable;
    }

    @Override
    public OperationCallable<DeleteConfigurationRequest, Empty, OperationMetadata> deleteConfigurationOperationCallable() {
        return this.deleteConfigurationOperationCallable;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.listInstancesCallable;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, LicenseManagerClient.ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.listInstancesPagedCallable;
    }

    @Override
    public UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.getInstanceCallable;
    }

    @Override
    public UnaryCallable<DeactivateConfigurationRequest, Operation> deactivateConfigurationCallable() {
        return this.deactivateConfigurationCallable;
    }

    @Override
    public OperationCallable<DeactivateConfigurationRequest, Configuration, OperationMetadata> deactivateConfigurationOperationCallable() {
        return this.deactivateConfigurationOperationCallable;
    }

    @Override
    public UnaryCallable<ReactivateConfigurationRequest, Operation> reactivateConfigurationCallable() {
        return this.reactivateConfigurationCallable;
    }

    @Override
    public OperationCallable<ReactivateConfigurationRequest, Configuration, OperationMetadata> reactivateConfigurationOperationCallable() {
        return this.reactivateConfigurationOperationCallable;
    }

    @Override
    public UnaryCallable<QueryConfigurationLicenseUsageRequest, QueryConfigurationLicenseUsageResponse> queryConfigurationLicenseUsageCallable() {
        return this.queryConfigurationLicenseUsageCallable;
    }

    @Override
    public UnaryCallable<AggregateUsageRequest, AggregateUsageResponse> aggregateUsageCallable() {
        return this.aggregateUsageCallable;
    }

    @Override
    public UnaryCallable<AggregateUsageRequest, LicenseManagerClient.AggregateUsagePagedResponse> aggregateUsagePagedCallable() {
        return this.aggregateUsagePagedCallable;
    }

    @Override
    public UnaryCallable<ListProductsRequest, ListProductsResponse> listProductsCallable() {
        return this.listProductsCallable;
    }

    @Override
    public UnaryCallable<ListProductsRequest, LicenseManagerClient.ListProductsPagedResponse> listProductsPagedCallable() {
        return this.listProductsPagedCallable;
    }

    @Override
    public UnaryCallable<GetProductRequest, Product> getProductCallable() {
        return this.getProductCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, LicenseManagerClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

