/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.licensemanager.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.licensemanager.v1.AggregateUsageRequest;
import com.google.cloud.licensemanager.v1.AggregateUsageResponse;
import com.google.cloud.licensemanager.v1.Configuration;
import com.google.cloud.licensemanager.v1.ConfigurationName;
import com.google.cloud.licensemanager.v1.CreateConfigurationRequest;
import com.google.cloud.licensemanager.v1.DeactivateConfigurationRequest;
import com.google.cloud.licensemanager.v1.DeleteConfigurationRequest;
import com.google.cloud.licensemanager.v1.GetConfigurationRequest;
import com.google.cloud.licensemanager.v1.GetInstanceRequest;
import com.google.cloud.licensemanager.v1.GetProductRequest;
import com.google.cloud.licensemanager.v1.Instance;
import com.google.cloud.licensemanager.v1.InstanceName;
import com.google.cloud.licensemanager.v1.LicenseManagerSettings;
import com.google.cloud.licensemanager.v1.ListConfigurationsRequest;
import com.google.cloud.licensemanager.v1.ListConfigurationsResponse;
import com.google.cloud.licensemanager.v1.ListInstancesRequest;
import com.google.cloud.licensemanager.v1.ListInstancesResponse;
import com.google.cloud.licensemanager.v1.ListProductsRequest;
import com.google.cloud.licensemanager.v1.ListProductsResponse;
import com.google.cloud.licensemanager.v1.LocationName;
import com.google.cloud.licensemanager.v1.OperationMetadata;
import com.google.cloud.licensemanager.v1.Product;
import com.google.cloud.licensemanager.v1.ProductName;
import com.google.cloud.licensemanager.v1.QueryConfigurationLicenseUsageRequest;
import com.google.cloud.licensemanager.v1.QueryConfigurationLicenseUsageResponse;
import com.google.cloud.licensemanager.v1.ReactivateConfigurationRequest;
import com.google.cloud.licensemanager.v1.UpdateConfigurationRequest;
import com.google.cloud.licensemanager.v1.Usage;
import com.google.cloud.licensemanager.v1.stub.LicenseManagerStub;
import com.google.cloud.licensemanager.v1.stub.LicenseManagerStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class LicenseManagerClient
implements BackgroundResource {
    private final LicenseManagerSettings settings;
    private final LicenseManagerStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final LicenseManagerClient create() throws IOException {
        return LicenseManagerClient.create(LicenseManagerSettings.newBuilder().build());
    }

    public static final LicenseManagerClient create(LicenseManagerSettings settings) throws IOException {
        return new LicenseManagerClient(settings);
    }

    public static final LicenseManagerClient create(LicenseManagerStub stub) {
        return new LicenseManagerClient(stub);
    }

    protected LicenseManagerClient(LicenseManagerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LicenseManagerStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected LicenseManagerClient(LicenseManagerStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final LicenseManagerSettings getSettings() {
        return this.settings;
    }

    public LicenseManagerStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListConfigurationsPagedResponse listConfigurations(LocationName parent) {
        ListConfigurationsRequest request = ListConfigurationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConfigurations(request);
    }

    public final ListConfigurationsPagedResponse listConfigurations(String parent) {
        ListConfigurationsRequest request = ListConfigurationsRequest.newBuilder().setParent(parent).build();
        return this.listConfigurations(request);
    }

    public final ListConfigurationsPagedResponse listConfigurations(ListConfigurationsRequest request) {
        return (ListConfigurationsPagedResponse)((Object)this.listConfigurationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConfigurationsRequest, ListConfigurationsPagedResponse> listConfigurationsPagedCallable() {
        return this.stub.listConfigurationsPagedCallable();
    }

    public final UnaryCallable<ListConfigurationsRequest, ListConfigurationsResponse> listConfigurationsCallable() {
        return this.stub.listConfigurationsCallable();
    }

    public final Configuration getConfiguration(ConfigurationName name) {
        GetConfigurationRequest request = GetConfigurationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConfiguration(request);
    }

    public final Configuration getConfiguration(String name) {
        GetConfigurationRequest request = GetConfigurationRequest.newBuilder().setName(name).build();
        return this.getConfiguration(request);
    }

    public final Configuration getConfiguration(GetConfigurationRequest request) {
        return (Configuration)this.getConfigurationCallable().call((Object)request);
    }

    public final UnaryCallable<GetConfigurationRequest, Configuration> getConfigurationCallable() {
        return this.stub.getConfigurationCallable();
    }

    public final OperationFuture<Configuration, OperationMetadata> createConfigurationAsync(LocationName parent, Configuration configuration, String configurationId) {
        CreateConfigurationRequest request = CreateConfigurationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConfiguration(configuration).setConfigurationId(configurationId).build();
        return this.createConfigurationAsync(request);
    }

    public final OperationFuture<Configuration, OperationMetadata> createConfigurationAsync(String parent, Configuration configuration, String configurationId) {
        CreateConfigurationRequest request = CreateConfigurationRequest.newBuilder().setParent(parent).setConfiguration(configuration).setConfigurationId(configurationId).build();
        return this.createConfigurationAsync(request);
    }

    public final OperationFuture<Configuration, OperationMetadata> createConfigurationAsync(CreateConfigurationRequest request) {
        return this.createConfigurationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateConfigurationRequest, Configuration, OperationMetadata> createConfigurationOperationCallable() {
        return this.stub.createConfigurationOperationCallable();
    }

    public final UnaryCallable<CreateConfigurationRequest, Operation> createConfigurationCallable() {
        return this.stub.createConfigurationCallable();
    }

    public final OperationFuture<Configuration, OperationMetadata> updateConfigurationAsync(Configuration configuration, FieldMask updateMask) {
        UpdateConfigurationRequest request = UpdateConfigurationRequest.newBuilder().setConfiguration(configuration).setUpdateMask(updateMask).build();
        return this.updateConfigurationAsync(request);
    }

    public final OperationFuture<Configuration, OperationMetadata> updateConfigurationAsync(UpdateConfigurationRequest request) {
        return this.updateConfigurationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateConfigurationRequest, Configuration, OperationMetadata> updateConfigurationOperationCallable() {
        return this.stub.updateConfigurationOperationCallable();
    }

    public final UnaryCallable<UpdateConfigurationRequest, Operation> updateConfigurationCallable() {
        return this.stub.updateConfigurationCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConfigurationAsync(ConfigurationName name) {
        DeleteConfigurationRequest request = DeleteConfigurationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteConfigurationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConfigurationAsync(String name) {
        DeleteConfigurationRequest request = DeleteConfigurationRequest.newBuilder().setName(name).build();
        return this.deleteConfigurationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConfigurationAsync(DeleteConfigurationRequest request) {
        return this.deleteConfigurationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteConfigurationRequest, Empty, OperationMetadata> deleteConfigurationOperationCallable() {
        return this.stub.deleteConfigurationOperationCallable();
    }

    public final UnaryCallable<DeleteConfigurationRequest, Operation> deleteConfigurationCallable() {
        return this.stub.deleteConfigurationCallable();
    }

    public final ListInstancesPagedResponse listInstances(LocationName parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(String parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(ListInstancesRequest request) {
        return (ListInstancesPagedResponse)((Object)this.listInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.stub.listInstancesPagedCallable();
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    public final Instance getInstance(InstanceName name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(String name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(GetInstanceRequest request) {
        return (Instance)this.getInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.stub.getInstanceCallable();
    }

    public final OperationFuture<Configuration, OperationMetadata> deactivateConfigurationAsync(ConfigurationName name) {
        DeactivateConfigurationRequest request = DeactivateConfigurationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deactivateConfigurationAsync(request);
    }

    public final OperationFuture<Configuration, OperationMetadata> deactivateConfigurationAsync(String name) {
        DeactivateConfigurationRequest request = DeactivateConfigurationRequest.newBuilder().setName(name).build();
        return this.deactivateConfigurationAsync(request);
    }

    public final OperationFuture<Configuration, OperationMetadata> deactivateConfigurationAsync(DeactivateConfigurationRequest request) {
        return this.deactivateConfigurationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeactivateConfigurationRequest, Configuration, OperationMetadata> deactivateConfigurationOperationCallable() {
        return this.stub.deactivateConfigurationOperationCallable();
    }

    public final UnaryCallable<DeactivateConfigurationRequest, Operation> deactivateConfigurationCallable() {
        return this.stub.deactivateConfigurationCallable();
    }

    public final OperationFuture<Configuration, OperationMetadata> reactivateConfigurationAsync(ConfigurationName name) {
        ReactivateConfigurationRequest request = ReactivateConfigurationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.reactivateConfigurationAsync(request);
    }

    public final OperationFuture<Configuration, OperationMetadata> reactivateConfigurationAsync(String name) {
        ReactivateConfigurationRequest request = ReactivateConfigurationRequest.newBuilder().setName(name).build();
        return this.reactivateConfigurationAsync(request);
    }

    public final OperationFuture<Configuration, OperationMetadata> reactivateConfigurationAsync(ReactivateConfigurationRequest request) {
        return this.reactivateConfigurationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ReactivateConfigurationRequest, Configuration, OperationMetadata> reactivateConfigurationOperationCallable() {
        return this.stub.reactivateConfigurationOperationCallable();
    }

    public final UnaryCallable<ReactivateConfigurationRequest, Operation> reactivateConfigurationCallable() {
        return this.stub.reactivateConfigurationCallable();
    }

    public final QueryConfigurationLicenseUsageResponse queryConfigurationLicenseUsage(ConfigurationName name, Timestamp startTime, Timestamp endTime) {
        QueryConfigurationLicenseUsageRequest request = QueryConfigurationLicenseUsageRequest.newBuilder().setName(name == null ? null : name.toString()).setStartTime(startTime).setEndTime(endTime).build();
        return this.queryConfigurationLicenseUsage(request);
    }

    public final QueryConfigurationLicenseUsageResponse queryConfigurationLicenseUsage(String name, Timestamp startTime, Timestamp endTime) {
        QueryConfigurationLicenseUsageRequest request = QueryConfigurationLicenseUsageRequest.newBuilder().setName(name).setStartTime(startTime).setEndTime(endTime).build();
        return this.queryConfigurationLicenseUsage(request);
    }

    public final QueryConfigurationLicenseUsageResponse queryConfigurationLicenseUsage(QueryConfigurationLicenseUsageRequest request) {
        return (QueryConfigurationLicenseUsageResponse)this.queryConfigurationLicenseUsageCallable().call((Object)request);
    }

    public final UnaryCallable<QueryConfigurationLicenseUsageRequest, QueryConfigurationLicenseUsageResponse> queryConfigurationLicenseUsageCallable() {
        return this.stub.queryConfigurationLicenseUsageCallable();
    }

    public final AggregateUsagePagedResponse aggregateUsage(ConfigurationName name, Timestamp startTime, Timestamp endTime) {
        AggregateUsageRequest request = AggregateUsageRequest.newBuilder().setName(name == null ? null : name.toString()).setStartTime(startTime).setEndTime(endTime).build();
        return this.aggregateUsage(request);
    }

    public final AggregateUsagePagedResponse aggregateUsage(String name, Timestamp startTime, Timestamp endTime) {
        AggregateUsageRequest request = AggregateUsageRequest.newBuilder().setName(name).setStartTime(startTime).setEndTime(endTime).build();
        return this.aggregateUsage(request);
    }

    public final AggregateUsagePagedResponse aggregateUsage(AggregateUsageRequest request) {
        return (AggregateUsagePagedResponse)((Object)this.aggregateUsagePagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregateUsageRequest, AggregateUsagePagedResponse> aggregateUsagePagedCallable() {
        return this.stub.aggregateUsagePagedCallable();
    }

    public final UnaryCallable<AggregateUsageRequest, AggregateUsageResponse> aggregateUsageCallable() {
        return this.stub.aggregateUsageCallable();
    }

    public final ListProductsPagedResponse listProducts(LocationName parent) {
        ListProductsRequest request = ListProductsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProducts(request);
    }

    public final ListProductsPagedResponse listProducts(String parent) {
        ListProductsRequest request = ListProductsRequest.newBuilder().setParent(parent).build();
        return this.listProducts(request);
    }

    public final ListProductsPagedResponse listProducts(ListProductsRequest request) {
        return (ListProductsPagedResponse)((Object)this.listProductsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProductsRequest, ListProductsPagedResponse> listProductsPagedCallable() {
        return this.stub.listProductsPagedCallable();
    }

    public final UnaryCallable<ListProductsRequest, ListProductsResponse> listProductsCallable() {
        return this.stub.listProductsCallable();
    }

    public final Product getProduct(ProductName name) {
        GetProductRequest request = GetProductRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProduct(request);
    }

    public final Product getProduct(String name) {
        GetProductRequest request = GetProductRequest.newBuilder().setName(name).build();
        return this.getProduct(request);
    }

    public final Product getProduct(GetProductRequest request) {
        return (Product)this.getProductCallable().call((Object)request);
    }

    public final UnaryCallable<GetProductRequest, Product> getProductCallable() {
        return this.stub.getProductCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListProductsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProductsRequest, ListProductsResponse, Product, ListProductsPage, ListProductsFixedSizeCollection> {
        private ListProductsFixedSizeCollection(List<ListProductsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProductsFixedSizeCollection createEmptyCollection() {
            return new ListProductsFixedSizeCollection(null, 0);
        }

        protected ListProductsFixedSizeCollection createCollection(List<ListProductsPage> pages, int collectionSize) {
            return new ListProductsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProductsPage
    extends AbstractPage<ListProductsRequest, ListProductsResponse, Product, ListProductsPage> {
        private ListProductsPage(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ListProductsResponse response) {
            super(context, (Object)response);
        }

        private static ListProductsPage createEmptyPage() {
            return new ListProductsPage(null, null);
        }

        protected ListProductsPage createPage(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ListProductsResponse response) {
            return new ListProductsPage(context, response);
        }

        public ApiFuture<ListProductsPage> createPageAsync(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ApiFuture<ListProductsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProductsPagedResponse
    extends AbstractPagedListResponse<ListProductsRequest, ListProductsResponse, Product, ListProductsPage, ListProductsFixedSizeCollection> {
        public static ApiFuture<ListProductsPagedResponse> createAsync(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ApiFuture<ListProductsResponse> futureResponse) {
            ApiFuture<ListProductsPage> futurePage = ListProductsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListProductsPagedResponse((ListProductsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListProductsPagedResponse(ListProductsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProductsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregateUsageFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregateUsageRequest, AggregateUsageResponse, Usage, AggregateUsagePage, AggregateUsageFixedSizeCollection> {
        private AggregateUsageFixedSizeCollection(List<AggregateUsagePage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregateUsageFixedSizeCollection createEmptyCollection() {
            return new AggregateUsageFixedSizeCollection(null, 0);
        }

        protected AggregateUsageFixedSizeCollection createCollection(List<AggregateUsagePage> pages, int collectionSize) {
            return new AggregateUsageFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregateUsagePage
    extends AbstractPage<AggregateUsageRequest, AggregateUsageResponse, Usage, AggregateUsagePage> {
        private AggregateUsagePage(PageContext<AggregateUsageRequest, AggregateUsageResponse, Usage> context, AggregateUsageResponse response) {
            super(context, (Object)response);
        }

        private static AggregateUsagePage createEmptyPage() {
            return new AggregateUsagePage(null, null);
        }

        protected AggregateUsagePage createPage(PageContext<AggregateUsageRequest, AggregateUsageResponse, Usage> context, AggregateUsageResponse response) {
            return new AggregateUsagePage(context, response);
        }

        public ApiFuture<AggregateUsagePage> createPageAsync(PageContext<AggregateUsageRequest, AggregateUsageResponse, Usage> context, ApiFuture<AggregateUsageResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregateUsagePagedResponse
    extends AbstractPagedListResponse<AggregateUsageRequest, AggregateUsageResponse, Usage, AggregateUsagePage, AggregateUsageFixedSizeCollection> {
        public static ApiFuture<AggregateUsagePagedResponse> createAsync(PageContext<AggregateUsageRequest, AggregateUsageResponse, Usage> context, ApiFuture<AggregateUsageResponse> futureResponse) {
            ApiFuture<AggregateUsagePage> futurePage = AggregateUsagePage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregateUsagePagedResponse((AggregateUsagePage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregateUsagePagedResponse(AggregateUsagePage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregateUsageFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        private ListInstancesFixedSizeCollection(List<ListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesFixedSizeCollection createEmptyCollection() {
            return new ListInstancesFixedSizeCollection(null, 0);
        }

        protected ListInstancesFixedSizeCollection createCollection(List<ListInstancesPage> pages, int collectionSize) {
            return new ListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesPage
    extends AbstractPage<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage> {
        private ListInstancesPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            super(context, (Object)response);
        }

        private static ListInstancesPage createEmptyPage() {
            return new ListInstancesPage(null, null);
        }

        protected ListInstancesPage createPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            return new ListInstancesPage(context, response);
        }

        public ApiFuture<ListInstancesPage> createPageAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesPagedResponse
    extends AbstractPagedListResponse<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        public static ApiFuture<ListInstancesPagedResponse> createAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            ApiFuture<ListInstancesPage> futurePage = ListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInstancesPagedResponse((ListInstancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancesPagedResponse(ListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConfigurationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConfigurationsRequest, ListConfigurationsResponse, Configuration, ListConfigurationsPage, ListConfigurationsFixedSizeCollection> {
        private ListConfigurationsFixedSizeCollection(List<ListConfigurationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConfigurationsFixedSizeCollection createEmptyCollection() {
            return new ListConfigurationsFixedSizeCollection(null, 0);
        }

        protected ListConfigurationsFixedSizeCollection createCollection(List<ListConfigurationsPage> pages, int collectionSize) {
            return new ListConfigurationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConfigurationsPage
    extends AbstractPage<ListConfigurationsRequest, ListConfigurationsResponse, Configuration, ListConfigurationsPage> {
        private ListConfigurationsPage(PageContext<ListConfigurationsRequest, ListConfigurationsResponse, Configuration> context, ListConfigurationsResponse response) {
            super(context, (Object)response);
        }

        private static ListConfigurationsPage createEmptyPage() {
            return new ListConfigurationsPage(null, null);
        }

        protected ListConfigurationsPage createPage(PageContext<ListConfigurationsRequest, ListConfigurationsResponse, Configuration> context, ListConfigurationsResponse response) {
            return new ListConfigurationsPage(context, response);
        }

        public ApiFuture<ListConfigurationsPage> createPageAsync(PageContext<ListConfigurationsRequest, ListConfigurationsResponse, Configuration> context, ApiFuture<ListConfigurationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConfigurationsPagedResponse
    extends AbstractPagedListResponse<ListConfigurationsRequest, ListConfigurationsResponse, Configuration, ListConfigurationsPage, ListConfigurationsFixedSizeCollection> {
        public static ApiFuture<ListConfigurationsPagedResponse> createAsync(PageContext<ListConfigurationsRequest, ListConfigurationsResponse, Configuration> context, ApiFuture<ListConfigurationsResponse> futureResponse) {
            ApiFuture<ListConfigurationsPage> futurePage = ListConfigurationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConfigurationsPagedResponse((ListConfigurationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConfigurationsPagedResponse(ListConfigurationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConfigurationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

