/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.language.v1beta2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.language.v1beta2.AnalyzeEntitiesRequest;
import com.google.cloud.language.v1beta2.AnalyzeEntitiesResponse;
import com.google.cloud.language.v1beta2.AnalyzeEntitySentimentRequest;
import com.google.cloud.language.v1beta2.AnalyzeEntitySentimentResponse;
import com.google.cloud.language.v1beta2.AnalyzeSentimentRequest;
import com.google.cloud.language.v1beta2.AnalyzeSentimentResponse;
import com.google.cloud.language.v1beta2.AnalyzeSyntaxRequest;
import com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse;
import com.google.cloud.language.v1beta2.AnnotateTextRequest;
import com.google.cloud.language.v1beta2.AnnotateTextResponse;
import com.google.cloud.language.v1beta2.ClassifyTextRequest;
import com.google.cloud.language.v1beta2.ClassifyTextResponse;
import com.google.cloud.language.v1beta2.stub.GrpcLanguageServiceCallableFactory;
import com.google.cloud.language.v1beta2.stub.LanguageServiceStub;
import com.google.cloud.language.v1beta2.stub.LanguageServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcLanguageServiceStub
extends LanguageServiceStub {
    private static final MethodDescriptor<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.language.v1beta2.LanguageService/AnalyzeSentiment").setRequestMarshaller(ProtoUtils.marshaller((Message)AnalyzeSentimentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AnalyzeSentimentResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.language.v1beta2.LanguageService/AnalyzeEntities").setRequestMarshaller(ProtoUtils.marshaller((Message)AnalyzeEntitiesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AnalyzeEntitiesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<AnalyzeEntitySentimentRequest, AnalyzeEntitySentimentResponse> analyzeEntitySentimentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.language.v1beta2.LanguageService/AnalyzeEntitySentiment").setRequestMarshaller(ProtoUtils.marshaller((Message)AnalyzeEntitySentimentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AnalyzeEntitySentimentResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<AnalyzeSyntaxRequest, AnalyzeSyntaxResponse> analyzeSyntaxMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.language.v1beta2.LanguageService/AnalyzeSyntax").setRequestMarshaller(ProtoUtils.marshaller((Message)AnalyzeSyntaxRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AnalyzeSyntaxResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ClassifyTextRequest, ClassifyTextResponse> classifyTextMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.language.v1beta2.LanguageService/ClassifyText").setRequestMarshaller(ProtoUtils.marshaller((Message)ClassifyTextRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ClassifyTextResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<AnnotateTextRequest, AnnotateTextResponse> annotateTextMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.language.v1beta2.LanguageService/AnnotateText").setRequestMarshaller(ProtoUtils.marshaller((Message)AnnotateTextRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AnnotateTextResponse.getDefaultInstance())).build();
    private final UnaryCallable<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentCallable;
    private final UnaryCallable<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesCallable;
    private final UnaryCallable<AnalyzeEntitySentimentRequest, AnalyzeEntitySentimentResponse> analyzeEntitySentimentCallable;
    private final UnaryCallable<AnalyzeSyntaxRequest, AnalyzeSyntaxResponse> analyzeSyntaxCallable;
    private final UnaryCallable<ClassifyTextRequest, ClassifyTextResponse> classifyTextCallable;
    private final UnaryCallable<AnnotateTextRequest, AnnotateTextResponse> annotateTextCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcLanguageServiceStub create(LanguageServiceStubSettings settings) throws IOException {
        return new GrpcLanguageServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcLanguageServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcLanguageServiceStub(LanguageServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcLanguageServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcLanguageServiceStub(LanguageServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcLanguageServiceStub(LanguageServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcLanguageServiceCallableFactory());
    }

    protected GrpcLanguageServiceStub(LanguageServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings analyzeSentimentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(analyzeSentimentMethodDescriptor).build();
        GrpcCallSettings analyzeEntitiesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(analyzeEntitiesMethodDescriptor).build();
        GrpcCallSettings analyzeEntitySentimentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(analyzeEntitySentimentMethodDescriptor).build();
        GrpcCallSettings analyzeSyntaxTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(analyzeSyntaxMethodDescriptor).build();
        GrpcCallSettings classifyTextTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(classifyTextMethodDescriptor).build();
        GrpcCallSettings annotateTextTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(annotateTextMethodDescriptor).build();
        this.analyzeSentimentCallable = callableFactory.createUnaryCallable(analyzeSentimentTransportSettings, settings.analyzeSentimentSettings(), clientContext);
        this.analyzeEntitiesCallable = callableFactory.createUnaryCallable(analyzeEntitiesTransportSettings, settings.analyzeEntitiesSettings(), clientContext);
        this.analyzeEntitySentimentCallable = callableFactory.createUnaryCallable(analyzeEntitySentimentTransportSettings, settings.analyzeEntitySentimentSettings(), clientContext);
        this.analyzeSyntaxCallable = callableFactory.createUnaryCallable(analyzeSyntaxTransportSettings, settings.analyzeSyntaxSettings(), clientContext);
        this.classifyTextCallable = callableFactory.createUnaryCallable(classifyTextTransportSettings, settings.classifyTextSettings(), clientContext);
        this.annotateTextCallable = callableFactory.createUnaryCallable(annotateTextTransportSettings, settings.annotateTextSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentCallable() {
        return this.analyzeSentimentCallable;
    }

    @Override
    public UnaryCallable<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesCallable() {
        return this.analyzeEntitiesCallable;
    }

    @Override
    public UnaryCallable<AnalyzeEntitySentimentRequest, AnalyzeEntitySentimentResponse> analyzeEntitySentimentCallable() {
        return this.analyzeEntitySentimentCallable;
    }

    @Override
    public UnaryCallable<AnalyzeSyntaxRequest, AnalyzeSyntaxResponse> analyzeSyntaxCallable() {
        return this.analyzeSyntaxCallable;
    }

    @Override
    public UnaryCallable<ClassifyTextRequest, ClassifyTextResponse> classifyTextCallable() {
        return this.classifyTextCallable;
    }

    @Override
    public UnaryCallable<AnnotateTextRequest, AnnotateTextResponse> annotateTextCallable() {
        return this.annotateTextCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

