/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.inventory.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.kms.inventory.v1.GetProtectedResourcesSummaryRequest;
import com.google.cloud.kms.inventory.v1.KeyTrackingServiceClient;
import com.google.cloud.kms.inventory.v1.ProtectedResource;
import com.google.cloud.kms.inventory.v1.ProtectedResourcesSummary;
import com.google.cloud.kms.inventory.v1.SearchProtectedResourcesRequest;
import com.google.cloud.kms.inventory.v1.SearchProtectedResourcesResponse;
import com.google.cloud.kms.inventory.v1.stub.GrpcKeyTrackingServiceStub;
import com.google.cloud.kms.inventory.v1.stub.HttpJsonKeyTrackingServiceStub;
import com.google.cloud.kms.inventory.v1.stub.KeyTrackingServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class KeyTrackingServiceStubSettings
extends StubSettings<KeyTrackingServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetProtectedResourcesSummaryRequest, ProtectedResourcesSummary> getProtectedResourcesSummarySettings;
    private final PagedCallSettings<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse, KeyTrackingServiceClient.SearchProtectedResourcesPagedResponse> searchProtectedResourcesSettings;
    private static final PagedListDescriptor<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse, ProtectedResource> SEARCH_PROTECTED_RESOURCES_PAGE_STR_DESC = new PagedListDescriptor<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse, ProtectedResource>(){

        public String emptyToken() {
            return "";
        }

        public SearchProtectedResourcesRequest injectToken(SearchProtectedResourcesRequest payload, String token) {
            return SearchProtectedResourcesRequest.newBuilder((SearchProtectedResourcesRequest)payload).setPageToken(token).build();
        }

        public SearchProtectedResourcesRequest injectPageSize(SearchProtectedResourcesRequest payload, int pageSize) {
            return SearchProtectedResourcesRequest.newBuilder((SearchProtectedResourcesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchProtectedResourcesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchProtectedResourcesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ProtectedResource> extractResources(SearchProtectedResourcesResponse payload) {
            return payload.getProtectedResourcesList() == null ? ImmutableList.of() : payload.getProtectedResourcesList();
        }
    };
    private static final PagedListResponseFactory<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse, KeyTrackingServiceClient.SearchProtectedResourcesPagedResponse> SEARCH_PROTECTED_RESOURCES_PAGE_STR_FACT = new PagedListResponseFactory<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse, KeyTrackingServiceClient.SearchProtectedResourcesPagedResponse>(){

        public ApiFuture<KeyTrackingServiceClient.SearchProtectedResourcesPagedResponse> getFuturePagedResponse(UnaryCallable<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse> callable, SearchProtectedResourcesRequest request, ApiCallContext context, ApiFuture<SearchProtectedResourcesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_PROTECTED_RESOURCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return KeyTrackingServiceClient.SearchProtectedResourcesPagedResponse.createAsync((PageContext<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse, ProtectedResource>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetProtectedResourcesSummaryRequest, ProtectedResourcesSummary> getProtectedResourcesSummarySettings() {
        return this.getProtectedResourcesSummarySettings;
    }

    public PagedCallSettings<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse, KeyTrackingServiceClient.SearchProtectedResourcesPagedResponse> searchProtectedResourcesSettings() {
        return this.searchProtectedResourcesSettings;
    }

    public KeyTrackingServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcKeyTrackingServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonKeyTrackingServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "kmsinventory";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "kmsinventory.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "kmsinventory.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return KeyTrackingServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(KeyTrackingServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(KeyTrackingServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return KeyTrackingServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected KeyTrackingServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getProtectedResourcesSummarySettings = settingsBuilder.getProtectedResourcesSummarySettings().build();
        this.searchProtectedResourcesSettings = settingsBuilder.searchProtectedResourcesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<KeyTrackingServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetProtectedResourcesSummaryRequest, ProtectedResourcesSummary> getProtectedResourcesSummarySettings;
        private final PagedCallSettings.Builder<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse, KeyTrackingServiceClient.SearchProtectedResourcesPagedResponse> searchProtectedResourcesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getProtectedResourcesSummarySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchProtectedResourcesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_PROTECTED_RESOURCES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getProtectedResourcesSummarySettings, this.searchProtectedResourcesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(KeyTrackingServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getProtectedResourcesSummarySettings = settings.getProtectedResourcesSummarySettings.toBuilder();
            this.searchProtectedResourcesSettings = settings.searchProtectedResourcesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getProtectedResourcesSummarySettings, this.searchProtectedResourcesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(KeyTrackingServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)KeyTrackingServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)KeyTrackingServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(KeyTrackingServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)KeyTrackingServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)KeyTrackingServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)KeyTrackingServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(KeyTrackingServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getProtectedResourcesSummarySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.searchProtectedResourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetProtectedResourcesSummaryRequest, ProtectedResourcesSummary> getProtectedResourcesSummarySettings() {
            return this.getProtectedResourcesSummarySettings;
        }

        public PagedCallSettings.Builder<SearchProtectedResourcesRequest, SearchProtectedResourcesResponse, KeyTrackingServiceClient.SearchProtectedResourcesPagedResponse> searchProtectedResourcesSettings() {
            return this.searchProtectedResourcesSettings;
        }

        public KeyTrackingServiceStubSettings build() throws IOException {
            return new KeyTrackingServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

