/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.kms.v1.AsymmetricDecryptRequest;
import com.google.cloud.kms.v1.AsymmetricDecryptResponse;
import com.google.cloud.kms.v1.AsymmetricSignRequest;
import com.google.cloud.kms.v1.AsymmetricSignResponse;
import com.google.cloud.kms.v1.CreateCryptoKeyRequest;
import com.google.cloud.kms.v1.CreateCryptoKeyVersionRequest;
import com.google.cloud.kms.v1.CreateImportJobRequest;
import com.google.cloud.kms.v1.CreateKeyRingRequest;
import com.google.cloud.kms.v1.CryptoKey;
import com.google.cloud.kms.v1.CryptoKeyVersion;
import com.google.cloud.kms.v1.DecryptRequest;
import com.google.cloud.kms.v1.DecryptResponse;
import com.google.cloud.kms.v1.DestroyCryptoKeyVersionRequest;
import com.google.cloud.kms.v1.EncryptRequest;
import com.google.cloud.kms.v1.EncryptResponse;
import com.google.cloud.kms.v1.GenerateRandomBytesRequest;
import com.google.cloud.kms.v1.GenerateRandomBytesResponse;
import com.google.cloud.kms.v1.GetCryptoKeyRequest;
import com.google.cloud.kms.v1.GetCryptoKeyVersionRequest;
import com.google.cloud.kms.v1.GetImportJobRequest;
import com.google.cloud.kms.v1.GetKeyRingRequest;
import com.google.cloud.kms.v1.GetPublicKeyRequest;
import com.google.cloud.kms.v1.ImportCryptoKeyVersionRequest;
import com.google.cloud.kms.v1.ImportJob;
import com.google.cloud.kms.v1.KeyManagementServiceClient;
import com.google.cloud.kms.v1.KeyRing;
import com.google.cloud.kms.v1.ListCryptoKeyVersionsRequest;
import com.google.cloud.kms.v1.ListCryptoKeyVersionsResponse;
import com.google.cloud.kms.v1.ListCryptoKeysRequest;
import com.google.cloud.kms.v1.ListCryptoKeysResponse;
import com.google.cloud.kms.v1.ListImportJobsRequest;
import com.google.cloud.kms.v1.ListImportJobsResponse;
import com.google.cloud.kms.v1.ListKeyRingsRequest;
import com.google.cloud.kms.v1.ListKeyRingsResponse;
import com.google.cloud.kms.v1.MacSignRequest;
import com.google.cloud.kms.v1.MacSignResponse;
import com.google.cloud.kms.v1.MacVerifyRequest;
import com.google.cloud.kms.v1.MacVerifyResponse;
import com.google.cloud.kms.v1.PublicKey;
import com.google.cloud.kms.v1.RestoreCryptoKeyVersionRequest;
import com.google.cloud.kms.v1.UpdateCryptoKeyPrimaryVersionRequest;
import com.google.cloud.kms.v1.UpdateCryptoKeyRequest;
import com.google.cloud.kms.v1.UpdateCryptoKeyVersionRequest;
import com.google.cloud.kms.v1.stub.HttpJsonKeyManagementServiceCallableFactory;
import com.google.cloud.kms.v1.stub.KeyManagementServiceStub;
import com.google.cloud.kms.v1.stub.KeyManagementServiceStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonKeyManagementServiceStub
extends KeyManagementServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListKeyRingsRequest, ListKeyRingsResponse> listKeyRingsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/ListKeyRings").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/keyRings", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListKeyRingsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListCryptoKeysRequest, ListCryptoKeysResponse> listCryptoKeysMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/ListCryptoKeys").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/keyRings/*}/cryptoKeys", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "versionView", (Object)request.getVersionView());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListCryptoKeysResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse> listCryptoKeyVersionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/ListCryptoKeyVersions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/keyRings/*/cryptoKeys/*}/cryptoKeyVersions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "view", (Object)request.getView());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListCryptoKeyVersionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListImportJobsRequest, ListImportJobsResponse> listImportJobsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/ListImportJobs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/keyRings/*}/importJobs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListImportJobsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetKeyRingRequest, KeyRing> getKeyRingMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/GetKeyRing").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/keyRings/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)KeyRing.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetCryptoKeyRequest, CryptoKey> getCryptoKeyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/GetCryptoKey").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/keyRings/*/cryptoKeys/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CryptoKey.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetCryptoKeyVersionRequest, CryptoKeyVersion> getCryptoKeyVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/GetCryptoKeyVersion").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CryptoKeyVersion.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetPublicKeyRequest, PublicKey> getPublicKeyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/GetPublicKey").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*}/publicKey", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)PublicKey.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetImportJobRequest, ImportJob> getImportJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/GetImportJob").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/keyRings/*/importJobs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ImportJob.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateKeyRingRequest, KeyRing> createKeyRingMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/CreateKeyRing").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/keyRings", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "keyRingId", (Object)request.getKeyRingId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("keyRing", (Message)request.getKeyRing())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)KeyRing.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateCryptoKeyRequest, CryptoKey> createCryptoKeyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/CreateCryptoKey").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/keyRings/*}/cryptoKeys", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "cryptoKeyId", (Object)request.getCryptoKeyId());
        serializer.putQueryParam(fields, "skipInitialVersionCreation", (Object)request.getSkipInitialVersionCreation());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("cryptoKey", (Message)request.getCryptoKey())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CryptoKey.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateCryptoKeyVersionRequest, CryptoKeyVersion> createCryptoKeyVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/CreateCryptoKeyVersion").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/keyRings/*/cryptoKeys/*}/cryptoKeyVersions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("cryptoKeyVersion", (Message)request.getCryptoKeyVersion())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CryptoKeyVersion.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ImportCryptoKeyVersionRequest, CryptoKeyVersion> importCryptoKeyVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/ImportCryptoKeyVersion").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/keyRings/*/cryptoKeys/*}/cryptoKeyVersions:import", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CryptoKeyVersion.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateImportJobRequest, ImportJob> createImportJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/CreateImportJob").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/keyRings/*}/importJobs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "importJobId", (Object)request.getImportJobId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("importJob", (Message)request.getImportJob())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ImportJob.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateCryptoKeyRequest, CryptoKey> updateCryptoKeyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/UpdateCryptoKey").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{cryptoKey.name=projects/*/locations/*/keyRings/*/cryptoKeys/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "cryptoKey.name", (Object)request.getCryptoKey().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("cryptoKey", (Message)request.getCryptoKey())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CryptoKey.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateCryptoKeyVersionRequest, CryptoKeyVersion> updateCryptoKeyVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/UpdateCryptoKeyVersion").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{cryptoKeyVersion.name=projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "cryptoKeyVersion.name", (Object)request.getCryptoKeyVersion().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("cryptoKeyVersion", (Message)request.getCryptoKeyVersion())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CryptoKeyVersion.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateCryptoKeyPrimaryVersionRequest, CryptoKey> updateCryptoKeyPrimaryVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/UpdateCryptoKeyPrimaryVersion").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/keyRings/*/cryptoKeys/*}:updatePrimaryVersion", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CryptoKey.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DestroyCryptoKeyVersionRequest, CryptoKeyVersion> destroyCryptoKeyVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/DestroyCryptoKeyVersion").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*}:destroy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CryptoKeyVersion.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RestoreCryptoKeyVersionRequest, CryptoKeyVersion> restoreCryptoKeyVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/RestoreCryptoKeyVersion").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*}:restore", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CryptoKeyVersion.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<EncryptRequest, EncryptResponse> encryptMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/Encrypt").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/keyRings/*/cryptoKeys/**}:encrypt", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)EncryptResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DecryptRequest, DecryptResponse> decryptMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/Decrypt").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/keyRings/*/cryptoKeys/*}:decrypt", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DecryptResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<AsymmetricSignRequest, AsymmetricSignResponse> asymmetricSignMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/AsymmetricSign").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*}:asymmetricSign", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AsymmetricSignResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<AsymmetricDecryptRequest, AsymmetricDecryptResponse> asymmetricDecryptMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/AsymmetricDecrypt").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*}:asymmetricDecrypt", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AsymmetricDecryptResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<MacSignRequest, MacSignResponse> macSignMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/MacSign").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*}:macSign", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)MacSignResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<MacVerifyRequest, MacVerifyResponse> macVerifyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/MacVerify").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*}:macVerify", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)MacVerifyResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GenerateRandomBytesRequest, GenerateRandomBytesResponse> generateRandomBytesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.kms.v1.KeyManagementService/GenerateRandomBytes").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{location=projects/*/locations/*}:generateRandomBytes", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "location", (Object)request.getLocation());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearLocation().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)GenerateRandomBytesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/locations/*/keyRings/*}:setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/locations/*/keyRings/*/cryptoKeys/*}:setIamPolicy", "/v1/{resource=projects/*/locations/*/keyRings/*/importJobs/*}:setIamPolicy", "/v1/{resource=projects/*/locations/*/ekmConnections/*}:setIamPolicy"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/locations/*/keyRings/*}:getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/locations/*/keyRings/*/cryptoKeys/*}:getIamPolicy", "/v1/{resource=projects/*/locations/*/keyRings/*/importJobs/*}:getIamPolicy", "/v1/{resource=projects/*/locations/*/ekmConnections/*}:getIamPolicy"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/locations/*/keyRings/*}:testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/locations/*/keyRings/*/cryptoKeys/*}:testIamPermissions", "/v1/{resource=projects/*/locations/*/keyRings/*/importJobs/*}:testIamPermissions", "/v1/{resource=projects/*/locations/*/ekmConnections/*}:testIamPermissions"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListKeyRingsRequest, ListKeyRingsResponse> listKeyRingsCallable;
    private final UnaryCallable<ListKeyRingsRequest, KeyManagementServiceClient.ListKeyRingsPagedResponse> listKeyRingsPagedCallable;
    private final UnaryCallable<ListCryptoKeysRequest, ListCryptoKeysResponse> listCryptoKeysCallable;
    private final UnaryCallable<ListCryptoKeysRequest, KeyManagementServiceClient.ListCryptoKeysPagedResponse> listCryptoKeysPagedCallable;
    private final UnaryCallable<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse> listCryptoKeyVersionsCallable;
    private final UnaryCallable<ListCryptoKeyVersionsRequest, KeyManagementServiceClient.ListCryptoKeyVersionsPagedResponse> listCryptoKeyVersionsPagedCallable;
    private final UnaryCallable<ListImportJobsRequest, ListImportJobsResponse> listImportJobsCallable;
    private final UnaryCallable<ListImportJobsRequest, KeyManagementServiceClient.ListImportJobsPagedResponse> listImportJobsPagedCallable;
    private final UnaryCallable<GetKeyRingRequest, KeyRing> getKeyRingCallable;
    private final UnaryCallable<GetCryptoKeyRequest, CryptoKey> getCryptoKeyCallable;
    private final UnaryCallable<GetCryptoKeyVersionRequest, CryptoKeyVersion> getCryptoKeyVersionCallable;
    private final UnaryCallable<GetPublicKeyRequest, PublicKey> getPublicKeyCallable;
    private final UnaryCallable<GetImportJobRequest, ImportJob> getImportJobCallable;
    private final UnaryCallable<CreateKeyRingRequest, KeyRing> createKeyRingCallable;
    private final UnaryCallable<CreateCryptoKeyRequest, CryptoKey> createCryptoKeyCallable;
    private final UnaryCallable<CreateCryptoKeyVersionRequest, CryptoKeyVersion> createCryptoKeyVersionCallable;
    private final UnaryCallable<ImportCryptoKeyVersionRequest, CryptoKeyVersion> importCryptoKeyVersionCallable;
    private final UnaryCallable<CreateImportJobRequest, ImportJob> createImportJobCallable;
    private final UnaryCallable<UpdateCryptoKeyRequest, CryptoKey> updateCryptoKeyCallable;
    private final UnaryCallable<UpdateCryptoKeyVersionRequest, CryptoKeyVersion> updateCryptoKeyVersionCallable;
    private final UnaryCallable<UpdateCryptoKeyPrimaryVersionRequest, CryptoKey> updateCryptoKeyPrimaryVersionCallable;
    private final UnaryCallable<DestroyCryptoKeyVersionRequest, CryptoKeyVersion> destroyCryptoKeyVersionCallable;
    private final UnaryCallable<RestoreCryptoKeyVersionRequest, CryptoKeyVersion> restoreCryptoKeyVersionCallable;
    private final UnaryCallable<EncryptRequest, EncryptResponse> encryptCallable;
    private final UnaryCallable<DecryptRequest, DecryptResponse> decryptCallable;
    private final UnaryCallable<AsymmetricSignRequest, AsymmetricSignResponse> asymmetricSignCallable;
    private final UnaryCallable<AsymmetricDecryptRequest, AsymmetricDecryptResponse> asymmetricDecryptCallable;
    private final UnaryCallable<MacSignRequest, MacSignResponse> macSignCallable;
    private final UnaryCallable<MacVerifyRequest, MacVerifyResponse> macVerifyCallable;
    private final UnaryCallable<GenerateRandomBytesRequest, GenerateRandomBytesResponse> generateRandomBytesCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonKeyManagementServiceStub create(KeyManagementServiceStubSettings settings) throws IOException {
        return new HttpJsonKeyManagementServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonKeyManagementServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonKeyManagementServiceStub(KeyManagementServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonKeyManagementServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonKeyManagementServiceStub(KeyManagementServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonKeyManagementServiceStub(KeyManagementServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonKeyManagementServiceCallableFactory());
    }

    protected HttpJsonKeyManagementServiceStub(KeyManagementServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listKeyRingsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listKeyRingsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listCryptoKeysTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listCryptoKeysMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listCryptoKeyVersionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listCryptoKeyVersionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listImportJobsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listImportJobsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getKeyRingTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getKeyRingMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getCryptoKeyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getCryptoKeyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getCryptoKeyVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getCryptoKeyVersionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getPublicKeyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getPublicKeyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getImportJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getImportJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createKeyRingTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createKeyRingMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createCryptoKeyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createCryptoKeyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createCryptoKeyVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createCryptoKeyVersionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings importCryptoKeyVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(importCryptoKeyVersionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createImportJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createImportJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateCryptoKeyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateCryptoKeyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateCryptoKeyVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateCryptoKeyVersionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateCryptoKeyPrimaryVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateCryptoKeyPrimaryVersionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings destroyCryptoKeyVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(destroyCryptoKeyVersionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings restoreCryptoKeyVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(restoreCryptoKeyVersionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings encryptTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(encryptMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings decryptTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(decryptMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings asymmetricSignTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(asymmetricSignMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings asymmetricDecryptTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(asymmetricDecryptMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings macSignTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(macSignMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings macVerifyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(macVerifyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings generateRandomBytesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(generateRandomBytesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listKeyRingsCallable = callableFactory.createUnaryCallable(listKeyRingsTransportSettings, settings.listKeyRingsSettings(), clientContext);
        this.listKeyRingsPagedCallable = callableFactory.createPagedCallable(listKeyRingsTransportSettings, settings.listKeyRingsSettings(), clientContext);
        this.listCryptoKeysCallable = callableFactory.createUnaryCallable(listCryptoKeysTransportSettings, settings.listCryptoKeysSettings(), clientContext);
        this.listCryptoKeysPagedCallable = callableFactory.createPagedCallable(listCryptoKeysTransportSettings, settings.listCryptoKeysSettings(), clientContext);
        this.listCryptoKeyVersionsCallable = callableFactory.createUnaryCallable(listCryptoKeyVersionsTransportSettings, settings.listCryptoKeyVersionsSettings(), clientContext);
        this.listCryptoKeyVersionsPagedCallable = callableFactory.createPagedCallable(listCryptoKeyVersionsTransportSettings, settings.listCryptoKeyVersionsSettings(), clientContext);
        this.listImportJobsCallable = callableFactory.createUnaryCallable(listImportJobsTransportSettings, settings.listImportJobsSettings(), clientContext);
        this.listImportJobsPagedCallable = callableFactory.createPagedCallable(listImportJobsTransportSettings, settings.listImportJobsSettings(), clientContext);
        this.getKeyRingCallable = callableFactory.createUnaryCallable(getKeyRingTransportSettings, settings.getKeyRingSettings(), clientContext);
        this.getCryptoKeyCallable = callableFactory.createUnaryCallable(getCryptoKeyTransportSettings, settings.getCryptoKeySettings(), clientContext);
        this.getCryptoKeyVersionCallable = callableFactory.createUnaryCallable(getCryptoKeyVersionTransportSettings, settings.getCryptoKeyVersionSettings(), clientContext);
        this.getPublicKeyCallable = callableFactory.createUnaryCallable(getPublicKeyTransportSettings, settings.getPublicKeySettings(), clientContext);
        this.getImportJobCallable = callableFactory.createUnaryCallable(getImportJobTransportSettings, settings.getImportJobSettings(), clientContext);
        this.createKeyRingCallable = callableFactory.createUnaryCallable(createKeyRingTransportSettings, settings.createKeyRingSettings(), clientContext);
        this.createCryptoKeyCallable = callableFactory.createUnaryCallable(createCryptoKeyTransportSettings, settings.createCryptoKeySettings(), clientContext);
        this.createCryptoKeyVersionCallable = callableFactory.createUnaryCallable(createCryptoKeyVersionTransportSettings, settings.createCryptoKeyVersionSettings(), clientContext);
        this.importCryptoKeyVersionCallable = callableFactory.createUnaryCallable(importCryptoKeyVersionTransportSettings, settings.importCryptoKeyVersionSettings(), clientContext);
        this.createImportJobCallable = callableFactory.createUnaryCallable(createImportJobTransportSettings, settings.createImportJobSettings(), clientContext);
        this.updateCryptoKeyCallable = callableFactory.createUnaryCallable(updateCryptoKeyTransportSettings, settings.updateCryptoKeySettings(), clientContext);
        this.updateCryptoKeyVersionCallable = callableFactory.createUnaryCallable(updateCryptoKeyVersionTransportSettings, settings.updateCryptoKeyVersionSettings(), clientContext);
        this.updateCryptoKeyPrimaryVersionCallable = callableFactory.createUnaryCallable(updateCryptoKeyPrimaryVersionTransportSettings, settings.updateCryptoKeyPrimaryVersionSettings(), clientContext);
        this.destroyCryptoKeyVersionCallable = callableFactory.createUnaryCallable(destroyCryptoKeyVersionTransportSettings, settings.destroyCryptoKeyVersionSettings(), clientContext);
        this.restoreCryptoKeyVersionCallable = callableFactory.createUnaryCallable(restoreCryptoKeyVersionTransportSettings, settings.restoreCryptoKeyVersionSettings(), clientContext);
        this.encryptCallable = callableFactory.createUnaryCallable(encryptTransportSettings, settings.encryptSettings(), clientContext);
        this.decryptCallable = callableFactory.createUnaryCallable(decryptTransportSettings, settings.decryptSettings(), clientContext);
        this.asymmetricSignCallable = callableFactory.createUnaryCallable(asymmetricSignTransportSettings, settings.asymmetricSignSettings(), clientContext);
        this.asymmetricDecryptCallable = callableFactory.createUnaryCallable(asymmetricDecryptTransportSettings, settings.asymmetricDecryptSettings(), clientContext);
        this.macSignCallable = callableFactory.createUnaryCallable(macSignTransportSettings, settings.macSignSettings(), clientContext);
        this.macVerifyCallable = callableFactory.createUnaryCallable(macVerifyTransportSettings, settings.macVerifySettings(), clientContext);
        this.generateRandomBytesCallable = callableFactory.createUnaryCallable(generateRandomBytesTransportSettings, settings.generateRandomBytesSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listKeyRingsMethodDescriptor);
        methodDescriptors.add(listCryptoKeysMethodDescriptor);
        methodDescriptors.add(listCryptoKeyVersionsMethodDescriptor);
        methodDescriptors.add(listImportJobsMethodDescriptor);
        methodDescriptors.add(getKeyRingMethodDescriptor);
        methodDescriptors.add(getCryptoKeyMethodDescriptor);
        methodDescriptors.add(getCryptoKeyVersionMethodDescriptor);
        methodDescriptors.add(getPublicKeyMethodDescriptor);
        methodDescriptors.add(getImportJobMethodDescriptor);
        methodDescriptors.add(createKeyRingMethodDescriptor);
        methodDescriptors.add(createCryptoKeyMethodDescriptor);
        methodDescriptors.add(createCryptoKeyVersionMethodDescriptor);
        methodDescriptors.add(importCryptoKeyVersionMethodDescriptor);
        methodDescriptors.add(createImportJobMethodDescriptor);
        methodDescriptors.add(updateCryptoKeyMethodDescriptor);
        methodDescriptors.add(updateCryptoKeyVersionMethodDescriptor);
        methodDescriptors.add(updateCryptoKeyPrimaryVersionMethodDescriptor);
        methodDescriptors.add(destroyCryptoKeyVersionMethodDescriptor);
        methodDescriptors.add(restoreCryptoKeyVersionMethodDescriptor);
        methodDescriptors.add(encryptMethodDescriptor);
        methodDescriptors.add(decryptMethodDescriptor);
        methodDescriptors.add(asymmetricSignMethodDescriptor);
        methodDescriptors.add(asymmetricDecryptMethodDescriptor);
        methodDescriptors.add(macSignMethodDescriptor);
        methodDescriptors.add(macVerifyMethodDescriptor);
        methodDescriptors.add(generateRandomBytesMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListKeyRingsRequest, ListKeyRingsResponse> listKeyRingsCallable() {
        return this.listKeyRingsCallable;
    }

    @Override
    public UnaryCallable<ListKeyRingsRequest, KeyManagementServiceClient.ListKeyRingsPagedResponse> listKeyRingsPagedCallable() {
        return this.listKeyRingsPagedCallable;
    }

    @Override
    public UnaryCallable<ListCryptoKeysRequest, ListCryptoKeysResponse> listCryptoKeysCallable() {
        return this.listCryptoKeysCallable;
    }

    @Override
    public UnaryCallable<ListCryptoKeysRequest, KeyManagementServiceClient.ListCryptoKeysPagedResponse> listCryptoKeysPagedCallable() {
        return this.listCryptoKeysPagedCallable;
    }

    @Override
    public UnaryCallable<ListCryptoKeyVersionsRequest, ListCryptoKeyVersionsResponse> listCryptoKeyVersionsCallable() {
        return this.listCryptoKeyVersionsCallable;
    }

    @Override
    public UnaryCallable<ListCryptoKeyVersionsRequest, KeyManagementServiceClient.ListCryptoKeyVersionsPagedResponse> listCryptoKeyVersionsPagedCallable() {
        return this.listCryptoKeyVersionsPagedCallable;
    }

    @Override
    public UnaryCallable<ListImportJobsRequest, ListImportJobsResponse> listImportJobsCallable() {
        return this.listImportJobsCallable;
    }

    @Override
    public UnaryCallable<ListImportJobsRequest, KeyManagementServiceClient.ListImportJobsPagedResponse> listImportJobsPagedCallable() {
        return this.listImportJobsPagedCallable;
    }

    @Override
    public UnaryCallable<GetKeyRingRequest, KeyRing> getKeyRingCallable() {
        return this.getKeyRingCallable;
    }

    @Override
    public UnaryCallable<GetCryptoKeyRequest, CryptoKey> getCryptoKeyCallable() {
        return this.getCryptoKeyCallable;
    }

    @Override
    public UnaryCallable<GetCryptoKeyVersionRequest, CryptoKeyVersion> getCryptoKeyVersionCallable() {
        return this.getCryptoKeyVersionCallable;
    }

    @Override
    public UnaryCallable<GetPublicKeyRequest, PublicKey> getPublicKeyCallable() {
        return this.getPublicKeyCallable;
    }

    @Override
    public UnaryCallable<GetImportJobRequest, ImportJob> getImportJobCallable() {
        return this.getImportJobCallable;
    }

    @Override
    public UnaryCallable<CreateKeyRingRequest, KeyRing> createKeyRingCallable() {
        return this.createKeyRingCallable;
    }

    @Override
    public UnaryCallable<CreateCryptoKeyRequest, CryptoKey> createCryptoKeyCallable() {
        return this.createCryptoKeyCallable;
    }

    @Override
    public UnaryCallable<CreateCryptoKeyVersionRequest, CryptoKeyVersion> createCryptoKeyVersionCallable() {
        return this.createCryptoKeyVersionCallable;
    }

    @Override
    public UnaryCallable<ImportCryptoKeyVersionRequest, CryptoKeyVersion> importCryptoKeyVersionCallable() {
        return this.importCryptoKeyVersionCallable;
    }

    @Override
    public UnaryCallable<CreateImportJobRequest, ImportJob> createImportJobCallable() {
        return this.createImportJobCallable;
    }

    @Override
    public UnaryCallable<UpdateCryptoKeyRequest, CryptoKey> updateCryptoKeyCallable() {
        return this.updateCryptoKeyCallable;
    }

    @Override
    public UnaryCallable<UpdateCryptoKeyVersionRequest, CryptoKeyVersion> updateCryptoKeyVersionCallable() {
        return this.updateCryptoKeyVersionCallable;
    }

    @Override
    public UnaryCallable<UpdateCryptoKeyPrimaryVersionRequest, CryptoKey> updateCryptoKeyPrimaryVersionCallable() {
        return this.updateCryptoKeyPrimaryVersionCallable;
    }

    @Override
    public UnaryCallable<DestroyCryptoKeyVersionRequest, CryptoKeyVersion> destroyCryptoKeyVersionCallable() {
        return this.destroyCryptoKeyVersionCallable;
    }

    @Override
    public UnaryCallable<RestoreCryptoKeyVersionRequest, CryptoKeyVersion> restoreCryptoKeyVersionCallable() {
        return this.restoreCryptoKeyVersionCallable;
    }

    @Override
    public UnaryCallable<EncryptRequest, EncryptResponse> encryptCallable() {
        return this.encryptCallable;
    }

    @Override
    public UnaryCallable<DecryptRequest, DecryptResponse> decryptCallable() {
        return this.decryptCallable;
    }

    @Override
    public UnaryCallable<AsymmetricSignRequest, AsymmetricSignResponse> asymmetricSignCallable() {
        return this.asymmetricSignCallable;
    }

    @Override
    public UnaryCallable<AsymmetricDecryptRequest, AsymmetricDecryptResponse> asymmetricDecryptCallable() {
        return this.asymmetricDecryptCallable;
    }

    @Override
    public UnaryCallable<MacSignRequest, MacSignResponse> macSignCallable() {
        return this.macSignCallable;
    }

    @Override
    public UnaryCallable<MacVerifyRequest, MacVerifyResponse> macVerifyCallable() {
        return this.macVerifyCallable;
    }

    @Override
    public UnaryCallable<GenerateRandomBytesRequest, GenerateRandomBytesResponse> generateRandomBytesCallable() {
        return this.generateRandomBytesCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

